/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

public class R01MDefSearchResultItemTypoPublicacionFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeTypoInfo(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (item.getContentTypology() == null) {
            return new StringBuffer("<em>&nbsp;</em>\r\n");
        }
        String typoId = this.obtainTypoId(lang, item);
        StringBuffer typoInfo = new StringBuffer();
        typoInfo.append("<em><span");
        if (!StringUtils.isEmptyString((String)typoId)) {
            typoInfo.append(" class='r01srItem");
            typoInfo.append(this.obtainTypoId(lang, item));
            typoInfo.append("'");
        }
        typoInfo.append(">").append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), null));
        typoInfo.append("</span></em>");
        return typoInfo;
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (!StringUtils.isEmptyString((String)item.getDocumentDescription())) {
            return new StringBuffer(item.getDocumentDescription());
        }
        return null;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(50);
        if ("1".equals(item.getDocumentMetaData("pubSCP"))) {
            String dptoDe = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicacion.departamentoDe");
            String promotor = null;
            if ("DPTO".equals(item.getDocumentMetaData("pubSponsorIsDpto"))) {
                R01MSearchResultItemStructureCatalog dptoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructureCatalog(item, "structures/entidadConvocanteAyuda");
                if (dptoCat != null) {
                    outSb.append("<div class=\"r01srItemTypoDet_sub\">");
                    outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicacion.promotor"));
                    outSb.append(":&nbsp;");
                    promotor = StringUtils.replaceString((String)dptoDe, (String)"$[promotor]$", (String)R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(dptoCat.getStructureOid(), dptoCat.getOid(), dptoCat.getRole()));
                    outSb.append(promotor);
                    outSb.append("</div>");
                }
            } else {
                R01MSearchResultItemStructureCatalog organoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructureCatalog(item, "structures/organoConvocanteAyuda");
                if (organoCat != null) {
                    outSb.append("<div class=\"r01srItemTypoDet_sub\">");
                    outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicacion.promotor"));
                    outSb.append(":&nbsp;");
                    promotor = R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organoCat.getStructureOid(), organoCat.getOid(), organoCat.getRole());
                    outSb.append(promotor);
                    outSb.append("</div>");
                }
            }
            if (!StringUtils.isEmptyString(promotor) || "SCP".equals(item.getDocumentMetaData("pubPublisherIsSCP"))) {
                outSb.append("<div class=\"r01srItemTypoDet_sub\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicacion.editor"));
                outSb.append(":&nbsp;");
                if ("SCP".equals(item.getDocumentMetaData("pubPublisherIsSCP"))) {
                    outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicacion.centralService"));
                } else {
                    outSb.append(promotor);
                }
                outSb.append("</div>");
            }
        } else {
            if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("pubSponsor"))) {
                outSb.append("<div class=\"r01srItemTypoDet_sub\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicacion.promotor"));
                outSb.append(":&nbsp;");
                outSb.append(item.getDocumentMetaData("pubSponsor"));
                outSb.append("</div>");
            }
            if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("pubPublisher"))) {
                outSb.append("<div class=\"r01srItemTypoDet_sub\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicacion.editor"));
                outSb.append(":&nbsp;");
                outSb.append(item.getDocumentMetaData("pubPublisher"));
                outSb.append("</div>");
            }
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return new StringBuffer("<em class=\"r01srItemTypoDet\">&nbsp;</em>");
        }
        return outSb;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        return null;
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        String docResume;
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docTitle)) {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">");
            sb.append(docTitle);
            sb.append("</em>\r\n");
        } else {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">&nbsp;</em>\r\n");
        }
        sb.append("\t\t\t\t</div>\r\n");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append("\t\t\t\t<div class=\"r01srItemDetails\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docDescription)) {
            sb.append("\t\t\t\t\t<div class=\"r01srItemDocDesc\">");
            sb.append(docDescription);
            sb.append("</div>\r\n");
        }
        boolean showResume = true;
        if (!allItemsAreAttachmentFiles && !item.isDocumentMainDataFile()) {
            showResume = true;
        }
        if (numItems == 1 && item.isDocumentMainDataFile) {
            showResume = true;
        }
        if (numItems == 1 && item.getFileAbsolutePath() != null && item.getFileAbsolutePath().indexOf("r01_gendata.txt") >= 0) {
            showResume = false;
        }
        if (showResume && !StringUtils.isEmptyString((String)(docResume = item.fileResume))) {
            docResume = R01MSearchResultItemFormatterUtils.fixTextToBeWrapped(item.fileResume);
            sb.append("\t\t\t\t\t<div class=\"r01srItemDocResume\">");
            sb.append(docResume);
            sb.append("</div>\r\n");
        }
        String typoCSSClassName = "r01srItem" + this.obtainTypoId(lang, item);
        sb.append("\t\t\t\t\t<div class=\"r01srItemDocDetail1 ");
        sb.append(typoCSSClassName);
        sb.append(" r01clearfix\">\r\n\t\t\t\t\t\t<div class=\"r01srItemTypo r01srItemTypo_publicacion\">\r\n");
        sb.append(typoInfo);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class=\"r01srItemTypoDet r01srItemTypoDet_publicacion\">\r\n");
        sb.append(typoDetails);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class=\"r01srItemCat r01srItemTypoCat_publicacion\">\r\n");
        sb.append(catalogDetails);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n");
        return sb;
    }
}

