/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MDefSearchResultItemTypoOpendataFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        if (item.getContentTypology().getTypeOid().equals("estadistica")) {
            StringBuffer outSb = new StringBuffer(50);
            R01MSearchResultItemStructureCatalog organismoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructureCatalog(item, "structures/organismosOpendata");
            if (organismoCat != null) {
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organismoCat.getStructureOid(), organismoCat.getOid(), organismoCat.getRole()));
            }
            if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
                return new StringBuffer("<em class=\"r01srItemTypoDet r01OpendataOrganStruct\">&nbsp;</em>");
            }
            outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
            outSb.append("</em>");
            return outSb;
        }
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeTypoInfo(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (item.getContentTypology() == null) {
            return new StringBuffer("<em>&nbsp;</em>\r\n");
        }
        String typoId = this.obtainTypoId(lang, item);
        StringBuffer typoInfo = new StringBuffer(23);
        typoInfo.append("<em><span");
        if (!StringUtils.isEmptyString((String)typoId)) {
            typoInfo.append(" class='r01srItemTypo_");
            typoInfo.append(item.getContentTypology().getFamilyOid());
            typoInfo.append(" r01srItemTypo_");
            typoInfo.append(item.getContentTypology().getTypeOid());
            typoInfo.append("'");
        }
        typoInfo.append('>');
        typoInfo.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid()));
        typoInfo.append("</span></em>");
        return typoInfo;
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        String docResume;
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docTitle)) {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">");
            sb.append(docTitle);
            sb.append("</em>\r\n");
        } else {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">&nbsp;</em>\r\n");
        }
        sb.append("\t\t\t\t</div>\r\n");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append(this._composeDatasetDetails(lang, item));
        sb.append("\t\t\t\t<div class=\"r01srItemDetails\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docDescription)) {
            sb.append("\t\t\t\t\t<div class=\"r01srItemDocDesc\">");
            sb.append(docDescription);
            sb.append("</div>\r\n");
        }
        boolean showResume = true;
        if (!allItemsAreAttachmentFiles && !item.isDocumentMainDataFile()) {
            showResume = true;
        }
        if (numItems == 1 && item.isDocumentMainDataFile) {
            showResume = true;
        }
        if (numItems == 1 && item.getFileAbsolutePath() != null && item.getFileAbsolutePath().indexOf("r01_gendata.txt") >= 0) {
            showResume = false;
        }
        if (showResume && !StringUtils.isEmptyString((String)(docResume = item.fileResume))) {
            docResume = R01MSearchResultItemFormatterUtils.fixTextToBeWrapped(item.fileResume);
            sb.append("\t\t\t\t\t<div class=\"r01srItemDocResume\">");
            sb.append(docResume);
            sb.append("</div>\r\n");
        }
        String typoCSSClassName = "r01srItem" + this.obtainTypoId(lang, item);
        sb.append("\t\t\t\t\t<div class=\"r01srItemDocDetail1 ");
        sb.append(typoCSSClassName);
        sb.append(" r01clearfix\">\r\n\t\t\t\t\t\t<div class=\"r01srItemTypo\">\r\n");
        sb.append(typoInfo);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class=\"r01srItemTypoDet\">\r\n");
        sb.append(typoDetails);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class=\"r01srItemCat\">\r\n");
        sb.append(catalogDetails);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n");
        return sb;
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        String releaseDateStr;
        StringBuffer outSb = new StringBuffer(30);
        StringBuffer statisticOfficialitygHtml = new StringBuffer(30);
        if (item.getContentTypology().getTypeOid().equals("estadistica")) {
            String statisticType;
            String string = statisticType = item.getDocumentMetaData() != null ? item.getDocumentMetaData("statisticOfficiality") : null;
            if (!StringUtils.isEmptyString((String)statisticType)) {
                statisticOfficialitygHtml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "estadisitica.oficialidad." + statisticType));
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)statisticOfficialitygHtml)) {
                    statisticOfficialitygHtml.insert(0, "<em class=\"r01srItemTypoDet r01StatisticOfficiality\">");
                    statisticOfficialitygHtml.append("&nbsp; &nbsp;</em>");
                }
            }
        }
        String string = releaseDateStr = item.getDocumentMetaData() != null ? item.getDocumentMetaData("OpendataReleaseDate") : null;
        if (releaseDateStr != null) {
            outSb.append(R01MSearchEngineUtils.formatDateTypeSearchResultMetaData(lang, releaseDateStr));
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)statisticOfficialitygHtml)) {
            outSb.insert(0, statisticOfficialitygHtml);
        }
        return outSb;
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    private StringBuffer _composeDatasetDetails(String lang, R01MSearchResultItem item) {
        JSONArray jArray;
        StringBuffer sb = new StringBuffer();
        if (item.getDocumentMetaData("OpendataDatasets") == null || StringUtils.isEmptyString((String)item.getDocumentMetaData("OpendataDatasets"))) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        try {
            jArray = new JSONArray(item.getDocumentMetaData("OpendataDatasets"));
        }
        catch (JSONException ex1) {
            Pattern p1 = Pattern.compile("\\{([^\\{\\}]*)\\}");
            Matcher m1 = p1.matcher(item.getDocumentMetaData("OpendataDatasets"));
            jArray = new JSONArray();
            while (m1.find()) {
                String JObjectString = m1.group(0);
                Pattern p2 = Pattern.compile("([^:,\\{\\}]*):([^,\\{\\}]*)");
                Matcher m2 = p2.matcher(JObjectString);
                JSONObject jObjectAutonomy = new JSONObject();
                while (m2.find()) {
                    try {
                        jObjectAutonomy.put(m2.group(1).trim(), (Object)m2.group(2).trim());
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                jArray.put((Object)jObjectAutonomy);
            }
        }
        try {
            StringBuffer list = new StringBuffer();
            if (jArray != null && jArray.length() > 0) {
                sb.append("<div class=\"r01srItemRispLink r01clearfix\">");
                for (int i = 0; i < jArray.length(); ++i) {
                    JSONObject jObject = (JSONObject)jArray.get(i);
                    R01MRispDocument rispDoc = new R01MRispDocument();
                    rispDoc.loadFromJson(jObject);
                    if (StringUtils.isEmptyString((String)rispDoc.getContentRelativePath())) continue;
                    list.append("<li>");
                    list.append("\t<a href=\"");
                    list.append(rispDoc.getContentRelativePath());
                    list.append('\"');
                    list.append(" class=\"");
                    list.append(rispDoc.getType().toLowerCase());
                    list.append("\" title= \"");
                    list.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.dataset." + rispDoc.getType().toLowerCase()));
                    list.append("\" ><strong><span class=\"file\">");
                    if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                        list.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                    } else {
                        list.append(rispDoc.getType().toUpperCase());
                    }
                    list.append("</span></strong></a>");
                    if (!StringUtils.isEmptyString((String)rispDoc.getSize()) && !"0".equals(rispDoc.getSize())) {
                        int numDeci;
                        list.append(" (");
                        String size = rispDoc.getSize();
                        if (!StringUtils.isEmptyString((String)size) && (size = size.replace(',', '.')).indexOf(46) != -1 && (numDeci = size.length() - size.lastIndexOf(46) - 1) > 2) {
                            size = size.substring(0, size.lastIndexOf(46) + 3);
                        }
                        list.append(size);
                        if (rispDoc.getUnits() != null) {
                            list.append(' ');
                            list.append(rispDoc.getUnits().toUpperCase());
                        }
                        list.append(") ");
                    }
                    list.append("</li>");
                }
                if (list != null && !StringUtils.isEmptyStringBuffer((StringBuffer)list)) {
                    StringBuffer head = new StringBuffer(45);
                    head.append("<div class=\"r01RispResultLabel\">");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.descargaDataset"));
                    head.append(":</div><div class=\"r01RispResultFiles\"><ul>");
                    list.insert(0, head);
                    list.append("</ul></div>");
                }
                sb.append(list);
                sb.append("</div>");
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace(System.out);
        }
        return sb;
    }
}

