/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.tags.links.R01MAppTagLinks;
import com.ejie.r01m.config.objects.tags.links.R01MTagLink;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class R01MDefSearchResultItemTypoNormativeFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    private static final String DEFAULT_VALUE_EMPTY_STRING = "---";
    private static final String EXTERNAL_PRIVATE_LINK = "vinculo_privado_externo";
    protected static Map _literales = new HashMap();

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        StringBuffer title = new StringBuffer(500);
        title.append("<span class=\"r01srItemlegesarea r01srItemlegesarea_Normative\"><span>");
        title.append(item.getDocumentName());
        title.append("</span></span>");
        return title;
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return this._composeNormativeDocument(lang, docTitle, item);
    }

    private StringBuffer _composeNormativeDocument(String lang, StringBuffer docTitle, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink r01srItemDocLinkTransfer r01clearfix\">\r\n\t\t\t\t\t<div class=\"r01srItemAutonomousRule\">\r\n\t\t\t\t\t\t<em class=\"r01srItemDocName\">\r\n");
        sb.append(docTitle);
        sb.append("\t\t\t\t\t\t</em>\r\n</div>");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append("\t\t\t\t</div>\r\n\t\t\t\t<div class=\"r01srItemDetails r01srItemDetailsTransfer\">\r\n\t\t\t\t\t");
        sb.append(this._composeMetadataInfo(lang, item));
        sb.append("<div class=\"r01srItemDocDetail1 ");
        String typoCSSClassName = "r01srItem" + this.obtainTypoId(lang, item);
        sb.append(typoCSSClassName);
        sb.append(" r01clearfix\">\r\n\t\t\t\t\t\t<div class=\"r01srItemTypo r01srItemTypoLegesarea r01clearfix\">\r\n");
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("normConsolidatedTextFlag")) && item.getDocumentMetaData("normConsolidatedTextFlag").toString().equals("1")) {
            sb.append("<strong>");
            String text = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.text.consolidate");
            sb.append("</strong> <div class=\"r01ConsolidatedText\"><span class=\"r01srItemState_Consolidate\">");
            sb.append(text);
            sb.append("</span></div>");
        }
        sb.append("<div class=\"r01AgreemetTypologies \">");
        Map tags = item.getLinkedSizeByTagSrc();
        try {
            List tagsDef;
            R01MAppTagLinks tagLinks = R01MClientFactory.getLinkedTagsConfigAPI().getTagLinks("x46a");
            if (tagLinks != null && (tagsDef = tagLinks.getTagsDefinitionOrdered()) != null && !tagsDef.isEmpty()) {
                for (int i = 0; i < tagsDef.size(); ++i) {
                    R01MTagLink tag = (R01MTagLink)tagsDef.get(i);
                    String value = "0";
                    if (tags != null && !tags.isEmpty() && tags.containsKey(tag.getOid())) {
                        value = tags.get(tag.getOid()).toString();
                    }
                    if (EXTERNAL_PRIVATE_LINK.equals(tag.getOid())) {
                        sb.append("<!--#if expr=\"${R01_CLIENT_PRIVATE_IP} = /^true/\" -->\r\n / ");
                    }
                    sb.append(tag.getDescription(lang));
                    sb.append(" <span>(");
                    sb.append(value);
                    sb.append(")</span>");
                    if (i < tagsDef.size() - 2) {
                        sb.append(" / ");
                    }
                    if (!EXTERNAL_PRIVATE_LINK.equals(tag.getOid())) continue;
                    sb.append("<!--#endif -->\r\n");
                }
            }
        }
        catch (R01MConfigLoadException ex) {
            ex.printStackTrace();
        }
        sb.append("</div>");
        sb.append("\r\n\t\t\t\t\t\t</div></div></div>\r\n");
        return sb;
    }

    private StringBuffer _composeMetadataInfo(String lang, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("<div class=\"r01srItemTypoNormative r01srItemTypoNormativeFirst r01clearfix\"><div class=\"r01srItemTypoNormativeItem\">");
        String ambito = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("normField")) ? R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.ambito." + _literales.get(item.getDocumentMetaData("normField"))) : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.ambito"));
        sb.append(": </strong>");
        sb.append(ambito);
        sb.append("</div><div class=\"r01srItemTypoNormativeItem\">");
        String normStatus = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("normStatus")) ? R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.state." + _literales.get("ESTATUS_" + item.getDocumentMetaData("normStatus"))) : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.state"));
        sb.append(": </strong> ");
        sb.append(normStatus);
        sb.append("</div><div class=\"r01srItemTypoNormativeItem\">");
        String area = "";
        R01MSearchResultItemStructureCatalog[] areaCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/materiaNormativa", false);
        if (areaCat != null && areaCat.length > 0) {
            for (int j = 0; j < areaCat.length; ++j) {
                area = j == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[j].getStructureOid(), areaCat[j].getOid(), areaCat[j].getRole()) : area + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[j].getStructureOid(), areaCat[j].getOid(), areaCat[j].getRole());
            }
        }
        area = !StringUtils.isEmptyString((String)area) ? area : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.area"));
        sb.append(": </strong> ");
        sb.append(area);
        sb.append("</div></div><div class=\"r01srItemTypoNormative  r01clearfix\"><div class=\"r01srItemTypoNormativeItem\">");
        String rango = R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid());
        rango = !StringUtils.isEmptyString((String)rango) ? rango : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.rango"));
        sb.append(": </strong> ");
        sb.append(rango);
        sb.append("</div><div class=\"r01srItemTypoNormativeItem\">");
        String newsletter = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("normTypeOB")) ? R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.newsletter." + _literales.get(item.getDocumentMetaData("normTypeOB"))) : DEFAULT_VALUE_EMPTY_STRING;
        String letter = "es".equalsIgnoreCase(lang) ? "N\u00ba " : "Zk ";
        String number = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("normNumberOB")) ? letter + item.getDocumentMetaData("normNumberOB") : DEFAULT_VALUE_EMPTY_STRING;
        String newsletterDate = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("normPublicationDate")) ? item.getDocumentMetaData("normPublicationDate") : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.newsletter"));
        sb.append(": </strong> ");
        sb.append(newsletter);
        sb.append(" ");
        sb.append(number);
        sb.append(" ");
        if (newsletterDate.equals(DEFAULT_VALUE_EMPTY_STRING)) {
            sb.append(newsletterDate);
        } else {
            Date newsletterDat = DateUtils.getDateFromLanguageFormatedString((String)newsletterDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            sb.append(DateUtils.getDateLanguageFormated((Date)newsletterDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
        }
        sb.append("</div><div class=\"r01srItemTypoNormativeItem\">");
        String sector = "";
        R01MSearchResultItemStructureCatalog[] sectorCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/submateriaNormativa", false);
        if (sectorCat != null && sectorCat.length > 0) {
            for (int i = 0; i < sectorCat.length; ++i) {
                sector = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(sectorCat[i].getStructureOid(), sectorCat[i].getOid(), sectorCat[i].getRole()) : sector + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(sectorCat[i].getStructureOid(), sectorCat[i].getOid(), sectorCat[i].getRole());
            }
        }
        sector = !StringUtils.isEmptyString((String)sector) ? sector : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "normative.section"));
        sb.append(": </strong> ");
        sb.append(sector);
        sb.append("</div></div>");
        return sb;
    }

    static {
        _literales.put("A", "autonomico");
        _literales.put("C", "comunitario");
        _literales.put("E", "estatal");
        _literales.put("F", "foral");
        _literales.put("ESTATUS_1", "vigente");
        _literales.put("ESTATUS_2", "derogada");
        _literales.put("ESTATUS_V", "vigente");
        _literales.put("ESTATUS_D", "derogada");
        _literales.put("1", "bopv");
        _literales.put("2", "doue");
        _literales.put("3", "boe");
        _literales.put("4", "bob");
        _literales.put("5", "bota");
        _literales.put("6", "bog");
        _literales.put("BOPV", "bopv");
        _literales.put("DOUE", "doue");
        _literales.put("BOE", "boe");
        _literales.put("BOB", "bob");
        _literales.put("BOTHA", "bota");
        _literales.put("BOG", "bog");
    }
}

