/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.tags.links.R01MAppTagLinks;
import com.ejie.r01m.config.objects.tags.links.R01MTagLink;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class R01MDefSearchResultItemTypoJuridicDocumentationFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    private static final String DEFAULT_VALUE_EMPTY_STRING = "---";
    private static final String EXTERNAL_PRIVATE_LINK = "vinculo_privado_externo";

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        StringBuffer title = new StringBuffer(500);
        title.append("<span class=\"r01srItemlegesarea r01srItemlegesarea_LegalDocumentation\"><span>");
        title.append(item.getDocumentName());
        title.append("</span></span>");
        return title;
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        String text = item.getDocumentDescription();
        if (text != null && item.getDocumentName() != null && text.equalsIgnoreCase(item.getDocumentName())) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return text != null ? new StringBuffer("<span class=\"r01srItemlegesareaDescription\">" + text + "</span>") : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return this._composeLegalDocumentationDocument(lang, docTitle, item, docDescription);
    }

    private StringBuffer _composeLegalDocumentationDocument(String lang, StringBuffer docTitle, R01MSearchResultItem item, StringBuffer docDescription) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink r01srItemDocLinkTransfer r01clearfix\">\r\n\t\t\t\t\t<div class=\"r01srItemAutonomousRule\">\r\n\t\t\t\t\t\t<em class=\"r01srItemDocName\">\r\n");
        sb.append(docTitle);
        sb.append("\t\t\t\t\t\t</em>\r\n</div>");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docDescription)) {
            sb.append(docDescription);
        }
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append("\t\t\t\t</div>\r\n\t\t\t\t<div class=\"r01srItemDetails r01srItemDetailsTransfer\">\r\n\t\t\t\t\t");
        sb.append(this._composeMetadataInfo(lang, item));
        if (!this.isOARC(item) && !this.isAVPD(item)) {
            sb.append("<div class=\"r01srItemDocDetail1 ");
            String typoCSSClassName = "r01srItem" + this.obtainTypoId(lang, item);
            sb.append(typoCSSClassName);
            sb.append(" r01clearfix\">\r\n\t\t\t\t\t\t<div class=\"r01srItemTypo r01srItemTypoLegesarea r01clearfix\">\r\n");
            sb.append("<div class=\"r01AgreemetTypologies \">");
            Map tags = item.getLinkedSizeByTagSrc();
            try {
                List tagsDef;
                R01MAppTagLinks tagLinks = R01MClientFactory.getLinkedTagsConfigAPI().getTagLinks("x46b");
                if (tagLinks != null && (tagsDef = tagLinks.getTagsDefinitionOrdered()) != null && !tagsDef.isEmpty()) {
                    for (int i = 0; i < tagsDef.size(); ++i) {
                        R01MTagLink tag = (R01MTagLink)tagsDef.get(i);
                        String value = "0";
                        if (tags != null && !tags.isEmpty() && tags.containsKey(tag.getOid())) {
                            value = tags.get(tag.getOid()).toString();
                        }
                        if (EXTERNAL_PRIVATE_LINK.equals(tag.getOid())) {
                            sb.append("<!--#if expr=\"${R01_CLIENT_PRIVATE_IP} = /^true/\" -->\r\n / ");
                        }
                        sb.append(tag.getDescription(lang));
                        sb.append(" <span>(");
                        sb.append(value);
                        sb.append(")</span>");
                        if (i < tagsDef.size() - 2) {
                            sb.append(" / ");
                        }
                        if (!EXTERNAL_PRIVATE_LINK.equals(tag.getOid())) continue;
                        sb.append("<!--#endif -->\r\n");
                    }
                }
            }
            catch (R01MConfigLoadException ex) {
                ex.printStackTrace();
            }
            sb.append("</div>");
            sb.append("\r\n\t\t\t\t\t\t</div></div>");
        }
        sb.append("</div>\r\n");
        return sb;
    }

    private StringBuffer _composeMetadataTramitaInfo(String lang, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("<div class=\"r01srItemTypoNormative r01srItemTypoNormativeFirst r01clearfix\"><div class=\"r01srItemTypoNormativeItem r01ItemDocumentType\">");
        String documentType = "";
        try {
            documentType = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(item.getContentTypology().getTypeOid()).getName(lang);
        }
        catch (R01MConfigLoadException ex) {
            ex.printStackTrace();
        }
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.expedenteTipo"));
        sb.append(": </strong>");
        sb.append(StringUtils.capitalizeFirstLetter((String)documentType));
        sb.append("</div>");
        sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalDocLeading\">");
        String organismo = "";
        R01MSearchResultItemStructureCatalog[] organismoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/organismo", true);
        if (organismoCat != null && organismoCat.length > 0) {
            for (int i = 0; i < organismoCat.length; ++i) {
                organismo = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organismoCat[i].getStructureOid(), organismoCat[i].getOid(), organismoCat[i].getRole()) : organismo + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organismoCat[i].getStructureOid(), organismoCat[i].getOid(), organismoCat[i].getRole());
            }
        }
        organismo = !StringUtils.isEmptyString((String)organismo) ? organismo : "";
        String depto = "";
        R01MSearchResultItemStructureCatalog[] deptoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/departamento", true);
        if (deptoCat != null && deptoCat.length > 0) {
            for (int i = 0; i < deptoCat.length; ++i) {
                depto = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(deptoCat[i].getStructureOid(), deptoCat[i].getOid(), deptoCat[i].getRole()) : depto + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(deptoCat[i].getStructureOid(), deptoCat[i].getOid(), deptoCat[i].getRole());
            }
        }
        depto = !StringUtils.isEmptyString((String)depto) ? depto : "";
        String organo = "";
        R01MSearchResultItemStructureCatalog[] organoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/organoGestor", true);
        if (organoCat != null && organoCat.length > 0) {
            for (int i = 0; i < organoCat.length; ++i) {
                organo = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organoCat[i].getStructureOid(), organoCat[i].getOid(), organoCat[i].getRole()) : organo + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organoCat[i].getStructureOid(), organoCat[i].getOid(), organoCat[i].getRole());
            }
        }
        organo = !StringUtils.isEmptyString((String)organo) ? organo : "";
        String promotor = organismo;
        if (!StringUtils.isEmptyString((String)promotor)) {
            promotor = promotor + (!StringUtils.isEmptyString((String)depto) ? " / " + depto : "");
        } else {
            String string = promotor = !StringUtils.isEmptyString((String)depto) ? depto : "";
        }
        promotor = !StringUtils.isEmptyString((String)promotor) ? promotor + (!StringUtils.isEmptyString((String)organo) ? " / " + organo : "") : promotor + (!StringUtils.isEmptyString((String)organo) ? organo : "");
        String edit = !StringUtils.isEmptyString((String)promotor) ? promotor : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.promotor"));
        sb.append(": </strong>");
        sb.append(edit);
        sb.append("</div>");
        sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalArea\">");
        String area = "";
        R01MSearchResultItemStructureCatalog[] areaCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/materiaJuridica", false);
        if (areaCat != null && areaCat.length > 0) {
            for (int i = 0; i < areaCat.length; ++i) {
                area = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[i].getStructureOid(), areaCat[i].getOid(), areaCat[i].getRole()) : area + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[i].getStructureOid(), areaCat[i].getOid(), areaCat[i].getRole());
            }
        }
        area = !StringUtils.isEmptyString((String)area) ? area : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.area"));
        sb.append(": </strong>");
        sb.append(area);
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<div class=\"r01srItemTypoNormative r01clearfix\">");
        sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemPublishDate\">");
        String publishDate = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("legalDocPublishDate")) ? item.getDocumentMetaData("legalDocPublishDate") : null;
        Date publish = DateUtils.getDateFromLanguageFormatedString(publishDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        sb.append("<strong>");
        String printDate = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.publishDate");
        if (StringUtils.isEmptyString((String)printDate)) {
            printDate = DEFAULT_VALUE_EMPTY_STRING;
        }
        sb.append(printDate);
        sb.append(": </strong>");
        if (!StringUtils.isEmptyString((String)publishDate)) {
            sb.append(DateUtils.getDateLanguageFormated((Date)publish, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
        }
        sb.append("</div>");
        sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalTheme\">");
        String tema = "";
        R01MSearchResultItemStructureCatalog[] temaCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/temaTransparencia", false);
        if (temaCat != null && temaCat.length > 0) {
            for (int i = 0; i < areaCat.length; ++i) {
                tema = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(temaCat[i].getStructureOid(), temaCat[i].getOid(), temaCat[i].getRole()) : tema + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(temaCat[i].getStructureOid(), temaCat[i].getOid(), temaCat[i].getRole());
            }
        }
        tema = !StringUtils.isEmptyString((String)tema) ? tema : DEFAULT_VALUE_EMPTY_STRING;
        String subtema = "";
        R01MSearchResultItemStructureCatalog[] subtemaCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/subtemaTransparencia", false);
        if (subtemaCat != null && subtemaCat.length > 0) {
            for (int i = 0; i < subtemaCat.length; ++i) {
                subtema = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(subtemaCat[i].getStructureOid(), subtemaCat[i].getOid(), subtemaCat[i].getRole()) : subtema + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(subtemaCat[i].getStructureOid(), subtemaCat[i].getOid(), subtemaCat[i].getRole());
            }
        }
        subtema = !StringUtils.isEmptyString((String)subtema) ? subtema : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.tema"));
        sb.append(": </strong>");
        sb.append(tema + " / " + subtema);
        sb.append("</div>");
        sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemSector\">");
        String sector = "";
        R01MSearchResultItemStructureCatalog[] sectorCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/submateriaJuridica", false);
        if (sectorCat != null && sectorCat.length > 0) {
            for (int i = 0; i < sectorCat.length; ++i) {
                sector = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(sectorCat[i].getStructureOid(), sectorCat[i].getOid(), sectorCat[i].getRole()) : sector + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(sectorCat[i].getStructureOid(), sectorCat[i].getOid(), sectorCat[i].getRole());
            }
        }
        sector = !StringUtils.isEmptyString((String)sector) ? sector : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.section"));
        sb.append(": </strong> ");
        sb.append(sector);
        sb.append("</div>");
        sb.append("</div>");
        return sb;
    }

    private StringBuffer _composeMetadataInfo(String lang, R01MSearchResultItem item) {
        int i;
        String edit;
        StringBuffer sb = new StringBuffer(700);
        if (this.isTramita(item)) {
            return this._composeMetadataTramitaInfo(lang, item);
        }
        sb.append("<div class=\"r01srItemTypoNormative r01srItemTypoNormativeFirst r01clearfix\"><div class=\"r01srItemTypoNormativeItem r01ItemDocumentType\">");
        String documentType = "";
        try {
            documentType = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(item.getContentTypology().getTypeOid()).getName(lang);
        }
        catch (R01MConfigLoadException ex) {
            ex.printStackTrace();
        }
        sb.append("<strong>");
        if (this.isAVPD(item)) {
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.documentTypeAVPD"));
        } else {
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.documentType"));
        }
        sb.append(": </strong>");
        sb.append(StringUtils.capitalizeFirstLetter((String)documentType));
        sb.append("</div>");
        if (this.isAVPD(item)) {
            sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalDocAVPDNumber\">");
            edit = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("legalDocNumber")) ? item.getDocumentMetaData("legalDocNumber") : DEFAULT_VALUE_EMPTY_STRING;
            sb.append("<strong>");
            if (this.isDictamenAVPD(item)) {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.dictamenNumber"));
            } else {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.resolutionNumber"));
            }
            sb.append(": </strong>");
            sb.append(edit);
            sb.append("</div>");
        } else {
            sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalDocLeading\">");
            edit = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("legalDocLeading")) ? item.getDocumentMetaData("legalDocLeading") : DEFAULT_VALUE_EMPTY_STRING;
            sb.append("<strong>");
            if (item.getContentTypology().getTypeOid().equals("doctrina")) {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.edit"));
            } else {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.organo"));
            }
            sb.append(": </strong>");
            sb.append(edit);
            sb.append("</div>");
        }
        if (this.isAVPD(item)) {
            sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalDocAVPDDAte\">");
            String resolutionDateStr = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("legalDocResolutionDate")) ? item.getDocumentMetaData("legalDocResolutionDate") : null;
            Date resolutionDate = DateUtils.getDateFromLanguageFormatedString(resolutionDateStr, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            sb.append("<strong>");
            if (this.isDictamenAVPD(item)) {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.firmDate"));
            } else {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.resolutionDate"));
            }
            sb.append(": </strong>");
            if (StringUtils.isEmptyString((String)resolutionDateStr)) {
                sb.append(DEFAULT_VALUE_EMPTY_STRING);
            } else {
                sb.append(DateUtils.getDateLanguageFormated((Date)resolutionDate, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            }
            sb.append("</div>");
        } else {
            sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalArea\">");
            String area = "";
            R01MSearchResultItemStructureCatalog[] areaCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/materiaJuridica", false);
            if (areaCat != null && areaCat.length > 0) {
                for (i = 0; i < areaCat.length; ++i) {
                    area = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[i].getStructureOid(), areaCat[i].getOid(), areaCat[i].getRole()) : area + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[i].getStructureOid(), areaCat[i].getOid(), areaCat[i].getRole());
                }
            }
            area = !StringUtils.isEmptyString((String)area) ? area : DEFAULT_VALUE_EMPTY_STRING;
            sb.append("<strong>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.area"));
            sb.append(": </strong>");
            sb.append(area);
            sb.append("</div>");
        }
        sb.append("</div>");
        sb.append("<div class=\"r01srItemTypoNormative r01clearfix\">");
        if (!this.isAVPD(item)) {
            String publishDate;
            sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemPublishDate\">");
            String string = publishDate = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("legalDocPublishDate")) ? item.getDocumentMetaData("legalDocPublishDate") : null;
            if (this.isOARC(item)) {
                publishDate = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("legalDocResolutionDate")) ? item.getDocumentMetaData("legalDocResolutionDate") : null;
            }
            Date publish = DateUtils.getDateFromLanguageFormatedString((String)publishDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            sb.append("<strong>");
            String printDate = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.publishDate");
            if (this.isOARC(item)) {
                printDate = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.resolutionDate");
            }
            if (StringUtils.isEmptyString((String)printDate)) {
                printDate = DEFAULT_VALUE_EMPTY_STRING;
            }
            sb.append(printDate);
            sb.append(": </strong>");
            if (!StringUtils.isEmptyString((String)publishDate)) {
                sb.append(DateUtils.getDateLanguageFormated((Date)publish, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            }
            sb.append("</div><div class=\"r01srItemTypoNormativeItem r01ItemAuthor\">");
            if (this.isOARC(item)) {
                String poder_adjudicador = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("contractingAuthority")) ? item.getDocumentMetaData("contractingAuthority") : DEFAULT_VALUE_EMPTY_STRING;
                sb.append("<strong>");
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.poder_adjudicador"));
                sb.append(": </strong> ");
                sb.append(poder_adjudicador);
            } else {
                String author = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("legalDocAuthor")) ? item.getDocumentMetaData("legalDocAuthor") : DEFAULT_VALUE_EMPTY_STRING;
                sb.append("<strong>");
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.author"));
                sb.append(": </strong> ");
                sb.append(author);
            }
            sb.append("</div><div class=\"r01srItemTypoNormativeItem r01ItemSector\">");
            String sector = "";
            R01MSearchResultItemStructureCatalog[] sectorCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/submateriaJuridica", false);
            if (sectorCat != null && sectorCat.length > 0) {
                for (int i2 = 0; i2 < sectorCat.length; ++i2) {
                    sector = i2 == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(sectorCat[i2].getStructureOid(), sectorCat[i2].getOid(), sectorCat[i2].getRole()) : sector + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(sectorCat[i2].getStructureOid(), sectorCat[i2].getOid(), sectorCat[i2].getRole());
                }
            }
            sector = !StringUtils.isEmptyString((String)sector) ? sector : DEFAULT_VALUE_EMPTY_STRING;
            sb.append("<strong>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.section"));
            sb.append(": </strong> ");
            sb.append(sector);
            sb.append("</div>");
        } else {
            sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalOrgan\">");
            String organo = "";
            R01MSearchResultItemStructureCatalog[] organoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/organoEmisorVigente", false);
            if (organoCat != null && organoCat.length > 0) {
                for (i = 0; i < organoCat.length; ++i) {
                    organo = organo + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organoCat[i].getStructureOid(), organoCat[i].getOid(), organoCat[i].getRole()).trim();
                    if (i >= organoCat.length - 1) continue;
                    organo = organo + "; ";
                }
            }
            sb.append("<strong>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.organo"));
            sb.append(": </strong>");
            sb.append(!StringUtils.isEmptyString((String)organo) ? organo : DEFAULT_VALUE_EMPTY_STRING);
            sb.append("</div>");
            sb.append("<div class=\"r01srItemTypoNormativeItem r01ItemLegalDescriptors\">");
            String descriptores = "";
            R01MSearchResultItemStructureCatalog[] descriptoresCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/submateriaAVPD", false);
            if (descriptoresCat != null && descriptoresCat.length > 0) {
                for (int i3 = 0; i3 < descriptoresCat.length; ++i3) {
                    descriptores = descriptores + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(descriptoresCat[i3].getStructureOid(), descriptoresCat[i3].getOid(), descriptoresCat[i3].getRole()).trim();
                    if (i3 >= descriptoresCat.length - 1) continue;
                    descriptores = descriptores + "; ";
                }
            }
            sb.append("<strong>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legalDoc.descriptors"));
            sb.append(": </strong>");
            sb.append(!StringUtils.isEmptyString((String)descriptores) ? descriptores : DEFAULT_VALUE_EMPTY_STRING);
            sb.append("</div>");
        }
        sb.append("</div>");
        return sb;
    }

    private boolean isOARC(R01MSearchResultItem item) {
        return item.getContentTypology().getTypeOid().equals("resolucion_oarc");
    }

    private boolean isAVPD(R01MSearchResultItem item) {
        return item.getContentTypology().getTypeOid().equals("resolucion_avpd") || this.isDictamenAVPD(item);
    }

    private boolean isDictamenAVPD(R01MSearchResultItem item) {
        return item.getContentTypology().getTypeOid().equals("dictamen_avpd");
    }

    private boolean isTramita(R01MSearchResultItem item) {
        return item.getContentTypology().getTypeOid().startsWith("tramita_");
    }
}

