/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class R01MDefSearchResultItemTypoEventsFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(200);
        outSb.append(item.getDocumentName());
        return outSb;
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        String text = item.getDocumentDescription();
        if (text != null && item.getDocumentName() != null && text.equalsIgnoreCase(item.getDocumentName())) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return text != null ? new StringBuffer(text) : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeTypoInfo(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (item.getContentTypology() == null) {
            return new StringBuffer("<em>&nbsp;</em>\r\n");
        }
        String typoId = this.obtainTypoId(lang, item);
        StringBuffer typoInfo = new StringBuffer(23);
        if (item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("eventType"))) {
            typoInfo.append("<em><span");
            if (!StringUtils.isEmptyString((String)typoId)) {
                typoInfo.append(" class='r01srItem");
                typoInfo.append(typoId);
                typoInfo.append("'");
            }
            typoInfo.append('>');
            typoInfo.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.evento"));
            typoInfo.append(":&nbsp;");
            typoInfo.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid(), "eventType", item.getDocumentMetaData("eventType")));
            typoInfo.append("</span></em>");
        }
        return typoInfo;
    }

    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        String outCls = "Typo_eventos";
        String eventStartDate = item.getDocumentMetaData("eventStartDate");
        String eventEndDate = item.getDocumentMetaData("eventEndDate");
        Date startDat = DateUtils.getDateFromLanguageFormatedString((String)eventStartDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date endDat = DateUtils.getDateFromLanguageFormatedString((String)eventEndDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date currentDate = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        String formattedDate = df.format(currentDate);
        currentDate = DateUtils.getDateFromLanguageFormatedString((String)formattedDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        if (startDat == null || endDat == null) {
            outCls = "Typo_eventos";
        } else if (startDat != null && DateUtils.getDateAsMillis((Date)currentDate) < DateUtils.getDateAsMillis((Date)startDat)) {
            outCls = "Typo_eventos_next";
        } else if (endDat != null && DateUtils.getDateAsMillis((Date)currentDate) > DateUtils.getDateAsMillis((Date)endDat)) {
            outCls = "Typo_eventos_finished";
        } else if (startDat != null && endDat != null) {
            outCls = "Typo_eventos_current";
        }
        return outCls;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(200);
        String startDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventStartDate") : null;
        String endDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventEndDate") : null;
        String provincia = item.getDocumentMetaData() != null ? this._checkGeograficMetadataNumber(item.getDocumentMetaData("eventTerritoryName")) : null;
        String municipio = item.getDocumentMetaData() != null ? this._checkGeograficMetadataNumber(item.getDocumentMetaData("eventTownName")) : null;
        String organizadoPor = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventSponsor") : null;
        Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, (String)lang, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, (String)lang, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date currentDate = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        String formattedDate = df.format(currentDate);
        currentDate = DateUtils.getDateFromLanguageFormatedString((String)formattedDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        String state = "";
        if (startDat != null && DateUtils.getDateAsMillis((Date)currentDate) < DateUtils.getDateAsMillis((Date)startDat)) {
            state = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.eventoProximo");
        } else if (endDat != null && DateUtils.getDateAsMillis((Date)currentDate) > DateUtils.getDateAsMillis((Date)endDat)) {
            state = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.eventoFinalizado");
        } else if (startDat != null && endDat != null) {
            state = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.eventoEnCurso");
        }
        if (!StringUtils.isEmptyString((String)state)) {
            outSb.append("<span class=\"r01srItemLiteral\">");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.plazo") + ":");
            outSb.append("</span>&nbsp;");
            outSb.append(state);
            outSb.append("&nbsp;&nbsp;");
        }
        if (startDate != null && endDate != null) {
            outSb.append("(");
            outSb.append(DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append(")");
        } else if (startDate != null) {
            outSb.append("(");
            outSb.append(DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(")");
        } else if (endDate != null) {
            outSb.append("(");
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append(")");
        }
        if (!(StringUtils.isEmptyStringBuffer((StringBuffer)outSb) || provincia == null && municipio == null)) {
            outSb.append(StringUtils.isEmptyStringBuffer((StringBuffer)outSb) ? "" : "<br/>");
            outSb.append("<span class=\"r01srItemLiteral\">");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.localizacion") + ":");
            outSb.append("</span>&nbsp;");
            if (municipio != null) {
                outSb.append(municipio);
                outSb.append("&nbsp;");
            }
            if (provincia != null) {
                outSb.append("(");
                outSb.append(provincia);
                outSb.append(")");
            }
        }
        if (organizadoPor != null) {
            outSb.append(StringUtils.isEmptyStringBuffer((StringBuffer)outSb) ? "" : "<br/>");
            outSb.append("<span class=\"r01srItemLiteral\">");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.organizadoPor") + ":");
            outSb.append("</span>&nbsp;");
            outSb.append(organizadoPor);
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet r01srItemTypoDet_eventos\">");
        outSb.append("</em>");
        return outSb;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(500);
        String onLine = item.getDocumentMetaData("eventOnLine");
        if (!StringUtils.isEmptyString((String)onLine) && !onLine.equalsIgnoreCase("N")) {
            outSb.append("\t\t\t\t\t\t\t<ul><li class='r01srItemMetaData_eventOnLine'><span>");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.eventoOnline"));
            outSb.append("</span></li></ul>\r\n");
        }
        String startDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventRegistrationStartDate") : null;
        String endDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventRegistrationEndDate") : null;
        Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date currentDate = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        String formattedDate = df.format(currentDate);
        currentDate = DateUtils.getDateFromLanguageFormatedString((String)formattedDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        if (!(startDat != null && DateUtils.getDateAsMillis((Date)currentDate) < DateUtils.getDateAsMillis((Date)startDat) || endDat != null && DateUtils.getDateAsMillis((Date)currentDate) > DateUtils.getDateAsMillis((Date)endDat) || endDat == null || startDat == null)) {
            outSb.append("\t\t\t\t\t\t\t<ul><li class='r01srItemMetaData_eventOpen'><span>");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "evento.incripcionAbierta"));
            outSb.append("</span></li></ul>\r\n");
        }
        return outSb;
    }

    private String _checkGeograficMetadataNumber(String metadata) {
        if (!StringUtils.isEmptyString((String)metadata)) {
            String[] geoMetadata = metadata.split(";");
            for (int i = 0; i < geoMetadata.length; ++i) {
                if (!NumberUtils.isInteger((String)geoMetadata[i].trim())) continue;
                return null;
            }
        }
        return metadata;
    }
}

