/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

public class R01MDefSearchResultItemTypoDocumentacionFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeTypoInfo(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (item.getContentTypology() == null) {
            return new StringBuffer("<em>&nbsp;</em>\r\n");
        }
        String typoId = this.obtainTypoId(lang, item);
        StringBuffer typoInfo = new StringBuffer();
        typoInfo.append("<em><span");
        if (!StringUtils.isEmptyString((String)typoId)) {
            typoInfo.append(" class='r01srItem");
            typoInfo.append(this.obtainTypoId(lang, item));
            typoInfo.append("'");
        }
        typoInfo.append('>');
        typoInfo.append("</span></em>");
        return typoInfo;
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        String text = item.getDocumentDescription();
        return text != null ? new StringBuffer(text) : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(50);
        outSb.append("<span class=\"r01srItem");
        outSb.append(super.obtainTypoId(lang, item));
        outSb.append("\">");
        outSb.append("</span>");
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        return outSb;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        R01MSearchResultItemStructureCatalog organoCat;
        StringBuffer outSb = new StringBuffer(50);
        R01MSearchResultItemStructureCatalog dptoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructureCatalog(item, "structures/entidadConvocanteAyuda");
        if (dptoCat != null) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.responsable"));
            outSb.append(":&nbsp;");
            outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(dptoCat.getStructureOid(), dptoCat.getOid(), dptoCat.getRole()));
        }
        if ((organoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructureCatalog(item, "structures/organoConvocanteAyuda")) != null && !StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            outSb.append("&nbsp;/&nbsp;");
            outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organoCat.getStructureOid(), organoCat.getOid(), organoCat.getRole()));
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return new StringBuffer("<em class=\"r01srItemTypoDet\">&nbsp;</em>");
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        return outSb;
    }
}

