/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.Properties;

public class R01MDefSearchResultItemTypoAvisosTecnicosFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    public StringBuffer composeDocumentIconText(String lang, R01MSearchResultItem item) {
        StringBuffer title = new StringBuffer(500);
        String css = "";
        boolean incidencia = false;
        if (item.getDocumentMetaData("noticeIncidence") != null && item.getDocumentMetaData("noticeIncidence").equals("1")) {
            css = "incidencia";
            incidencia = true;
        } else {
            css = "aviso";
        }
        title.append("<div class=\"r01Subtitle\"><span class=\"r01srItemAvisoTecnico_comun r01srItemAvisoTecnico_" + css + "\">");
        if (incidencia) {
            title.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "avisoTecnico.incidencia"));
        } else {
            title.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid()));
        }
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("noticeIncidenceDate")) && incidencia) {
            title.append(":&nbsp;");
        }
        title.append("</span>");
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("noticeIncidenceDate")) && incidencia) {
            String activationDate = "";
            Date activationDat = DateUtils.getDateFromLanguageFormatedString((String)item.getDocumentMetaData("noticeActivationDate"), null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            activationDate = DateUtils.getDateLanguageFormated((Date)activationDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
            title.append(activationDate);
        }
        title.append("</div>");
        return title;
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("noticeTitle"))) {
            return new StringBuffer(item.getDocumentMetaData("noticeTitle"));
        }
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("noticeDescription"))) {
            return new StringBuffer(item.getDocumentMetaData("noticeDescription"));
        }
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return this._composeDocument(lang, docTitle, docDescription, item);
    }

    private StringBuffer _composeDocument(String lang, StringBuffer docTitle, StringBuffer docDescription, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink r01srItemDocLinkTransfer r01clearfix\">\r\n\t\t\t\t\t<div class=\"r01srItemAutonomousRule\">\r\n\t\t\t\t\t\t<em class=\"r01srItemDocName\">\r\n");
        sb.append(docTitle);
        sb.append("\t\t\t\t\t\t</em>\r\n</div>");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append("\t\t\t\t</div>\r\n\t\t\t\t<div class=\"r01srItemDetails r01srItemDetailsTransfer\">\r\n\t\t\t\t\t");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docDescription)) {
            sb.append("<div class=\"r01srItemDocDesc\">");
            sb.append(docDescription);
            sb.append("</div>");
        }
        sb.append(this._composeMetadataInfo(lang, item));
        sb.append("</div>\r\n");
        return sb;
    }

    private StringBuffer _composeMetadataInfo(String lang, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append(this.composeDocumentIconText(lang, item));
        sb.append("<div class=\"r01srItemTypoMet\">");
        if (item.getDocumentMetaData("noticeIncidence") != null && item.getDocumentMetaData("noticeIncidence").equals("1")) {
            sb.append("<div class=\"r01srItemTypoMetItemAvisoTecnico\">");
            sb.append("<strong>");
            if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("noticeSolved")) && item.getDocumentMetaData("noticeSolved").equals("1")) {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "avisoTecnico.resuelta"));
            } else {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "avisoTecnico.noResuelta"));
            }
            if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("noticeIncidenceResolutionDate"))) {
                String resolutionDate = "";
                Date resolutionDat = DateUtils.getDateFromLanguageFormatedString((String)item.getDocumentMetaData("noticeIncidenceResolutionDate"), null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
                resolutionDate = DateUtils.getDateLanguageFormated((Date)resolutionDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
                sb.append(" (" + resolutionDate + ")");
            }
            sb.append("</strong>");
            sb.append("</div>");
        }
        sb.append("</div>");
        return sb;
    }
}

