/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xml.utils.XMLTransformerHelper;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchSessionHtmlFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalDataAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;

public class R01MSearchSessionXSLFormatter
extends R01MDefSearchSessionHtmlFormatter
implements R01MSearchSessionFormatter,
Serializable {
    private static final long serialVersionUID = -5286824506799110678L;

    @Override
    public StringBuffer formatSearchResults(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSessionResults sessionResults, Map preGeneratedCode, R01MQueryObject qry) {
        StringBuffer results = R01MSearchSessionXSLFormatter._formatResults(lang, prefs, sessionResults, preGeneratedCode);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer _formatResults(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSessionResults sessionResults, Map preGeneratedCode) {
        String xslPortalRelativePath = prefs.getFormatterProperty("xslPortalAbsolutePath");
        String portalOid = prefs.getFormatterProperty("portalCode");
        StringBuffer sb = new StringBuffer("");
        if (sessionResults != null && portalOid != null && xslPortalRelativePath != null && !StringUtils.isEmptyString((String)portalOid) && !StringUtils.isEmptyString((String)xslPortalRelativePath)) {
            OutputStream out = null;
            InputStream xslIS = null;
            try {
                String environment = XMLProperties.get((String)R01MConstants.PORTALRENDER_APPCODE, (String)"portalServer/portalFiles/@location");
                if (environment.equals("fileSystem")) {
                    String portalBasePath = XMLProperties.get((String)R01MConstants.PORTALRENDER_APPCODE, (String)("portalServer/portalFiles/" + environment));
                    Properties vars = new Properties();
                    vars.put("portalOid", portalOid);
                    portalBasePath = StringUtils.replaceVariableValues((String)portalBasePath, (char)'$', (Map)vars);
                    xslIS = new FileInputStream(new File(portalBasePath + xslPortalRelativePath));
                } else {
                    try {
                        R01MPortalDataAPI portalDataAPI = R01MClientFactory.getPortalDataAPI(R01MAuthManager.createMasterSystemUserContext(), portalOid);
                        xslIS = portalDataAPI.downloadPortalFile(xslPortalRelativePath);
                    }
                    catch (Exception e) {
                        sb.append(R01MSearchSessionXSLFormatter._composeNoResultsMessage(lang, preGeneratedCode));
                        StringBuffer vars = sb;
                        try {
                            if (xslIS != null) {
                                xslIS.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.out);
                        }
                        return vars;
                    }
                }
                out = new ByteArrayOutputStream();
                StringBuffer xml = new StringBuffer(500);
                xml.append("<?xml version=\"1.0\" encoding=\"");
                xml.append(R01MConstants.DEFAULT_WEB_ENCODING);
                xml.append("\"?>\r\n");
                xml.append(R01MClientFactory.getSearchEngineSessionAPI().getXMLFromSearchSessionResults(sessionResults));
                Properties params = new Properties();
                params.put("queryEncoded", R01MSearchEngineUtils.encodeQueryObjectInURL(sessionResults.getQry()));
                params.put("pageContents", StringUtils.isEmptyString((String)prefs.resultsFormatterPreferences.itemUrlPrefix) ? "" : prefs.resultsFormatterPreferences.itemUrlPrefix);
                XMLTransformerHelper.applyXSLtoXML((InputStream)new ByteArrayInputStream(xml.toString().getBytes()), (InputStream)xslIS, (Properties)params, (OutputStream)out);
                sb.append(out.toString());
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace(System.out);
            }
            catch (XOMarshallerException ex) {
                ex.printStackTrace(System.out);
            }
            catch (TransformerException ex) {
                ex.printStackTrace(System.out);
            }
            catch (Throwable th) {
                th.printStackTrace(System.out);
            }
            finally {
                try {
                    if (xslIS != null) {
                        xslIS.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                }
            }
        } else {
            sb.append(R01MSearchSessionXSLFormatter._composeNoResultsMessage(lang, preGeneratedCode));
        }
        return sb;
    }

    private static StringBuffer _composeNoResultsMessage(String lang, Map preGeneratedCode) {
        StringBuffer msg = new StringBuffer("No se han encontrado resultados...");
        return msg;
    }
}

