/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.servlet.URLDecoder;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.util.URLEncoder;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchNavBar;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterURLHelpper;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchGuideFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultsNavBarFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchedRepositoriesResumeFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MDefSearchSessionHtmlFormatter
implements R01MSearchSessionFormatter,
Serializable {
    private static final long serialVersionUID = -5286844506799110678L;
    private static final boolean SHOW_SUGGESTIONS_ONLY_IN_FULL_TEXT_SEARCHS = XMLProperties.getBoolean((String)R01MConstants.API_APPCODE, (String)"searchEngine/showSuggestionsOnlyInFullTextSearchs", (boolean)true);

    @Override
    public StringBuffer formatSearchSession(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSession session) {
        return null;
    }

    @Override
    public StringBuffer formatSectionBySection(String lang, R01MSearchSessionFormatterPreferences prefs, StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        return R01MDefSearchSessionHtmlFormatter._format(searchResultsFormatted, preGeneratedCode);
    }

    @Override
    public StringBuffer format(String lang, R01MSearchSessionFormatterPreferences prefs, StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        return this.formatSectionBySection(lang, prefs, searchResultsFormatted, preGeneratedCode);
    }

    @Override
    public StringBuffer formatSearchBox(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return R01MDefSearchSessionHtmlFormatter._formatSearchBox(lang, qry, prefs);
    }

    @Override
    public StringBuffer formatHeader(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, R01MSearchSessionResults sessionResults, Map preGeneratedCode) {
        return R01MDefSearchSessionHtmlFormatter._formatHeader(lang, prefs, sessionResults);
    }

    @Override
    public StringBuffer formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return this.formatQuery(lang, prefs, qry, preGeneratedCode, false);
    }

    @Override
    public StringBuffer formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode, boolean showAllMetadataDescription) {
        return R01MDefSearchSessionHtmlFormatter._formatQuery(lang, prefs, qry, showAllMetadataDescription);
    }

    @Override
    public StringBuffer formatRssFeedLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return R01MDefSearchSessionHtmlFormatter._formatRssFeedLink(lang, prefs, qry, false);
    }

    @Override
    public StringBuffer formatRispLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return R01MDefSearchSessionHtmlFormatter._formatRispLink(lang, prefs, qry, false);
    }

    @Override
    public StringBuffer formatSearchResults(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSessionResults sessionResults, Map preGeneratedCode, R01MQueryObject qry) {
        return R01MDefSearchSessionHtmlFormatter._formatResults(lang, prefs, sessionResults.getSearchResultsBySource(), preGeneratedCode, qry);
    }

    @Override
    public StringBuffer formatSearchResultsItems(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchResultItem[] items, Map preGeneratedCode) {
        return R01MDefSearchSessionHtmlFormatter._formatResultItems(lang, prefs, items);
    }

    @Override
    public StringBuffer formatSearchGuide(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchGuide guide, Map preGeneratedCode) {
        StringBuffer g;
        if (!prefs.showGuide) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (guide != null) {
            R01MSearchGuideElement[] guidePastElements = guide.getCurrentGuideNode() == null ? null : guide.getCurrentGuideNode().getPastElementsArray();
            R01MSearchGuideElement guideCurrentElement = guide.getCurrentGuideNode() == null ? null : guide.getCurrentGuideNode().getNodeElement();
            R01MSearchGuideElement[] guideFutureElements = guide.getCurrentGuideNode() == null ? guide.getFirstLevelNodesElements() : guide.getCurrentGuideNode().getFutureElementsArray();
            g = this._formatSearchGuide(lang, prefs, guidePastElements, guideCurrentElement, guideFutureElements);
        } else {
            g = new StringBuffer("");
        }
        return g;
    }

    private static StringBuffer _format(StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("\r\n\r\n<div class=\"r01SearchSession\">\r\n");
        if (preGeneratedCode != null) {
            StringBuffer searchBoxFormatted = (StringBuffer)preGeneratedCode.get("searchBox");
            StringBuffer headerFormatted = (StringBuffer)preGeneratedCode.get("header");
            StringBuffer guideFormatted = (StringBuffer)preGeneratedCode.get("guide");
            StringBuffer rssFeedLinkFormatted = (StringBuffer)preGeneratedCode.get("rssLink");
            if (searchBoxFormatted != null) {
                sb.append(searchBoxFormatted);
            }
            sb.append("<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n<div class=\"r01SearchSessionResults\">\r\n");
            if (headerFormatted != null) {
                sb.append(headerFormatted);
            }
            if (guideFormatted != null) {
                sb.append(guideFormatted);
            }
            if (rssFeedLinkFormatted != null) {
                sb.append(rssFeedLinkFormatted);
            }
            if (searchResultsFormatted != null) {
                sb.append(searchResultsFormatted);
            }
            sb.append("</div>\r\n<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n");
        } else {
            sb.append("<h1>ERROR: Pre-Generated code was not received from R01MSearchEngineWebRequestProcessor!!!</h1>");
        }
        sb.append("</div>\r\n");
        return sb;
    }

    private static StringBuffer _formatSearchBox(String lang, R01MQueryObject qry, R01MSearchSessionFormatterPreferences prefs) {
        String fullTextValue = qry != null && qry.getFullText() != null ? R01MSearchEngineUtils.sanitizeParam(qry.getFullText()) : "";
        String vaName = prefs.getFormatterProperty("vaName");
        String effLang = "es".equals(lang) || "eu".equals(lang) || "fr".equals(lang) || "en".equals(lang) || "de".equals(lang) ? lang : "en";
        StringBuffer sb = new StringBuffer(895);
        String servletRelativePath = R01MSearchFormatterURLHelpper.BASE_URL;
        sb.append("<!--[if !IE]> Se submite a esta misma p\u00e1gina <![endif]-->\r\n<div class=\"r01searchBox r01clearfix\">\r\n<fieldset>\r\n\t<form name=\"r01searchForm\" action=\"");
        sb.append(servletRelativePath);
        sb.append("\" onsubmit=\"if (window.r01gBtnSearchResult_Submit) window.r01gBtnSearchResult_Submit(event,'");
        sb.append(vaName);
        sb.append("');\">\r\n\t\t<label class=\"r01gLabelInputText r01Oculto\" for=\"r01searchFormText_");
        sb.append(vaName);
        sb.append("\" >");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "searchbox.label"));
        sb.append("</label>\t\t<input type=\"text\" name=\"");
        sb.append("fullText");
        sb.append("\" id=\"r01searchFormText_");
        sb.append(vaName);
        sb.append("\" value=\"");
        sb.append(StringEscapeUtils.escapeHtml((String)fullTextValue));
        String iptClass = "r01searchFormText";
        if (prefs.showSuggestedSearchBox) {
            sb.append("\" onkeyup=\"if (window.r01gSearchBoxKeypress) r01gSearchBoxKeypress('");
            sb.append(vaName);
            sb.append("','");
            sb.append(prefs.resultsFormatterPreferences.itemUrlPrefix);
            iptClass = iptClass + " iptAutocomplete";
            sb.append("');\" onmouseup=\"if (window.r01gSearchBoxKeypress) r01gSearchBoxKeypress('");
            sb.append(vaName);
            sb.append("','");
            sb.append(prefs.resultsFormatterPreferences.itemUrlPrefix);
            iptClass = iptClass + " iptAutocomplete";
            sb.append("');");
        }
        sb.append("\" class=\"");
        sb.append(iptClass);
        sb.append("\" />\r\n\t\t<input type=\"hidden\" name=\"");
        sb.append("r01kLang");
        sb.append("\" value=\"");
        sb.append(lang);
        sb.append("\"/>\r\n");
        if (qry != null) {
            sb.append("\r\n\t\t<input type=\"hidden\" name=\"r01kQry\" id=\"r01kQry_");
            sb.append(vaName);
            sb.append("\" value=\"");
            sb.append(URLDecoder.decode((String)R01MSearchEngineUtils.encodeQueryObjectInString(qry)));
            sb.append("\"/>");
        } else {
            sb.append("\r\n\t\t<input type=\"hidden\" name=\"resultsSource\" value=\"fullText\"/>");
        }
        sb.append("\t\t<input type=\"submit\" class=\"r01searchFormButton\" value=\"");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", effLang, "searchbox.button"));
        sb.append("\"/>\r\n\t</form>\r\n\t</fieldset>\r\n");
        String helpPage = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)("searchEngine/searchHelpPage/" + effLang));
        sb.append("\t<div class=\"r01searchBoxHelp\">\r\n\t\t<p><a href=\"");
        sb.append(StringEscapeUtils.escapeHtml((String)(R01MSearchFormatterURLHelpper.BASE_URL + "?resultsSource=fullText&" + "fullText")));
        sb.append("=\">");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "query.nueva"));
        sb.append("</a></p>\r\n\t\t<p><a href=\"");
        sb.append(StringEscapeUtils.escapeHtml((String)helpPage));
        sb.append("\">");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", effLang, "query.ayuda"));
        sb.append("</a></p>\r\n\t</div>\r\n");
        if (prefs.showSuggestedSearchBox) {
            sb.append("\t<div id=\"r01searchBoxSuggested_" + prefs.getFormatterProperty("vaName") + "\" class=\"r01searchBoxSuggested\"></div>");
        }
        sb.append("</div>\r\n");
        return sb;
    }

    private static StringBuffer _formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, boolean showAllMetadataDescription) {
        StringBuffer sb;
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        String formatterClassName = "";
        if (appliedPrefs.showFullQuery) {
            if (appliedPrefs.formatterImpls.searchFullQueryFormatterClassName != null) {
                formatterClassName = appliedPrefs.formatterImpls.searchFullQueryFormatterClassName;
            }
        } else if (appliedPrefs.formatterImpls.searchQueryFormatterClassName != null) {
            formatterClassName = appliedPrefs.formatterImpls.searchQueryFormatterClassName;
        }
        if (!StringUtils.isEmptyString((String)formatterClassName)) {
            sb = new StringBuffer(200);
            try {
                R01MSearchQueryFormatter qryFormatter = (R01MSearchQueryFormatter)ReflectionUtils.getObjectInstance((String)formatterClassName);
                sb.append(qryFormatter.doFormatQuery(lang, appliedPrefs.queryFormatterPreferences, qry, showAllMetadataDescription));
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                sb.append("Error al formatear la cabecera de b\u00fasqueda. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getMessage());
            }
        } else {
            sb = new StringBuffer();
        }
        if (sb.length() > 0) {
            sb.insert(0, "\r\n\r\n<!--[if !IE]> oooooooooo CABECERA: CONDICIONES DE BUSQUEDA oooooooooo <![endif]-->\r\n<span class=\"r01Query\">\r\n");
            sb.append("</span>\r\n");
        }
        return sb;
    }

    private static StringBuffer _formatHeader(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSessionResults sessionResults) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        StringBuffer sb = new StringBuffer(200);
        sb.append("\r\n\r\n<!--[if !IE]>oooooooooo CABECERA: CONDICIONES DE BUSQUEDA oooooooooo <![endif]-->\r\n");
        if (appliedPrefs.queryFormatterPreferences.showRepositoriesResume && appliedPrefs.formatterImpls.searchedRepositoriesFormatterClassName != null) {
            try {
                sb.append("<div class=\"r01SearchSessionResultsHeader\">\r\n");
                R01MSearchedRepositoriesResumeFormatter repoFormatter = (R01MSearchedRepositoriesResumeFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchedRepositoriesFormatterClassName);
                sb.append(repoFormatter.doFormatRepositoriesResume(lang, appliedPrefs.queryFormatterPreferences, sessionResults));
                sb.append("</div>\r\n");
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                sb.append("Error al formatear la cabecera de b\u00fasqueda. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getMessage());
            }
        }
        return sb;
    }

    private StringBuffer _formatSearchGuide(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchGuideElement[] guidePastElements, R01MSearchGuideElement guideCurrentElement, R01MSearchGuideElement[] guideFutureElements) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        StringBuffer sb = new StringBuffer(85);
        try {
            if (appliedPrefs.formatterImpls.searchGuideFormatterClassName != null) {
                R01MSearchGuideFormatter guideFormatter = (R01MSearchGuideFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchGuideFormatterClassName);
                if (appliedPrefs.guideFormatterPreferences.guideType == 1) {
                    sb.append(guideFormatter.doFormatGuideAsCombo(lang, appliedPrefs.guideFormatterPreferences, guidePastElements, guideCurrentElement, guideFutureElements));
                } else if (appliedPrefs.guideFormatterPreferences.guideType == 2) {
                    sb.append(guideFormatter.doFormatGuideAsList(lang, appliedPrefs.guideFormatterPreferences, guidePastElements, guideCurrentElement, guideFutureElements, appliedPrefs.guideFormatterPreferences.guideColumnsNum));
                }
            }
        }
        catch (ReflectionException refEx) {
            refEx.printStackTrace(System.out);
            sb.append("Error al formatear la guia de navegaci\u00f3n. No se ha podido instanciar el formateador: ");
            sb.append(refEx.getMessage());
        }
        return sb;
    }

    private static StringBuffer _formatRssFeedLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, boolean rispAndRss) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        String subscripcionRSS = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "portal.rss.subscription");
        String queEsRSS = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "portal.rss.queRSS");
        StringBuffer sb = new StringBuffer(156);
        sb.append("\r\n\r\n<!--[if !IE]> oooooooooo SINDICACION DE CONTENIDOS oooooooooo <![endif]-->\r\n<div class=\"r01SearchSessionRssFeed");
        if (rispAndRss) {
            sb.append(" r01RssRispFloat");
        }
        sb.append("\">\r\n");
        String rssTitle = "";
        if (prefs != null) {
            rssTitle = prefs.getFormatterProperty("rssTitle");
        }
        String encodedTitleRSS = "";
        if (!StringUtils.isEmptyString((String)rssTitle)) {
            try {
                encodedTitleRSS = URLEncoder.encode((String)rssTitle, (String)"UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                encodedTitleRSS = rssTitle;
            }
        }
        Properties propsRSS = new Properties();
        if (rssTitle != null) {
            propsRSS.put("rssTitle", encodedTitleRSS);
        }
        if (subscripcionRSS != null) {
            propsRSS.put("subscripcionRSS", subscripcionRSS);
        }
        if (queEsRSS != null) {
            propsRSS.put("whatIsRSS", queEsRSS);
        }
        if (lang != null) {
            propsRSS.put("lang", lang);
        }
        propsRSS.put("typeVA", "SearchResult");
        if (appliedPrefs.resultsFormatterPreferences.itemUrlPrefix != null) {
            propsRSS.put("presentationPage", appliedPrefs.resultsFormatterPreferences.itemUrlPrefix);
        }
        sb.append(R01MSearchEngineUtils.decorateRSSFeedLink("rssid", "r01kQry=" + R01MSearchEngineUtils.encodeQueryObjectInURL(query), true, propsRSS));
        sb.append("</div>\r\n");
        return sb;
    }

    private static StringBuffer _formatRispLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, boolean rispAndRss) {
        StringBuffer sb = new StringBuffer(200);
        R01MQueryObject rispQuery = (R01MQueryObject)CloneUtils.cloneByReflection((Object)query);
        sb.append("\r\n\r\n<!--[if !IE]> oooooooooo FORMATO RISP oooooooooo <![endif]-->\r\n<div class=\"r01SearchSessionRispGlobal");
        if (rispAndRss) {
            sb.append(" r01RssRispFloat");
        }
        sb.append("\">\r\n");
        rispQuery.setPresentationProperty("r01PageSize", String.valueOf(R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE));
        rispQuery.getPresentationProperties().remove("r01NavBarBlockSize");
        R01MDefSearchSessionHtmlFormatter._formatXMLRispLink(lang, prefs, rispQuery, sb);
        R01MDefSearchSessionHtmlFormatter._formatRDFRispLink(lang, prefs, rispQuery, sb);
        sb.append("</div>\r\n");
        return sb;
    }

    private static void _formatXMLRispLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, StringBuffer sbRisp) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        String xmlRispLabel = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.xml.label");
        String queXMLRisp = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.xml.queXMLRisp");
        String queXMLRispTitle = "risp XML";
        sbRisp.append("\r\n\r\n<!--[if !IE]> oooooooooo FORMATO RISP XML oooooooooo <![endif]-->\r\n<div class=\"r01SearchSessionRisp\">\r\n");
        Properties propsRisp = new Properties();
        propsRisp.put("rispUrl", "/r01htSearchResultWAR/r01hPresentationXML.jsp");
        propsRisp.put("rispImage", "/AVComun/r01gSearchResultVA/images/r01gRispXML.gif");
        propsRisp.put("typeVA", "SearchResult");
        propsRisp.put("rispPageInfo", R01MSearchEngineWebConstants.XML_PAGE_INFO);
        if (xmlRispLabel != null) {
            propsRisp.put("labelRisp", xmlRispLabel);
        }
        if (queXMLRisp != null) {
            propsRisp.put("whatIsRisp", queXMLRisp);
        }
        if (queXMLRispTitle != null) {
            propsRisp.put("whatIsRispTitle", queXMLRispTitle);
        }
        if (lang != null) {
            propsRisp.put("lang", lang);
        }
        if (appliedPrefs.resultsFormatterPreferences.itemUrlPrefix != null) {
            propsRisp.put("presentationPage", appliedPrefs.resultsFormatterPreferences.itemUrlPrefix);
        }
        sbRisp.append(R01MSearchEngineUtils.decorateRispLink("r01RispXML", "r01kQry=" + R01MSearchEngineUtils.encodeQueryObjectInURL(query), true, propsRisp));
        sbRisp.append("</div>\r\n");
    }

    private static void _formatRDFRispLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, StringBuffer sbRisp) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        String rdfRispLabel = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.rdf.label");
        String queRDFRisp = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.rdf.queRDFRisp");
        String queRDFRispTitle = "risp RDF";
        sbRisp.append("\r\n\r\n<!--[if !IE]> oooooooooo FORMATO RISP RDF oooooooooo <![endif]-->\r\n<div class=\"r01SearchSessionRisp\">\r\n");
        Properties propsRisp = new Properties();
        propsRisp.put("rispUrl", "/r01htSearchResultWAR/r01DataSet.rdf");
        propsRisp.put("rispImage", "/AVComun/r01gSearchResultVA/images/r01gRispRDF.gif");
        propsRisp.put("typeVA", "SearchResult");
        propsRisp.put("rispPageInfo", R01MSearchEngineWebConstants.RDF_PAGE_INFO);
        if (rdfRispLabel != null) {
            propsRisp.put("labelRisp", rdfRispLabel);
        }
        if (queRDFRisp != null) {
            propsRisp.put("whatIsRisp", queRDFRisp);
        }
        if (queRDFRispTitle != null) {
            propsRisp.put("whatIsRispTitle", queRDFRispTitle);
        }
        if (lang != null) {
            propsRisp.put("lang", lang);
        }
        if (appliedPrefs.resultsFormatterPreferences.itemUrlPrefix != null) {
            propsRisp.put("presentationPage", appliedPrefs.resultsFormatterPreferences.itemUrlPrefix);
        }
        sbRisp.append(R01MSearchEngineUtils.decorateRispLink("r01RispRDF", "r01kQry=" + R01MSearchEngineUtils.encodeQueryObjectInURL(query), true, propsRisp));
        sbRisp.append("</div>\r\n");
    }

    private static StringBuffer _formatResults(String lang, R01MSearchSessionFormatterPreferences prefs, Map searchResultsBySource, Map preGeneratedCode, R01MQueryObject qry) {
        StringBuffer sb;
        R01MSearchSessionFormatterPreferences appliedPrefs;
        R01MSearchSessionFormatterPreferences r01MSearchSessionFormatterPreferences = appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        if (searchResultsBySource != null) {
            sb = new StringBuffer(5000);
            sb.append("\r\n\r\n<!--[if !IE]> oooooooooo RESULTADOS POR ORIGEN oooooooooo <![endif]-->\r\n<div class=\"r01SearchResultsBySource\">\r\n");
            R01MSearchSourceResults currSrcResults = null;
            Iterator it = searchResultsBySource.values().iterator();
            while (it.hasNext()) {
                StringBuffer queryFormatted;
                currSrcResults = (R01MSearchSourceResults)it.next();
                if (currSrcResults.getResults() == null || currSrcResults.getResults().length == 0) {
                    if (SHOW_SUGGESTIONS_ONLY_IN_FULL_TEXT_SEARCHS && (!SHOW_SUGGESTIONS_ONLY_IN_FULL_TEXT_SEARCHS || !qry.isFullTextSearch() && StringUtils.isEmptyString((String)qry.getFullText()))) continue;
                    sb.append(R01MDefSearchSessionHtmlFormatter._composeNoResultsMessage(lang));
                    continue;
                }
                StringBuffer navBarText = null;
                StringBuffer navBar = null;
                try {
                    if (appliedPrefs.navBarFormatterPreferences.showSourceResultsNavBars && appliedPrefs.formatterImpls.searchResultsNavBarFormatterClassName != null) {
                        R01MSearchResultsNavBarFormatter navFormatter = (R01MSearchResultsNavBarFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchResultsNavBarFormatterClassName);
                        navBarText = navFormatter.doFormatNavBarText(lang, appliedPrefs.navBarFormatterPreferences, it.hasNext(), currSrcResults.getSourceOid(), currSrcResults.getSourceDetails().getSourceName(), currSrcResults.getNumberOfResults(), currSrcResults.getNumberOfPages(), currSrcResults.getNavBar());
                        navBar = navFormatter.doFormatNavBar(lang, appliedPrefs.navBarFormatterPreferences, it.hasNext(), currSrcResults.getSourceOid(), currSrcResults.getSourceDetails().getSourceName(), currSrcResults.getNumberOfResults(), currSrcResults.getNumberOfPages(), currSrcResults.getNavBar());
                    }
                }
                catch (ReflectionException refEx) {
                    refEx.printStackTrace(System.out);
                    sb.append("Error al formatear la guia. No se ha podido instanciar el formateador: ");
                    sb.append(refEx.getDetailedMessage());
                }
                sb.append("\r\n\r\n\t<!--[if !IE]> :::: RESULTADOS DEL ORIGEN ");
                sb.append(currSrcResults.getSourceDetails().getSourceName());
                sb.append(" <![endif]-->\r\n");
                sb.append("\t<div class=\"r01SearchResultsSource \">\r\n\t<a name=\"");
                sb.append(currSrcResults.getSourceOid());
                sb.append("\" class=\"r01Invisible\">");
                sb.append(currSrcResults.getSourceDetails().getSourceName());
                sb.append('(');
                sb.append(currSrcResults.getSourceOid());
                sb.append(")</a>\r\n");
                if (prefs != null && prefs.resultsFormatterPreferences.showOrderByTabs) {
                    sb.append("\t<div class=\"r01TabsContainer r01clearfix\"><!-- Tabs Ordenacion -->\r\n\t\t<span class=\"r01OrderByTxt\">");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanas.ordenar"));
                    sb.append("</span>\r\n\t\t<div class=\"r01topTabs r01topTabsRight r01OrderByTabs\">\r\n\t\t\t<ul>\r\n\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanas.fecha"));
                    sb.append("</span></a></li>\r\n\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanas.relevancia"));
                    sb.append("</span></a></li>\r\n\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanas.ordeAlfab"));
                    sb.append("</span></a></li>\r\n\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanas.vigencia"));
                    sb.append("</span></a></li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t</div><!--[if !IE]> Tabs de ordenacion <![endif]-->\r\n");
                }
                sb.append("\t<div class=\"r01SourceNavBarAndResults\">\r\n");
                StringBuffer stringBuffer = queryFormatted = preGeneratedCode != null && preGeneratedCode.get("query") != null ? (StringBuffer)preGeneratedCode.get("query") : null;
                if (prefs != null) {
                    String highLightNoScriptTitle;
                    String highLightNoScriptText;
                    if (prefs.showRSSFeedLink && prefs.showRisp) {
                        sb.append("<div class=\"r01clearfix r01SearchSessionRSSRisp\">");
                    }
                    if (prefs.showRSSFeedLink) {
                        sb.append(R01MDefSearchSessionHtmlFormatter._formatRssFeedLink(lang, prefs, qry, prefs.showRisp));
                    }
                    if (prefs.showRisp) {
                        sb.append(R01MDefSearchSessionHtmlFormatter._formatRispLink(lang, prefs, qry, prefs.showRSSFeedLink));
                        if (!prefs.showRSSFeedLink) {
                            sb.append("<!--#include virtual='/AVComun/r01gSearchResultVA/html/risp_anuncio_contratacion_leyend_");
                            sb.append(lang);
                            sb.append(".html'-->");
                            sb.append("<!--#include virtual='/AVComun/r01gSearchResultVA/html/risp_leyend_");
                            sb.append(lang);
                            sb.append(".html'-->");
                        }
                    }
                    if (prefs.showRSSFeedLink && prefs.showRisp) {
                        sb.append("<!--#include virtual='/AVComun/r01gSearchResultVA/html/risp_anuncio_contratacion_leyend_");
                        sb.append(lang);
                        sb.append(".html'-->");
                        sb.append("<!--#include virtual='/AVComun/r01gSearchResultVA/html/risp_leyend_");
                        sb.append(lang);
                        sb.append(".html'--></div>");
                    }
                    StringBuffer supNavBarText = new StringBuffer(200);
                    supNavBarText.append(navBarText);
                    if (lang != null && lang.equalsIgnoreCase("eu")) {
                        supNavBarText.append(preGeneratedCode != null && queryFormatted != null && queryFormatted.length() > 0 ? queryFormatted : "");
                    } else {
                        supNavBarText.append(preGeneratedCode != null && queryFormatted != null && queryFormatted.length() > 0 ? queryFormatted : "");
                    }
                    sb.append(R01MDefSearchSessionHtmlFormatter._formatNavBar(supNavBarText, navBar, it.hasNext(), currSrcResults.getSourceDetails().getSourceName(), currSrcResults.getNumberOfPages(), currSrcResults.getNavBar(), prefs.showResultsHeader));
                    if (prefs.showBanner || !"0".equals(prefs.getFormatterProperty("maxNumHighLightsValue"))) {
                        sb.append("\t<div id=\"r01SourceHighLights_");
                        sb.append(prefs.getFormatterProperty("vaName"));
                        sb.append("\" class=\"r01SourceSearchResults\">\r\n\t<!-- en caso de que el navegador no soporte javascript mostrar una p\u00e1gina con todas los destacados -->\r\n");
                        if (qry.getFullText() != null) {
                            sb.append("\t<noscript>\r\n");
                            highLightNoScriptText = prefs.getFormatterProperty("highlightedNoScriptText");
                            if (highLightNoScriptText == null || StringUtils.isEmptyString((String)highLightNoScriptText)) {
                                highLightNoScriptText = "Enlaces Destacados";
                            }
                            if ((highLightNoScriptTitle = prefs.getFormatterProperty("highlightedNoScriptTitle")) == null || StringUtils.isEmptyString((String)highLightNoScriptTitle)) {
                                highLightNoScriptTitle = "";
                            }
                            sb.append("\t\t<a href=\"http://euskadi.colbenson.es/highlightedSearchResults?jsoncallback=?&r01FullText=");
                            sb.append(qry.getFullText());
                            sb.append("&r01IncludeBanner=");
                            sb.append(prefs.showBanner);
                            sb.append("&r01MaxNumHighLights=");
                            sb.append(prefs.getFormatterProperty("maxNumHighLightsValue"));
                            sb.append("&t=html&r01SearchResultsPresentation=");
                            sb.append(prefs.getFormatterProperty("R01HPortal"));
                            sb.append('-');
                            sb.append(prefs.getFormatterProperty("R01HPage"));
                            sb.append('/');
                            sb.append(prefs.getFormatterProperty("R01HLang"));
                            sb.append("&r01ContentsPresentation=\" title=\"");
                            sb.append(highLightNoScriptTitle);
                            sb.append("\">[");
                            sb.append(highLightNoScriptText);
                            sb.append("]</a>\t</noscript>\r\n");
                        }
                        sb.append("\t</div>\r\n");
                    }
                    if (prefs.showSemanticSearch) {
                        sb.append("\t<div id=\"r01SemanticSearchResults_");
                        sb.append(prefs.getFormatterProperty("vaName"));
                        sb.append("\" class=\"r01SemanticSearchResults\">\r\n\t<!-- en caso de que el navegador no soporte javascript mostrar una p\u00e1gina con todas los destacados -->\r\n");
                        if (!StringUtils.isEmptyString((String)qry.getFullText())) {
                            sb.append("\t<noscript>\r\n");
                            highLightNoScriptText = prefs.getFormatterProperty("highlightedNoScriptText");
                            if (highLightNoScriptText == null || StringUtils.isEmptyString((String)highLightNoScriptText)) {
                                highLightNoScriptText = "Enlaces Destacados";
                            }
                            if ((highLightNoScriptTitle = prefs.getFormatterProperty("highlightedNoScriptTitle")) == null || StringUtils.isEmptyString((String)highLightNoScriptTitle)) {
                                highLightNoScriptTitle = "";
                            }
                            sb.append("\t\t<a href=\"http://ws07.inbenta.com/euskadinet?jsoncallback=?&r01FullText=");
                            sb.append(qry.getFullText());
                            sb.append("&t=html&r01SearchResultsPresentation=");
                            sb.append(prefs.getFormatterProperty("R01HPortal"));
                            sb.append('-');
                            sb.append(prefs.getFormatterProperty("R01HPage"));
                            sb.append('/');
                            sb.append(prefs.getFormatterProperty("R01HLang"));
                            sb.append("&r01ContentsPresentation=\" title=\"");
                            sb.append(highLightNoScriptTitle);
                            sb.append("\">[");
                            sb.append(highLightNoScriptText);
                            sb.append("]</a>\t</noscript>\r\n");
                        }
                        sb.append("\t</div>\r\n");
                    }
                    sb.append(R01MDefSearchSessionHtmlFormatter._formatResultItems(lang, appliedPrefs, currSrcResults.getResults()));
                    sb.append(R01MDefSearchSessionHtmlFormatter._formatNavBar(navBarText, navBar, false, currSrcResults.getSourceDetails().getSourceName(), currSrcResults.getNumberOfPages(), currSrcResults.getNavBar(), prefs.showResultsHeader));
                }
                sb.append("\t</div>\r\n\t</div>\r\n\t<!--[if !IE]> FIN RESULTADOS DEL ORIGEN ");
                sb.append(currSrcResults.getSourceDetails().getSourceName());
                sb.append(" <![endif]-->\r\n\r\n\r\n");
            }
        } else {
            StringBuffer queryFormatted;
            sb = new StringBuffer();
            sb.append("\r\n\r\n<!--[if !IE]> oooooooooo RESULTADOS POR ORIGEN oooooooooo <![endif]-->\r\n<div class=\"r01SearchResultsBySource\">\r\n");
            StringBuffer navBarText = null;
            try {
                if (appliedPrefs.navBarFormatterPreferences.showSourceResultsNavBars && appliedPrefs.formatterImpls.searchResultsNavBarFormatterClassName != null) {
                    R01MSearchResultsNavBarFormatter navFormatter = (R01MSearchResultsNavBarFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchResultsNavBarFormatterClassName);
                    navBarText = navFormatter.doFormatNavBarText(lang, appliedPrefs.navBarFormatterPreferences, false, "", "", 0, 0, new R01MSearchNavBar());
                }
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                sb.append("Error al formatear la guia. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getDetailedMessage());
            }
            StringBuffer supNavBarText = new StringBuffer(200);
            supNavBarText.append(navBarText);
            StringBuffer stringBuffer = queryFormatted = preGeneratedCode != null && preGeneratedCode.get("query") != null ? (StringBuffer)preGeneratedCode.get("query") : null;
            if (lang != null && lang.equalsIgnoreCase("eu")) {
                supNavBarText.append(preGeneratedCode != null && queryFormatted != null && queryFormatted.length() > 0 ? queryFormatted : "");
            } else {
                supNavBarText.append(preGeneratedCode != null && queryFormatted != null && queryFormatted.length() > 0 ? queryFormatted : "");
            }
            sb.append(R01MDefSearchSessionHtmlFormatter._formatNavBar(supNavBarText, new StringBuffer(), false, "", 0, null, prefs.showResultsHeader));
            if (!SHOW_SUGGESTIONS_ONLY_IN_FULL_TEXT_SEARCHS || SHOW_SUGGESTIONS_ONLY_IN_FULL_TEXT_SEARCHS && (qry.isFullTextSearch() || !StringUtils.isEmptyString((String)qry.getFullText()))) {
                sb.append(R01MDefSearchSessionHtmlFormatter._composeNoResultsMessage(lang));
            }
        }
        sb.append("</div>\r\n<!--[if !IE]> oooooooooo FIN RESULTADOS POR ORIGEN oooooooooo <![endif]-->\r\n");
        return sb;
    }

    private static StringBuffer _formatResultItems(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchResultItem[] items) {
        StringBuffer sb;
        R01MSearchSessionFormatterPreferences appliedPrefs;
        R01MSearchSessionFormatterPreferences r01MSearchSessionFormatterPreferences = appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        if (appliedPrefs.formatterImpls.searchResultItemFormatterClassName != null) {
            sb = new StringBuffer(5000);
            try {
                R01MSearchResultItemsFormatter resultsFormatter = (R01MSearchResultItemsFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchResultItemFormatterClassName);
                sb.append(resultsFormatter.doFormatResultItems(lang, appliedPrefs.resultsFormatterPreferences, items));
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                sb.append("Error al formatear los resultados. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getDetailedMessage());
            }
        } else {
            sb = new StringBuffer();
        }
        return sb;
    }

    private static StringBuffer _formatNavBar(StringBuffer navBarText, StringBuffer navBarFormatted, boolean areThereMoreSources, String sourceName, int numPages, R01MSearchNavBar navBar, boolean showHeader) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("\t<!--[if !IE]> BARRA DE NAVEGACI\u00d3N EN EL ORIGEN <![endif]-->\r\n\t<div class=\"r01SearchResultsNavBar r01clearfix\">\r\n");
        String colsClassName = "r01SearchResultsNavBar" + (numPages == 0 ? "1" : (areThereMoreSources ? "3" : "2")) + "cols";
        if (areThereMoreSources) {
            sb.append("\t\t<div class=\"r01SearchSourceName ");
            sb.append(colsClassName);
            sb.append("_1\">");
            sb.append(sourceName);
            sb.append("</div>\r\n");
        }
        sb.append("\t\t<div class=\"r01SearchSourcePagCtx ");
        sb.append(colsClassName);
        sb.append("_2\">");
        if (showHeader) {
            sb.append(navBarText);
        }
        sb.append("\t\t</div>\r\n");
        if (numPages > 0 && navBar.getNavBarItems() != null && navBar.getNavBarItems().size() >= 4) {
            sb.append("\t\t<div class=\"r01SearchResultsNavBarItems ");
            sb.append(colsClassName);
            sb.append("_32\">\r\n");
            sb.append(navBarFormatted);
            sb.append("\t\t</div>\r\n");
        }
        sb.append("\t</div>\r\n\t<!--[if !IE]> FIN BARRA DE NAVEGACI\u00d3N EN EL ORIGEN <![endif]-->\r\n");
        return sb;
    }

    private static StringBuffer _composeNoResultsMessage(String lang) {
        StringBuffer msg = new StringBuffer(500);
        String line1 = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "noResults.line1") + "&nbsp;";
        String line1_2 = "";
        String line2 = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "noResults.line2");
        String sug1 = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "noResults.sugerencia1");
        String sug2 = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "noResults.sugerencia2");
        String sug3 = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "noResults.sugerencia3");
        msg.append("<div class=\"r01noResults\"><p class=\"r01noResultsLine1\">");
        msg.append(line1 != null && line1_2 != null ? line1 + line1_2 : "[NO Results]");
        msg.append("</p>");
        if (line2 != null) {
            msg.append("<p class=\"r01noResultsLine2\">");
            msg.append(line2);
            msg.append("</p>");
        }
        if (sug1 != null || sug2 != null || sug3 != null) {
            msg.append("<ul>");
            if (sug1 != null) {
                msg.append("<li>");
                msg.append(sug1);
                msg.append("</li>");
            }
            if (sug2 != null) {
                msg.append("<li>");
                msg.append(sug2);
                msg.append("</li>");
            }
            if (sug3 != null) {
                msg.append("<li>");
                msg.append(sug3);
                msg.append("</li>");
            }
            msg.append("</ul>");
        }
        msg.append("</div>");
        return msg;
    }
}

