/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.objects.searchengine.results.R01MSearchNavBar;
import com.ejie.r01m.objects.searchengine.results.R01MSearchNavBarItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterURLHelpper;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultsNavBarFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsNavBarFormatterPreferences;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MDefSearchResultsNavBarHtmlFormatter
implements R01MSearchResultsNavBarFormatter,
Serializable {
    private static final long serialVersionUID = -7493222398944421761L;
    private static final boolean SHOW_RESUME_HEADER_WITH_NO_RESULTS = XMLProperties.getBoolean((String)R01MConstants.API_APPCODE, (String)"searchEngine/showResumeHeaderWithNoResults", (boolean)true);

    @Override
    public StringBuffer doFormatNavBarText(String lang, R01MSearchResultsNavBarFormatterPreferences prefs, boolean areThereMoreSources, String sourceOid, String sourceName, int numResults, int numPages, R01MSearchNavBar navBar) {
        if (numResults < 0 || !SHOW_RESUME_HEADER_WITH_NO_RESULTS && numResults == 0) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer outPaggingTxt = new StringBuffer(2000);
        StringBuffer paggingSB = new StringBuffer(500);
        paggingSB.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.numResultados"));
        if (numPages > 0) {
            paggingSB.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.resultados"));
        } else {
            paggingSB.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "noResults.headerprefix"));
        }
        Properties props = new Properties();
        try {
            NumberFormat nf = NumberFormat.getInstance();
            props.setProperty("numResultados", nf.format(numResults));
            props.setProperty("currPage", nf.format(navBar.getCurrentPage()));
            props.setProperty("totalPages", nf.format(numPages));
            props.setProperty("currPageFirstEl", nf.format(navBar.getCurrentPageFirstElementNumber()));
            props.setProperty("currPageLastEl", nf.format(navBar.getCurrentPageLastElementNumber()));
        }
        catch (NumberFormatException nfEx) {
            nfEx.printStackTrace(System.out);
            props.setProperty("numResultados", Integer.toString(numResults));
            props.setProperty("currPage", Integer.toString(navBar.getCurrentPage()));
            props.setProperty("totalPages", Integer.toString(numPages));
            props.setProperty("currPageFirstEl", Integer.toString(navBar.getCurrentPageFirstElementNumber()));
            props.setProperty("currPageLastEl", Integer.toString(navBar.getCurrentPageLastElementNumber()));
        }
        try {
            Pattern p = Pattern.compile("(\\$\\[[^]$]+\\]\\$)");
            Matcher m = p.matcher(paggingSB);
            boolean directiveValid = m.find();
            String foundDirective = null;
            String propValue = null;
            while (directiveValid) {
                foundDirective = paggingSB.substring(m.start(), m.end());
                propValue = props.getProperty(foundDirective.substring(2, foundDirective.length() - 2));
                m.appendReplacement(outPaggingTxt, propValue != null ? propValue : "");
                directiveValid = m.find();
            }
            m.appendTail(outPaggingTxt);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        return outPaggingTxt;
    }

    @Override
    public StringBuffer doFormatNavBar(String lang, R01MSearchResultsNavBarFormatterPreferences prefs, boolean areThereMoreSources, String sourceOid, String sourceName, int numResults, int numPages, R01MSearchNavBar navBar) {
        if (navBar.getNavBarItems().size() < 4) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("\t\t\t<ul class=\"r01NavBarItems\">\r\n");
        Iterator it = navBar.getNavBarItems().iterator();
        R01MSearchNavBarItem currItem = null;
        String itemStyleClass = null;
        String itemText = null;
        String itemAlt = null;
        String itemURL = null;
        R01MSearchNavBarItem firstPageItem = navBar.findFirstPageItem();
        R01MSearchNavBarItem lastPageItem = navBar.findLastPageItem();
        boolean prevPagesBlockMarkIncluded = false;
        boolean nextPagesBlockMarkIncluded = false;
        do {
            currItem = (R01MSearchNavBarItem)it.next();
            itemURL = "";
            if (currItem.getItemType().equals("firstPage")) continue;
            if (currItem.getItemType().equals("previousBlock")) {
                itemStyleClass = "r01NavBarCtrlItem r01NavBarPrevBlock";
                itemText = "&nbsp;&nbsp;&nbsp;&nbsp;";
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.bloqueanterior");
                itemURL = itemURL + R01MSearchFormatterURLHelpper.composePrevBlockURL(sourceOid, currItem.getPageNum());
            } else if (currItem.getItemType().equals("prevPage")) {
                itemStyleClass = "r01NavBarCtrlItem";
                itemText = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.anterior");
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.paganterior");
                itemURL = itemURL + R01MSearchFormatterURLHelpper.composePrevPageURL(sourceOid, currItem.getPageNum());
            } else if (currItem.getItemType().equals("pageX")) {
                itemStyleClass = "r01NavBarItem";
                if (currItem != lastPageItem) {
                    itemStyleClass = itemStyleClass + " r01NavBarIntermediateItem";
                }
                itemText = Integer.toString(currItem.getPageNum());
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.pagina") + itemText;
                itemURL = itemURL + R01MSearchFormatterURLHelpper.composePageURL(sourceOid, currItem.getPageNum());
            } else if (currItem.getItemType().equals("nextPage")) {
                itemStyleClass = "r01NavBarCtrlItem";
                itemText = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.siguiente");
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.pagsiguiente");
                itemURL = itemURL + R01MSearchFormatterURLHelpper.composeNextPageURL(sourceOid, currItem.getPageNum());
            } else if (currItem.getItemType().equals("nextBlock")) {
                itemStyleClass = "r01NavBarCtrlItem r01NavBarNextBlock";
                itemText = "&nbsp;&nbsp;&nbsp;&nbsp;";
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "navegaBarra.bloquesiguiente");
                itemURL = itemURL + R01MSearchFormatterURLHelpper.composeNextBlockURL(sourceOid, currItem.getPageNum());
            } else if (currItem.getItemType().equals("lastPage")) continue;
            if (!prevPagesBlockMarkIncluded && currItem == firstPageItem && currItem.getPageNum() > navBar.getNavBarBlockSize()) {
                sb.append("\t\t\t\t<li class=\"r01NavBarItem\">...</li>\r\n");
                prevPagesBlockMarkIncluded = true;
            }
            itemURL = itemURL + "#" + sourceOid;
            sb.append("\t\t\t\t<li class=\"");
            sb.append(itemStyleClass);
            sb.append("\">");
            if (currItem.getPageNum() != navBar.getCurrentPage()) {
                sb.append("<a href=\"");
                sb.append(StringEscapeUtils.escapeHtml((String)itemURL));
                sb.append("\" title=\"");
                sb.append(itemAlt);
                sb.append("\">");
                sb.append(itemText);
                sb.append("</a>");
            } else {
                sb.append("<strong>");
                sb.append(itemText);
                sb.append("</strong>");
            }
            sb.append("</li>\r\n");
            if (nextPagesBlockMarkIncluded || currItem != lastPageItem || currItem.getPageNum() >= navBar.getTotalNumberOfPages()) continue;
            sb.append("\t\t\t\t<li class=\"r01NavBarItem\">...</li>\r\n");
            nextPagesBlockMarkIncluded = true;
        } while (it.hasNext());
        sb.append("\t\t\t</ul>\r\n");
        return sb;
    }
}

