/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class R01MDefSearchResultItemsHtmlFormatter
implements R01MSearchResultItemsFormatter,
Serializable {
    private static final long serialVersionUID = 8893493012869809487L;
    protected Properties _typoDepFormatterClassNames = null;

    @Override
    public void setTypoDependantFormatterClassNames(Properties classNames) {
        this._typoDepFormatterClassNames = classNames;
        if (this._typoDepFormatterClassNames == null) {
            this._typoDepFormatterClassNames = new Properties();
            this._typoDepFormatterClassNames.put("default", R01MClientFactory.getPropertiesConfigAPI().getProperty("searchEngine/defaultHTMLFormatters/searchResultDefault", "com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter"));
        }
    }

    @Override
    public StringBuffer doFormatResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        if (results == null || results.length == 0) {
            return new StringBuffer("\t<!-- LISTA DE ELEMENTOS (items) -->\r\n");
        }
        StringBuffer sb = new StringBuffer(720);
        sb.append("\t<!--[if !IE]> LISTA DE ELEMENTOS (items) <![endif]-->\r\n");
        LinkedHashMap<String, DocItemsWrapper> docs = new LinkedHashMap<String, DocItemsWrapper>(results.length);
        DocItemsWrapper currDocItemsWrapper2 = null;
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == null) continue;
            currDocItemsWrapper2 = (DocItemsWrapper)docs.get(results[i].getDocumentOid());
            if (currDocItemsWrapper2 == null) {
                currDocItemsWrapper2 = new DocItemsWrapper();
                docs.put(results[i].getDocumentOid(), currDocItemsWrapper2);
            }
            if (results[i].isDocumentMainDataFile()) {
                currDocItemsWrapper2.addItem(0, results[i]);
                continue;
            }
            currDocItemsWrapper2.addItem(results[i]);
        }
        sb.append("\t<div class=\"r01SourceSearchResults\">\r\n\t\t<ul>\r\n");
        for (DocItemsWrapper currDocItemsWrapper2 : docs.values()) {
            sb.append(this._formatResultItem(lang, prefs, currDocItemsWrapper2));
        }
        sb.append("\t\t</ul>\r\n\t</div>\r\n\t<!--[if !IE]> FIN LISTA DE ELEMENTOS (items) <![endif]-->\r\n");
        return sb;
    }

    public StringBuffer doFormatResultItem(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem result) {
        if (result == null) {
            return new StringBuffer("\t<!-- LISTA DE ELEMENTOS (items) -->\r\n");
        }
        StringBuffer sb = new StringBuffer();
        DocItemsWrapper currDocItemsWrapper = new DocItemsWrapper();
        if (result.isDocumentMainDataFile()) {
            currDocItemsWrapper.addItem(0, result);
        } else {
            currDocItemsWrapper.addItem(result);
        }
        sb.append(this._formatResultItem(lang, prefs, currDocItemsWrapper));
        return sb;
    }

    protected StringBuffer _formatResultItem(String lang, R01MSearchResultsFormatterPreferences prefs, DocItemsWrapper currDocItemsWrapper) {
        StringBuffer sb = new StringBuffer(256);
        StringBuffer leftColSb = null;
        StringBuffer rightColSb = null;
        R01MSearchResultItem[] items = currDocItemsWrapper.getItemsArray();
        try {
            StringBuffer docTitle = R01MSearchResultItemFormatterUtils.composeDocumentTitle(this._typoDepFormatterClassNames, lang, items[0], prefs);
            StringBuffer docDesc = R01MSearchResultItemFormatterUtils.composeDocumentDescription(this._typoDepFormatterClassNames, lang, items[0], prefs);
            StringBuffer typoInfo = R01MSearchResultItemFormatterUtils.composeTypoInfo(this._typoDepFormatterClassNames, lang, items[0], prefs);
            StringBuffer typoDetails = R01MSearchResultItemFormatterUtils.composeTypoDetails(this._typoDepFormatterClassNames, lang, items[0], prefs);
            StringBuffer catalogDetails = R01MSearchResultItemFormatterUtils.composeCatalogDetails(this._typoDepFormatterClassNames, lang, items[0], prefs);
            StringBuffer metaDataDetails = R01MSearchResultItemFormatterUtils.composeMetaDataDetail(this._typoDepFormatterClassNames, lang, items[0], prefs);
            sb.append("\t\t\t<li class=\"r01srItem r01clearfix\">\r\n");
            leftColSb = new StringBuffer(128);
            StringBuffer itemFormatted = R01MSearchResultItemFormatterUtils.composeDocument(this._typoDepFormatterClassNames, lang, items[0], currDocItemsWrapper.getNumItems(), currDocItemsWrapper.areAllItemsAttachmentFiles(), docTitle, docDesc, typoInfo, typoDetails, catalogDetails, metaDataDetails, prefs);
            leftColSb.append(itemFormatted);
            if (prefs.showAttachments && items.length >= 1) {
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].fileName != null && items[i].fileName.indexOf("gendata.txt") < 0) {
                        if (items[i].isDocumentMainDataFile()) continue;
                        itemFormatted = R01MSearchResultItemFormatterUtils.composeAttachment(this._typoDepFormatterClassNames, lang, items[i], prefs);
                        leftColSb.append(itemFormatted);
                        continue;
                    }
                    R01FLog.to((String)"r01m.searchEngine").info("El item resultado de b\u00fasqueda NO incorpora el metaDato 'fileName': Revisa la configuraci\u00f3n de almacenamiento de metaDatos para la b\u00fasqueda!!!");
                }
            }
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)metaDataDetails)) {
                rightColSb = metaDataDetails;
            }
            String widthStyle = StringUtils.isEmptyStringBuffer((StringBuffer)rightColSb) ? " r01allWidth" : "";
            sb.append("\t\t\t<div class=\"r01srItemCommon");
            sb.append(widthStyle);
            sb.append("\">\r\n");
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)leftColSb)) {
                sb.append(leftColSb);
            }
            sb.append("\t\t\t</div>\r\n");
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)rightColSb)) {
                sb.append("\t\t\t<div class=\"r01srItemMetaData\">\r\n");
                sb.append(rightColSb);
                sb.append("\t\t\t</div>\r\n");
            }
            sb.append("\t\t\t</li>\r\n");
        }
        catch (Exception ex) {
            sb.append("<!--<li class=\"r01srItem r01clearfix\"><div class=\"r01srItemCommon r01allWidth\"><div class=\"r01srItemDocLink\"><em class=\"r01srItemDocName\">");
            sb.append(StringUtils.replaceString((String)R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.document.error"), (String)"[$[documentName]$]", (String)(items[0] != null ? items[0].getContentName() + "/" + items[0].getDocumentInternalName() : "null")));
            sb.append(":");
            sb.append(ex.getMessage());
            sb.append("</em></div></div></li>-->").append("\t\t\t</li>\r\n");
            R01FLog.to((String)"r01m.search").severe("Error al formatear un resultado de b\u00fasqueda: " + ex.getMessage());
            ex.printStackTrace();
        }
        return sb;
    }

    public Map doFormatSimpleResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        LinkedHashMap<String, StringBuffer> sb = new LinkedHashMap<String, StringBuffer>();
        if (results.length > 0) {
            for (int i = 0; i < results.length; ++i) {
                sb.put(results[i].documentOid, this._formatSimpleResultItem(lang, prefs, results[i]));
            }
        }
        return sb;
    }

    protected StringBuffer _formatSimpleResultItem(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (prefs == null) {
            prefs = new R01MSearchResultsFormatterPreferences();
            prefs.sourceFormatter = "SEARCH_RESULT";
        }
        StringBuffer sb = new StringBuffer(500);
        sb.append("<div  class=\"r01clearfix\">");
        StringBuffer docTitle = R01MSearchResultItemFormatterUtils.composeDocumentTitle(this._typoDepFormatterClassNames, lang, item, prefs);
        StringBuffer typoInfo = R01MSearchResultItemFormatterUtils.composeTypoInfo(this._typoDepFormatterClassNames, lang, item, prefs);
        StringBuffer typoDetails = R01MSearchResultItemFormatterUtils.composeTypoDetails(this._typoDepFormatterClassNames, lang, item, prefs);
        StringBuffer catalogDetails = R01MSearchResultItemFormatterUtils.composeCatalogDetails(this._typoDepFormatterClassNames, lang, item, prefs);
        StringBuffer metaDataDetails = R01MSearchResultItemFormatterUtils.composeMetaDataDetail(this._typoDepFormatterClassNames, lang, item, prefs);
        sb.append(R01MSearchResultItemFormatterUtils.composeDocument(this._typoDepFormatterClassNames, lang, item, 0, false, docTitle, null, typoInfo, typoDetails, catalogDetails, metaDataDetails, prefs));
        sb.append("</div>");
        return sb;
    }

    protected class DocItemsWrapper {
        private LinkedList docItems = new LinkedList();
        private int numItems = 0;
        private boolean allItemsAreAttachmentFiles = true;

        public DocItemsWrapper() {
        }

        public DocItemsWrapper(R01MSearchResultItem item) {
            this.addItem(item);
            this.allItemsAreAttachmentFiles = false;
        }

        public void setNumItems(int theNumItems) {
            this.numItems = theNumItems;
        }

        public int getNumItems() {
            return this.numItems;
        }

        public void addItem(R01MSearchResultItem theItem) {
            if (theItem.fileName != null && theItem.fileName.indexOf("gendata.txt") >= 0) {
                this.allItemsAreAttachmentFiles = false;
            }
            this.docItems.add(theItem);
            ++this.numItems;
        }

        public void addItem(int position, R01MSearchResultItem theItem) {
            if (theItem.fileName != null && theItem.fileName.indexOf("gendata.txt") >= 0) {
                this.allItemsAreAttachmentFiles = false;
            }
            this.docItems.add(position, theItem);
            ++this.numItems;
        }

        public R01MSearchResultItem[] getItemsArray() {
            R01MSearchResultItem[] outItems = new R01MSearchResultItem[this.docItems.size()];
            int i = 0;
            Iterator it = this.docItems.iterator();
            while (it.hasNext()) {
                outItems[i] = (R01MSearchResultItem)it.next();
                ++i;
            }
            return outItems;
        }

        public boolean areAllItemsAttachmentFiles() {
            return this.allItemsAreAttachmentFiles;
        }
    }
}

