/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01m.config.objects.formatters.R01MFormatterClassConfig;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemGeoCatalog;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemTypoDependantFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MDefSearchResultHttpClientFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer outSb = new StringBuffer(133);
        String tipo = super.obtainTypoId(lang, item);
        outSb.append("\t\t\t\t\t\t\t<div class=\"r01srItem").append(tipo).append("\">\n\t\t\t\t\t\t\t\t<div class=\"r01srItem").append(tipo).append("Cat\">\n");
        outSb.append(this._sendRequest(lang, item, numItems, allItemsAreAttachmentFiles, docTitle, docDescription, typoInfo, typoDetails, catalogDetails, metaDataDetails));
        outSb.append("\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n");
        return outSb;
    }

    private StringBuffer _sendRequest(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        StringBuffer outSb = new StringBuffer(2215);
        String type = item.contentTypology.getTypeOid();
        R01MContentType typeConfig = null;
        R01MFormatterClassConfig formatterClassConfig = null;
        try {
            typeConfig = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(type);
            formatterClassConfig = (R01MFormatterClassConfig)typeConfig.getSearchEngineFormattersConfig().get(type + ".type");
            if (formatterClassConfig == null || formatterClassConfig.getParams() == null) {
                String family = item.contentTypology.getFamilyOid();
                formatterClassConfig = (R01MFormatterClassConfig)typeConfig.getSearchEngineFormattersConfig().get(family + ".family");
            }
        }
        catch (R01MConfigLoadException ex) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar el formateador especifico para el documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ex.getDetailedMessage());
            outSb.append("<!-- ************** ERROR AL CARGAR EL FORMATEADOR ESPECIFICO PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ex.getDetailedMessage() + " -->\n");
            StackTraceElement[] trace = ex.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar el formateador especifico para el documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ex.getMessage());
            outSb.append("<!-- ************** ERROR AL CARGAR EL FORMATEADOR ESPECIFICO PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ex.getMessage() + " -->\n");
            StackTraceElement[] trace = ex.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
        String urlSearchResultClass = "";
        if (formatterClassConfig == null || formatterClassConfig.getParams() == null) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar el formateador especifico para el documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + " En la configuraci\u00f3n de la tipolog\u00eda se ha determinado que el formateo se debe realizar \n" + "     a partir de una conexion HTTP y sin embargo no se ha definido una URL para acceder al formateador.\n" + "     En el fichero de configuracion del tipo o familia debe haber unos parametros del estilo:" + "     <searchEngineFormattersConfig>\n" + "         <formatterClass id= \"informacion\" type=\"family\">\n" + "             <searchResultClass>com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultHttpClientFormatter</searchResultClass>\n" + "             <contentListClass>com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultHttpClientFormatter</contentListClass>\n" + "             <params>\n" + "                 <urlSearchResultClass><![CDATA[http://www.contenidos.servicios.jakinaplus.ejgvdns/r01mPruebasClientAPI/R01MFormatterServlet]]></urlSearchResultClass>\n" + "                 <urlContentListClass><![CDATA[http://www.contenidos.servicios.jakinaplus.ejgvdns/r01mPruebasClientAPI/R01MFormatterServlet]]></urlContentListClass>\n" + "             </params>\n" + "         </formatterClass>\n" + "     </searchEngineFormattersConfig>\n");
            outSb.append("<!-- ************** ERROR AL CARGAR EL FORMATEADOR ESPECIFICO PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n");
            outSb.append("<!-- En la configuraci\u00f3n de la tipolog\u00eda se ha determinado que el formateo se debe realizar \n     a partir de una conexion HTTP y sin embargo no se ha definido una URL para acceder al formateador.\n     En el fichero de configuracion del tipo o familia debe haber unos parametros del estilo:     <searchEngineFormattersConfig>\n         <formatterClass id= \"informacion\" type=\"family\">\n             <searchResultClass>com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultHttpClientFormatter</searchResultClass>\n             <contentListClass>com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultHttpClientFormatter</contentListClass>\n             <params>\n                 <urlSearchResultClass><![CDATA[http://www.contenidos.servicios.jakinaplus.ejgvdns/r01mPruebasClientAPI/R01MFormatterServlet]]></urlSearchResultClass>\n                 <urlContentListClass><![CDATA[http://www.contenidos.servicios.jakinaplus.ejgvdns/r01mPruebasClientAPI/R01MFormatterServlet]]></urlContentListClass>\n             </params>\n         </formatterClass>\n     </searchEngineFormattersConfig> -->\n");
            return outSb;
        }
        urlSearchResultClass = formatterClassConfig.getParams().get("urlSearchResultClass").toString();
        JSONObject jObject = new JSONObject();
        Object[] jsonLoadResponse = this._getJSONObjectFromSearchResultItem(jObject, lang, item);
        if (!((Boolean)jsonLoadResponse[0]).booleanValue()) {
            outSb.append((StringBuffer)jsonLoadResponse[1]);
            return outSb;
        }
        StringBuffer errorsLoadingJSON = (StringBuffer)jsonLoadResponse[1];
        if (errorsLoadingJSON.length() > 0) {
            outSb.append(errorsLoadingJSON);
        }
        URL url = null;
        try {
            url = new URL(urlSearchResultClass);
        }
        catch (MalformedURLException mEx) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar la URL de acceso al formateador especifico para el documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + mEx.getMessage());
            outSb.append("<!-- ************** ERROR AL CARGAR LA URL DE ACCESO AL FORMATEADOR ESPECIFICO PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + mEx.getMessage() + " -->\n");
            StackTraceElement[] trace = mEx.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("POST");
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
        }
        catch (IOException ioEx) {
            R01FLog.to((String)"r01m.search").severe("Error al definir la conexi\u00f3n de acceso al formateador especifico para el documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ioEx.getMessage());
            outSb.append("<!-- ************** ERROR AL DEFINIR LA CONEXION DE ACCESO AL FORMATEADOR ESPECIFICO PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ioEx.getMessage() + " -->\n");
            StackTraceElement[] trace = ioEx.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
        try {
            connection.connect();
            OutputStream streamSalida = connection.getOutputStream();
            PrintWriter pw = new PrintWriter(streamSalida);
            pw.println("item=" + jObject.toString());
            pw.flush();
            pw.close();
            InputStream streamEntrada = null;
            try {
                streamEntrada = connection.getInputStream();
            }
            catch (IOException ioEx) {
                String typoFormatterClassName = R01MClientFactory.getPropertiesConfigAPI().getProperty("searchEngine/defaultHTMLFormatters/searchResultDefault", "com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter");
                R01MSearchResultItemTypoDependantFormatter outFormatter = null;
                try {
                    outFormatter = (R01MSearchResultItemTypoDependantFormatter)ReflectionUtils.getObjectInstance((String)typoFormatterClassName);
                }
                catch (ReflectionException ex) {
                    R01FLog.to((String)"r01m.search").severe("Error al obtener la instancia para el formateador definido por defecto: " + typoFormatterClassName + ". Se toma como formateador R01MDefSearchResultItemTypoDefaultFormatter.\n" + "Formateado para el resultado del documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ex.getMessage());
                    outFormatter = new R01MDefSearchResultItemTypoDefaultFormatter();
                }
                outFormatter.setFormatterPreferences(new R01MSearchResultsFormatterPreferences());
                outSb.append(outFormatter.composeDocument(lang, item, numItems, allItemsAreAttachmentFiles, docTitle, docDescription, typoInfo, typoDetails, catalogDetails, metaDataDetails));
                R01FLog.to((String)"r01m.search").severe("Error al recuperar el c\u00f3digo formateado para el resultado del documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ioEx.getMessage());
                outSb.append("<!-- ************** ERROR AL RECUPERAR EL CODIGO FORMATEADO PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- No se ha podido obtener la conexi\u00f3n con el formateador. \n     Se pinta el resultado con el formateador por defecto indicado en el properties de r01m \n     (searchEngine/defaultHTMLFormatters/searchResultDefault) -->\n\n<!-- " + ioEx.getMessage() + " -->\n");
                StackTraceElement[] trace = ioEx.getStackTrace();
                for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                    outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
                }
            }
            if (streamEntrada != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(streamEntrada));
                String linea = null;
                while ((linea = reader.readLine()) != null) {
                    outSb.append(linea).append('\n');
                }
                reader.close();
            }
            return outSb;
        }
        catch (IOException ioEx) {
            R01FLog.to((String)"r01m.search").severe("Error al recuperar el c\u00f3digo formateado para el resultado del documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ioEx.getMessage());
            outSb.append("<!-- ************** ERROR AL RECUPERAR EL CODIGO FORMATEADO PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ioEx.getMessage() + " -->\n");
            StackTraceElement[] trace = ioEx.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
    }

    private Object[] _getJSONObjectFromSearchResultItem(JSONObject jObject, String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(126);
        try {
            StringBuffer fileErrors;
            StringBuffer documentErrors;
            jObject.put("itemId", (Object)item.getItemId());
            jObject.put("itemNumber", item.getItemNumber());
            jObject.put("score", (double)item.getScore());
            jObject.put("searchEngineDBName", (Object)item.getSearchEngineDBName());
            jObject.put("searchSourceOid", (Object)item.getSearchSourceOid());
            StringBuffer contentErrors = this._composeContentDataJSONObject(jObject, lang, item);
            if (contentErrors.length() > 0) {
                outSb.append(contentErrors);
            }
            if ((documentErrors = this._composeDocumentDataJSONObject(jObject, lang, item)).length() > 0) {
                outSb.append(documentErrors);
            }
            if ((fileErrors = this._composeDatafileDataJSONObject(jObject, item)).length() > 0) {
                outSb.append(fileErrors);
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar el objeto JSON para el resultado del documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ex.getMessage());
            outSb.append("<!-- ************** ERROR AL CARGAR EL OBJETO JSON PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ex.getMessage() + " -->\n");
            StackTraceElement[] trace = ex.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return new Object[]{Boolean.FALSE, outSb};
        }
        return new Object[]{Boolean.TRUE, outSb};
    }

    private StringBuffer _composeContentDataJSONObject(JSONObject jObject, String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(158);
        try {
            jObject.put("contentAuthor", (Object)item.getContentAuthor());
            jObject.put("contentCreateDate", (Object)item.getContentCreateDate());
            jObject.put("contentDescription", (Object)item.getContentDescription());
            jObject.put("contentEditURL", (Object)item.getContentEditURL(lang));
            jObject.put("contentName", (Object)item.getContentName());
            jObject.put("contentNewnessUntilDate", (Object)item.getContentNewnessUntilDate());
            jObject.put("contentOid", (Object)item.getContentOid());
            jObject.put("contentResponsible", (Object)item.getContentResponsible());
            jObject.put("contentRispDocumentsInfo", item.getContentRispDocumentsInfo());
            jObject.put("contentWorkAreaRelativePath", (Object)item.getContentWorkAreaRelativePath());
            jObject.put("mainFriendlyURL", (Object)item.getMainFriendlyURL());
            jObject.put("contentLocationServerOid", (Object)item.getContentLocation().getServerOid());
            jObject.put("contentLocationDataStoreOid", (Object)item.getContentLocation().getDataStoreOid());
            jObject.put("contentLocationAreaOid", (Object)item.getContentLocation().getAreaOid());
            jObject.put("contentLocationWorkareaOid", (Object)item.getContentLocation().getWorkAreaOid());
            jObject.put("contentLocationServerPath", (Object)item.getContentLocation().getServerPath());
            jObject.put("contentLocationDataStorePath", (Object)item.getContentLocation().getDataStorePath());
            jObject.put("contentLocationAreaPath", (Object)item.getContentLocation().getAreaPath());
            jObject.put("contentLocationWorkareaPath", (Object)item.getContentLocation().getWorkAreaPath());
            jObject.put("contentTypologyClusterNumericId", item.getContentTypology().getClusterNumericId());
            jObject.put("contentTypologyFamilyNumericId", item.getContentTypology().getFamilyNumericId());
            jObject.put("contentTypologyTypeNumericId", item.getContentTypology().getTypeNumericId());
            jObject.put("contentTypologyClusterOid", (Object)item.getContentTypology().getClusterOid());
            jObject.put("contentTypologyFamilyOid", (Object)item.getContentTypology().getFamilyOid());
            jObject.put("contentTypologyTypeOid", (Object)item.getContentTypology().getTypeOid());
            jObject.put("structureCatalogs", (Object)this._getCatalogInfo(item));
            jObject.put("geoCatalogs", (Object)this._getGeoCatalogInfo(item));
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar la informacion de contenido en el objeto JSON para el resultado del documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ex.getMessage());
            outSb.append("<!-- ************** ERROR AL CARGAR LA INFORMACION DEL CONTENIDO EN EL OBJETO JSON PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ex.getMessage() + " -->\n");
            StackTraceElement[] trace = ex.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
        return outSb;
    }

    private StringBuffer _composeDocumentDataJSONObject(JSONObject jObject, String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(158);
        try {
            jObject.put("documentOid", (Object)item.getDocumentOid());
            jObject.put("documentLanguage", (Object)item.getDocumentLanguage());
            jObject.put("documentInternalName", (Object)item.getDocumentInternalName());
            jObject.put("documentName", (Object)item.getDocumentName());
            jObject.put("documentDescription", (Object)item.getDocumentDescription());
            jObject.put("documentAuthor", (Object)item.getDocumentAuthor());
            jObject.put("documentEditURL", (Object)item.getDocumentEditURL(lang));
            jObject.put("documentCreateDate", (Object)item.getDocumentCreateDate());
            jObject.put("documentApprovalStatus", (Object)item.getDocumentApprovalStatus());
            jObject.put("documentContentRelativePath", (Object)item.getDocumentContentRelativePath());
            jObject.put("documentWorkAreaRelativePath", (Object)item.getDocumentWorkAreaRelativePath());
            JSONArray dataFilesRelativePathsArray = new JSONArray();
            dataFilesRelativePathsArray.put(item.getDocumentDataFilesGeneratedFilesDocumentRelativePaths());
            jObject.put("documentDataFilesGeneratedFilesDocumentRelativePaths", (Object)dataFilesRelativePathsArray);
            jObject.put("documentDepthLevel", (Object)item.getDocumentDepthLevel());
            jObject.put("documentLinkedDataSrc", (Collection)item.getLinkedDocumentsByTagSrc());
            jObject.put("documentLinkedDataDst", (Collection)item.getLinkedDocumentsByTagDst());
            jObject.put("documentMainDataFileDefaultGeneratedFileDocumentRelativePath", (Object)item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath());
            jObject.put("documentMainDataFileGeneratedFilesDocumentRelativePaths", item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths());
            JSONArray documentMetadataArray = new JSONArray();
            documentMetadataArray.put(item.getDocumentMetaData());
            jObject.put("documentMetaData", (Object)documentMetadataArray);
            jObject.put("documentPublicationInfo", (Object)this._getPublishInfo(item));
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar la informacion de documento en el objeto JSON para el resultado del documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ex.getMessage());
            outSb.append("<!-- ************** ERROR AL CARGAR LA INFORMACION DEL DOCUMENTO EN EL OBJETO JSON PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ex.getMessage() + " -->\n");
            StackTraceElement[] trace = ex.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
        return outSb;
    }

    private StringBuffer _composeDatafileDataJSONObject(JSONObject jObject, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(156);
        try {
            jObject.put("fileAbsolutePath", (Object)item.getFileAbsolutePath());
            jObject.put("fileDocumentRelativePath", (Object)item.getFileDocumentRelativePath());
            jObject.put("fileName", (Object)item.getFileName());
            jObject.put("fileResume", (Object)item.getFileResume());
            jObject.put("fileTitle", (Object)item.getFileTitle());
            jObject.put("fileURL", (Object)item.getFileURL());
            jObject.put("fileWorkAreaRelativePath", (Object)item.getFileWorkAreaRelativePath());
            jObject.put("realFileWorkAreaRelativePath", (Object)item.getRealFileWorkAreaRelativePath());
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01m.search").severe("Error al cargar la informacion de fichero en el objeto JSON para el resultado del documento " + (item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())) + ".  > " + ex.getMessage());
            outSb.append("<!-- ************** ERROR AL CARGAR LA INFORMACION DEL FICHERO EN EL OBJETO JSON PARA EL RESULTADO DEL DOCUMENTO ").append(item == null ? "(item null)" : (item.getDocumentOid() == null ? "(documentOid null)" : item.getDocumentOid())).append(" ************** -->\n<!-- " + ex.getMessage() + " -->\n");
            StackTraceElement[] trace = ex.getStackTrace();
            for (int traceIndex = 0; traceIndex < trace.length; ++traceIndex) {
                outSb.append("<!-- " + trace[traceIndex].toString() + " -->\n");
            }
            return outSb;
        }
        return outSb;
    }

    private JSONArray _getCatalogInfo(R01MSearchResultItem item) throws JSONException {
        JSONArray catalogsArray = new JSONArray();
        List catalogs = item.getStructureCatalogs();
        if (catalogs != null && !catalogs.isEmpty()) {
            for (R01MSearchResultItemStructureCatalog catalog : catalogs) {
                JSONObject structureObject = new JSONObject();
                structureObject.put("labelOid", (Object)catalog.getLabelOid());
                structureObject.put("structureOid", (Object)catalog.getStructureOid());
                structureObject.put("role", (Object)catalog.getRole());
                catalogsArray.put((Object)structureObject);
            }
        }
        return catalogsArray;
    }

    private JSONArray _getGeoCatalogInfo(R01MSearchResultItem item) throws JSONException {
        JSONArray catalogsArray = new JSONArray();
        List catalogs = item.getGeoCatalogs();
        if (catalogs != null && !catalogs.isEmpty()) {
            for (R01MSearchResultItemGeoCatalog catalog : catalogs) {
                JSONObject structureObject = new JSONObject();
                structureObject.put("country", catalog.getCountry());
                structureObject.put("territory", catalog.getTerritory());
                structureObject.put("province", catalog.getProvince());
                structureObject.put("municipality", catalog.getMunicipality());
                structureObject.put("getMunicipality", catalog.getCity());
                structureObject.put("street", catalog.getStreet());
                catalogsArray.put((Object)structureObject);
            }
        }
        return catalogsArray;
    }

    private JSONArray _getPublishInfo(R01MSearchResultItem item) throws JSONException {
        JSONArray publicationsArray = new JSONArray();
        List<R01MSearchResultItemPublicationInfo> publications = item.getDocumentPublicationInfo();
        if (publications != null && !publications.isEmpty()) {
            for (R01MSearchResultItemPublicationInfo publication : publications) {
                JSONObject publicationObject = new JSONObject();
                publicationObject.put("repositoryOid", (Object)publication.getRepositoryOid());
                publicationObject.put("repositoryAlias", (Object)publication.getRepositoryAlias());
                publicationObject.put("date", (Object)publication.getDate());
                publicationObject.put("state", publication.getState());
                publicationsArray.put((Object)publicationObject);
            }
        }
        return publicationsArray;
    }
}

