/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryTypoFormatter;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class R01MDefSearchQueryTypoHtmlFormatter
implements R01MSearchQueryTypoFormatter,
Serializable {
    private static final long serialVersionUID = -6390584042128764595L;
    private static final int MAX_NUM_OF_CLUSTERS = XMLProperties.getInt((String)R01MConstants.API_APPCODE, (String)"searchEngine/queryPresentation/maxNumberOf/typoClusters", (int)-1);
    private static final int MAX_NUM_OF_FAMILIES = XMLProperties.getInt((String)R01MConstants.API_APPCODE, (String)"searchEngine/queryPresentation/maxNumberOf/typoFamilies", (int)3);
    private static final int MAX_NUM_OF_TYPES = XMLProperties.getInt((String)R01MConstants.API_APPCODE, (String)"searchEngine/queryPresentation/maxNumberOf/typoTypes", (int)4);

    @Override
    public StringBuffer doFormatTypo(String lang, List clusters, List families, List types) {
        if (!(clusters != null && clusters.size() != 0 || families != null && families.size() != 0 || types != null && types.size() != 0)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("<span class='r01QueryTypoInter'>");
        if (families != null && families.size() > 0 || types != null && types.size() > 0) {
            Iterator it;
            sb.append("<span class='r01QueryTitleTypo'>&nbsp;</span>");
            sb.append("&nbsp;");
            sb.append("<span class='r01QueryTextTypo'>");
            R01MSearchedFamily currSearchedFamily = null;
            R01MSearchedContentType currSearchedType2 = null;
            if (families != null && families.size() > 0) {
                it = families.iterator();
                while (it.hasNext()) {
                    boolean isAnyTypeFromFamily;
                    block10: {
                        currSearchedFamily = (R01MSearchedFamily)it.next();
                        isAnyTypeFromFamily = false;
                        try {
                            R01MContentFamily family = R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(currSearchedFamily.getOid());
                            if (types == null || types.size() <= 0) break block10;
                            for (R01MSearchedContentType currSearchedType2 : types) {
                                if (family.getType(currSearchedType2.getOid()) == null) continue;
                                isAnyTypeFromFamily = true;
                                break;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (isAnyTypeFromFamily) continue;
                    sb.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(null, currSearchedFamily.getOid(), null));
                    if (it.hasNext()) {
                        sb.append(",&nbsp;");
                        continue;
                    }
                    if (types == null || types.size() <= 0) continue;
                    sb.append(",&nbsp;");
                }
            }
            if (types != null && types.size() > 0) {
                it = types.iterator();
                while (it.hasNext()) {
                    currSearchedType2 = (R01MSearchedContentType)it.next();
                    sb.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(null, null, currSearchedType2.getOid()));
                    if (!it.hasNext()) continue;
                    sb.append(",&nbsp;");
                }
            }
            sb.append("</span>");
        }
        sb.append("</span>");
        return sb;
    }
}

