/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideNode;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterURLHelpper;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchGuideFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchGuideFormatterPreferences;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MDefSearchGuideHtmlFormatter
implements R01MSearchGuideFormatter,
Serializable {
    private static final long serialVersionUID = 6451023872857119317L;

    @Override
    public StringBuffer doFormatGuideAsCombo(String lang, R01MSearchGuideFormatterPreferences prefs, R01MSearchGuideElement[] guidePastElements, R01MSearchGuideElement guideCurrentElement, R01MSearchGuideElement[] guideFutureElements) {
        StringBuffer sb = new StringBuffer(3000);
        sb.append("\r\n\r\n<!-- oooooooooo GUIA DE NAVEGACI\u00d3N oooooooooo -->\r\n<div id=\"r01Guide r01clearfix\">\r\n");
        long totalNumOfResults = -1L;
        sb.append(this._composePastElementsGuide(lang, prefs, totalNumOfResults, guidePastElements, guideCurrentElement));
        if (guideFutureElements != null) {
            sb.append("\t<select id=\"\">\r\n");
            for (int i = 0; i < guideFutureElements.length; ++i) {
                sb.append("\t\t<option onchange=\"\">");
                sb.append(this._composeGuideElement(lang, prefs, guideFutureElements[i], true, false));
                sb.append("</option>\r\n");
            }
            sb.append("\t</select>\r\n");
        }
        sb.append("</div>\r\n<!-- oooooooooo FIN GUIA DE NAVEGACI\u00d3N oooooooooo -->\r\n\r\n");
        return sb;
    }

    @Override
    public StringBuffer doFormatGuideAsList(String lang, R01MSearchGuideFormatterPreferences prefs, R01MSearchGuideElement[] guidePastElements, R01MSearchGuideElement guideCurrentElement, R01MSearchGuideElement[] guideFutureElements, int guideColsNum) {
        R01MSearchGuideElement[] fullGuideFutureElements = this._filterGuideFutureElements(guideFutureElements);
        if (guideCurrentElement == null && (fullGuideFutureElements == null || fullGuideFutureElements.length == 0)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        int appliedGuideColsNum = guideColsNum;
        if (guideColsNum <= 0 || guideColsNum > 3) {
            appliedGuideColsNum = 2;
        }
        StringBuffer sb = new StringBuffer(3000);
        sb.append("\r\n\r\n<!-- oooooooooo GUIA DE NAVEGACI\u00d3N oooooooooo -->\r\n<div class=\"r01SearchResultGuide\">\r\n");
        if (prefs != null && prefs.showGuidesTabs) {
            sb.append("\t<div class=\"r01TabsContainer r01clearfix\"><!-- tabs guia -->\r\n\t\t<div class=\"r01topTabs r01topTabsLeft\">\r\n\t\t\t<ul>\r\n\t\t\t\t<li><a href=\"#\"><span>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanasup.tema"));
            sb.append("</span></a></li>\r\n\t\t\t\t<li><a href=\"#\"><span>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanasup.tipo"));
            sb.append("</span></a></li>\r\n\t\t\t\t<li><a href=\"#\"><span>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanasup.origen"));
            sb.append("</span></a></li>\r\n\t\t\t\t<li><a href=\"#\"><span>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "pestanasup.destinatario"));
            sb.append("</span></a></li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t</div><!-- tabs guia -->\r\n");
        }
        sb.append("\t<div class=\"r01GuideEls\">\r\n\t\t<div class=\"r01GuidePastElem r01clearfix\">\r\n");
        long totalNumOfResults = -1L;
        sb.append(this._composePastElementsGuide(lang, prefs, totalNumOfResults, guidePastElements, guideCurrentElement, fullGuideFutureElements));
        sb.append("\t\t</div>\r\n");
        if (fullGuideFutureElements != null) {
            sb.append("\t\t<div id=\"r01SearchGuide\" class=\"r01GuideCols r01clearfix\">\r\n");
            do {
                if (fullGuideFutureElements.length >= appliedGuideColsNum) continue;
                --appliedGuideColsNum;
            } while (fullGuideFutureElements.length < appliedGuideColsNum);
            if (appliedGuideColsNum == 0) {
                appliedGuideColsNum = 1;
            }
            int colElems = fullGuideFutureElements.length / appliedGuideColsNum;
            int remainder = fullGuideFutureElements.length % appliedGuideColsNum;
            if (appliedGuideColsNum == 1) {
                int i = 0;
                if (remainder-- > 0) {
                    i = 1;
                }
                StringBuffer col1Html = this._composeColumnInListGuide(lang, prefs, appliedGuideColsNum, 1, fullGuideFutureElements, 0, colElems + i - 1);
                sb.append(col1Html);
            } else if (appliedGuideColsNum == 2) {
                int i = 0;
                int j = 0;
                if (remainder-- > 0) {
                    i = 1;
                }
                StringBuffer col1Html = this._composeColumnInListGuide(lang, prefs, appliedGuideColsNum, 1, fullGuideFutureElements, 0, colElems + i - 1);
                if (remainder-- > 0) {
                    j = 1;
                }
                StringBuffer col2Html = this._composeColumnInListGuide(lang, prefs, appliedGuideColsNum, 2, fullGuideFutureElements, colElems + i, colElems * 2 + i + j - 1);
                sb.append(col1Html);
                sb.append(col2Html);
            } else if (appliedGuideColsNum == 3) {
                int i = 0;
                int j = 0;
                int k = 0;
                if (remainder-- > 0) {
                    i = 1;
                }
                StringBuffer col1Html = this._composeColumnInListGuide(lang, prefs, appliedGuideColsNum, 1, fullGuideFutureElements, 0, colElems + i - 1);
                if (remainder-- > 0) {
                    j = 1;
                }
                StringBuffer col2Html = this._composeColumnInListGuide(lang, prefs, appliedGuideColsNum, 2, fullGuideFutureElements, colElems + i, colElems * 2 + i + j - 1);
                if (remainder-- > 0) {
                    k = 1;
                }
                StringBuffer col3Html = this._composeColumnInListGuide(lang, prefs, appliedGuideColsNum, 3, fullGuideFutureElements, colElems * 2 + i + j, colElems * 3 + i + j + k - 1);
                sb.append(col1Html);
                sb.append(col2Html);
                sb.append(col3Html);
            }
            sb.append("\t\t</div>\r\n");
        }
        sb.append("\t</div>\r\n</div>\r\n<!-- oooooooooo FIN GUIA DE NAVEGACI\u00d3N oooooooooo -->\r\n\r\n");
        return sb;
    }

    @Override
    public StringBuffer doFormatGuideAsTree(String lang, R01MSearchGuideFormatterPreferences prefs, R01MSearchGuide guide) {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("\r\n\r\n\t<div id=\"r01Guide\">\r\n");
        if (guide != null && guide.getFirstLevelNodes() != null) {
            sb.append("<ul class=\"r01tree\" id=\"guideTree\"><li>Guide:<ul>");
            for (int i = 0; i < guide.getFirstLevelNodes().length; ++i) {
                sb.append(this._formatGuideNodeInTree(lang, prefs, guide.getFirstLevelNodes()[i]));
            }
            sb.append("</ul></li></ul><script languaje=\"JavaScript\">\r\n\tvar theTree = new R01Tree(document.getElementById('guideTree'),{trackSelection:true,allowNodeArrangement:false,isTextClickable:true,selectedBGColor:'#E2E2E2'});\r\n\ttheTree.createTree();\r\n</script>");
        }
        sb.append("\t</div>\r\n");
        return sb;
    }

    private StringBuffer _formatGuideNodeInTree(String lang, R01MSearchGuideFormatterPreferences prefs, R01MSearchGuideNode node) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<li class=\"r01GuideElem\">");
        sb.append(this._composeGuideElement(lang, prefs, node.getNodeElement(), true, false));
        if (node.getFutureNodes() != null && node.getFutureNodes().size() > 0) {
            sb.append("<ul>");
            Iterator it = node.getFutureNodes().iterator();
            while (it.hasNext()) {
                sb.append(this._formatGuideNodeInTree(lang, prefs, (R01MSearchGuideNode)it.next()));
            }
            sb.append("</ul>");
        }
        sb.append("</li>");
        return sb;
    }

    private R01MSearchGuideElement[] _filterGuideFutureElements(R01MSearchGuideElement[] futureGuideEls) {
        if (futureGuideEls == null || futureGuideEls.length == 0) {
            return null;
        }
        ArrayList<R01MSearchGuideElement> outEls = new ArrayList<R01MSearchGuideElement>();
        for (int i = 0; i < futureGuideEls.length; ++i) {
            if (futureGuideEls[i].getNumberOfResults() <= 0) continue;
            outEls.add(futureGuideEls[i]);
        }
        return outEls.toArray(new R01MSearchGuideElement[outEls.size()]);
    }

    private StringBuffer _composeColumnInListGuide(String lang, R01MSearchGuideFormatterPreferences prefs, int totalCols, int colNum, R01MSearchGuideElement[] guideFutureElements, int fromIndex, int toIndex) {
        StringBuffer sb = new StringBuffer(2000);
        int widthPercent = 100 / totalCols;
        sb.append("\t\t<div class=\"r01GuideCol-");
        sb.append(colNum);
        sb.append("\" style=\"width:");
        sb.append(widthPercent - 1);
        sb.append("%\">\r\n");
        if (toIndex >= fromIndex) {
            sb.append("\t\t\t<ul>\r\n");
            for (int i = fromIndex; i <= toIndex; ++i) {
                sb.append("\t\t\t\t<li class=\"r01GuideElem\">");
                sb.append(this._composeGuideElement(lang, prefs, guideFutureElements[i], true, true));
                sb.append("</li>\r\n");
            }
            sb.append("\t\t\t</ul>\r\n");
        }
        sb.append("\t\t</div>\r\n");
        return sb;
    }

    private StringBuffer _composeGuideElement(String lang, R01MSearchGuideFormatterPreferences prefs, R01MSearchGuideElement theEl, boolean isFutureElement, boolean link) {
        if (theEl == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        String itemURL = null;
        String itemAlt = null;
        if (link) {
            itemURL = isFutureElement ? R01MSearchFormatterURLHelpper.composeFutureGuideElementURL(theEl.getPathInGuide()) : R01MSearchFormatterURLHelpper.composePastGuideElementURL(theEl.getPathInGuide());
            itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "guide.refinar") + theEl.getDescription(lang);
        }
        NumberFormat nf = NumberFormat.getInstance();
        StringBuffer sb = new StringBuffer(2000);
        if (link) {
            sb.append("<a class=\"r01SearchGuideSpanText\" href=\"");
            sb.append(StringEscapeUtils.escapeHtml((String)itemURL));
            sb.append("\" title=\"");
            sb.append(itemAlt);
            sb.append("\">");
        }
        if (theEl.getDescription() != null) {
            sb.append(theEl.getDescription(lang));
        }
        if (prefs.showGuideElementsSubTotals && theEl.getNumberOfResults() >= 0) {
            sb.append(" (");
            sb.append(nf.format(theEl.getNumberOfResults()));
            sb.append(")");
        }
        if (theEl.isHighLight()) {
            sb.append(" *");
        }
        if (link) {
            sb.append("</a>");
        }
        return sb;
    }

    private StringBuffer _composePastElementsGuide(String lang, R01MSearchGuideFormatterPreferences prefs, long totalNumOfResults, R01MSearchGuideElement[] guidePastElements, R01MSearchGuideElement currentElement, R01MSearchGuideElement[] fullGuideFutureElements) {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("\t\t\t<ul>\r\n");
        NumberFormat nf = NumberFormat.getInstance();
        if (currentElement != null || guidePastElements != null) {
            sb.append("\t\t\t\t<li class=\"r01GuideElem\">");
            sb.append("<a href=\"");
            sb.append(StringEscapeUtils.escapeHtml((String)R01MSearchFormatterURLHelpper.composeResetGuideElementURL()));
            sb.append("\" title=\"");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "guia.todosresultados.alt"));
            sb.append("\"><span class=\"r01SearchGuideSpanText\">");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "guia.todosresultados"));
            sb.append(totalNumOfResults > 0L ? " (" + nf.format(totalNumOfResults) + ")" : "");
            sb.append("</span></a>");
            sb.append("</li>\r\n");
            if (guidePastElements != null && guidePastElements.length > 0) {
                for (int i = 0; i < guidePastElements.length; ++i) {
                    sb.append("\t\t\t\t<li class=\"r01GuideElem r01GuideElemNavigator\">");
                    sb.append(this._composeGuideElement(lang, prefs, guidePastElements[i], false, true));
                    sb.append("</li>\r\n");
                }
            }
            if (currentElement != null) {
                sb.append("\t\t\t\t<li class=\"r01GuideElem r01GuideElemNavigator\">");
                sb.append(currentElement.getDescription(lang));
                if (currentElement.getNumberOfResults() > 0) {
                    sb.append(" (");
                    sb.append(nf.format(currentElement.getNumberOfResults()));
                    sb.append(")");
                }
                sb.append("</li>\r\n");
            }
        }
        sb.append("\t\t\t\t<li class=\"r01GuideElem\">");
        if (fullGuideFutureElements != null) {
            sb.append("<a href=\"#\" onclick=\"if (window.r01gSearchGuideShowHide) window.r01gSearchGuideShowHide(event, 'r01SearchGuide'); else document.getElementById('r01SearchGuide').style.display = 'block'; return false;\"><span class=\"r01SearchGuideSpanClose\">&nbsp;</span>");
            sb.append("<span class=\"r01SearchGuideSpanText\">");
            if (currentElement != null) {
                sb.append(StringUtils.replaceString((String)R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "guia.filtrartema"), (String)"$[guide]$", (String)currentElement.getDescription(lang)));
            } else {
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "guia.filtrar"));
            }
            sb.append(totalNumOfResults > 0L ? " (" + nf.format(totalNumOfResults) + ")" : "");
            sb.append("</span>");
            sb.append("</a>");
        }
        sb.append("</li>\r\n");
        sb.append("\t\t\t</ul>\r\n");
        return sb;
    }

    private StringBuffer _composePastElementsGuide(String lang, R01MSearchGuideFormatterPreferences prefs, long totalNumOfResults, R01MSearchGuideElement[] guidePastElements, R01MSearchGuideElement currentElement) {
        return this._composePastElementsGuide(lang, prefs, totalNumOfResults, guidePastElements, currentElement, null);
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                int k;
                int j;
                int i;
                int numOfCols = 3;
                int numOfElems = 3;
                int colElems = numOfElems / numOfCols;
                int remainder = numOfElems % numOfCols;
                if (numOfCols == 1) {
                    i = 0;
                    if (remainder-- > 0) {
                        i = 1;
                    }
                    R01FLog.to((String)"r01m.test").info("Col1: 0-" + (colElems + i - 1));
                    continue;
                }
                if (numOfCols == 2) {
                    i = 0;
                    j = 0;
                    if (remainder-- > 0) {
                        i = 1;
                    }
                    R01FLog.to((String)"r01m.test").info("Col1: 0-" + (colElems + i - 1));
                    if (remainder-- > 0) {
                        j = 1;
                    }
                    R01FLog.to((String)"r01m.test").info("Col2: " + (colElems + i) + "-" + (colElems * 2 + i + j - 1));
                    continue;
                }
                if (numOfCols == 3) {
                    i = 0;
                    j = 0;
                    k = 0;
                    if (remainder-- > 0) {
                        i = 1;
                    }
                    R01FLog.to((String)"r01m.test").info("Col1: 0-" + (colElems + i - 1));
                    if (remainder-- > 0) {
                        j = 1;
                    }
                    R01FLog.to((String)"r01m.test").info("Col2: " + (colElems + i) + "-" + (colElems * 2 + i + j - 1));
                    if (remainder-- > 0) {
                        k = 1;
                    }
                    R01FLog.to((String)"r01m.test").info("Col3: " + (colElems * 2 + i + j) + "-" + (colElems * 3 + i + j + k - 1));
                    continue;
                }
                if (numOfCols != 4) continue;
                i = 0;
                j = 0;
                k = 0;
                int l = 0;
                if (remainder-- > 0) {
                    i = 1;
                }
                R01FLog.to((String)"r01m.test").info("Col1: 0-" + (colElems + i - 1));
                if (remainder-- > 0) {
                    j = 1;
                }
                R01FLog.to((String)"r01m.test").info("Col2: " + (colElems + i) + "-" + (colElems * 2 + i + j - 1));
                if (remainder-- > 0) {
                    k = 1;
                }
                R01FLog.to((String)"r01m.test").info("Col3: " + (colElems * 2 + i + j) + "-" + (colElems * 3 + i + j + k - 1));
                if (remainder-- > 0) {
                    l = 1;
                }
                R01FLog.to((String)"r01m.test").info("Col4: " + (colElems * 3 + i + j + k) + "-" + (colElems * 4 + i + j + k + l - 1));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to((String)"r01m.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

