/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults;

import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemTypoDependantFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class R01MDefSearchEngineDefaultFormatter
implements R01MSearchResultItemTypoDependantFormatter {
    protected R01MSearchResultsFormatterPreferences _formatterPrefs;
    public static final StringBuffer EMPTY_TYPO = new StringBuffer("<em class=\"r01srItemTypoDet\">&nbsp;</em>");
    public static final StringBuffer EMPTY_TEXT = new StringBuffer("");

    @Override
    public void setFormatterPreferences(R01MSearchResultsFormatterPreferences prefs) {
        this._formatterPrefs = prefs;
    }

    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        if (item.getContentTypology() == null) {
            return "TypoNoTypo";
        }
        if (item.getContentTypology().getFamilyOid() == null) {
            return "TypoNoTypo";
        }
        if (item.getContentTypology().getTypeOid() == null) {
            return "Typo_" + item.getContentTypology().getFamilyOid();
        }
        return "Typo_" + item.getContentTypology().getFamilyOid();
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        String docResume;
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docTitle)) {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">");
            sb.append(docTitle);
            sb.append("</em>\r\n");
        } else {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">&nbsp;</em>\r\n");
        }
        sb.append("\t\t\t\t</div>\r\n");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append("\t\t\t\t<div class=\"r01srItemDetails\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docDescription)) {
            sb.append("\t\t\t\t\t<div class=\"r01srItemDocDesc\">");
            sb.append(docDescription);
            sb.append("</div>\r\n");
        }
        boolean showResume = true;
        if (!allItemsAreAttachmentFiles && !item.isDocumentMainDataFile()) {
            showResume = true;
        }
        if (numItems == 1 && item.isDocumentMainDataFile) {
            showResume = true;
        }
        if (numItems == 1 && item.getFileAbsolutePath() != null && item.getFileAbsolutePath().indexOf("r01_gendata.txt") >= 0) {
            showResume = false;
        }
        if (showResume && !StringUtils.isEmptyString((String)(docResume = item.fileResume))) {
            docResume = R01MSearchResultItemFormatterUtils.fixTextToBeWrapped(item.fileResume);
            sb.append("\t\t\t\t\t<div class=\"r01srItemDocResume\">");
            sb.append(docResume);
            sb.append("</div>\r\n");
        }
        String typoCSSClassName = "r01srItem" + this.obtainTypoId(lang, item);
        sb.append("\t\t\t\t\t<div class=\"r01srItemDocDetail1 ");
        sb.append(typoCSSClassName);
        sb.append(" r01clearfix\">\r\n\t\t\t\t\t\t<div class=\"r01srItemTypo\">\r\n");
        sb.append(typoInfo);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class=\"r01srItemTypoDet\">\r\n");
        sb.append(typoDetails);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class=\"r01srItemCat\">\r\n");
        sb.append(catalogDetails);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n");
        return sb;
    }

    @Override
    public StringBuffer composeAttachment(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(500);
        sb.append("\t\t\t\t<div class=\"r01srItemAttach\">\r\n\t\t\t\t\t");
        sb.append(this._composeAttachmentDetail(lang, item));
        sb.append("\r\n\t\t\t\t\t");
        sb.append(this._composeAttachmentResume(lang, item));
        sb.append("\r\n\t\t\t\t</div>\r\n");
        return sb;
    }

    @Override
    public StringBuffer composeRispDetails(String prefix, String lang, R01MSearchResultItem item) {
        if (!this._formatterPrefs.showRisp) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer();
        if (item.getContentRispDocumentsInfo() != null && !item.getContentRispDocumentsInfo().isEmpty()) {
            Map<String, String> rispInfo = item.getContentRispDocumentsInfo();
            StringBuffer listZip = new StringBuffer();
            StringBuffer listXml = new StringBuffer();
            StringBuffer list = new StringBuffer();
            if (rispInfo != null && !rispInfo.isEmpty()) {
                StringBuffer head;
                String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
                for (String keyResult : rispInfo.keySet()) {
                    R01MRispDocument rispDoc;
                    String[] values = rispInfo.get(keyResult).split(",");
                    if (values.length <= 1 || StringUtils.isEmptyString((String)(rispDoc = new R01MRispDocument(keyResult, values[0], values[1])).getContentRelativePath())) continue;
                    if (rispDoc.getType().toUpperCase().equalsIgnoreCase("XML")) {
                        Map dataFilesGenerated;
                        if (item.getDocumentDataFilesGeneratedFilesDocumentRelativePaths() != null && (dataFilesGenerated = item.getDocumentDataFilesGeneratedFilesDocumentRelativePaths()) != null && !dataFilesGenerated.isEmpty()) {
                            Iterator dataFilesGeneratedAux = dataFilesGenerated.keySet().iterator();
                            String key = (String)dataFilesGeneratedAux.next();
                            String dataFileOid = key.indexOf(".") == -1 ? key : key.substring(key.indexOf(".") + 1);
                            listXml.append(prefix);
                            listXml.append("<li>\t<a href=\"/");
                            listXml.append(contentAlias);
                            listXml.append('/');
                            listXml.append(item.getContentWorkAreaRelativePath());
                            listXml.append('/');
                            listXml.append(item.getDocumentLanguage());
                            listXml.append('_');
                            listXml.append(item.getDocumentInternalName());
                            listXml.append("/data/");
                            listXml.append(item.getDocumentLanguage());
                            listXml.append('_');
                            listXml.append(dataFileOid);
                            listXml.append("\" class=\"");
                            listXml.append(rispDoc.getType().toLowerCase());
                            listXml.append("\" title=\"");
                            listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp." + rispDoc.getType().toLowerCase() + ".datos"));
                            listXml.append("\" ><strong><span class=\"file\">");
                            if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                                listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                            } else {
                                listXml.append(rispDoc.getType().toUpperCase());
                            }
                            listXml.append("</span></strong>");
                            listXml.append("<strong><span class=\"adjuntos\">&nbsp;");
                            listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto.datos"));
                            listXml.append("</span></strong></a></li>");
                        }
                        listXml.append(prefix);
                        listXml.append("<li>\t<a href=\"/");
                        listXml.append(contentAlias);
                        listXml.append('/');
                        listXml.append(item.getContentWorkAreaRelativePath());
                        listXml.append(rispDoc.getContentRelativePath());
                        listXml.append("\" class=\"");
                        listXml.append(rispDoc.getType().toLowerCase());
                        listXml.append("\" title=\"");
                        listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp." + rispDoc.getType().toLowerCase() + ".metadatos"));
                        listXml.append("\" ><strong><span class=\"file\">");
                        if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                            listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                        } else {
                            listXml.append(rispDoc.getType().toUpperCase());
                        }
                        listXml.append("</span></strong>");
                        listXml.append("<strong><span class=\"adjuntos\">&nbsp;");
                        listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto.metadatos"));
                        listXml.append("</span></strong></a></li>");
                        continue;
                    }
                    if (rispDoc.getType().toUpperCase().equalsIgnoreCase("ZIP") || rispDoc.getType().toUpperCase().equalsIgnoreCase("ZIPTHIN")) {
                        if (!rispDoc.getType().toUpperCase().equalsIgnoreCase("ZIP")) continue;
                        listZip.append(prefix);
                        listZip.append("<li>\t<a href=\"/");
                        listZip.append(contentAlias);
                        listZip.append('/');
                        listZip.append(item.getContentWorkAreaRelativePath());
                        listZip.append(rispDoc.getContentRelativePath());
                        listZip.append("\" class=\"");
                        listZip.append(rispDoc.getType().toLowerCase());
                        listZip.append("\" title=\"");
                        listZip.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp." + rispDoc.getType().toLowerCase()));
                        listZip.append("\" ><strong><span class=\"file\">");
                        if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                            listZip.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                        } else {
                            listZip.append(rispDoc.getType().toUpperCase());
                        }
                        listZip.append("</span></strong></a>");
                        if (!StringUtils.isEmptyString((String)rispDoc.getSize()) && !"0".equals(rispDoc.getSize())) {
                            listZip.append(" (");
                            if (NumberUtils.isLong((String)rispDoc.getSize())) {
                                listZip.append(FileUtils.formatedFileLength((long)Long.parseLong(rispDoc.getSize())));
                            } else {
                                listZip.append(rispDoc.getSize());
                            }
                            listZip.append(") ");
                        }
                        listZip.append("</li>");
                        continue;
                    }
                    list.append(prefix);
                    list.append("<li>\t<a href=\"/");
                    list.append(contentAlias);
                    list.append('/');
                    list.append(item.getContentWorkAreaRelativePath());
                    list.append(rispDoc.getContentRelativePath());
                    list.append("\" class=\"");
                    list.append(rispDoc.getType().toLowerCase());
                    list.append("\" title=\"");
                    list.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp." + rispDoc.getType().toLowerCase()));
                    list.append("\" ><strong><span class=\"file\">");
                    if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                        list.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                    } else {
                        list.append(rispDoc.getType().toUpperCase());
                    }
                    list.append("</span></strong></a>");
                    if (!StringUtils.isEmptyString((String)rispDoc.getSize()) && !"0".equals(rispDoc.getSize())) {
                        list.append(" (");
                        if (NumberUtils.isLong((String)rispDoc.getSize())) {
                            list.append(FileUtils.formatedFileLength((long)Long.parseLong(rispDoc.getSize())));
                        } else {
                            list.append(rispDoc.getSize());
                        }
                        list.append(") ");
                    }
                    list.append("</li>");
                }
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)listXml)) {
                    head = new StringBuffer(60);
                    head.append("<div class=\"r01RispResultLabel\">");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.accederDatos"));
                    head.append("&nbsp;<a href=\"#TB_inline?height=450&amp;width=450&amp;inlineId=r01gSearchResultRispLeyend&amp;modal=false\" title=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.div.leyend"));
                    head.append("\" class=\"thickbox\"><img src=\"/AVComun/r01gSearchResultVA/images/ayuda.gif\"  alt=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.img.alt"));
                    head.append("\" /></a>&nbsp;:</div>");
                    head.append("<div class=\"r01RispResultFiles\"><ul>");
                    listXml.insert(0, head);
                    listXml.append("</ul></div>");
                    sb.append(prefix);
                    sb.append("<div class=\"r01srItemRispLink r01clearfix\">");
                    sb.append(listXml);
                    sb.append(prefix);
                    sb.append("</div>");
                }
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)listZip)) {
                    head = new StringBuffer(60);
                    head.append("<div class=\"r01RispResultLabel\">");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.descargaContenido"));
                    head.append("&nbsp;<a href=\"#TB_inline?height=450&amp;width=450&amp;inlineId=r01gSearchResultRispLeyend&amp;modal=false\" title=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.div.leyend"));
                    head.append("\" class=\"thickbox\"><img src=\"/AVComun/r01gSearchResultVA/images/ayuda.gif\"  alt=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.img.alt"));
                    head.append("\" /></a>&nbsp;:</div>");
                    head.append("<div class=\"r01RispResultFiles\"><ul>");
                    listZip.insert(0, head);
                    listZip.append("</ul></div>");
                    sb.append(prefix);
                    sb.append("<div class=\"r01srItemRispLink r01clearfix\">");
                    sb.append(listZip);
                    sb.append(prefix);
                    sb.append("</div>");
                }
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)list)) {
                    head = new StringBuffer(60);
                    head.append("<div class=\"r01RispResultLabel\">");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.descargaContenido"));
                    head.append("&nbsp;<a href=\"#TB_inline?height=450&amp;width=450&amp;inlineId=r01gSearchResultRispLeyend&amp;modal=false\" title=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.div.leyend"));
                    head.append("\" class=\"thickbox\"><img src=\"/AVComun/r01gSearchResultVA/images/ayuda.gif\"  alt=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.img.alt"));
                    head.append("\" /></a>&nbsp;:</div>");
                    head.append("<div class=\"r01RispResultFiles\"><ul>");
                    list.insert(0, head);
                    list.append("</ul></div>");
                    sb.append(prefix);
                    sb.append("<div class=\"r01srItemRispLink r01clearfix\">");
                    sb.append(list);
                    sb.append(prefix);
                    sb.append("</div>");
                }
            }
        }
        return sb;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(50);
        R01MSearchResultItemStructureCatalog dptoCat = R01MSearchResultItemFormatterUtils.obtainOrgStructureCatalog(item);
        if (dptoCat != null) {
            outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(dptoCat.getStructureOid(), dptoCat.getOid(), dptoCat.getRole()));
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return new StringBuffer("<em class=\"r01srItemTypoDet\">&nbsp;</em>");
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        return outSb;
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        return item.getDocumentDescription() != null ? new StringBuffer(item.getDocumentDescription()) : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeTypoInfo(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (item.getContentTypology() == null) {
            return new StringBuffer("<em>&nbsp;</em>\r\n");
        }
        String typoId = this.obtainTypoId(lang, item);
        StringBuffer typoInfo = new StringBuffer(23);
        typoInfo.append("<em><span");
        if (!StringUtils.isEmptyString((String)typoId)) {
            typoInfo.append(" class='r01srItem");
            typoInfo.append(typoId);
            typoInfo.append("'");
        }
        typoInfo.append('>');
        typoInfo.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid()));
        typoInfo.append("</span></em>");
        return typoInfo;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    protected String[] _obtainStartAndEndDates(String lang, R01MSearchResultItem item, String metadataStarDate, String metadataEndDate) {
        String startDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData(metadataStarDate) : null;
        String endDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData(metadataEndDate) : null;
        String[] outDates = new String[2];
        if (startDate != null && endDate != null) {
            Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            if (startDate != null && endDate != null) {
                outDates[0] = DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
                outDates[1] = DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
            } else if (startDate != null) {
                outDates[0] = DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
            }
        }
        return outDates;
    }

    protected String _obtainNewDate(String lang, R01MSearchResultItem item, String metadataDate) {
        String newDate;
        String string = newDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData(metadataDate) : null;
        if (newDate != null) {
            newDate = R01MSearchEngineUtils.formatDateTypeSearchResultMetaData(lang, newDate);
        }
        if (newDate == null && item.getDocumentPublicationInfo() != null && item.getDocumentPublicationInfo().size() > 0) {
            for (R01MSearchResultItemPublicationInfo pubInfo : item.getDocumentPublicationInfo()) {
                if (pubInfo.getState() != 1) continue;
                newDate = DateUtils.getDateFormated((Date)pubInfo.getDate(), (String)DateUtils.getLanguageDateFormat((String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
                break;
            }
        }
        return newDate;
    }

    private StringBuffer _composeAttachmentResume(String lang, R01MSearchResultItem item) {
        String text = item.getFileResume();
        if (text != null && text.length() < 100) {
            text = null;
        }
        StringBuffer outResume = new StringBuffer(100);
        outResume.append("<span class='r01srItemAttachResume'>");
        outResume.append(text != null ? text + "..." : "&nbsp;");
        outResume.append("</span>");
        return outResume;
    }

    private StringBuffer _composeAttachmentDetail(String lang, R01MSearchResultItem item) {
        StringBuffer fileURL = new StringBuffer();
        StringBuffer fileName = new StringBuffer();
        String ext = null;
        if (item.realFileWorkAreaRelativePath != null && item.realFileWorkAreaRelativePath.lastIndexOf(".") > 0 || item.fileWorkAreaRelativePath != null && item.fileWorkAreaRelativePath.lastIndexOf(".") > 0) {
            String waRelativePath = item.fileWorkAreaRelativePath;
            if (item.realFileWorkAreaRelativePath != null && item.realFileWorkAreaRelativePath.lastIndexOf(".") > 0) {
                waRelativePath = item.realFileWorkAreaRelativePath;
            }
            if (item != null && item.getFileAbsolutePath() != null) {
                ext = item.getFileAbsolutePath().substring(item.getFileAbsolutePath().lastIndexOf(".") + 1);
            }
            ext = ext != null ? ext.toUpperCase() : "";
            fileName = new StringBuffer(waRelativePath.lastIndexOf("/") > 0 ? waRelativePath.substring(waRelativePath.lastIndexOf("/") + 1) : waRelativePath);
            StringBuffer urlBase = R01MSearchResultItemFormatterUtils.composeItemBaseURL(this._formatterPrefs);
            String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
            String fileWARelPath = waRelativePath;
            if (fileWARelPath.startsWith("/")) {
                fileWARelPath = fileWARelPath.substring(1);
            }
            fileURL.append(urlBase);
            fileURL.append(contentAlias);
            fileURL.append('/');
            fileURL.append(fileWARelPath);
        }
        StringBuffer outDetail = new StringBuffer(200);
        outDetail.append("<span class='r01srItemAttachSprite");
        if (item.isDocumentMainDataFile()) {
            outDetail.append(" r01srItemMainDataFile'>");
        } else if (ext == null) {
            outDetail.append(" r01srItemAttachOther'>");
        } else if ("PDF".equals(ext)) {
            outDetail.append(" r01srItemAttachPDF'>");
        } else if ("DOC".equals(ext) || "RTF".equals(ext)) {
            outDetail.append(" r01srItemAttachDOC'>");
        } else if ("XLS".equals(ext)) {
            outDetail.append(" r01srItemAttachXLS'>");
        } else if ("PPT".equals(ext)) {
            outDetail.append(" r01srItemAttachPPT'>");
        } else if ("HTML".equals(ext) || "HTM".equals(ext)) {
            outDetail.append(" r01srItemAttachHTM'>");
        } else if ("XML".equals(ext)) {
            outDetail.append(" r01srItemAttachXML'>");
        } else if ("ZIP".equals(ext) || "RAR".equals(ext)) {
            outDetail.append(" r01srItemAttachZIP'>");
        } else {
            outDetail.append(" r01srItemAttachOther'>");
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)fileURL)) {
            fileURL.append(item.fileURL);
        }
        outDetail.append(R01MSearchResultItemFormatterUtils.composeItemLink(fileURL, fileName, null, null));
        outDetail.append("</span>");
        return outDetail;
    }
}

