/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant.R01MDefContentListItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class R01MContentListSearchResultItemTypoRecursosHumanosFormatter
extends R01MDefContentListItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefContentListItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        String cssClass = "r01gCLItem" + this.obtainTypoId(lang, item);
        StringBuffer sb = new StringBuffer(700);
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)metaDataDetails)) {
            sb.append("<div class=\"r01clearfix\">");
            sb.append("<div class=\"r01CLSItemCommon\">");
        }
        if (cssClass != null && cssClass.length() > 0) {
            sb.append("<div class=\"r01gCLItemDocLink ");
            sb.append(cssClass);
            sb.append("\">");
        } else {
            sb.append("<div class=\"r01gCLItemDocLink\">");
        }
        sb.append(docTitle);
        sb.append("</div>");
        if (typoDetails != null) {
            StringUtils.replaceAll((StringBuffer)typoDetails, (String)"&nbsp;", (String)" ");
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)typoDetails)) {
                sb.append("<div class=\"r01CLItemTypoDet\">");
                sb.append(typoDetails);
                sb.append("</div>");
            }
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)metaDataDetails)) {
            sb.append("</div>");
            sb.append("<div class=\"r01CLSItemMetaData\">");
            sb.append(metaDataDetails);
            sb.append("</div></div>");
        }
        return sb;
    }

    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        String cls = "Typo_empleo_publico";
        String state = this._getState(item);
        if (!StringUtils.isEmptyString((String)state)) {
            cls = cls.concat("_").concat(state);
        }
        return cls;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(50);
        String startDate = item.getDocumentMetaData("rrhhStartDate");
        String endDate = item.getDocumentMetaData("rrhhEndDate");
        String state = this._getState(item);
        Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.dateRange_" + state));
        if (startDat != null) {
            outSb.append("&nbsp;(");
            outSb.append(DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
        }
        if (endDat != null) {
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append(")");
        }
        if (startDat != null && endDat == null) {
            outSb.append(")");
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        String strOfertante = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhSponsor")) ? item.getDocumentMetaData("rrhhSponsor") : "";
        outSb.append(" - ");
        outSb.append(strOfertante);
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        return outSb;
    }

    private String _getState(R01MSearchResultItem item) {
        String state = "";
        String startDate = item.getDocumentMetaData("rrhhStartDate");
        String endDate = item.getDocumentMetaData("rrhhEndDate");
        Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date currentDate = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        String formattedDate = df.format(currentDate);
        currentDate = DateUtils.getDateFromLanguageFormatedString((String)formattedDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        state = startDat == null || endDat == null ? "pendiente" : (DateUtils.getDateAsMillis((Date)currentDate) < DateUtils.getDateAsMillis((Date)startDat) ? "no_abierto" : (endDat != null && DateUtils.getDateAsMillis((Date)currentDate) > DateUtils.getDateAsMillis((Date)endDat) ? "cerrado" : "abierto"));
        return state;
    }
}

