/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant.R01MDefContentListItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class R01MContentListSearchResultItemTypoProceduresFormatter
extends R01MDefContentListItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefContentListItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        String cssClass = "r01gCLItem" + this.obtainTypoId(lang, item);
        StringBuffer sb = new StringBuffer(700);
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)metaDataDetails)) {
            sb.append("<div class=\"r01clearfix\">");
            sb.append("<div class=\"r01CLSItemCommon\">");
        }
        if (cssClass != null && cssClass.length() > 0) {
            sb.append("<div class=\"r01gCLItemDocLink ");
            sb.append(cssClass);
            sb.append("\">");
        } else {
            sb.append("<div class=\"r01gCLItemDocLink\">");
        }
        sb.append(docTitle);
        sb.append("</div>");
        if (typoDetails != null) {
            StringUtils.replaceAll((StringBuffer)typoDetails, (String)"&nbsp;", (String)" ");
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)typoDetails)) {
                sb.append("<div class=\"r01CLItemTypoDet\">");
                sb.append(typoDetails);
                sb.append("</div>");
            }
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)metaDataDetails)) {
            sb.append("</div>");
            sb.append("<div class=\"r01CLSItemMetaData\">");
            sb.append(metaDataDetails);
            sb.append("</div></div>");
        }
        return sb;
    }

    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        String cls = "Typo_procedimientos_administrativos";
        String procStatus = item.getDocumentMetaData("procedureStatus");
        String procSolved = item.getDocumentMetaData("procedureSolved");
        if (procStatus != null) {
            if (procStatus.equals("16")) {
                cls = this._obtainStyleByEndDate(item.getDocumentMetaData("procedureEndDate"));
            } else if (procStatus.equals("17")) {
                cls = "Typo_procedimientos_administrativos_closed";
            } else if (procStatus.equals("18")) {
                cls = "Typo_procedimientos_administrativos_solved";
            } else if (procStatus.equals("19")) {
                cls = "Typo_procedimientos_administrativos_historic";
            }
        } else {
            cls = procSolved != null ? (procSolved.equalsIgnoreCase("S") ? "Typo_procedimientos_administrativos_solved" : this._obtainStyleByEndDate(item.getDocumentMetaData("procedureEndDate"))) : "Typo_" + item.getContentTypology().getFamilyOid();
        }
        return cls;
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        Date startDat;
        StringBuffer outSb = new StringBuffer(50);
        String procStatus = item.getDocumentMetaData("procedureStatus");
        String startDate = item.getDocumentMetaData("procedureStartDate");
        String endDate = item.getDocumentMetaData("procedureEndDate");
        String br = "";
        if (procStatus != null) {
            outSb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid(), "procedureStatus", procStatus));
            br = "<br />";
        }
        if (startDate != null && endDate != null) {
            Date startDat2 = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            if (startDate != null && endDate != null) {
                outSb.append(br);
                outSb.append('(');
                outSb.append(DateUtils.getDateLanguageFormated((Date)startDat2, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
                outSb.append("&nbsp;-&nbsp;");
                outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
                outSb.append(')');
            }
        } else if (startDate == null && endDate != null) {
            Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            if (endDat != null) {
                outSb.append(br);
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.fechaFin"));
                outSb.append("&nbsp;");
                outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            }
        } else if (startDate != null && endDate == null && (startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS)) != null) {
            outSb.append(br);
            outSb.append('(');
            outSb.append(DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "procedimientos_administrativos.pendiente_publicacion"));
            outSb.append(')');
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        return outSb;
    }

    private String _obtainStyleByEndDate(String procEndDate) {
        String outCls = "Typo_procedimientos_administrativos";
        if (procEndDate != null) {
            Date endDate = DateUtils.getDateFromLanguageFormatedString((String)procEndDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(endDate);
            Calendar endMinusTwoCalendar = Calendar.getInstance();
            endMinusTwoCalendar.setTime(endDate);
            endMinusTwoCalendar.roll(5, -2);
            Calendar currCalendar = Calendar.getInstance();
            outCls = DateUtils.rollCalendarToMinimum((Calendar)endMinusTwoCalendar).before(DateUtils.rollCalendarToMaximum((Calendar)currCalendar)) && DateUtils.rollCalendarToMinimum((Calendar)currCalendar).before(DateUtils.rollCalendarToMaximum((Calendar)endCalendar)) ? "Typo_procedimientos_administrativos_activeLastDays" : "Typo_procedimientos_administrativos_active";
        } else {
            outCls = "Typo_procedimientos_administrativos_active";
        }
        return outCls;
    }
}

