/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant.R01MDefContentListItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.util.Date;
import java.util.Properties;

public class R01MContentListSearchResultItemTypoMeteoFormatter
extends R01MDefContentListItemTypoDefaultFormatter {
    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefContentListItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(700);
        String cssClassMeteo = "r01gCLItemTypo_NoAvisos";
        sb.append("<div class=\"r01gCLItemDocLink r01gCLItemDocLinkMeteo ");
        sb.append(cssClassMeteo);
        sb.append("\">");
        sb.append(docTitle);
        sb.append("</div>");
        if (typoDetails != null) {
            StringUtils.replaceAll((StringBuffer)typoDetails, (String)"&nbsp;", (String)" ");
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)typoDetails)) {
                sb.append("<div class=\"r01CLItemTypoDet\">");
                sb.append(typoDetails);
                sb.append("</div>");
            }
        }
        return sb;
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        StringBuffer titleText = new StringBuffer(77);
        String dateStart = this.getMetaDateFormatedString(item.getDocumentMetaData("meteoDateStart"), lang);
        titleText.append("\t\t\t\t\t\t\t<img src=\"");
        titleText.append("\" class=\"r01srItemPrev\" alt=\"");
        if (item.getDocumentMetaData("meteoForecastIcon") != null) {
            titleText.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, this.getImageResourceNameFromUrl(item.getDocumentMetaData("meteoForecastIcon"))));
        }
        titleText.append("\"/>");
        if (dateStart != null) {
            titleText.append("<span>");
            titleText.append(item.getDocumentName());
            titleText.append("&nbsp;(");
            titleText.append(dateStart);
            titleText.append(")</span>");
            return titleText;
        }
        return new StringBuffer(item.getDocumentName());
    }

    protected String getMetaDateFormatedString(String metaDateString, String lang) {
        Properties dateFormat = new Properties();
        dateFormat.put("es", "dd/MM/yyyy");
        dateFormat.put("eu", "yyyy/MM/dd");
        Date metaDate = DateUtils.getDateFromFormatedString((String)metaDateString, (String)"dd/MM/yyyy");
        return metaDate != null ? DateUtils.getDateLanguageFormated((Date)metaDate, (String)lang, (Properties)dateFormat) : null;
    }

    protected String getImageResourceNameFromUrl(String imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        String resp = imageUrl;
        if (imageUrl.lastIndexOf(47) != -1) {
            resp = "meteo." + resp.substring(imageUrl.lastIndexOf(47) + 1);
        }
        return resp;
    }
}

