/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist.typo;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant.R01MContentListSearchResultItemTypoProceduresFormatter;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.Properties;

public class R01MContentListTypoAnuncioContratacionFormatter
extends R01MContentListSearchResultItemTypoProceduresFormatter {
    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        String cls = "Typo_procedimientos_administrativos";
        String prcStatus = item.getDocumentMetaData("contratacion_estado_tramitacion");
        String prcStatusAdjudicacion = item.getDocumentMetaData("contratacion_adjudicacion");
        if (!StringUtils.isEmptyString((String)prcStatus)) {
            if ("AP".equals(prcStatus)) {
                cls = "Typo_contratacion_anuncio_previo";
            } else if ("AT".equals(prcStatus)) {
                cls = "Typo_contratacion_alerta_temprana";
            } else if ("AL".equals(prcStatus)) {
                cls = "Typo_contratacion_plazo";
            } else if ("AC".equals(prcStatus)) {
                cls = "Typo_contratacion_cerrado";
            } else if ("AD".equals(prcStatus)) {
                if (!StringUtils.isEmptyString((String)prcStatusAdjudicacion)) {
                    cls = "Typo_contratacion_adjudicacion_provisional";
                    cls = "2".equals(prcStatusAdjudicacion) ? "Typo_contratacion_adjudicado" : "Typo_contratacion_adjudicacion_provisional";
                } else {
                    cls = "Typo_contratacion_adjudicacion_provisional";
                }
            } else if ("DE".equals(prcStatus)) {
                cls = "Typo_contratacion_desistimiento";
            } else if ("HI".equals(prcStatus)) {
                cls = "Typo_contratacion_historico";
            } else if ("FO".equals(prcStatus)) {
                cls = "Typo_formalizacion_contrato";
            }
        }
        return cls;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(50);
        String estado = "";
        String tipo = "Typo_procedimientos_administrativos";
        estado = item.getDocumentMetaData("contratacion_estado_tramitacion");
        if (!StringUtils.isEmptyString((String)estado)) {
            if ("AP".equals(estado)) {
                tipo = "Typo_contratacion_anuncio_previo";
            } else if ("AT".equals(estado)) {
                tipo = "Typo_contratacion_alerta_temprana";
            } else if ("AL".equals(estado)) {
                tipo = "Typo_contratacion_plazo";
            } else if ("AC".equals(estado)) {
                tipo = "Typo_contratacion_anuncio_estudio";
            } else if ("AD".equals(estado)) {
                tipo = "Typo_contratacion_adjudicacion_provisional";
            } else if ("DE".equals(estado)) {
                tipo = "Typo_contratacion_desistimiento";
            } else if ("HI".equals(estado)) {
                tipo = "Typo_contratacion_historico";
            } else if ("FO".equals(estado)) {
                tipo = "Typo_formalizacion_contrato";
            }
        }
        Date fechaPublicacionDate = null;
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("contratacion_fecha_de_publicacion_documento"))) {
            fechaPublicacionDate = DateUtils.getDateFromLanguageFormatedString((String)item.getDocumentMetaData("contratacion_fecha_de_publicacion_documento"), null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        }
        if (fechaPublicacionDate == null) {
            return new StringBuffer();
        }
        String typoInfo = "<em class=\"r01srItemTypoDet\"><span class=\"r01srItem" + tipo + "\">";
        outSb.insert(0, typoInfo);
        if (fechaPublicacionDate != null) {
            outSb.append(DateUtils.getDateLanguageFormated((Date)fechaPublicacionDate, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
        }
        outSb.append("</span></em>");
        return outSb;
    }
}

