/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist.ehu;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultItemsHtmlFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.Serializable;
import java.util.Properties;

public class R01MContentListSearchResultItemsHtmlEHUFormatter
extends R01MDefSearchResultItemsHtmlFormatter
implements R01MSearchResultItemsFormatter,
Serializable {
    private static final long serialVersionUID = 4226755714139850088L;

    @Override
    public void setTypoDependantFormatterClassNames(Properties classNames) {
        this._typoDepFormatterClassNames = classNames;
        if (this._typoDepFormatterClassNames == null) {
            this._typoDepFormatterClassNames = new Properties();
            this._typoDepFormatterClassNames.put("default", R01MClientFactory.getPropertiesConfigAPI().getProperty("searchEngine/defaultHTMLFormatters/contentListDefault", "com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter"));
        }
    }

    @Override
    public StringBuffer doFormatResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        StringBuffer sb = new StringBuffer(5000);
        if (results.length > 0) {
            sb.append("<ul>");
            for (int i = 0; i < results.length; ++i) {
                try {
                    sb.append(this._formatResultItem(lang, prefs, results[i]).toString());
                    continue;
                }
                catch (Exception ex) {
                    sb.append("<!--[Error :");
                    sb.append(ex.getMessage());
                    sb.append("]-->");
                }
            }
            sb.append("</ul>");
        }
        return sb;
    }

    protected StringBuffer _formatResultItem(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem item) {
        String typoDetailCheck;
        if (item == null) {
            return new StringBuffer("");
        }
        StringBuffer sb = new StringBuffer(500);
        String cssClass = "r01gCLItem" + R01MSearchResultItemFormatterUtils.obtainTypoId(this._typoDepFormatterClassNames, lang, item, prefs);
        sb.append("<li>");
        if (cssClass != null && cssClass.length() > 0) {
            sb.append("<div class='r01gCLItemDocLink ");
            sb.append(cssClass);
            sb.append("'>");
            sb.append(R01MSearchResultItemFormatterUtils.composeDocumentTitle(this._typoDepFormatterClassNames, lang, item, prefs));
            sb.append("</div>");
        } else {
            sb.append("<div class='r01gCLItemDocLink'>");
            sb.append(R01MSearchResultItemFormatterUtils.composeDocumentTitle(this._typoDepFormatterClassNames, lang, item, prefs));
            sb.append("</div>");
        }
        StringBuffer typoDetail = R01MSearchResultItemFormatterUtils.composeTypoDetails(this._typoDepFormatterClassNames, lang, item, prefs);
        if (typoDetail != null && !StringUtils.isEmptyString((String)(typoDetailCheck = StringUtils.replaceString((String)typoDetail.toString(), (String)"&nbsp;", (String)" ")))) {
            sb.append("<div class='r01CLItemTypoDet'>");
            sb.append(typoDetail);
            sb.append("</div>");
        }
        sb.append("</li>");
        return sb;
    }
}

