/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist.customized;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.html.contentlist.typodependant.R01MDefContentListItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MContentListTypoLanbideEstadisticaFormatter
extends R01MDefContentListItemTypoDefaultFormatter {
    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        return "Typo_opendata";
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        String actualizacion;
        StringBuffer outSb = new StringBuffer(50);
        outSb.append(this._composeDatasetDetails(lang, item));
        String regularity = item.getDocumentMetaData() != null ? item.getDocumentMetaData("statisticRegularity") : null;
        String string = actualizacion = item.getDocumentMetaData() != null ? item.getDocumentMetaData("OpendataReleaseDate") : null;
        if (regularity != null || actualizacion != null) {
            outSb.append("<div class=\"r01clearfix\">");
            if (regularity != null) {
                outSb.append("<div class=\"r01dLanbideEstadisticaInfo r01dLanbideEstadisticaPeriodicidad\"><span class=\"r01dLanbideEstadisticaInfoTitle\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "estadistica.periodicidad"));
                outSb.append(":</span>&nbsp;<i>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid(), "statisticRegularity", regularity));
                outSb.append("</i></div>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            if (actualizacion != null) {
                outSb.append("<div class=\"r01dLanbideEstadisticaInfo r01dLanbideEstadisticaActualizacion\"><span class=\"r01dLanbideEstadisticaInfoTitle\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "estadistica.acutalizado"));
                outSb.append(":</span>&nbsp;<i>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid(), "OpendataReleaseDate", actualizacion));
                outSb.append("</i></div>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            outSb.append("</div>");
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        outSb.insert(0, "<div class=\"r01srItemTypoDet\">");
        outSb.append("</div>");
        return outSb;
    }

    private StringBuffer _composeDatasetDetails(String lang, R01MSearchResultItem item) {
        JSONArray jArray;
        StringBuffer sb = new StringBuffer();
        if (item.getDocumentMetaData("OpendataDatasets") == null || StringUtils.isEmptyString((String)item.getDocumentMetaData("OpendataDatasets"))) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        try {
            jArray = new JSONArray(item.getDocumentMetaData("OpendataDatasets"));
        }
        catch (JSONException ex1) {
            Pattern p1 = Pattern.compile("\\{([^\\{\\}]*)\\}");
            Matcher m1 = p1.matcher(item.getDocumentMetaData("OpendataDatasets"));
            jArray = new JSONArray();
            while (m1.find()) {
                String JObjectString = m1.group(0);
                Pattern p2 = Pattern.compile("([^:,\\{\\}]*):((?:[a-zA-Z ]+:)?[^:,\\{\\}]*)");
                Matcher m2 = p2.matcher(JObjectString);
                JSONObject jObjectAutonomy = new JSONObject();
                while (m2.find()) {
                    try {
                        jObjectAutonomy.put(m2.group(1).trim(), (Object)m2.group(2).trim());
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                jArray.put((Object)jObjectAutonomy);
            }
        }
        try {
            StringBuffer list = new StringBuffer();
            if (jArray != null && jArray.length() > 0) {
                sb.append("<div class=\"r01srItemRispLink r01clearfix\">");
                for (int i = 0; i < jArray.length(); ++i) {
                    JSONObject jObject = (JSONObject)jArray.get(i);
                    R01MRispDocument rispDoc = new R01MRispDocument();
                    rispDoc.loadFromJson(jObject);
                    if (StringUtils.isEmptyString((String)rispDoc.getContentRelativePath())) continue;
                    list.append("<li>\t<a href=\"");
                    list.append(rispDoc.getContentRelativePath());
                    list.append("\" class=\"");
                    list.append(rispDoc.getType().toLowerCase());
                    list.append("\" title= \"");
                    list.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.dataset." + rispDoc.getType().toLowerCase()));
                    list.append("\" ><strong><span class=\"file\">");
                    if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                        list.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                    } else {
                        list.append(rispDoc.getType().toUpperCase());
                    }
                    list.append("</span></strong></a>");
                    if (!StringUtils.isEmptyString((String)rispDoc.getSize()) && !"0".equals(rispDoc.getSize())) {
                        list.append(" (");
                        list.append(rispDoc.getSize());
                        if (rispDoc.getUnits() != null) {
                            list.append(" ");
                            list.append(rispDoc.getUnits());
                        }
                        list.append(") ");
                    }
                    list.append("</li>");
                }
                if (list != null && !StringUtils.isEmptyStringBuffer((StringBuffer)list)) {
                    list.insert(0, "<ul>");
                    list.append("</ul>");
                }
                sb.append(list);
                sb.append("</div>");
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace(System.err);
        }
        return sb;
    }
}

