/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xml.utils.XMLTransformerHelper;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.searchengine.formatters.html.contentlist.R01MContentListSearchResultItemsHtmlFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalDataAPI;
import com.ejie.r01m.utils.R01MConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.TransformerException;

public class R01MContentListSearchResultItemsXslFormatter
extends R01MContentListSearchResultItemsHtmlFormatter
implements R01MSearchResultItemsFormatter,
Serializable {
    private static final long serialVersionUID = 1915282241585923001L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer doFormatResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        String xslPortalRelativePath = prefs.formatterAtributtes.get("xslPortalRelativePath").toString();
        String portalOid = prefs.formatterAtributtes.get("portalCode").toString();
        StringBuffer sb = null;
        if (results != null && results.length > 0 && portalOid != null && xslPortalRelativePath != null && !StringUtils.isEmptyString((String)portalOid) && !StringUtils.isEmptyString((String)xslPortalRelativePath)) {
            OutputStream out = null;
            InputStream xslIS = null;
            try {
                try {
                    R01MPortalDataAPI portal = R01MClientFactory.getPortalDataAPI(R01MAuthManager.createMasterSystemUserContext(), portalOid);
                    xslIS = portal.downloadPortalFile(xslPortalRelativePath);
                }
                catch (Exception e) {
                    StringBuffer stringBuffer = R01MContentListSearchResultItemsXslFormatter._composeNoResultsMessage(lang);
                    try {
                        if (xslIS != null) {
                            xslIS.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.out);
                    }
                    return stringBuffer;
                }
                out = new ByteArrayOutputStream();
                StringBuffer xml = new StringBuffer();
                xml.append("<?xml version=\"1.0\" encoding=\"");
                xml.append(R01MConstants.DEFAULT_WEB_ENCODING);
                xml.append("\"?>\r\n");
                R01MSearchSessionResults virtualSessionResults = new R01MSearchSessionResults();
                R01MSearchSourceResults virtualSourceResults = new R01MSearchSourceResults("virtualSourceOid");
                virtualSourceResults.setResults(results);
                HashMap<String, R01MSearchSourceResults> virtualResults = new HashMap<String, R01MSearchSourceResults>();
                virtualResults.put("virtualSourceOid", virtualSourceResults);
                virtualSessionResults.setSearchResultsBySource(virtualResults);
                xml.append(R01MClientFactory.getSearchEngineSessionAPI().getXMLFromSearchSessionResults(virtualSessionResults));
                Properties params = new Properties();
                XMLTransformerHelper.applyXSLtoXML((InputStream)new ByteArrayInputStream(xml.toString().getBytes()), (InputStream)xslIS, (Properties)params, (OutputStream)out);
                sb = new StringBuffer(5000);
                sb.append(out.toString());
            }
            catch (XOMarshallerException ex) {
                ex.printStackTrace(System.out);
            }
            catch (TransformerException ex) {
                ex.printStackTrace(System.out);
            }
            catch (Throwable th) {
                th.printStackTrace(System.out);
            }
            finally {
                try {
                    if (xslIS != null) {
                        xslIS.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                }
            }
        } else {
            R01MContentListSearchResultItemsXslFormatter._composeNoResultsMessage(lang);
        }
        return sb;
    }

    private static StringBuffer _composeNoResultsMessage(String lang) {
        return new StringBuffer("No se han encontrado resultados...");
    }
}

