/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.contentlist;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultItemsHtmlFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class R01MContentListSearchResultItemsHtmlFormatter
extends R01MDefSearchResultItemsHtmlFormatter
implements R01MSearchResultItemsFormatter,
Serializable {
    private static final long serialVersionUID = 8893493012869809487L;

    @Override
    public void setTypoDependantFormatterClassNames(Properties classNames) {
        this._typoDepFormatterClassNames = classNames;
        if (this._typoDepFormatterClassNames == null) {
            this._typoDepFormatterClassNames = new Properties();
            this._typoDepFormatterClassNames.put("default", R01MClientFactory.getPropertiesConfigAPI().getProperty("searchEngine/defaultHTMLFormatters/contentListDefault", "com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter"));
        }
    }

    @Override
    public StringBuffer doFormatResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        StringBuffer sb = new StringBuffer(5000);
        if (results.length > 0) {
            sb.append("<ul>");
            for (int i = 0; i < results.length; ++i) {
                sb.append(this._formatResultItem(lang, prefs, results[i]).toString());
            }
            sb.append("</ul>");
        }
        return sb;
    }

    @Override
    public Map doFormatSimpleResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        LinkedHashMap<String, StringBuffer> sb = new LinkedHashMap<String, StringBuffer>();
        if (results.length > 0) {
            for (int i = 0; i < results.length; ++i) {
                sb.put(results[i].documentOid, this._formatSimpleResultItem(lang, prefs, results[i]));
            }
        }
        return sb;
    }

    protected StringBuffer _formatResultItem(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (prefs != null) {
            prefs.sourceFormatter = "CONTENT_LIST";
        }
        StringBuffer sb = new StringBuffer(500);
        try {
            String linkStyleClass = null;
            sb.append("<li>");
            if (item.getContentTypology().getFamilyOid().equals("meteorologia") && !item.getContentTypology().getTypeOid().equals("avisos")) {
                linkStyleClass = "r01clearfix";
            }
            StringBuffer docTitle = R01MSearchResultItemFormatterUtils.composeDocumentTitle(this._typoDepFormatterClassNames, lang, item, prefs, linkStyleClass);
            StringBuffer typoDetail = R01MSearchResultItemFormatterUtils.composeTypoDetails(this._typoDepFormatterClassNames, lang, item, prefs);
            StringBuffer metaDataDetails = R01MSearchResultItemFormatterUtils.composeMetaDataDetail(this._typoDepFormatterClassNames, lang, item, prefs);
            sb.append(R01MSearchResultItemFormatterUtils.composeDocument(this._typoDepFormatterClassNames, lang, item, 0, false, docTitle, null, null, typoDetail, null, metaDataDetails, prefs));
            sb.append("</li>");
        }
        catch (Exception ex) {
            sb.append("<!--<li><div class=\"r01gCLItemDocLink r01gCLItemTypoNoTypo\">[");
            sb.append(StringUtils.replaceString((String)R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.document.error"), (String)"[$[documentName]$]", (String)(item.getContentName() + "/" + item.getDocumentInternalName())));
            sb.append(":");
            sb.append(ex.getMessage());
            sb.append("</div></li>-->");
        }
        return sb;
    }

    @Override
    protected StringBuffer _formatSimpleResultItem(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (prefs != null) {
            prefs.sourceFormatter = "CONTENT_LIST";
        }
        StringBuffer sb = new StringBuffer(500);
        String linkStyleClass = null;
        sb.append("<div class=\"r01gClsDataGridItem\">");
        if (item.getContentTypology().getFamilyOid().equals("meteorologia") && !item.getContentTypology().getTypeOid().equals("avisos")) {
            linkStyleClass = "r01clearfix";
        }
        StringBuffer docTitle = R01MSearchResultItemFormatterUtils.composeDocumentTitle(this._typoDepFormatterClassNames, lang, item, prefs, linkStyleClass);
        StringBuffer typoDetail = R01MSearchResultItemFormatterUtils.composeTypoDetails(this._typoDepFormatterClassNames, lang, item, prefs);
        StringBuffer metaDataDetails = R01MSearchResultItemFormatterUtils.composeMetaDataDetail(this._typoDepFormatterClassNames, lang, item, prefs);
        sb.append(R01MSearchResultItemFormatterUtils.composeDocument(this._typoDepFormatterClassNames, lang, item, 0, false, docTitle, null, null, typoDetail, null, metaDataDetails, prefs));
        sb.append("</div>");
        return sb;
    }
}

