/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MContentSearchResultsHtmlFormatter
implements R01MSearchResultItemsFormatter,
Serializable {
    private static final long serialVersionUID = 5881988650916720053L;
    private Properties _typoDepFormatterClassNames = null;
    private Properties _propertiesResources = null;

    @Override
    public void setTypoDependantFormatterClassNames(Properties classNames) {
        this._typoDepFormatterClassNames = classNames;
        if (this._typoDepFormatterClassNames == null) {
            this._typoDepFormatterClassNames = new Properties();
            this._typoDepFormatterClassNames.put("default", "com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter");
        }
    }

    @Override
    public StringBuffer doFormatResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        if (results == null || results.length == 0) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(500);
        if (this._propertiesResources == null) {
            this.setLanguageResources(lang);
        }
        sb.append(this._formatHeadTable());
        for (int i = 0; i < results.length; ++i) {
            try {
                sb.append(this._formatResultItem(lang, results[i]));
                continue;
            }
            catch (Exception ex) {
                String filaStyle = "r01dFilaImparPar";
                if (i % 2 == 0) {
                    filaStyle = "r01dFilaPar";
                }
                sb.append("\n<table class='r01dSearchResultsTable'>\n\t<tr class='");
                sb.append(filaStyle);
                sb.append("'>\n\t\t<td colspan=\"2\"><span>");
                sb.append(i + 1);
                sb.append(".- ");
                sb.append(StringUtils.replaceString((String)R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.document.error"), (String)"[$[documentName]$]", (String)(results[i] != null ? results[i].getContentName() + "/" + results[i].getDocumentInternalName() : "null")));
                sb.append(':');
                sb.append(ex.getMessage());
                sb.append("</span></td>\n\t\t</td>\n\t</tr>\n</table>");
            }
        }
        return sb;
    }

    private StringBuffer _formatResultItem(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(500);
        NumberFormat format = DecimalFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        String itemNumber = item.getItemNumber() > 0 ? Integer.toString(item.getItemNumber()) : "0";
        String filaStyle = "r01dFilaImparPar";
        if (item.getItemNumber() % 2 == 0) {
            filaStyle = "r01dFilaPar";
        }
        sb.append("\n<table class='r01dSearchResultsTable'>\n\t<tr class='");
        sb.append(filaStyle);
        sb.append("'>\n\t\t<td width='30%'>");
        try {
            sb.append("\n\t\t\t");
            sb.append(itemNumber);
            sb.append(".- <label  title='");
            sb.append(this._propertiesResources.getProperty("r01dadvancedsearchcontent.table.contentType").toUpperCase());
            sb.append("'>");
            sb.append(item.getContentTypology().getTypeOid());
            sb.append("</label>");
        }
        catch (NullPointerException e) {
            sb.append("\n\t\t\t");
            sb.append(itemNumber);
            sb.append(".- <label  title='");
            sb.append(this._propertiesResources.getProperty("r01dadvancedsearchcontent.table.contentType").toUpperCase());
            sb.append("'>La tipologia es <strong>null</strong></label>");
        }
        String editURL = item.getContentEditURL(lang);
        if (editURL == null) {
            editURL = item.getContentEditURL(R01MConstants.DEFAULT_LANG);
        }
        if (editURL == null) {
            editURL = "/r01dtContentManagerWAR/r01dLoadAdminContent.jsp?oid=" + item.getContentOid();
        }
        sb.append("\n\t\t</td>\n\t\t<td width='40%'>\n\t\t\t<a href='javascript:window.parent.location.href=\"");
        sb.append(editURL);
        sb.append("&loadSearch=true&urlReturn=/r01dtContentManagerWAR/advancedSearchEnter.do\";' class='r01dTextoLink'  title='");
        sb.append(this._propertiesResources.getProperty("r01dadvancedsearchcontent.table.contentName").toUpperCase());
        sb.append("'>\n\t\t\t\t");
        sb.append(item.getContentName());
        sb.append("\n\t\t\t</a>&nbsp;-&nbsp;<span title=\"");
        sb.append(StringEscapeUtils.escapeHtml((String)item.getDocumentName()));
        sb.append("\">");
        if (item.getDocumentName().length() + item.getContentName().length() > 75) {
            sb.append(item.getDocumentName().substring(0, 75 - item.getContentName().length()));
            sb.append("...");
        } else {
            sb.append(item.getDocumentName());
        }
        sb.append("</span>");
        sb.append("\n\t\t</td>");
        sb.append("\n\t\t<td width='30%'>");
        if (StringUtils.isEmptyString((String)item.getMainFriendlyURL())) {
            sb.append("");
        } else {
            sb.append(item.getMainFriendlyURL());
        }
        sb.append("</td>");
        sb.append("\n\t</tr>\n</table>");
        return sb;
    }

    public void setLanguageResources(String lang) {
        try {
            this._propertiesResources = new Properties();
            String languageResource = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)("propertiesFilesPath/contentManager/" + lang));
            this._propertiesResources.load(ResourcesLoader.getResourceFileAsStream((String)languageResource));
        }
        catch (IOException e) {
            R01FLog.to((String)"r01m.searchEngine").severe("Error cargando ficheros de idiomas: " + e.toString());
        }
    }

    private StringBuffer _formatHeadTable() {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public Map doFormatSimpleResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        return null;
    }
}

