/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01m.exceptions.R01MSearchWebException;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class R01MSearchSessionFormatterInstanceManager {
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01m.searchEngineWeb").intValue() != Level.OFF.intValue();
    private Map _formatter_instances = new HashMap(10);

    public R01MSearchSessionFormatter getSessionFormatter(R01MSearchSessionFormatterPreferences prefs) throws R01MSearchWebException {
        if (prefs != null && prefs.formatterImpls.sessionFormatterClassName != null && prefs.formatterImpls.sessionFormatterClassName.length() > 0) {
            try {
                R01MSearchSessionFormatter instance = (R01MSearchSessionFormatter)this._formatter_instances.get(prefs.formatterImpls.sessionFormatterClassName);
                if (instance != null) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01m.searchEngineWeb").info("formateador de b\u00fasqueda: " + prefs.formatterImpls.sessionFormatterClassName);
                    }
                    return instance;
                }
                R01MSearchSessionFormatter formatter = (R01MSearchSessionFormatter)ReflectionUtils.getObjectInstance((String)prefs.formatterImpls.sessionFormatterClassName);
                this._formatter_instances.put(prefs.formatterImpls.sessionFormatterClassName, formatter);
                if (DEBUG) {
                    R01FLog.to((String)"r01m.searchEngineWeb").info("formateador de b\u00fasqueda: " + prefs.formatterImpls.sessionFormatterClassName);
                }
                return formatter;
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
            }
        }
        try {
            String defaultSessionFormatterClassName = R01MClientFactory.getPropertiesConfigAPI().getProperty("searchEngine/defaultHTMLFormatters/session");
            R01FLog.to((String)"r01m.searchEngineWeb").severe("No se ha podido instanciar el formateador indicado en las preferencias: " + (prefs != null ? prefs.formatterImpls.sessionFormatterClassName : "null") + ": Se utiliza el formateador por defecto " + defaultSessionFormatterClassName);
            R01MSearchSessionFormatter instance = (R01MSearchSessionFormatter)this._formatter_instances.get(defaultSessionFormatterClassName);
            if (instance != null) {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.searchEngineWeb").info("formateador de b\u00fasqueda: " + defaultSessionFormatterClassName);
                }
                return instance;
            }
            R01MSearchSessionFormatter formatter = (R01MSearchSessionFormatter)ReflectionUtils.getObjectInstance((String)defaultSessionFormatterClassName);
            this._formatter_instances.put(prefs.formatterImpls.sessionFormatterClassName, formatter);
            if (DEBUG) {
                R01FLog.to((String)"r01m.searchEngineWeb").info("formateador de b\u00fasqueda: " + defaultSessionFormatterClassName);
            }
            return formatter;
        }
        catch (ReflectionException refEx) {
            throw new R01MSearchWebException("Error al instanciar el formateador de la sesi\u00f3n: " + refEx.getMessage(), (Exception)((Object)refEx));
        }
    }
}

