/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.ArrayUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.formatters.R01MCataloguingFilters;
import com.ejie.r01m.config.objects.formatters.R01MFormatterClassConfig;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.link.R01MWindowAppearance;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemTypologyInfo;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemTypoDependantFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.catalog.R01MCatalogUtils;
import com.ejie.r01m.utils.link.R01MLinkUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import com.ejie.r01m.utils.urlreferencer.R01MUrlReferenceUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MSearchResultItemFormatterUtils {
    private static Map _typoFormattersImpls = new HashMap();

    public static StringBuffer composeDocument(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer docComposed = typoFormatter.composeDocument(lang, item, numItems, allItemsAreAttachmentFiles, docTitle, docDescription, typoInfo, typoDetails, catalogDetails, metaDataDetails);
        return docComposed != null ? docComposed : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public static String obtainTypoId(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return "";
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        String cssClass = typoFormatter.obtainTypoId(lang, item);
        return cssClass != null ? cssClass : "";
    }

    public static StringBuffer composeDocumentTitle(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        return R01MSearchResultItemFormatterUtils.composeDocumentTitle(typoDependantFormatterClassNames, lang, item, formatterPrefs, null);
    }

    public static StringBuffer composeDocumentTitle(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs, String linkStyleClass) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer text = typoFormatter.composeDocumentTitleText(lang, item);
        StringBuffer url = new StringBuffer(50);
        if (item.getContentTypology().getFamilyOid().equals("enlaces") && item.getDocumentMetaData("enlaceDirectRedirection") != null && item.getDocumentMetaData("enlaceDirectRedirection").equals("s")) {
            url = R01MSearchResultItemFormatterUtils._getLinkUrl(item);
            if (item.getDocumentMetaData("enlaceTarget") != null && item.getDocumentMetaData("enlaceTarget").equals("new_window")) {
                R01MSearchResultsFormatterPreferences newFormatterPrefs = null;
                if (formatterPrefs != null && formatterPrefs.formatterAtributtes != null && !formatterPrefs.formatterAtributtes.isEmpty() && formatterPrefs.formatterAtributtes.containsKey("urlReferenceWindowAppearance")) {
                    newFormatterPrefs = (R01MSearchResultsFormatterPreferences)CloneUtils.cloneByReflection((Object)formatterPrefs);
                    newFormatterPrefs.openInNewWindow = true;
                    ((R01MWindowAppearance)newFormatterPrefs.formatterAtributtes.get("urlReferenceWindowAppearance")).setNewWindow(true);
                } else {
                    newFormatterPrefs = formatterPrefs == null ? new R01MSearchResultsFormatterPreferences() : (R01MSearchResultsFormatterPreferences)CloneUtils.cloneByReflection((Object)formatterPrefs);
                    if (newFormatterPrefs.formatterAtributtes == null) {
                        newFormatterPrefs.formatterAtributtes = new HashMap();
                    }
                    R01MWindowAppearance windowAppearance = new R01MWindowAppearance();
                    windowAppearance.setNewWindow(true);
                    newFormatterPrefs.formatterAtributtes.put("urlReferenceWindowAppearance", windowAppearance);
                }
                if (StringUtils.isEmptyStringBuffer((StringBuffer)url)) {
                    url = R01MUrlReferenceUtils.encodeUrlSpaces(R01MSearchResultItemFormatterUtils.composeItemFriendlyURL(item, newFormatterPrefs));
                }
                return new StringBuffer(R01MSearchResultItemFormatterUtils.composeItemLink(url, text, linkStyleClass, newFormatterPrefs));
            }
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)url)) {
            url = R01MUrlReferenceUtils.encodeUrlSpaces(R01MSearchResultItemFormatterUtils.composeItemFriendlyURL(item, formatterPrefs));
        }
        return new StringBuffer(R01MSearchResultItemFormatterUtils.composeItemLink(url, text, linkStyleClass, formatterPrefs));
    }

    public static StringBuffer composeItemURL(R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        StringBuffer urlBase = R01MSearchResultItemFormatterUtils.composeItemBaseURL(formatterPrefs);
        boolean activeAliases = R01MSearchEngineWebConstants.ACTIVE_URL_ALIASES.equals("1");
        boolean isPage = true;
        boolean pageIsAlias = false;
        StringUtils.replaceAll((StringBuffer)urlBase, (String)"//", (String)"/");
        if (StringUtils.isEmptyStringBuffer((StringBuffer)urlBase) || urlBase.toString().equals("/")) {
            isPage = false;
        } else if (activeAliases) {
            Pattern pattern = Pattern.compile("/([^-]+)-([^/-]+)/[^/]{2}/?");
            Matcher match = pattern.matcher(urlBase);
            if (!match.matches()) {
                pageIsAlias = true;
            }
        } else {
            isPage = false;
        }
        boolean documentIsAlias = false;
        if (!StringUtils.isEmptyString((String)item.getMainFriendlyURL()) && activeAliases) {
            documentIsAlias = true;
        }
        String documentWorkAreaRelativePath = item.getDocumentWorkAreaRelativePath() != null ? item.getDocumentWorkAreaRelativePath() : "";
        String docMainDataFileDefGenFileDocRelPath = null;
        if (item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths() != null) {
            docMainDataFileDefGenFileDocRelPath = (String)item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths().get("main");
        }
        if (StringUtils.isEmptyString(docMainDataFileDefGenFileDocRelPath)) {
            String string = docMainDataFileDefGenFileDocRelPath = item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() != null ? item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() : "";
        }
        if (urlBase == null) {
            urlBase = new StringBuffer();
        }
        if (item.getContentTypology().getFamilyOid().equalsIgnoreCase(R01MConstants.PORTAL_FAMILY_ID)) {
            urlBase = new StringBuffer();
            Pattern p = Pattern.compile("([^_]+)_(.*)");
            Matcher m = p.matcher(item.getDocumentInternalName());
            if (m.find()) {
                urlBase.append("/");
                urlBase.append(m.group(2));
                urlBase.append("/");
                urlBase.append(m.group(1));
                urlBase.append("/");
            }
            return urlBase;
        }
        String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
        if (documentWorkAreaRelativePath != null && !StringUtils.isEmptyString((String)docMainDataFileDefGenFileDocRelPath)) {
            if (isPage) {
                if (pageIsAlias) {
                    if (documentIsAlias) {
                        urlBase.append("/-/");
                        urlBase.append(item.getMainFriendlyURL());
                    } else {
                        urlBase.append("/-/");
                        urlBase.append(contentAlias);
                        urlBase.append('/');
                        urlBase.append(documentWorkAreaRelativePath);
                        urlBase.append('/');
                        urlBase.append(docMainDataFileDefGenFileDocRelPath);
                    }
                } else if (documentIsAlias) {
                    urlBase.insert(0, item.getMainFriendlyURL());
                    urlBase.insert(0, '/');
                } else {
                    urlBase.append(contentAlias);
                    urlBase.append('/');
                    urlBase.append(documentWorkAreaRelativePath);
                    urlBase.append('/');
                    urlBase.append(docMainDataFileDefGenFileDocRelPath);
                }
            } else {
                urlBase.append(contentAlias);
                urlBase.append('/');
                urlBase.append(documentWorkAreaRelativePath);
                urlBase.append('/');
                urlBase.append(docMainDataFileDefGenFileDocRelPath);
            }
            StringUtils.replaceAll((StringBuffer)urlBase, (String)"//", (String)"/");
            return urlBase;
        }
        return new StringBuffer(35);
    }

    public static StringBuffer composeItemNormalURL(R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        StringBuffer urlBase = R01MSearchResultItemFormatterUtils.composeItemBaseURL(formatterPrefs);
        String documentWorkAreaRelativePath = item.getDocumentWorkAreaRelativePath() != null ? item.getDocumentWorkAreaRelativePath() : "";
        String docMainDataFileDefGenFileDocRelPath = null;
        if (item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths() != null) {
            docMainDataFileDefGenFileDocRelPath = (String)item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths().get("main");
        }
        if (StringUtils.isEmptyString(docMainDataFileDefGenFileDocRelPath)) {
            String string = docMainDataFileDefGenFileDocRelPath = item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() != null ? item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() : "";
        }
        if (urlBase == null) {
            urlBase = new StringBuffer();
        }
        if (item.getContentTypology().getFamilyOid().equalsIgnoreCase(R01MConstants.PORTAL_FAMILY_ID)) {
            urlBase = new StringBuffer();
            Pattern p = Pattern.compile("([^_]+)_(.*)");
            Matcher m = p.matcher(item.getDocumentInternalName());
            if (m.find()) {
                urlBase.append("/");
                urlBase.append(m.group(2));
                urlBase.append("/");
                urlBase.append(m.group(1));
                urlBase.append("/");
            }
            return urlBase;
        }
        String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
        if (documentWorkAreaRelativePath != null && !StringUtils.isEmptyString((String)docMainDataFileDefGenFileDocRelPath)) {
            urlBase.append(contentAlias);
            urlBase.append('/');
            urlBase.append(documentWorkAreaRelativePath);
            urlBase.append('/');
            urlBase.append(docMainDataFileDefGenFileDocRelPath);
            return urlBase;
        }
        return new StringBuffer(35);
    }

    public static StringBuffer composeItemFriendlyURL(R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        StringBuffer urlBase = R01MSearchResultItemFormatterUtils.composeItemBaseURL(formatterPrefs);
        boolean activeAliases = R01MSearchEngineWebConstants.ACTIVE_URL_ALIASES.equals("1");
        boolean isPage = true;
        boolean pageIsAlias = false;
        StringUtils.replaceAll((StringBuffer)urlBase, (String)"//", (String)"/");
        if (StringUtils.isEmptyStringBuffer((StringBuffer)urlBase) || urlBase.toString().equals("/")) {
            isPage = false;
        } else if (activeAliases) {
            Pattern pattern = Pattern.compile("/([^-]+)-([^/-]+)/[^/]{2}/?");
            Matcher match = pattern.matcher(urlBase);
            if (!match.matches()) {
                pageIsAlias = true;
            }
        } else {
            isPage = false;
        }
        boolean documentIsAlias = false;
        if (!StringUtils.isEmptyString((String)item.getMainFriendlyURL()) && activeAliases) {
            documentIsAlias = true;
        }
        String documentWorkAreaRelativePath = item.getDocumentWorkAreaRelativePath() != null ? item.getDocumentWorkAreaRelativePath() : "";
        String docMainDataFileDefGenFileDocRelPath = null;
        if (item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths() != null) {
            docMainDataFileDefGenFileDocRelPath = (String)item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths().get("main");
        }
        if (StringUtils.isEmptyString(docMainDataFileDefGenFileDocRelPath)) {
            String string = docMainDataFileDefGenFileDocRelPath = item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() != null ? item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() : "";
        }
        if (urlBase == null) {
            urlBase = new StringBuffer();
        }
        if (item.getContentTypology().getFamilyOid().equalsIgnoreCase(R01MConstants.PORTAL_FAMILY_ID)) {
            urlBase = new StringBuffer();
            Pattern p = Pattern.compile("([^_]+)_(.*)");
            Matcher m = p.matcher(item.getDocumentInternalName());
            if (m.find()) {
                urlBase.append("/");
                urlBase.append(m.group(2));
                urlBase.append("/");
                urlBase.append(m.group(1));
                urlBase.append("/");
            }
            return urlBase;
        }
        String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
        if (documentWorkAreaRelativePath != null && !StringUtils.isEmptyString((String)docMainDataFileDefGenFileDocRelPath)) {
            if (isPage) {
                if (pageIsAlias) {
                    if (documentIsAlias) {
                        urlBase.append("/-/");
                        urlBase.append(item.getMainFriendlyURL());
                    } else {
                        urlBase.append("/-/");
                        urlBase.append(contentAlias);
                        urlBase.append('/');
                        urlBase.append(documentWorkAreaRelativePath);
                        urlBase.append('/');
                        urlBase.append(docMainDataFileDefGenFileDocRelPath);
                    }
                } else if (documentIsAlias) {
                    urlBase.insert(0, item.getMainFriendlyURL());
                    urlBase.insert(0, '/');
                } else {
                    urlBase.append(contentAlias);
                    urlBase.append('/');
                    urlBase.append(documentWorkAreaRelativePath);
                    urlBase.append('/');
                    urlBase.append(docMainDataFileDefGenFileDocRelPath);
                }
            } else {
                urlBase.append(contentAlias);
                urlBase.append('/');
                urlBase.append(documentWorkAreaRelativePath);
                urlBase.append('/');
                urlBase.append(docMainDataFileDefGenFileDocRelPath);
            }
            StringUtils.replaceAll((StringBuffer)urlBase, (String)"//", (String)"/");
            return urlBase;
        }
        return new StringBuffer(35);
    }

    public static StringBuffer composeItemRdfURL(R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        StringBuffer urlBase = R01MSearchResultItemFormatterUtils.composeItemBaseURL(formatterPrefs);
        String docMainDataFileDefGenFileDocRelPath = null;
        if (item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths() != null && (docMainDataFileDefGenFileDocRelPath = (String)item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths().get("main")).lastIndexOf(".") != -1) {
            docMainDataFileDefGenFileDocRelPath = docMainDataFileDefGenFileDocRelPath.substring(0, docMainDataFileDefGenFileDocRelPath.lastIndexOf("."));
        }
        String type = null;
        if (item.getContentTypology() != null && item.getContentTypology().getTypeOid() != null) {
            type = item.getContentTypology().getTypeOid();
        }
        if (urlBase == null) {
            urlBase = new StringBuffer();
        }
        if (!StringUtils.isEmptyString(type) && !StringUtils.isEmptyString((String)docMainDataFileDefGenFileDocRelPath)) {
            String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
            urlBase.append(contentAlias);
            urlBase.append("/");
            urlBase.append(type);
            urlBase.append("/");
            urlBase.append(item.getContentName());
            urlBase.append("/");
            urlBase.append(item.getDocumentInternalName());
            urlBase.append("/");
            urlBase.append(docMainDataFileDefGenFileDocRelPath);
            return urlBase;
        }
        return new StringBuffer(35);
    }

    public static StringBuffer composeItemBaseURL(R01MSearchResultsFormatterPreferences formatterPrefs) {
        String urlPrefix;
        String string = urlPrefix = formatterPrefs.itemUrlPrefix != null ? new String(formatterPrefs.itemUrlPrefix) : "";
        if (urlPrefix.length() > 0) {
            if (!urlPrefix.startsWith("/")) {
                urlPrefix = "/" + urlPrefix;
            }
            if (!urlPrefix.endsWith("/")) {
                urlPrefix = urlPrefix + "/";
            }
        } else {
            urlPrefix = "/";
        }
        return new StringBuffer(urlPrefix);
    }

    public static StringBuffer composeItemLink(StringBuffer targetURL, StringBuffer linkText, String linkStyleClass, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (StringUtils.isEmptyStringBuffer((StringBuffer)targetURL)) {
            return linkText;
        }
        StringBuffer link = new StringBuffer(30);
        link.append("<a");
        if (!StringUtils.isEmptyString((String)linkStyleClass)) {
            link.append(" class=\"");
            link.append(linkStyleClass);
            link.append("\" ");
        }
        R01MWindowAppearance refWindowAppearance = null;
        if (formatterPrefs != null && formatterPrefs.formatterAtributtes != null && formatterPrefs.formatterAtributtes.containsKey("urlReferenceWindowAppearance")) {
            refWindowAppearance = (R01MWindowAppearance)formatterPrefs.formatterAtributtes.get("urlReferenceWindowAppearance");
        }
        link.append(R01MLinkUtils.composeHrefWindowAppearance(targetURL.toString(), refWindowAppearance));
        link.append('>');
        link.append(linkText);
        link.append("</a>");
        return link;
    }

    public static StringBuffer composeDocumentDescription(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer description = typoFormatter.composeDocumentDescription(lang, item);
        return description != null ? description : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public static StringBuffer composeTypoInfo(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer typoInfo = typoFormatter.composeTypoInfo(lang, item);
        return typoInfo != null ? typoInfo : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public static StringBuffer composeTypoDetails(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer typoDetails = typoFormatter.composeTypoDetails(lang, item);
        return typoDetails != null ? typoDetails : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public static StringBuffer composeCatalogDetails(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer catDetails = typoFormatter.composeCatalogDetails(lang, item);
        return catDetails != null ? catDetails : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public static R01MSearchResultItemStructureCatalog[] obtainStructureCatalogs(R01MSearchResultItem item, String structureOid, String labelRole, int numOfCats) {
        int theNumOfCats = numOfCats <= 0 ? Integer.MAX_VALUE : numOfCats;
        int currNumOfCats = 0;
        ArrayList<R01MSearchResultItemStructureCatalog> outCats = new ArrayList<R01MSearchResultItemStructureCatalog>();
        if (item.getStructureCatalogs() != null) {
            R01MSearchResultItemStructureCatalog currCat2 = null;
            for (R01MSearchResultItemStructureCatalog currCat2 : item.getStructureCatalogs()) {
                if (currCat2.getStructureOid() == null || !currCat2.getStructureOid().equals(structureOid)) continue;
                if (currCat2.getRole().equals(labelRole)) {
                    outCats.add(currCat2);
                    ++currNumOfCats;
                }
                if (currNumOfCats != theNumOfCats) continue;
            }
        }
        return outCats.size() > 0 ? outCats.toArray(new R01MSearchResultItemStructureCatalog[outCats.size()]) : null;
    }

    public static R01MSearchResultItemStructureCatalog[] obtainStructureCatalogs(R01MSearchResultItem item, String structureOid, String labelRole) {
        return R01MSearchResultItemFormatterUtils.obtainStructureCatalogs(item, structureOid, labelRole, -1);
    }

    public static R01MSearchResultItemStructureCatalog obtainStructureCatalog(R01MSearchResultItem item, String structureOid, String labelRole) {
        R01MSearchResultItemStructureCatalog[] cats = R01MSearchResultItemFormatterUtils.obtainStructureCatalogs(item, structureOid, labelRole, 1);
        if (cats != null && cats.length == 0) {
            return null;
        }
        return cats != null ? cats[0] : null;
    }

    public static R01MSearchResultItemStructureCatalog[] obtainOrgStructureCatalogs(R01MSearchResultItem item) {
        R01MSearchResultItemStructureCatalog[] orgStructureCatalogs = null;
        List<R01MStructureCatalog> departamentos = R01MCatalogUtils.getStructuresConfig("structures/departamento");
        Iterator<R01MStructureCatalog> it = departamentos.iterator();
        while (it.hasNext()) {
            R01MStructureCatalog structureConfig = it.next();
            orgStructureCatalogs = (R01MSearchResultItemStructureCatalog[])ArrayUtils.addAll(orgStructureCatalogs, (Object[])R01MSearchResultItemFormatterUtils.obtainStructureCatalogs(item, structureConfig.getStructureOid(), structureConfig.getRole(), -1));
            it.hasNext();
        }
        return orgStructureCatalogs;
    }

    public static R01MSearchResultItemStructureCatalog obtainOrgStructureCatalog(R01MSearchResultItem item) {
        return R01MSearchResultItemFormatterUtils.obtainOrgStructureCatalog(item, "structures/departamento");
    }

    public static R01MSearchResultItemStructureCatalog obtainOrgStructureCatalog(R01MSearchResultItem item, String structure) {
        R01MSearchResultItemStructureCatalog[] catalogs = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, structure, true);
        return catalogs != null && catalogs.length > 0 ? catalogs[0] : null;
    }

    public static R01MSearchResultItemStructureCatalog[] obtainOrgStructuresCatalog(R01MSearchResultItem item, String structure, boolean onlyFirst) {
        R01MSearchResultItemStructureCatalog[] cats = null;
        List<R01MStructureCatalog> structuresCfg = R01MCatalogUtils.getStructuresConfig(structure);
        Iterator<R01MStructureCatalog> it = structuresCfg.iterator();
        while (it.hasNext()) {
            R01MStructureCatalog structureConfig = it.next();
            cats = R01MSearchResultItemFormatterUtils.obtainStructureCatalogs(item, structureConfig.getStructureOid(), structureConfig.getRole(), -1);
            if (onlyFirst && cats != null && cats.length != 0) break;
            it.hasNext();
        }
        if (cats != null && cats.length == 0) {
            return null;
        }
        return cats != null ? cats : null;
    }

    public static StringBuffer composeMetaDataDetail(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer md = typoFormatter.composeMetaDataDetails(lang, item);
        return md != null ? md : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public static StringBuffer composeLastUpdateDetail(String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        String date = R01MSearchResultItemFormatterUtils._obtainLastUpdateDate(lang, item);
        if (date != null) {
            String title = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.lastUpdateDate");
            return new StringBuffer(title + date);
        }
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    private static String _obtainLastUpdateDate(String lang, R01MSearchResultItem item) {
        Date date = null;
        date = item.getDocumentCreateDate();
        if (date != null) {
            return DateUtils.getDateLanguageFormated((Date)date, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
        }
        return "";
    }

    public static StringBuffer composeAttachment(Properties typoDependantFormatterClassNames, String lang, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        R01MSearchResultItemTypoDependantFormatter typoFormatter = R01MSearchResultItemFormatterUtils._obtainTypoFormatter(item, formatterPrefs);
        StringBuffer attach = typoFormatter.composeAttachment(lang, item);
        return attach != null ? attach : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    public static String fixTextToBeWrapped(String theText) {
        if (theText == null) {
            return null;
        }
        StringBuffer outText = new StringBuffer("");
        Pattern p = Pattern.compile("([^, ]),([^, ])", 2);
        Matcher m = p.matcher(theText);
        boolean directiveValid = m.find();
        while (directiveValid) {
            m.appendReplacement(outText, m.group(1) + ", " + m.group(2));
            directiveValid = m.find();
        }
        m.appendTail(outText);
        return outText.toString();
    }

    private static R01MSearchResultItemTypoDependantFormatter _obtainTypoFormatter(R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs) {
        R01MSearchResultItemTypoDependantFormatter outFormatter;
        String typoFormatterClassName = R01MClientFactory.getPropertiesConfigAPI().getProperty("searchEngine/defaultHTMLFormatters/searchResultDefault", "com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter");
        if (item == null) {
            R01FLog.to((String)"r01m.search").severe("El item a formatear es NULO !!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return new R01MDefSearchResultItemTypoDefaultFormatter();
        }
        R01MSearchResultItemTypologyInfo typo = item.getContentTypology();
        if (typo == null) {
            R01FLog.to((String)"r01m.search").severe("El tipo del item del documento " + item.getDocumentInternalName() + " del contenido " + item.contentName + " a formatear es NULO !!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return new R01MDefSearchResultItemTypoDefaultFormatter();
        }
        R01MContentType typeConfig = null;
        try {
            typeConfig = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typo.getFamilyOid(), typo.getTypeOid());
        }
        catch (R01MConfigLoadException ex) {
            R01FLog.to((String)"r01m.search").severe("Error al decorar el resultado de la busqueda. No se ha podido cargar la configuracion del tipo = " + typo.getTypeOid() + "_" + item.contentOid + " > " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
        if (typeConfig != null) {
            String className = R01MSearchResultItemFormatterUtils._obtainTypoFormatterClassName(typeConfig, item, formatterPrefs, typo.getTypeOid() + ".type");
            if (StringUtils.isEmptyString((String)className) && StringUtils.isEmptyString((String)(className = R01MSearchResultItemFormatterUtils._obtainTypoFormatterClassName(typeConfig, item, formatterPrefs, typo.getFamilyOid() + ".family")))) {
                className = R01MSearchResultItemFormatterUtils._obtainTypoFormatterClassName(typeConfig, item, formatterPrefs, "default");
            }
            if (!StringUtils.isEmptyString((String)className)) {
                typoFormatterClassName = className;
            }
        }
        if ((outFormatter = (R01MSearchResultItemTypoDependantFormatter)_typoFormattersImpls.get(typoFormatterClassName)) == null) {
            try {
                outFormatter = (R01MSearchResultItemTypoDependantFormatter)ReflectionUtils.getObjectInstance((String)typoFormatterClassName);
            }
            catch (ReflectionException ex) {
                ex.printStackTrace(System.out);
                R01MDefSearchResultItemTypoDefaultFormatter defFormatter = new R01MDefSearchResultItemTypoDefaultFormatter();
                defFormatter.setFormatterPreferences(formatterPrefs);
                _typoFormattersImpls.put(typoFormatterClassName, defFormatter);
                return defFormatter;
            }
        }
        if (outFormatter != null) {
            outFormatter.setFormatterPreferences(formatterPrefs);
            _typoFormattersImpls.put(typoFormatterClassName, outFormatter);
        }
        return outFormatter != null ? outFormatter : new R01MDefSearchResultItemTypoDefaultFormatter();
    }

    private static String _obtainTypoFormatterClassName(R01MContentType typeConfig, R01MSearchResultItem item, R01MSearchResultsFormatterPreferences formatterPrefs, String key) {
        String typoFormatterClassName = "";
        R01MFormatterClassConfig formatterClassConfig = null;
        if (typeConfig.getSearchEngineFormattersConfig() != null && typeConfig.getSearchEngineFormattersConfig().containsKey(key)) {
            formatterClassConfig = (R01MFormatterClassConfig)typeConfig.getSearchEngineFormattersConfig().get(key);
        }
        if (formatterClassConfig != null) {
            typoFormatterClassName = formatterPrefs != null && formatterPrefs.sourceFormatter.equals("CONTENT_LIST") ? formatterClassConfig.getContentListClass() : formatterClassConfig.getSearchResultClass();
            if (formatterClassConfig.getSearchEngineFormattersByLabelConfig() != null) {
                typoFormatterClassName = R01MSearchResultItemFormatterUtils._obtainTypoCataloguingFormatter(item.getStructureCatalogs(), formatterClassConfig.getSearchEngineFormattersByLabelConfig(), formatterPrefs.sourceFormatter);
            }
        }
        return typoFormatterClassName;
    }

    private static String _obtainTypoCataloguingFormatter(List structureCatalogs, List cataloguingFilters, String source) {
        String typoFormatterClassName = "";
        if (cataloguingFilters != null) {
            boolean containCataloguingFilter = false;
            R01MCataloguingFilters filter = null;
            Iterator it = cataloguingFilters.iterator();
            while (it.hasNext() && !(containCataloguingFilter = R01MSearchResultItemFormatterUtils._containCataloguingFilter(structureCatalogs, (filter = (R01MCataloguingFilters)it.next()).getFilter()))) {
            }
            if (containCataloguingFilter) {
                typoFormatterClassName = source.equals("CONTENT_LIST") ? filter.getContentListClass() : filter.getSearchResultClass();
            }
        }
        return typoFormatterClassName;
    }

    private static boolean _containCataloguingFilter(List structureCatalogs, String filter) {
        boolean containCataloguingFilter = false;
        String[] filtered = filter.split("_");
        if (structureCatalogs != null) {
            block0: for (int positionFilter = 0; !(positionFilter >= filtered.length || positionFilter != 0 && (filtered[positionFilter - 1].toUpperCase().equals("AND") && !containCataloguingFilter || filtered[positionFilter - 1].toUpperCase().equals("OR") && containCataloguingFilter)); positionFilter += 2) {
                for (R01MSearchResultItemStructureCatalog structureCatalog : structureCatalogs) {
                    if (filtered[positionFilter].indexOf(".") != -1) {
                        if (filtered[positionFilter].equals(structureCatalog.getStructureOid() + "." + structureCatalog.getLabelOid())) {
                            containCataloguingFilter = true;
                            continue block0;
                        }
                    } else if (filtered[positionFilter].equals(structureCatalog.getStructureOid())) {
                        containCataloguingFilter = true;
                        continue block0;
                    }
                    containCataloguingFilter = false;
                }
            }
        }
        return containCataloguingFilter;
    }

    private static StringBuffer _getLinkUrl(R01MSearchResultItem item) {
        StringBuffer url = new StringBuffer();
        url.append(item.getDocumentMetaData("enlaceUrl"));
        if (!url.toString().startsWith("/") && !url.toString().startsWith("#") && !"#".equals(url.toString()) && StringUtils.isEmptyString((String)R01MSearchResultItemFormatterUtils.getUrlProtocol(url.toString()))) {
            url.insert(0, "http://");
        }
        return url;
    }

    private static String getUrlProtocol(String url) {
        String protocol = null;
        String external_url_regexp = "(([A-Za-z]+:[\\/]+)|([mailto:|javascript:]+))*(.*)";
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile(external_url_regexp);
        m = p.matcher(url);
        if (m.matches() && m.groupCount() == 4) {
            protocol = m.group(1);
        }
        return protocol;
    }
}

