/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentDataAPI;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MSearchResultItemFormatterCommons {
    public static final StringBuffer composeThumbNailInclude(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem item, boolean checkThumNailFileInContentServer) {
        String thumbNailType = R01MSearchResultItemFormatterCommons._obtainThumbNailType(prefs);
        String generatedFileName = R01MSearchResultItemFormatterCommons._obtainGeneratedFileName(item, thumbNailType);
        if (generatedFileName == null) {
            return null;
        }
        boolean thumbNailOK = true;
        if (checkThumNailFileInContentServer) {
            try {
                R01MContentDataAPI dataAPI = R01MClientFactory.getContentDataAPI(R01MAuthManager.createMasterSystemUserContext(), item.getContentOid());
                if (!dataAPI.checkAttachmentFile(item.getDocumentOid(), generatedFileName)) {
                    thumbNailOK = false;
                }
            }
            catch (R01MSecurityException ex) {
                ex.printStackTrace(System.out);
                thumbNailOK = false;
            }
            catch (R01MContentModelException ex) {
                ex.printStackTrace(System.out);
                thumbNailOK = false;
            }
        }
        if (!thumbNailOK) {
            return null;
        }
        StringBuffer sb = null;
        StringBuffer filePath = new StringBuffer();
        List<R01MSearchResultItemPublicationInfo> pubInfo = item.getDocumentPublicationInfo();
        if (pubInfo != null) {
            R01MSearchResultItemPublicationInfo currPubInfo2 = null;
            for (R01MSearchResultItemPublicationInfo currPubInfo2 : pubInfo) {
                if (StringUtils.isEmptyString((String)currPubInfo2.getRepositoryOid())) continue;
                filePath.append('/');
                filePath.append(currPubInfo2.getRepositoryAlias());
                filePath.append('/');
                filePath.append(item.getContentTypology().getTypeOid());
                filePath.append('/');
                filePath.append(item.getContentName());
                filePath.append('/');
                filePath.append(item.getDocumentLanguage());
                filePath.append('_');
                filePath.append(item.getDocumentInternalName());
                filePath.append('/');
                filePath.append(generatedFileName);
                break;
            }
        } else {
            String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
            filePath.append("/");
            filePath.append(contentAlias);
            filePath.append('/');
            filePath.append(item.getContentTypology().getTypeOid());
            filePath.append('/');
            filePath.append(item.getContentName());
            filePath.append('/');
            filePath.append(item.getDocumentLanguage());
            filePath.append('_');
            filePath.append(item.getDocumentInternalName());
            filePath.append('/');
            filePath.append(generatedFileName);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)filePath)) {
            sb = new StringBuffer(128);
            sb.append("<!--#include virtual=\"");
            sb.append(filePath);
            sb.append("\"-->");
        }
        return sb;
    }

    private static final String _obtainGeneratedFileName(R01MSearchResultItem item, String thumbNailType) {
        String outGeneratedFile = null;
        if (item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths() != null) {
            outGeneratedFile = (String)item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths().get(thumbNailType);
        }
        return outGeneratedFile;
    }

    private static String _obtainThumbNailType(R01MSearchResultsFormatterPreferences prefs) {
        String thumbNailType;
        String string = thumbNailType = prefs != null && prefs.formatterAtributtes != null ? (String)prefs.formatterAtributtes.get("thumbNailType") : null;
        if (thumbNailType == null) {
            thumbNailType = "miniatura-1";
        } else {
            thumbNailType = thumbNailType.trim();
            Pattern p = Pattern.compile("miniatura-[0-9]{1,2}");
            Matcher m = p.matcher(thumbNailType);
            if (!m.matches()) {
                thumbNailType = "miniatura-1";
            }
        }
        return thumbNailType;
    }
}

