/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters;

import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.storage.R01MArea;
import com.ejie.r01m.config.objects.storage.R01MDataRepository;
import com.ejie.r01m.config.objects.storage.R01MServer;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.config.objects.typology.R01MBaseTypologyObject;
import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.config.objects.typology.R01MContentTypeMetaData;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.cachedmanagers.R01MCachedCatalogLabelsManager;
import com.ejie.r01m.utils.cachedmanagers.R01MCachedMetaDataManager;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MSearchResultDecoratorDirectiveListener
implements DirectiveListener {
    private static final transient String METADATAREGEX = "^\\$\\[r01MetaData\\(([^.]+)\\.([^.]+)\\.([^.]+)\\.([^=]+)=(.*)\\)\\]\\$$";
    private static final transient String METADATANAMEREGEX = "^\\$\\[r01MetaDataName\\(([^.]+)\\.([^.]+)\\.([^.]+)\\.([^=]+)=(.*)\\)\\]\\$$";
    private static final transient String TYPOREGEX = "^\\$\\[r01Typo\\(([^)]+)\\)\\]\\$$";
    private static final transient String STORAGEREGEX = "\\$\\[r01Storage\\(([^,]+),([^,]+),([^,]+),([^,]+)\\)\\]\\$$";
    private static final transient String STRUCTURELABELREGEX = "^\\$\\[r01StructureLabel\\(([^,]*),([^,]+),([^,]*)\\)\\]\\$$";
    private String _lang = R01MConstants.DEFAULT_LANG;
    private String _serviceBaseURL = null;
    private boolean _debug = false;
    private String _moreParameters = null;
    private String _qryURLEncoded = null;
    private String _guideDefOid = null;
    private String _currGuideNodePath = null;

    public R01MSearchResultDecoratorDirectiveListener() {
    }

    public R01MSearchResultDecoratorDirectiveListener(String newLang, String newSearchServiceBaseURL, boolean newDebug, String newQryURLEncoded, String newGuideDefOid, String newCurrGuideNodePath) {
        this._lang = newLang == null ? R01MConstants.DEFAULT_LANG : newLang;
        this._serviceBaseURL = newSearchServiceBaseURL == null ? "[error]" : newSearchServiceBaseURL;
        this._debug = newDebug;
        this._qryURLEncoded = newQryURLEncoded;
        this._guideDefOid = newGuideDefOid;
        this._currGuideNodePath = newCurrGuideNodePath;
    }

    public R01MSearchResultDecoratorDirectiveListener(String newLang, String newSearchServiceBaseURL, String newMoreParameters, String newQryURLEncoded, String newGuideDefOid, String newCurrGuideNodePath) {
        this._lang = newLang == null ? R01MConstants.DEFAULT_LANG : newLang;
        this._serviceBaseURL = newSearchServiceBaseURL == null ? "[error]" : newSearchServiceBaseURL;
        this._moreParameters = newMoreParameters;
        this._qryURLEncoded = newQryURLEncoded;
        this._guideDefOid = newGuideDefOid;
        this._currGuideNodePath = newCurrGuideNodePath;
    }

    public char[] processDirective(String directiveText, long index) throws IOException {
        String outText = "";
        try {
            boolean directiveValid;
            block72: {
                String patternStr = null;
                Pattern p = null;
                Matcher m = null;
                directiveValid = false;
                if (directiveText.startsWith("$[r01SearchServiceURL")) {
                    directiveValid = true;
                    outText = this._serviceBaseURL;
                } else if (directiveText.startsWith("$[r01DebugParam")) {
                    directiveValid = true;
                    outText = this._debug ? "r01kDebug=true&" : "";
                } else if (directiveText.startsWith("$[r01CommonParams")) {
                    directiveValid = true;
                    outText = !StringUtils.isEmptyString((String)this._moreParameters) ? this._moreParameters : "";
                } else if (directiveText.startsWith("$[r01SearchSessionContext")) {
                    directiveValid = true;
                    StringBuffer sb = new StringBuffer("");
                    if (this._lang != null) {
                        sb.append("r01kLang=").append(this._lang);
                    }
                    if (this._qryURLEncoded != null) {
                        sb.append("&r01kQry=").append(this._qryURLEncoded);
                    }
                    if (this._guideDefOid != null) {
                        sb.append("&r01kGuide=").append(this._guideDefOid);
                    }
                    if (this._currGuideNodePath != null) {
                        sb.append("&r01kCurrGuideEl=").append(this._currGuideNodePath);
                    }
                    outText = sb.toString();
                    outText = StringEscapeUtils.escapeHtml((String)outText);
                } else if (directiveText.startsWith("$[r01MetaData(")) {
                    patternStr = METADATAREGEX;
                    p = Pattern.compile(patternStr);
                    m = p.matcher(directiveText);
                    directiveValid = m.find();
                    if (directiveValid) {
                        String clusterOid = m.group(1);
                        String familyOid = m.group(2);
                        String typeOid = m.group(3);
                        String metaDataOid = m.group(4);
                        String metaDataValue = m.group(5);
                        if ("null".equals(clusterOid)) {
                            clusterOid = null;
                        }
                        if ("null".equals(familyOid)) {
                            familyOid = null;
                        }
                        if ("null".equals(typeOid)) {
                            typeOid = null;
                        }
                        if (metaDataValue.charAt(0) == '(') {
                            String[] values = metaDataValue.substring(1, metaDataValue.length() - 1).split(",");
                            StringBuffer outTextBuffer = new StringBuffer("(");
                            for (int i = 0; i < values.length; ++i) {
                                outTextBuffer.append(R01MCachedMetaDataManager.getMetaDataValueDescription(this._lang, clusterOid, familyOid, typeOid, metaDataOid, values[i]));
                                if (i >= values.length - 1) continue;
                                outTextBuffer.append(',');
                            }
                            outTextBuffer.append(')');
                            outText = outTextBuffer.toString();
                        } else {
                            outText = R01MCachedMetaDataManager.getMetaDataValueDescription(this._lang, clusterOid, familyOid, typeOid, metaDataOid, metaDataValue);
                        }
                        if (outText == null || outText.length() == 0) {
                            R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. No se ha encontrado la descripcion del " + metaDataOid + "=" + metaDataValue + " del cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typeOid);
                            outText = "<!--[ERROR]: No se ha encontrado la descripcion del " + metaDataOid + "=" + metaDataValue + " del cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typeOid + "-->";
                        }
                    }
                } else if (directiveText.startsWith("$[r01MetaDataName(")) {
                    patternStr = METADATANAMEREGEX;
                    p = Pattern.compile(patternStr);
                    m = p.matcher(directiveText);
                    directiveValid = m.find();
                    if (directiveValid) {
                        String clusterOid = m.group(1);
                        String familyOid = m.group(2);
                        String typeOid = m.group(3);
                        String metaDataOid = m.group(4);
                        String metaDataValue = m.group(5);
                        if ("null".equals(clusterOid)) {
                            clusterOid = null;
                        }
                        if ("null".equals(familyOid)) {
                            familyOid = null;
                        }
                        if ("null".equals(typeOid)) {
                            typeOid = null;
                        }
                        try {
                            R01MContentTypeMetaData mdCfg = R01MClientFactory.getTypologyConfigAPI().getContentTypeMetaData(clusterOid, familyOid, typeOid, metaDataOid);
                            if (mdCfg != null && StringUtils.isEmptyString((String)(outText = mdCfg.getName(this._lang)))) {
                                outText = mdCfg.getName("en");
                            }
                            if (outText == null || outText.length() == 0) {
                                R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. No se ha encontrado la descripcion del " + metaDataOid + "=" + metaDataValue + " del cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typeOid);
                                outText = "<!--[ERROR]: No se ha encontrado la descripcion del " + metaDataOid + "=" + metaDataValue + " del cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typeOid + "-->";
                            }
                        }
                        catch (R01MConfigLoadException ex) {
                            R01FLog.to((String)"r01m.search").severe("Error al decorar el resultado de la busqueda. No se ha podido encontrar la descripcion del metadato " + metaDataOid + " > " + ex.getMessage());
                            ex.printStackTrace(System.out);
                            outText = "<!--[ERROR]: No se ha podido encontrar la descripcion del metadato " + metaDataOid + "-->";
                        }
                    }
                } else if (directiveText.startsWith("$[r01Storage(")) {
                    patternStr = STORAGEREGEX;
                    p = Pattern.compile(patternStr);
                    m = p.matcher(directiveText);
                    directiveValid = m.find();
                    if (directiveValid) {
                        String serverOid = m.group(1);
                        String storeOid = m.group(2);
                        String areaOid = m.group(3);
                        String workAreaOid = m.group(4);
                        if (!("null".equals(workAreaOid) || "null".equals(areaOid) || "null".equals(storeOid) || "null".equals(serverOid))) {
                            R01MWorkArea waCfg = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(serverOid, storeOid, areaOid, workAreaOid);
                            if (waCfg != null) {
                                outText = waCfg.getName(this._lang);
                            }
                        } else if (!("null".equals(areaOid) || "null".equals(storeOid) || "null".equals(serverOid))) {
                            R01MArea areaCfg = R01MClientFactory.getStorageConfigAPI().getAreaConfig(serverOid, storeOid, areaOid);
                            if (areaCfg != null) {
                                outText = areaCfg.getName(this._lang);
                            }
                        } else if (!"null".equals(storeOid) && !"null".equals(serverOid)) {
                            R01MDataRepository storeCfg = R01MClientFactory.getStorageConfigAPI().getDataRepositoryConfig(serverOid, storeOid);
                            if (storeCfg != null) {
                                outText = storeCfg.getName(this._lang);
                            }
                        } else if (!"null".equals(serverOid)) {
                            R01MServer serverCfg = R01MClientFactory.getStorageConfigAPI().getServerConfig(serverOid);
                            if (serverCfg != null) {
                                outText = serverCfg.getName(this._lang);
                            }
                        } else {
                            R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. No se encuentra el almacenamiento " + directiveText);
                            outText = "<!--[ERROR]: No se encuentra el almacenamiento " + directiveText + "-->";
                        }
                    }
                } else if (directiveText.startsWith("$[r01Typo(")) {
                    String typeInfo;
                    String[] typeInfSplitted;
                    patternStr = TYPOREGEX;
                    p = Pattern.compile(patternStr);
                    m = p.matcher(directiveText);
                    directiveValid = m.find();
                    if (directiveValid && (typeInfSplitted = (typeInfo = m.group(1)).split(",")).length == 3) {
                        R01MContentCluster clusterCfg = null;
                        R01MContentFamily familyCfg = null;
                        R01MBaseTypologyObject typeCfg = null;
                        try {
                            clusterCfg = !typeInfSplitted[0].equals("null") ? R01MClientFactory.getTypologyConfigAPI().getClusterConfig(typeInfSplitted[0]) : null;
                            familyCfg = !typeInfSplitted[1].equals("null") ? R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(null, typeInfSplitted[1]) : null;
                            typeCfg = !typeInfSplitted[2].equals("null") ? R01MClientFactory.getTypologyConfigAPI().getTypeConfig(null, null, typeInfSplitted[2]) : null;
                        }
                        catch (R01MConfigLoadException e) {
                            R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. No se encuentra el tipo de contenido (" + typeInfo + ")");
                        }
                        if (typeCfg != null) {
                            outText = typeCfg.getPublicName(this._lang);
                        } else if (familyCfg != null) {
                            outText = familyCfg.getPublicName(this._lang);
                        } else if (clusterCfg != null) {
                            outText = clusterCfg.getPublicName(this._lang);
                        } else {
                            R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. No se encuentra el tipo de contenido (" + typeInfo + ")");
                            outText = "<!--[ERROR]: No se encuentra el tipo de contenido (" + typeInfo + ")-->";
                        }
                    }
                } else if (directiveText.startsWith("$[r01StructureLabel(")) {
                    patternStr = STRUCTURELABELREGEX;
                    p = Pattern.compile(patternStr);
                    m = p.matcher(directiveText);
                    directiveValid = m.find();
                    if (directiveValid) {
                        String structureOid = m.group(1);
                        String labelOid = m.group(2);
                        String role = m.group(3);
                        try {
                            R01MLabel label = R01MCachedCatalogLabelsManager.getLabel(labelOid);
                            if (label == null) {
                                R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. No se encuentra la etiqueta (" + structureOid + "," + labelOid + "," + role + ")");
                                break block72;
                            }
                            R01MTerm term = label.getStandardizedTerm(this._lang);
                            if (term != null) {
                                outText = term.getValue();
                                if (StringUtils.isEmptyString((String)outText) && (term = label.getStandardizedTerm("en")) != null) {
                                    outText = term.getValue();
                                }
                                break block72;
                            }
                            R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. No se ha encontrado la descripcion en " + this._lang + " (t\u00e9rmino estandar) para  la etiqueta de catalogacion " + label.getOid());
                        }
                        catch (R01MCatalogException catEx) {
                            R01FLog.to((String)"r01m.search").warning("Error al acceder al API de catalogaci\u00f3n: " + catEx.getMessage());
                            outText = "<!--[ERROR]: API de catalogacion " + catEx.getDetailedMessage() + "-->";
                        }
                    }
                } else if (directiveText.startsWith("$[r01GeoLabel(")) {
                    R01FLog.to((String)"r01m.search").severe("NO se ha implementado completamente la catalogaci\u00f3n geogr\u00e1fica");
                }
            }
            if (!directiveValid) {
                R01FLog.to((String)"r01m.search").warning("Error al decorar el resultado de la busqueda. La directiva " + directiveText + " NO es valida!!!");
                outText = "<!--[ERROR]: La directiva " + directiveText + " NO es valida!!!-->";
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            R01FLog.to((String)"r01m.search").severe("Error al decorar el resultado de la busqueda. No se ha podido acceder a la configuracion: " + cfgLoadEx.getMessage());
            cfgLoadEx.printStackTrace(System.out);
            outText = "<!-- [ERROR]: " + cfgLoadEx.getDetailedMessage() + "-->";
        }
        catch (Throwable th) {
            R01FLog.to((String)"r01m.search").severe("Error al decorar el resultado de la busqueda: " + th.getMessage());
            th.printStackTrace(System.out);
            outText = "<!-- [ERROR]: " + th.getMessage() + "-->";
        }
        if (outText != null) {
            return outText.toCharArray();
        }
        return "".toCharArray();
    }
}

