/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters;

import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;

public abstract class R01MSearchFormatterURLHelpper {
    public static String BASE_URL = R01MSearchFormatterDirectiveUtils.composeSearchEngineServiceDirective();
    public static String DEBUG_PARAM = R01MSearchFormatterDirectiveUtils.composeDebugDirective();
    public static String COMMONS_PARAMS = R01MSearchFormatterDirectiveUtils.composeCommonParamsDirective();
    public static String SESSION_CONTEXT_URLPARAM_DIRECTIVE = R01MSearchFormatterDirectiveUtils.composeSearchSessionContextDirective();

    public static final String composeNavBarItemBaseURL(String sourceOid, int targetPageNum) {
        String outURL = BASE_URL + "?" + COMMONS_PARAMS + "r01kSrchSrcId" + "=" + sourceOid + "&" + "r01kTgtPg" + "=" + targetPageNum + "&" + SESSION_CONTEXT_URLPARAM_DIRECTIVE + "&";
        return outURL;
    }

    public static final String composeFirstPageURL(String sourceOid, int currPageNum) {
        return R01MSearchFormatterURLHelpper.composeNavBarItemBaseURL(sourceOid, currPageNum) + "r01kPgCmd" + "=" + "first";
    }

    public static final String composePrevBlockURL(String sourceOid, int currPageNum) {
        return R01MSearchFormatterURLHelpper.composeNavBarItemBaseURL(sourceOid, currPageNum) + "r01kPgCmd" + "=" + "prevBlock";
    }

    public static final String composePrevPageURL(String sourceOid, int currPageNum) {
        return R01MSearchFormatterURLHelpper.composeNavBarItemBaseURL(sourceOid, currPageNum) + "r01kPgCmd" + "=" + "prev";
    }

    public static final String composePageURL(String sourceOid, int currPageNum) {
        return R01MSearchFormatterURLHelpper.composeNavBarItemBaseURL(sourceOid, currPageNum) + "r01kPgCmd" + "=" + currPageNum;
    }

    public static final String composeNextPageURL(String sourceOid, int currPageNum) {
        return R01MSearchFormatterURLHelpper.composeNavBarItemBaseURL(sourceOid, currPageNum) + "r01kPgCmd" + "=" + "next";
    }

    public static final String composeNextBlockURL(String sourceOid, int currPageNum) {
        return R01MSearchFormatterURLHelpper.composeNavBarItemBaseURL(sourceOid, currPageNum) + "r01kPgCmd" + "=" + "nextBlock";
    }

    public static final String composeLastPageURL(String sourceOid, int currPageNum) {
        return R01MSearchFormatterURLHelpper.composeNavBarItemBaseURL(sourceOid, currPageNum) + "r01kPgCmd" + "=" + "last";
    }

    public static final String composeGuideItemBaseURL(String guideElementPath) {
        String outURL = BASE_URL + "?" + COMMONS_PARAMS + "r01kTgtGuideEl" + "=" + guideElementPath + "&" + SESSION_CONTEXT_URLPARAM_DIRECTIVE + "&";
        return outURL;
    }

    public static final String composeFutureGuideElementURL(String guideElementPath) {
        return R01MSearchFormatterURLHelpper.composeGuideItemBaseURL(guideElementPath) + "r01kGuideCmd" + "=" + "follow";
    }

    public static final String composePastGuideElementURL(String guideElementPath) {
        return R01MSearchFormatterURLHelpper.composeGuideItemBaseURL(guideElementPath) + "r01kGuideCmd" + "=" + "rewind";
    }

    public static final String composeResetGuideElementURL() {
        String outURL = BASE_URL + "?" + COMMONS_PARAMS + "r01kGuideCmd" + "=" + "reset" + "&" + SESSION_CONTEXT_URLPARAM_DIRECTIVE + "&";
        return outURL;
    }
}

