/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters;

public class R01MSearchFormatterDirectiveUtils {
    public static final transient String DIRECTIVE_SERVICE = "r01SearchServiceURL";
    public static final transient String DIRECTIVE_DEBUG = "r01DebugParam";
    public static final transient String DIRECTIVE_COMMON_PARAMS = "r01CommonParams";
    public static final transient String DIRECTIVE_SEARCHSESSION_CONTEXT = "r01SearchSessionContext";
    public static final transient String DIRECTIVE_STORAGE = "r01Storage";
    public static final transient String DIRECTIVE_TYPO = "r01Typo";
    public static final transient String DIRECTIVE_METADATA = "r01MetaData";
    public static final transient String DIRECTIVE_METADATANAME = "r01MetaDataName";
    public static final transient String DIRECTIVE_STRUCTURE_LABEL = "r01StructureLabel";
    public static final transient String DIRECTIVE_GEO_LABEL = "r01GeoLabel";
    public static final transient String DIRECTIVE_GUIDE_ELEMENT = "r01Guide";
    public static final transient String DIRECTIVE_START = "$[";
    public static final transient String DIRECTIVE_END = "]$";

    public static final String composeSearchEngineServiceDirective() {
        return "$[r01SearchServiceURL]$";
    }

    public static final String composeDebugDirective() {
        return "$[r01DebugParam]$";
    }

    public static final String composeCommonParamsDirective() {
        return "$[r01CommonParams]$";
    }

    public static final String composeSearchSessionContextDirective() {
        return "$[r01SearchSessionContext]$";
    }

    public static final String composeStructureLabelDirective(String structureOid, String labelOid, String roleOid) {
        StringBuffer sb = new StringBuffer();
        sb.append("$[r01StructureLabel(");
        sb.append(structureOid);
        sb.append(',');
        sb.append(labelOid);
        sb.append(',');
        sb.append(roleOid);
        sb.append(")]$");
        return sb.toString();
    }

    public static final String composeMetaDataDirective(String clusterOid, String familyOid, String typeOid, String metaDataOid, String metaDataValue) {
        StringBuffer sb = new StringBuffer();
        sb.append("$[r01MetaData(");
        sb.append(clusterOid);
        sb.append('.');
        sb.append(familyOid);
        sb.append('.');
        sb.append(typeOid);
        sb.append('.');
        sb.append(metaDataOid);
        sb.append('=');
        sb.append(metaDataValue);
        sb.append(")]$");
        return sb.toString();
    }

    public static final String composeMetaDataNameDirective(String clusterOid, String familyOid, String typeOid, String metaDataOid, String metaDataValue) {
        StringBuffer sb = new StringBuffer();
        sb.append("$[r01MetaDataName(");
        sb.append(clusterOid);
        sb.append('.');
        sb.append(familyOid);
        sb.append('.');
        sb.append(typeOid);
        sb.append('.');
        sb.append(metaDataOid);
        sb.append('=');
        sb.append(metaDataValue);
        sb.append(")]$");
        return sb.toString();
    }

    public static final String composeStorageDirective(String serverOid, String dataStoreOid, String areaOid, String workAreaOid) {
        StringBuffer sb = new StringBuffer();
        sb.append("$[r01Storage(");
        sb.append(serverOid);
        sb.append(',');
        sb.append(dataStoreOid);
        sb.append(',');
        sb.append(areaOid);
        sb.append(',');
        sb.append(workAreaOid);
        sb.append(")]$");
        return sb.toString();
    }

    public static final String composeTypoDirective(String clusterOid, String familyOid, String typeOid) {
        StringBuffer sb = new StringBuffer();
        sb.append("$[r01Typo(");
        sb.append(clusterOid);
        sb.append(',');
        sb.append(familyOid);
        sb.append(',');
        sb.append(typeOid);
        sb.append(")]$");
        return sb.toString();
    }

    public static final String composeGuideDirective(String nodeInGuidePath) {
        StringBuffer sb = new StringBuffer();
        sb.append("$[r01Guide(");
        sb.append(nodeInGuidePath);
        sb.append(")]$");
        return sb.toString();
    }
}

