/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.session;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.guids.GUIDDispenserManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.Pager;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.searchengine.R01MSearchEngineConfig;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDefBranch;
import com.ejie.r01m.config.objects.typology.R01MBaseTypologyObject;
import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.config.objects.typology.R01MOrderByMetaData;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchIllegalPaginationException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideNode;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedGuideConditionDetails;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;
import com.ejie.r01m.objects.searchengine.results.R01MSearchNavBar;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceInitResult;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResume;
import com.ejie.r01m.objects.searchengine.results.R01MSessionSearchInitResult;
import com.ejie.r01m.objects.searchengine.session.R01MSearchOrchestatorAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MTypologyConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang.ArrayUtils;

public class R01MSearchSession
implements Serializable {
    private static final long serialVersionUID = -3559593268518671473L;
    private static final String PAGE_SIZE = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"presentationProperties/pageSize");
    private static final String NAVBAR_BLOCK_SIZE = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"presentationProperties/navBarBlockSize");
    private static final String LOG_TYPE_ID = "r01m.searchEngine";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.searchEngine").intValue() != Level.OFF.intValue();
    private static transient R01MSearchOrchestatorAPI ORCHESTATOR_API = new R01MSearchOrchestatorAPI();
    private String context = null;
    private String searchEngineId = null;
    private String sessionOid = null;
    private String sessionLang = R01MConstants.DEFAULT_LANG;
    private R01MQueryObject query = null;
    private R01MQueryObject effectiveQuery = null;
    private R01MSearchGuide searchGuide = null;
    private boolean lazyGuide = false;
    private boolean lazyInit = false;
    private R01MSessionSearchInitResult searchSessionInitResult = null;
    private boolean initialized = false;
    private boolean cacheResults = true;
    private R01MSearchSessionResults cachedSearchResults;
    public static final String GENERATED_SEARCHBOX_ID = "searchBox";
    public static final String GENERATED_QUERY_ID = "query";
    public static final String GENERATED_HEADER_ID = "header";
    public static final String GENERATED_RSSLINK_ID = "rssLink";
    public static final String GENERATED_GUIDE_ID = "guide";
    public static final String GENERATED_RESULTS_ID = "results";
    private static final int GENERATED_CODE_CACHE_SIZE = 6;
    private Map cachedFormatedCode = new HashMap(6);

    public R01MSearchSession() throws R01MSearchInitializeException {
    }

    public R01MSearchSession(String newSessionLang, String newQryXML, boolean newLazyInit, boolean newCacheResults) throws R01MSearchInitializeException {
        this();
        try {
            R01MQueryObject newQry = (R01MQueryObject)XOManager.getObject((String)R01MConstants.QUERY_RESULTS_MAPFILE, (String)newQryXML);
            this._initInstance(null, null, null, newSessionLang, newQry, null, newLazyInit, false, newCacheResults);
            this.initSession();
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchInitializeException("Error al convertir el XML de b\u00fasqueda a objetos: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
    }

    public R01MSearchSession(String newSessionLang, R01MQueryObject newQry, boolean newLazyInit, boolean newCacheResults) throws R01MSearchInitializeException {
        this(null, null, null, newSessionLang, newQry, null, newLazyInit, false, newCacheResults);
    }

    public R01MSearchSession(String newSessionLang, R01MQueryObject newQry, R01MSearchGuide newGuide, boolean newLazyInit, boolean newLazyGuide, boolean newCacheResults) throws R01MSearchInitializeException {
        this(null, null, null, newSessionLang, newQry, newGuide, newLazyInit, newLazyGuide, newCacheResults);
    }

    public R01MSearchSession(String newContext, String newSearchEngineId, String newSessionOid, String newSessionLang, R01MQueryObject newQry, R01MSearchGuide newGuide, boolean newLazyInit, boolean newLazyGuide, boolean newCacheResults) throws R01MSearchInitializeException {
        this();
        this._initInstance(newContext, newSearchEngineId, newSessionOid, newSessionLang, newQry, newGuide, newLazyInit, newLazyGuide, newCacheResults);
        this.initSession();
    }

    private void _initInstance(String newContext, String newSearchEngineId, String newSessionOid, String newSessionLang, R01MQueryObject newQry, R01MSearchGuide newGuide, boolean newLazyInit, boolean newLazyGuide, boolean newCacheResults) throws R01MSearchInitializeException {
        try {
            this.sessionOid = newSessionOid == null ? GUIDDispenserManager.createDispenser().getGUID() : newSessionOid;
        }
        catch (GUIDDispenserException guidDispEx) {
            throw new R01MSearchInitializeException("No se ha podido obtener un guid para la sessi\u00f3n de b\u00fasqueda: " + guidDispEx.getMessage(), (Exception)((Object)guidDispEx));
        }
        this.sessionLang = newSessionLang != null ? newSessionLang : R01MConstants.DEFAULT_LANG;
        this.searchEngineId = newSearchEngineId;
        this.searchGuide = newGuide;
        this.lazyInit = newLazyInit;
        this.lazyGuide = newLazyGuide;
        this.cacheResults = newCacheResults;
        this.setContext(newContext);
        this.setQuery(newQry);
        this.effectiveQuery = null;
        newQry.validate();
    }

    public void initSession() throws R01MSearchInitializeException {
        if (this.query == null) {
            throw new R01MSearchInitializeException("La query de b\u00fasqueda es nula!!!");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\noooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo\r\noooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo\r\n:::::Nueva sesi\u00f3n de b\u00fasqueda... Inicializando!!!");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Inicializaci\u00f3n lazy? : " + this.lazyInit + "\r\nCache Results?       : " + this.cacheResults);
        }
        this._reduceQuerySearchedTypo(this.query);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}-PASO 1: Componer la query efectiva -------------------------------------------------------------------------");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("...query de b\u00fasqueda ANTES de a\u00f1adir las condiciones procedentes de las gu\u00edas de navegaci\u00f3n:\r\n" + this.query.composeDebugInfo());
        }
        this.effectiveQuery = this._composeEffectiveQuery(this.searchEngineId, this.sessionLang, this.query, this.searchGuide);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}-PASO 2: Llamar al coordinador para inicializar -------------------------------------------------------------------------");
        }
        R01MSearchGuideElement[] futureGuideElements = null;
        if (!this.lazyGuide && this.searchGuide != null) {
            futureGuideElements = this.searchGuide.getCurrentNodeFutureElementsArray();
        }
        this.searchSessionInitResult = ORCHESTATOR_API.initSession(this.searchEngineId, this.context, this.sessionOid, this.sessionLang, this.effectiveQuery, futureGuideElements, this.lazyInit);
        if ((this.searchSessionInitResult == null || this.searchSessionInitResult.getSourcesInitResults().isEmpty()) && DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Ning\u00fan origen de resultados ha respondido a la fase de inicializaci\u00f3n. O no se han devuelto resultados!");
        }
        if (this.searchGuide != null && this.searchGuide.getCurrentNodeFutureElementsArray() != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}-PASO 3: Todos los or\u00edgenes de resultados est\u00e1n inicializados!!!! -------------------------------------------\r\nObtener resultados agregados para la gu\u00eda de navegaci\u00f3n (sumar resultados de cada origen) ----------");
            }
            this.searchGuide.resetFutureNodesState();
            R01MSearchSourceInitResult currSrcInitResult2 = null;
            if (this.searchSessionInitResult != null) {
                for (R01MSearchSourceInitResult currSrcInitResult2 : this.searchSessionInitResult.getSourcesInitResults().values()) {
                    R01MSearchGuideElement[] currSrcGuideFutureEls = currSrcInitResult2.getGuideFutureElements();
                    if (currSrcGuideFutureEls == null) continue;
                    for (int i = 0; i < currSrcGuideFutureEls.length; ++i) {
                        if (currSrcGuideFutureEls[i] == null || currSrcGuideFutureEls[i].getNumberOfResults() <= 0) continue;
                        R01MSearchGuideNode theNod = this.searchGuide.getNextLevelNode(currSrcGuideFutureEls[i].getPathInGuide());
                        if (theNod != null) {
                            theNod.addNodeElementState(currSrcGuideFutureEls[i].getNumberOfResults(), currSrcGuideFutureEls[i].isHighLight());
                            continue;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).warning("Hay un origen que ha devuelto un elemento de guia (" + currSrcGuideFutureEls[i].getPathInGuide() + ") que no est\u00e1 en la gu\u00eda global... se ignora!");
                    }
                }
            }
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}-PASO 3: NO SE UTILIZA GUIA DE NAVEGACI\u00d3N (no se aplica) ----------------------------------------------------");
        }
        this.initialized = true;
        this.cachedSearchResults = null;
        try {
            this._getSearchResults();
        }
        catch (R01MSearchPerformerException spEx) {
            throw new R01MSearchInitializeException((Exception)((Object)spEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info(":::::Sesion de b\u00fasqueda INICIALIZADA!!!!!\r\noooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo\r\noooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo\r\n\r\n\r\n");
        }
    }

    public R01MSearchSessionResults getSearchResults() throws IllegalStateException, R01MSearchPerformerException {
        if (this.cacheResults && this.cachedSearchResults != null) {
            return this.cachedSearchResults;
        }
        return this._getSearchResults();
    }

    private R01MSearchSessionResults _getSearchResults() throws IllegalStateException, R01MSearchPerformerException {
        R01MSearchSessionResults outSearchResults;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Obtener los resultados de todos los or\u00edgenes [" + (this.cacheResults ? "cacheando" : "sin cachear") + " resultados]");
        }
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a getSearchResults() SIN haber llamado a initSession() previamente!");
        }
        R01MSearchSessionResults r01MSearchSessionResults = this.cacheResults && this.cachedSearchResults != null ? this.cachedSearchResults : (outSearchResults = new R01MSearchSessionResults(this.sessionOid, this.sessionLang, -1, this.effectiveQuery, this.searchGuide != null ? this.searchGuide.getCurrentNodePastElementsArray() : null, this.searchGuide != null ? this.searchGuide.getCurrentNodeFutureElementsArray() : null));
        if (this.cachedSearchResults == null) {
            this.cachedSearchResults = outSearchResults;
        }
        if (this.searchSessionInitResult != null && !this.searchSessionInitResult.getSourcesInitResults().isEmpty()) {
            outSearchResults.totalNumberOfResults = 0;
            outSearchResults.searchResultsBySource = new HashMap(this.searchSessionInitResult.getSourcesInitResults().size());
            R01MSearchSourceInitResult currSrcInitResult2 = null;
            for (R01MSearchSourceInitResult currSrcInitResult2 : this.searchSessionInitResult.getSourcesInitResults().values()) {
                R01MSearchSourceResults currSrcSearchResults = null;
                currSrcSearchResults = this._performSearch(currSrcInitResult2.getSourceOid(), currSrcInitResult2.getPager().getCurrentPageElementNumber(), currSrcInitResult2.getPager().getCurrentPageFirstElement(), currSrcInitResult2.getPager().getCurrentPageLastElement());
                if (currSrcSearchResults == null) continue;
                outSearchResults.searchResultsBySource.put(currSrcInitResult2.getSourceOid(), currSrcSearchResults);
                outSearchResults.totalNumberOfResults += currSrcSearchResults.numberOfResults;
            }
        }
        return outSearchResults;
    }

    public R01MSearchSourceResults getSourceSearchResults(String sourceOid) throws IllegalStateException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a getSourceSearchResults() SIN haber llamado a initSession() previamente!");
        }
        if (sourceOid == null) {
            throw new R01MSearchPerformerException("No se pueden obtener los resultados de un origen con oid null");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Obtener los resultados del origen " + sourceOid);
        }
        if (this.searchSessionInitResult == null || this.searchSessionInitResult.getSourcesInitResults().size() == 0 || this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) == null) {
            throw new R01MSearchPerformerException("El origen " + sourceOid + " NO se ha inicializado correctamente. No se pueden obtener los resultados de b\u00fasqueda!");
        }
        R01MSearchSourceInitResult srcSrchInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid);
        return this._performSearch(sourceOid, srcSrchInitResult.getPager().getCurrentPageElementNumber(), srcSrchInitResult.getPager().getCurrentPageFirstElement(), srcSrchInitResult.getPager().getCurrentPageLastElement());
    }

    public Collection getSearchResultItemsAsCollection(R01MSearchResultItem[] items) {
        if (items == null) {
            return null;
        }
        ArrayList<R01MSearchResultItem> outCol = new ArrayList<R01MSearchResultItem>(items.length);
        for (int i = 0; i < items.length; ++i) {
            outCol.add(items[i]);
        }
        return outCol;
    }

    public R01MSearchResultItem[] getSourceSearchResultItem(String sourceOid) throws IllegalStateException, R01MSearchPerformerException {
        R01MSearchSourceResults srcResults = this.getSourceSearchResults(sourceOid);
        R01MSearchResultItem[] outItems = null;
        if (srcResults != null) {
            outItems = srcResults.getResults();
        }
        return outItems;
    }

    public int getSourceSearchResultItemsCount(String sourceOid) throws IllegalStateException, R01MSearchPerformerException {
        R01MSearchSourceResults srcResults = this.getSourceSearchResults(sourceOid);
        return srcResults != null ? srcResults.getNumberOfResults() : 0;
    }

    public List<R01MSearchResultItem> getTotalPagesAndSourcesSearchResultItems() throws IllegalStateException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        ArrayList<R01MSearchResultItem> totalResults = null;
        R01MSearchResultItem[] initialResults = this.getAllSourcesSearchResultItems();
        if (initialResults != null && initialResults.length > 0) {
            totalResults = new ArrayList<R01MSearchResultItem>();
            totalResults.addAll(Arrays.asList(initialResults));
            String[] sourcesOids = this.getSearchSourcesOids();
            if (sourcesOids != null && sourcesOids.length > 0) {
                for (int s = 0; s < sourcesOids.length; ++s) {
                    Pager pager = this.getPager(sourcesOids[s]);
                    if (pager == null) continue;
                    for (int p = pager.getCurrentPageElementNumber(); p < pager.getLastPageElementNumber(); ++p) {
                        R01MSearchResultItem[] tmpResults = this.goToNextPage(sourcesOids[s]).getResults();
                        if (tmpResults == null || tmpResults.length <= 0) continue;
                        totalResults.addAll(Arrays.asList(tmpResults));
                    }
                }
            } else {
                return null;
            }
        }
        return totalResults;
    }

    public R01MSearchResultItem[] getAllSourcesSearchResultItems() throws IllegalStateException, R01MSearchPerformerException {
        ArrayList<R01MSearchResultItem> outSrchItemsList = null;
        R01MSearchSessionResults sessionResults = this.getSearchResults();
        if (sessionResults != null) {
            outSrchItemsList = new ArrayList<R01MSearchResultItem>();
            Map resultsBySource = sessionResults.getSearchResultsBySource();
            if (resultsBySource != null) {
                R01MSearchSourceResults currSrcResults2 = null;
                R01MSearchResultItem[] currSrcItems = null;
                for (R01MSearchSourceResults currSrcResults2 : resultsBySource.values()) {
                    currSrcItems = currSrcResults2.getResults();
                    if (currSrcItems == null) continue;
                    for (int i = 0; i < currSrcItems.length; ++i) {
                        outSrchItemsList.add(currSrcItems[i]);
                    }
                }
            }
        }
        if (outSrchItemsList != null) {
            return outSrchItemsList.toArray(new R01MSearchResultItem[outSrchItemsList.size()]);
        }
        return null;
    }

    public long getAllSourcesSearchResultItemsCount() throws IllegalStateException, R01MSearchPerformerException {
        Map resultsBySource;
        int totalNumberOfResults = 0;
        R01MSearchSessionResults sessionResults = this.getSearchResults();
        if (sessionResults != null && (resultsBySource = sessionResults.getSearchResultsBySource()) != null) {
            R01MSearchSourceResults currSrcResults2 = null;
            for (R01MSearchSourceResults currSrcResults2 : resultsBySource.values()) {
                totalNumberOfResults += currSrcResults2.getNumberOfResults();
            }
        }
        return totalNumberOfResults;
    }

    public String[] getSearchSourcesOids() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a getSearchSourcesOids() SIN haber llamado a getSearchResults() / initSession() previamente!");
        }
        String[] outSrcsOids = null;
        if (this.searchSessionInitResult != null) {
            outSrcsOids = this.searchSessionInitResult.sourcesInitResults.keySet().toArray(new String[this.searchSessionInitResult.sourcesInitResults.size()]);
        }
        return outSrcsOids;
    }

    public R01MSearchSourceResults goToFirstPage(String sourceOid) throws IllegalStateException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToFirstPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Primera p\u00e1gina de resultados para el origen " + sourceOid);
            }
            R01MSearchSourceInitResult srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid);
            srcInitResult.getPager().goToFirstPage();
            return this._performSearch(sourceOid, srcInitResult.getPager().getCurrentPageElementNumber(), srcInitResult.getPager().getCurrentPageFirstElement(), srcInitResult.getPager().getCurrentPageLastElement());
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public R01MSearchSourceResults goToPrevBlockLastPage(String sourceOid) throws IllegalStateException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToPrevBlockLastPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Ultima p\u00e1gina del bloque anterior de resultados para el origen " + sourceOid);
            }
            R01MSearchSourceInitResult srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid);
            srcInitResult.getPager().gotoPrevBlockLastPage();
            return this._performSearch(sourceOid, srcInitResult.getPager().getCurrentPageElementNumber(), srcInitResult.getPager().getCurrentPageFirstElement(), srcInitResult.getPager().getCurrentPageLastElement());
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public R01MSearchSourceResults goToPrevPage(String sourceOid) throws IllegalStateException, R01MSearchIllegalPaginationException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToPrevPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            R01MSearchSourceInitResult srcInitResult;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Anterior p\u00e1gina de resultados para el origen " + sourceOid);
            }
            if ((srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid)).getPager().getCurrentPageElementNumber() == 1) {
                throw new R01MSearchIllegalPaginationException("No hay menos p\u00e1ginas: No se puede ir a la p\u00e1gina anterior de resultados.");
            }
            srcInitResult.getPager().goToPrevPage();
            return this._performSearch(sourceOid, srcInitResult.getPager().getCurrentPageElementNumber(), srcInitResult.getPager().getCurrentPageFirstElement(), srcInitResult.getPager().getCurrentPageLastElement());
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public R01MSearchSourceResults getSearchResultsFromAutonomyQuery(String sourceOid, String autonomyContext, String autonomyQuery, R01MSearchGuide guide, int pageSize, int blockSize) throws IllegalStateException, R01MSearchPerformerException {
        R01MSearchSourceResults outSrcResults = null;
        R01MSearchResultItem[] resultItems = ORCHESTATOR_API.getResultsFromAutonomyQuery(sourceOid, autonomyContext, autonomyQuery);
        if (resultItems != null) {
            R01MSearchEngineConfig searchEngineConfig = null;
            try {
                searchEngineConfig = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig();
            }
            catch (R01MConfigLoadException clEx) {
                throw new R01MSearchPerformerException("Error al cargar la configuraci\u00f3n de los or\u00edgenes de b\u00fasqueda: " + clEx.getMessage());
            }
            Pager pager = new Pager();
            if (blockSize >= 0) {
                pager.setBlockSize(blockSize);
            }
            if (pageSize >= 0) {
                pager.setPageSize(pageSize);
            }
            for (int i = 0; i < resultItems.length; ++i) {
                pager.addPageElement((Object)Integer.toString(i));
            }
            outSrcResults = this._composeSourceSearchResults(sourceOid, (String)searchEngineConfig.getSearchSourceCfg(autonomyContext, sourceOid).getName().get(R01MConstants.DEFAULT_LANG), pager, resultItems);
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("NO se han devuelto resultados de b\u00fasqueda para el origen " + sourceOid);
        }
        return outSrcResults;
    }

    public R01MSearchSourceResults goToNextPageFromAutonomyQuery(String sourceOid) throws IllegalStateException, R01MSearchIllegalPaginationException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToNextPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            R01MSearchSourceInitResult srcInitResult;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Siguiente p\u00e1gina de resultados para el origen " + sourceOid);
            }
            if ((srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid)).getPager().getCurrentPageElementNumber() == srcInitResult.getPager().getPageCount()) {
                throw new R01MSearchIllegalPaginationException("No hay mas p\u00e1ginas: No se puede ir a la siguiente p\u00e1gina de resultados.");
            }
            srcInitResult.getPager().goToNextPage();
            R01MSearchSourceResults outSrcResults = this.cachedSearchResults.getSearchSourceResults(sourceOid);
            R01MSearchSourceResults newOutSrcResults = new R01MSearchSourceResults(sourceOid);
            newOutSrcResults.setNavBar(outSrcResults.getNavBar());
            newOutSrcResults.setNumberOfPages(outSrcResults.getNumberOfPages());
            newOutSrcResults.setNumberOfResultsPerPage(outSrcResults.getNumberOfResultsPerPage());
            newOutSrcResults.setSourceDetails(outSrcResults.getSourceDetails());
            int numberOfResultsPerPage = ((R01MSearchSourceResults)this.cachedSearchResults.getSearchResultsBySource().get(sourceOid)).getNumberOfResultsPerPage();
            R01MSearchResultItem[] newResult = new R01MSearchResultItem[numberOfResultsPerPage];
            int firstElement = (srcInitResult.getPager().getCurrentPageElementNumber() - 1) * srcInitResult.getPager().getPageSize();
            int numberOfElements = this.cachedSearchResults.getTotalNumberOfResults() > firstElement + srcInitResult.getPager().getPageSize() ? srcInitResult.getPager().getPageSize() : this.cachedSearchResults.getTotalNumberOfResults() - firstElement;
            System.arraycopy(outSrcResults.getResults(), firstElement, newResult, 0, numberOfElements);
            newOutSrcResults.setResults(newResult);
            newOutSrcResults.setNumberOfResults(newResult.length);
            return newOutSrcResults;
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public R01MSearchSourceResults goToPage(String sourceOid, int pageNum) throws IllegalStateException, R01MSearchIllegalPaginationException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Ir a p\u00e1gina " + pageNum + " de resultados para el origen " + sourceOid);
            }
            R01MSearchSourceInitResult srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid);
            if (pageNum < 1 || pageNum > srcInitResult.getPager().getPageCount()) {
                throw new R01MSearchIllegalPaginationException("La p\u00e1gina " + pageNum + " NO existe entre los resultados de b\u00fasqueda. Solo hay " + srcInitResult.getPager().getPageCount() + " paginas.");
            }
            srcInitResult.getPager().goToPage(pageNum);
            return this._performSearch(sourceOid, srcInitResult.getPager().getCurrentPageElementNumber(), srcInitResult.getPager().getCurrentPageFirstElement(), srcInitResult.getPager().getCurrentPageLastElement());
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public R01MSearchSourceResults goToNextPage(String sourceOid) throws IllegalStateException, R01MSearchIllegalPaginationException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToNextPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            R01MSearchSourceInitResult srcInitResult;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Siguiente p\u00e1gina de resultados para el origen " + sourceOid);
            }
            if ((srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid)).getPager().getCurrentPageElementNumber() == srcInitResult.getPager().getPageCount()) {
                throw new R01MSearchIllegalPaginationException("No hay mas p\u00e1ginas: No se puede ir a la siguiente p\u00e1gina de resultados.");
            }
            srcInitResult.getPager().goToNextPage();
            return this._performSearch(sourceOid, srcInitResult.getPager().getCurrentPageElementNumber(), srcInitResult.getPager().getCurrentPageFirstElement(), srcInitResult.getPager().getCurrentPageLastElement());
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public R01MSearchSourceResults goToNextBlockFirstPage(String sourceOid) throws IllegalStateException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToNextBlockFirstPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Primera p\u00e1gina del bloque siguiente de resultados para el origen " + sourceOid);
            }
            R01MSearchSourceInitResult srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid);
            srcInitResult.getPager().gotoNextBlockFirstPage();
            return this._performSearch(sourceOid, srcInitResult.getPager().getCurrentPageElementNumber(), srcInitResult.getPager().getCurrentPageFirstElement(), srcInitResult.getPager().getCurrentPageLastElement());
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public R01MSearchSourceResults goToLastPage(String sourceOid) throws IllegalStateException, R01MSearchPerformerException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a goToLastPage(" + sourceOid + ") SIN haber llamado a getSearchResults(" + sourceOid + ") previamente!");
        }
        if (this.searchSessionInitResult != null && this.searchSessionInitResult.getSourcesInitResults().get(sourceOid) != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> \u00daltima p\u00e1gina de resultados para el origen " + sourceOid);
            }
            R01MSearchSourceInitResult srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid);
            srcInitResult.getPager().goToLastPage();
            return this._performSearch(sourceOid, srcInitResult.getPager().getCurrentPageElementNumber(), srcInitResult.getPager().getCurrentPageFirstElement(), srcInitResult.getPager().getCurrentPageLastElement());
        }
        R01FLog.to((String)LOG_TYPE_ID).severe("No se ha creado e inicializado la session para el origen de resultados " + sourceOid);
        return null;
    }

    public void gotoGuideNode(String elementKey) throws R01MSearchInitializeException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Ir a elemento " + elementKey + " de la guia de navegacion (provoca inicializacion de origenes)");
        }
        if (this.searchGuide == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede ir al elemento " + elementKey + " de la guia ya que esta es NULA o no hay elementos posibles!!!");
        } else {
            boolean success = this.searchGuide.gotoNode(elementKey);
            if (success) {
                this.initSession();
            } else {
                R01FLog.to((String)LOG_TYPE_ID).severe("No se puede ir al elemento " + elementKey + " de la guia ya que el elemento NO existe!!!");
            }
        }
    }

    public void followGuide(String futureElementKey) throws R01MSearchInitializeException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Avanzar a elemento " + futureElementKey + " de la guia de navegacion (provoca inicializacion de origenes)");
        }
        if (this.searchGuide == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede avanzar al elemento " + futureElementKey + " de la guia ya que esta es NULA o no hay elementos futuros posibles!!!");
        } else {
            boolean success = this.searchGuide.followGuide(futureElementKey);
            if (success) {
                this.initSession();
            } else {
                R01FLog.to((String)LOG_TYPE_ID).severe("No se puede avanzar al elemento " + futureElementKey + " de la guia ya que el elemento NO existe!!!");
            }
        }
    }

    public void rewindGuide(String elementToRewindKey) throws R01MSearchInitializeException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Rebobinar a elemento " + elementToRewindKey + " de la guia de navegacion (provoca inicializacion de origenes)");
        }
        if (this.searchGuide == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede rebobinar al elemento " + elementToRewindKey + " de la guia de navegaci\u00f3n ya que esta es NULA o no hay elementos pasados posibles!!!");
        } else {
            boolean success = this.searchGuide.rewindGuide(elementToRewindKey);
            if (success) {
                this.initSession();
            } else {
                R01FLog.to((String)LOG_TYPE_ID).severe("No se puede rebobinar al elemento " + elementToRewindKey + " de la guia ya que el elemento NO existe!!!");
            }
        }
    }

    public void resetGuide() throws R01MSearchInitializeException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n{SEARCH_SESSION}>> Resetear la guia de navegaci\u00f3n (provoca inicializaci\u00f3n de or\u00edgenes)");
        }
        if (this.searchGuide == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede resetear la guia de navegaci\u00f3n ya que esta es NULA");
        } else {
            this.searchGuide.setCurrentGuideNode(null);
            this.initSession();
        }
    }

    public String getSearchEngineQuerySentence(String sourceOid, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        return ORCHESTATOR_API.getSearchEngineQuerySentence(this.searchEngineId, this.context, this.sessionOid, this.sessionLang, sourceOid, this.effectiveQuery, pageNum, pageFirstCod, pageLastCod);
    }

    private R01MSearchSourceResults _performSearch(String sourceOid, int pageNum, Object pageFirstElementCod, Object pageLastElementCod) throws R01MSearchPerformerException {
        R01MSearchSourceResults outSrcResults = null;
        R01MSearchSourceInitResult srcInitResult = (R01MSearchSourceInitResult)this.searchSessionInitResult.getSourcesInitResults().get(sourceOid);
        if (this.cacheResults && this.cachedSearchResults != null && this.cachedSearchResults.getSearchSourceResults(sourceOid) != null) {
            R01MSearchSourceResults srcResults = this.cachedSearchResults.getSearchSourceResults(sourceOid);
            if (srcResults.getNavBar() != null) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Origen " + sourceOid + ": Pagina actual: " + srcResults.getNavBar().getCurrentPage() + " - Pagina destino: " + pageNum);
                }
                if (srcResults.getNavBar().getCurrentPage() == pageNum) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Se est\u00e1n solicitando los resultados de la misma p\u00e1gina que la actual en el origen " + sourceOid + " pero YA estaban cacheados as\u00ed que NO se invoca al buscador");
                    }
                    outSrcResults = this.cachedSearchResults.getSearchSourceResults(sourceOid);
                    return outSrcResults;
                }
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Se est\u00e1n solicitando los resultados de una p\u00e1gina DISTINTA de la actual en el origen " + sourceOid + " as\u00ed que NO estaban cacheados: se invoca al buscador");
                }
            } else {
                R01FLog.to((String)LOG_TYPE_ID).warning("El origen " + sourceOid + " NO tiene informaci\u00f3n de paginaci\u00f3n (navBar). Error en la cache de resultados en el objeto R01MSearchSession!!!");
            }
        } else if (pageNum == 1) {
            if (srcInitResult.getFirstPageSearchResults() != null) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Se est\u00e1n solicitando los resultados de la primera p\u00e1gina en el origen " + sourceOid + " pero YA estaban cacheados durante la fase de inicializaci\u00f3n as\u00ed que NO se invoca al buscador");
                }
                R01MSearchResultItem[] resultItems = srcInitResult.getFirstPageSearchResults();
                outSrcResults = this._composeSourceSearchResults(srcInitResult.getSourceOid(), srcInitResult.getSourceDetails().getSourceName(), srcInitResult.getPager(), resultItems);
                if (this.cacheResults && this.cachedSearchResults != null) {
                    this.cachedSearchResults.searchResultsBySource.put(sourceOid, outSrcResults);
                }
                return outSrcResults;
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Se est\u00e1n solicitando los resultados de la primera p\u00e1gina en el origen " + sourceOid + " pero NO estaban cacheados durante la fase de inicializaci\u00f3n as\u00ed que SI se invoca al buscador");
            }
        }
        R01MSearchResultItem[] resultItems = ORCHESTATOR_API.getResults(this.searchEngineId, this.context, this.sessionOid, this.sessionLang, this.effectiveQuery, sourceOid, pageNum, pageFirstElementCod, pageLastElementCod);
        if (resultItems != null) {
            outSrcResults = this._composeSourceSearchResults(srcInitResult.getSourceOid(), srcInitResult.getSourceDetails().getSourceName(), srcInitResult.getPager(), resultItems);
            if (this.cacheResults && this.cachedSearchResults != null) {
                this.cachedSearchResults.setSearchSourceResults(sourceOid, outSrcResults);
            }
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("NO se han devuelto resultados de b\u00fasqueda para el origen " + sourceOid);
        }
        return outSrcResults;
    }

    private R01MSearchSourceResults _composeSourceSearchResults(String sourceOid, String sourceName, Pager pager, R01MSearchResultItem[] results) {
        int i;
        R01MSearchSourceResults outSrcSearchResults = new R01MSearchSourceResults();
        outSrcSearchResults.sourceOid = sourceOid;
        outSrcSearchResults.sourceDetails = new R01MSearchSourceResume();
        outSrcSearchResults.sourceDetails.sourceOid = sourceOid;
        outSrcSearchResults.sourceDetails.sourceName = sourceName;
        outSrcSearchResults.numberOfResults = pager.getElementCount();
        outSrcSearchResults.numberOfResultsPerPage = pager.getPageSize();
        outSrcSearchResults.numberOfPages = pager.getPageCount();
        int[] pages = pager.getCurrentBlockPageNumbers();
        outSrcSearchResults.setNavBar(new R01MSearchNavBar());
        outSrcSearchResults.getNavBar().setNavBarBlockSize(pager.getBlockSize());
        outSrcSearchResults.getNavBar().setTotalNumberOfResults(pager.getElementCount());
        outSrcSearchResults.getNavBar().setTotalNumberOfPages(pager.getPageCount());
        outSrcSearchResults.getNavBar().setCurrentPage(pager.getCurrentPageElementNumber());
        outSrcSearchResults.getNavBar().setCurrentPageFirstElementNumber(pager.getCurrentPageFirstElementNumber());
        outSrcSearchResults.getNavBar().setCurrentPageLastElementNumber(pager.getCurrentPageLastElementNumber());
        if (pager.getCurrentPageElementNumber() > 1) {
            outSrcSearchResults.getNavBar().addItem("firstPage", pager.getFirstPageElementNumber());
            if (pager.getCurrentBlockNumber() > 1) {
                outSrcSearchResults.getNavBar().addItem("previousBlock", pager.getPrevBlockLastElementNumber());
            }
            outSrcSearchResults.getNavBar().addItem("prevPage", pager.getCurrentPagePrevElementNumber());
        }
        for (i = 0; i < pages.length; ++i) {
            outSrcSearchResults.getNavBar().addItem("pageX", pages[i]);
        }
        if (pager.getCurrentPageElementNumber() < pager.getPageCount()) {
            outSrcSearchResults.getNavBar().addItem("nextPage", pager.getCurrentPageNextElementNumber());
            if (pager.getCurrentBlockNumber() < pager.getBlockCount()) {
                outSrcSearchResults.getNavBar().addItem("nextBlock", pager.getNextBlockFirstElementNumber());
            }
            outSrcSearchResults.getNavBar().addItem("lastPage", pager.getLastPageElementNumber());
        }
        if (results != null) {
            i = pager.getCurrentPageFirstElementNumber();
            for (int r = 0; r < results.length; ++r) {
                results[r].setItemNumber(i++);
            }
            outSrcSearchResults.results = (R01MSearchResultItem[])ArrayUtils.clone((Object[])results);
        }
        return outSrcSearchResults;
    }

    private R01MQueryObject _composeEffectiveQuery(String theSearchEngineId, String lang, R01MQueryObject inQry, R01MSearchGuide guide) throws R01MSearchInitializeException {
        Collection defOrderByMetaDataCol;
        R01MQueryObject outQry = (R01MQueryObject)CloneUtils.cloneByReflection((Object)inQry);
        if (outQry.getPresentationProperties() == null || outQry.getPresentationProperty("r01PageSize") == null) {
            outQry.setPresentationProperty("r01PageSize", PAGE_SIZE == null ? "10" : PAGE_SIZE);
        }
        if (outQry.getPresentationProperties() == null || outQry.getPresentationProperty("r01NavBarBlockSize") == null) {
            outQry.setPresentationProperty("r01NavBarBlockSize", NAVBAR_BLOCK_SIZE == null ? "9" : NAVBAR_BLOCK_SIZE);
        }
        if (StringUtils.isEmptyString((String)outQry.getFullText())) {
            outQry.setReturnAttachments(false);
        }
        if (theSearchEngineId != null) {
            outQry.setSearchEngineId(theSearchEngineId);
        }
        if (outQry.getMetaData("documentLanguage") == null && outQry.isSearchByDefaultLang()) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("La query no filtra por idioma... se a\u00f1ade el idioma de la sesi\u00f3n de usuario: " + lang);
            }
            outQry.addMetaData("documentLanguage", "EQ", lang);
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("La query no filtra por idioma ya que no hay metadato lenguaje y no se quiere filtrar por idioma de usuario(isSearchByDefaultLang = false)");
        }
        if (!(outQry.isFullTextSearch() || outQry.getOrderBy() != null && outQry.getOrderBy().size() != 0 || (defOrderByMetaDataCol = R01MSearchSession._obtainOrderByMetaData(outQry)) == null)) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("La query NO incluye criterios de ordenacion y se trata de una query de metaDatos (no de texto libre), asi que se obtienen los metaDatos de ordenacion por defecto de la configuraci\u00f3n de tipologia");
                R01MSearchedOrderByMetaData currODMD2 = null;
                for (R01MSearchedOrderByMetaData currODMD2 : defOrderByMetaDataCol) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t-" + currODMD2.getOid() + " " + currODMD2.getOrder());
                }
            }
            outQry.setOrderBy(new ArrayList(defOrderByMetaDataCol));
        }
        if (guide == null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("...NO se utilizan guias de navegaci\u00f3n... la query no se modifica");
            }
            return outQry;
        }
        if (guide.getCurrentGuideNode() == null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Primer nivel de la guia de navegaci\u00f3n...NO hay condiciones pasadas que imponer!");
            }
            return outQry;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("...componiendo la query a ejecutar, incorporando las condiciones de las gu\u00edas...");
        }
        outQry.setQueryOid(outQry.getQueryOid() + "." + guide.getCurrentGuideNode().getPathInGuide());
        for (R01MSearchGuideNode currGuideNode = guide.getCurrentGuideNode(); currGuideNode != null; currGuideNode = currGuideNode.getParentNode()) {
            R01MSearchSession._addGuideNodeConditionToQuery(outQry, currGuideNode.getNodeElement());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("...query de b\u00fasqueda DESPUES de a\u00f1adir las condiciones procedentes de las gu\u00edas de navegaci\u00f3n:\r\n" + outQry.composeDebugInfo());
        }
        return outQry;
    }

    private static void _addGuideNodeConditionToQuery(R01MQueryObject inOutQry, R01MSearchGuideElement guideNodeElement) throws R01MSearchInitializeException {
        R01MSearchGuideDefBranch guideBranchDef = null;
        try {
            guideBranchDef = R01MClientFactory.getSearchEnginePersistenceAPI().getGuideBranchDef(guideNodeElement.getBranchDefPath());
            if (guideBranchDef == null) {
                throw new R01MSearchInitializeException("_composeEffectiveQuery: La guia est\u00e1 mal formada ya que el elemento NO tiene la definici\u00f3n del branch al que pertenece. Se ignora el nodo!!");
            }
        }
        catch (R01MSearchStorageException ssEx) {
            throw new R01MSearchInitializeException((Exception)((Object)ssEx));
        }
        String elementPath = guideBranchDef.getStartingPath() + "/" + guideNodeElement.getElementPathInBranch();
        String[] elementPathSplitted = elementPath.split("/");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("...condici\u00f3n de la guia en el branch tipo: " + guideBranchDef.getBranchType() + " > path en el branch: " + elementPath);
        }
        if (guideBranchDef.getBranchType().equals("typo")) {
            switch (elementPathSplitted.length - 1) {
                case 0: {
                    inOutQry.setContentClusters(new ArrayList());
                    inOutQry.addContentCluster(elementPathSplitted[0]);
                    inOutQry.getContentCluster(elementPathSplitted[0]).setGuideCondition(new R01MSearchedGuideConditionDetails(guideNodeElement.getGuideOid(), guideNodeElement.getBranchDefPath(), guideNodeElement.getElementPathInBranch()));
                    break;
                }
                case 1: {
                    inOutQry.setContentFamilies(new ArrayList());
                    inOutQry.addContentFamily(elementPathSplitted[1]);
                    inOutQry.getContentFamily(elementPathSplitted[1]).setGuideCondition(new R01MSearchedGuideConditionDetails(guideNodeElement.getGuideOid(), guideNodeElement.getBranchDefPath(), guideNodeElement.getElementPathInBranch()));
                    break;
                }
                case 2: {
                    inOutQry.setContentTypes(new ArrayList());
                    inOutQry.addContentType(elementPathSplitted[2]);
                    inOutQry.getContentType(elementPathSplitted[2]).setGuideCondition(new R01MSearchedGuideConditionDetails(guideNodeElement.getGuideOid(), guideNodeElement.getBranchDefPath(), guideNodeElement.getElementPathInBranch()));
                    break;
                }
                default: {
                    throw new R01MSearchInitializeException("Error en el path de una guia tipol\u00f3gica: " + elementPath + "> Tiene mas elementos que la profundidad de la guia cluster/familia/tipo");
                }
            }
            if (DEBUG) {
                String[] descs = new String[]{"cluster", "familia", "tipo"};
                R01FLog.to((String)LOG_TYPE_ID).info("...condici\u00f3n de guia sobre " + descs[elementPathSplitted.length - 1] + ": " + elementPathSplitted[elementPathSplitted.length - 1]);
            }
        } else if (guideBranchDef.getBranchType().equals("structure")) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("...condici\u00f3n de guia sobre etiqueta de catalogaci\u00f3n: " + elementPathSplitted[elementPathSplitted.length - 1] + " del eje " + guideBranchDef.getStartingPath());
            }
            inOutQry.addANDStructureCatalog(elementPathSplitted[elementPathSplitted.length - 1]);
            inOutQry.getANDStructureCatalog(elementPathSplitted[elementPathSplitted.length - 1]).setGuideCondition(new R01MSearchedGuideConditionDetails(guideNodeElement.getGuideOid(), guideNodeElement.getBranchDefPath(), guideNodeElement.getElementPathInBranch()));
        } else if (guideBranchDef.getBranchType().equals("geoStructure")) {
            throw new R01MSearchInitializeException("El tipo de branch geoStructure NO est\u00e1 soportado de momento...");
        }
    }

    private static Collection _obtainOrderByMetaData(R01MQueryObject qry) {
        LinkedHashMap outOrderByMD = new LinkedHashMap();
        if (qry.getContentTypes() != null && !qry.getContentTypes().isEmpty()) {
            R01MSearchSession._putOrderByMetaDataInMap(outOrderByMD, R01MSearchSession._obtainCommonOrderByMetaData(qry.getContentTypes()));
        } else if (qry.getContentFamilies() != null && !qry.getContentFamilies().isEmpty()) {
            R01MSearchSession._putOrderByMetaDataInMap(outOrderByMD, R01MSearchSession._obtainCommonOrderByMetaData(qry.getContentFamilies()));
        } else if (qry.getContentClusters() != null && !qry.getContentClusters().isEmpty()) {
            R01MSearchSession._putOrderByMetaDataInMap(outOrderByMD, R01MSearchSession._obtainCommonOrderByMetaData(qry.getContentClusters()));
        }
        return !outOrderByMD.isEmpty() ? outOrderByMD.values() : null;
    }

    private static void _putOrderByMetaDataInMap(Map orderByMetaData, List commonOrderByMetaData) {
        if (commonOrderByMetaData == null) {
            return;
        }
        for (R01MOrderByMetaData currOrderByMD : commonOrderByMetaData) {
            if (orderByMetaData.containsKey(currOrderByMD.getMetaDataOid())) continue;
            orderByMetaData.put(currOrderByMD.getMetaDataOid(), new R01MSearchedOrderByMetaData(currOrderByMD.getMetaDataOid(), currOrderByMD.getOrder()));
        }
    }

    private static List _obtainCommonOrderByMetaData(List searchedTypoObjs) {
        Object[] commonOrderByMetaData;
        R01MTypologyConfigAPI typoAPI = R01MClientFactory.getTypologyConfigAPI();
        ArrayList<R01MOrderByMetaData[]> typoObjsDefaultOrderByMetaData = new ArrayList<R01MOrderByMetaData[]>();
        R01MBaseSearchedTypoObj currSearchedTypoObj = null;
        R01MBaseTypologyObject currTypoObj = null;
        Iterator it = searchedTypoObjs.iterator();
        while (it.hasNext()) {
            try {
                currSearchedTypoObj = (R01MBaseSearchedTypoObj)it.next();
                if (currSearchedTypoObj instanceof R01MSearchedCluster) {
                    currTypoObj = typoAPI.getClusterConfig(currSearchedTypoObj.getOid());
                } else if (currSearchedTypoObj instanceof R01MSearchedFamily) {
                    currTypoObj = typoAPI.getFamilyConfig(currSearchedTypoObj.getOid());
                } else if (currSearchedTypoObj instanceof R01MSearchedContentType) {
                    currTypoObj = typoAPI.getTypeConfig(currSearchedTypoObj.getOid());
                }
                if (currTypoObj != null && currTypoObj.getDefaultOrderByMetaData() != null && !currTypoObj.getDefaultOrderByMetaData().isEmpty()) {
                    typoObjsDefaultOrderByMetaData.add(currTypoObj.getDefaultOrderByMetaData().toArray(new R01MOrderByMetaData[currTypoObj.getDefaultOrderByMetaData().size()]));
                    continue;
                }
                typoObjsDefaultOrderByMetaData.add(new R01MOrderByMetaData[0]);
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                cfgLoadEx.printStackTrace(System.out);
            }
        }
        if (!typoObjsDefaultOrderByMetaData.isEmpty() && (commonOrderByMetaData = CollectionUtils.obtainArraysCommonElements((Object[])typoObjsDefaultOrderByMetaData.toArray(), (Comparator)new Comparator(){

            public int compare(Object obj1, Object obj2) {
                R01MOrderByMetaData odMD1 = (R01MOrderByMetaData)obj1;
                R01MOrderByMetaData odMD2 = (R01MOrderByMetaData)obj2;
                if (odMD1.getMetaDataOid().equals(odMD2.getMetaDataOid())) {
                    return 0;
                }
                return -1;
            }
        })) != null && commonOrderByMetaData.length > 0) {
            return Arrays.asList(commonOrderByMetaData);
        }
        return null;
    }

    private void _reduceQuerySearchedTypo(R01MQueryObject qry) {
        if (qry == null) {
            return;
        }
        try {
            Map<String, R01MContentType> allContentTypes;
            if (qry.getContentClusters() != null && qry.getContentFamilies() != null) {
                R01MSearchedCluster currCluster2 = null;
                R01MContentCluster currClusterCfg = null;
                for (R01MSearchedCluster currCluster2 : qry.getContentClusters()) {
                    currClusterCfg = R01MClientFactory.getTypologyConfigAPI().getClusterConfig(currCluster2.getOid());
                    if (currClusterCfg == null || currClusterCfg.getFamilies() == null || !this._areAllTypoObjsContained(currClusterCfg.getFamilies().values(), qry.getContentFamilies())) continue;
                    String currFamilyOid2 = null;
                    for (String currFamilyOid2 : currClusterCfg.getFamilies().keySet()) {
                        qry.removeContentFamily(currFamilyOid2);
                        if (qry.getContentTypes() == null || qry.getContentTypes().size() != 0) continue;
                    }
                }
            }
            if (qry.getContentFamilies() != null && qry.getContentTypes() != null) {
                R01MSearchedFamily currFamily2 = null;
                R01MContentFamily currFamilyCfg = null;
                for (R01MSearchedFamily currFamily2 : qry.getContentFamilies()) {
                    currFamilyCfg = R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(currFamily2.getOid());
                    if (currFamilyCfg == null || currFamilyCfg.getTypes() == null || !this._areAllTypoObjsContained(currFamilyCfg.getTypes().values(), qry.getContentTypes())) continue;
                    Iterator<String> tit = currFamilyCfg.getTypes().keySet().iterator();
                    while (tit.hasNext()) {
                        qry.removeContentType(tit.next());
                    }
                }
            }
            if (qry.getContentTypes() != null && qry.getContentTypes().size() > 0 && (qry.getContentFamilies() == null || qry.getContentFamilies().size() == 0) && (allContentTypes = R01MClientFactory.getTypologyConfigAPI().getAllTypesConfigIgnoringFamilyAndCluster()) != null && this._areAllTypoObjsContained(allContentTypes.values(), qry.getContentTypes())) {
                qry.setContentTypes(null);
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            cfgLoadEx.printStackTrace(System.out);
        }
    }

    private boolean _areAllTypoObjsContained(Collection where, Collection what) {
        if (where == null || what == null) {
            return false;
        }
        if (what.isEmpty()) {
            return false;
        }
        if (where.size() != what.size()) {
            return false;
        }
        boolean allIncluded = true;
        R01MBaseSearchedTypoObj currSearchedTypoObj2 = null;
        R01MBaseTypologyObject currTypoObj2 = null;
        for (R01MBaseSearchedTypoObj currSearchedTypoObj2 : what) {
            boolean currObjIncluded = false;
            for (R01MBaseTypologyObject currTypoObj2 : where) {
                if (!currTypoObj2.getOid().equals(currSearchedTypoObj2.getOid())) continue;
                currObjIncluded = true;
                break;
            }
            if (currObjIncluded) continue;
            allIncluded = false;
            break;
        }
        return allIncluded;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String theContext) {
        this.context = theContext;
        if (this.context != null && this.query != null) {
            this.query.setContext(theContext);
        }
    }

    public R01MQueryObject getQuery() {
        return this.query;
    }

    public void setQuery(R01MQueryObject theQuery) {
        this.query = theQuery;
        if (StringUtils.isEmptyString((String)this.query.getContext())) {
            this.query.setContext(R01MSearchEngineUtils.obtainContext(this.getContext(), this.query));
        }
    }

    public R01MQueryObject getEffectiveQuery() {
        return this.effectiveQuery;
    }

    public void setEffectiveQuery(R01MQueryObject theEffectiveQuery) {
        this.effectiveQuery = theEffectiveQuery;
    }

    public R01MSearchGuide getSearchGuide() {
        return this.searchGuide;
    }

    public void setSearchGuide(R01MSearchGuide theGuide) {
        this.searchGuide = theGuide;
    }

    public String getSearchEngineId() {
        return this.searchEngineId;
    }

    public void setSearchEngineId(String theSearchEngineId) {
        this.searchEngineId = theSearchEngineId;
    }

    public String getSessionLang() {
        return this.sessionLang;
    }

    public void setSessionLang(String theSessionLang) {
        this.sessionLang = theSessionLang;
    }

    public String getSessionOid() {
        return this.sessionOid;
    }

    public void setSessionOid(String theSessionOid) {
        this.sessionOid = theSessionOid;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean isInitialized) {
        this.initialized = isInitialized;
    }

    public R01MSessionSearchInitResult getSessionSearchInitResult() {
        return this.searchSessionInitResult;
    }

    public void setSessionSearchInitResult(R01MSessionSearchInitResult theSearchSessionInitResult) {
        this.searchSessionInitResult = theSearchSessionInitResult;
    }

    public R01MSearchSourceInitResult getSessionSearchInitResult(String sourceOid) {
        return this.searchSessionInitResult == null ? null : this.searchSessionInitResult.getSourceInitResult(sourceOid);
    }

    public Pager getPager(String sourceOid) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("Se intenta llamar a getPager() SIN haber llamado a initSession() previamente!");
        }
        R01MSearchSourceInitResult initResults = this.getSessionSearchInitResult(sourceOid);
        if (initResults != null) {
            return initResults.getPager();
        }
        return null;
    }

    public R01MSearchSessionResults getCachedSearchResults() {
        return this.cachedSearchResults;
    }

    public void setCachedSearchResults(R01MSearchSessionResults theCachedSearchResults) {
        this.cachedSearchResults = theCachedSearchResults;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(boolean lazy) {
        this.lazyInit = lazy;
    }

    public boolean isLazyGuide() {
        return this.lazyGuide;
    }

    public void setLazyGuide(boolean theLazyGuide) {
        this.lazyGuide = theLazyGuide;
    }

    public boolean isCacheResults() {
        return this.cacheResults;
    }

    public void setCacheResults(boolean theCacheResults) {
        this.cacheResults = theCacheResults;
    }

    public R01MSessionSearchInitResult getSearchSessionInitResult() {
        return this.searchSessionInitResult;
    }

    public void setSearchSessionInitResult(R01MSessionSearchInitResult theSearchSessionInitResult) {
        this.searchSessionInitResult = theSearchSessionInitResult;
    }

    public Map getCachedFormatedCode() {
        return this.cachedFormatedCode;
    }

    public void setCachedFormatedCode(Map theCachedFormatedCode) {
        this.cachedFormatedCode = theCachedFormatedCode;
    }

    public StringBuffer getCachedFormattedCode(String codeId) {
        return this.cachedFormatedCode != null ? (StringBuffer)this.cachedFormatedCode.get(codeId) : null;
    }

    public Map getCachedFormatedCodeMap() {
        return this.cachedFormatedCode != null ? this.cachedFormatedCode : new HashMap(6);
    }

    public void addCachedFormattedCode(String codeId, StringBuffer theCachedFormattedCode) {
        if (theCachedFormattedCode == null) {
            return;
        }
        if (this.cachedFormatedCode == null) {
            this.cachedFormatedCode = new HashMap(6);
        }
        this.cachedFormatedCode.put(codeId, theCachedFormattedCode);
    }
}

