/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.session;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSessionSearchInitResult;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MSearchOrchestatorBzd;

class R01MSearchOrchestatorAPI
extends R01MBaseAPI {
    R01MSearchOrchestatorAPI() {
        super("searchEngine");
    }

    R01MSessionSearchInitResult initSession(String searchEngineId, String context, String searchSessionOid, String searchSessionLang, R01MQueryObject qry, R01MSearchGuideElement[] guideFutureElements, boolean lazy) throws R01MSearchInitializeException {
        R01FLog.to((String)"r01m.searchAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n[SEARCH CLIENT API]: Nueva sesion de b\u00fasqueda...");
        try {
            return ((R01MSearchOrchestatorBzd)super.getBzd()).execInitSession(searchEngineId, context, searchSessionOid, searchSessionLang, qry, guideFutureElements, lazy);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchInitializeException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    R01MSearchResultItem[] getResults(String searchEngineId, String context, String searchSessionOid, String searchSessionLang, R01MQueryObject qry, String sourceOid, int pageNum, Object pageFirstElementOid, Object pageLastElementOid) throws R01MSearchPerformerException {
        R01FLog.to((String)"r01m.searchAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n[SEARCH CLIENT API]: Obtener los resultados del origen " + sourceOid);
        try {
            return ((R01MSearchOrchestatorBzd)super.getBzd()).execGetResults(searchEngineId, context, searchSessionOid, searchSessionLang, sourceOid, qry, pageNum, pageFirstElementOid, pageLastElementOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchPerformerException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    R01MSearchResultItem[] getResultsFromAutonomyQuery(String sourceOid, String context, String autonomyQuery) throws R01MSearchPerformerException {
        if (StringUtils.isEmptyString((String)sourceOid) || StringUtils.isEmptyString((String)context)) {
            throw new R01MSearchPerformerException("el origen y el contexto definido para la b\u00fasqueda no pueden ser nulos");
        }
        R01FLog.to((String)"r01m.searchAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n[SEARCH CLIENT API]: Obtener los resultados del origen " + (sourceOid == null ? " [NULL]" : sourceOid) + " para el contexto " + (context == null ? " [NULL] " : context));
        try {
            return ((R01MSearchOrchestatorBzd)super.getBzd()).execGetResultsFromAutonomyQuery(sourceOid, context, autonomyQuery);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchPerformerException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public String getSearchEngineQuerySentence(String searchEngineId, String context, String searchSessionOid, String searchSessionLang, String sourceOid, R01MQueryObject qry, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        try {
            return ((R01MSearchOrchestatorBzd)super.getBzd()).execGetSearchEngineQuerySentence(searchEngineId, context, searchSessionOid, searchSessionLang, sourceOid, qry, pageNum, pageFirstCod, pageLastCod);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchPerformerException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }
}

