/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.query;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj;
import java.io.Serializable;

public class R01MSearchedWorkArea
extends R01MBaseSearchedStorageObj
implements Serializable {
    private static final long serialVersionUID = 1119770168557331887L;
    public String serverOid;
    public String dataRepositoryOid;
    public String areaOid;
    public String workAreaOid;

    public R01MSearchedWorkArea() {
    }

    public R01MSearchedWorkArea(String newServerOid, String newDataStoreOid, String newAreaOid, String newWorkAreaOid) {
        this();
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataStoreOid;
        this.areaOid = newAreaOid;
        this.workAreaOid = newWorkAreaOid;
    }

    public R01MSearchedWorkArea(String newServerOid, String newDataRepositoryOid, String newAreaOid, String newWorkAreaOid, String newName) {
        this(newServerOid, newDataRepositoryOid, newAreaOid, newWorkAreaOid);
        this.name = newName;
    }

    @Override
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedWorkArea) {
            R01MSearchedWorkArea otherWA = (R01MSearchedWorkArea)other;
            boolean eq = true;
            eq &= this.serverOid != null && otherWA.serverOid != null && this.serverOid.equals(otherWA.serverOid);
            eq &= this.dataRepositoryOid != null && otherWA.dataRepositoryOid != null && this.dataRepositoryOid.equals(otherWA.dataRepositoryOid);
            eq &= this.areaOid != null && otherWA.areaOid != null && this.areaOid.equals(otherWA.areaOid);
            return eq &= this.workAreaOid != null && otherWA.workAreaOid != null && this.workAreaOid.equals(otherWA.workAreaOid);
        }
        return false;
    }

    @Override
    public String composeDebugInfo() {
        return "serverOid=" + this.serverOid + " dataStoreOid=" + this.dataRepositoryOid + " area=" + this.areaOid + " workArea=" + this.workAreaOid;
    }

    @Override
    public String getKey() {
        return this.getServerOid() + "." + this.getDataRepositoryOid() + "." + this.getAreaOid() + "." + this.getWorkAreaOid();
    }

    @Override
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key del objeto de almacenamiento workArea NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid.workAreaOid");
            return;
        }
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 4) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key del workArea " + key + " NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid.workAreaOid");
        } else {
            this.serverOid = keySplitted[0];
            this.dataRepositoryOid = keySplitted[1];
            this.areaOid = keySplitted[2];
            this.workAreaOid = keySplitted[3];
        }
    }

    @Override
    public String getStorageObjOid() {
        return this.getWorkAreaOid();
    }

    public String getServerOid() {
        return this.serverOid;
    }

    public void setServerOid(String theServerOid) {
        this.serverOid = theServerOid;
    }

    public String getDataRepositoryOid() {
        return this.dataRepositoryOid;
    }

    public void setDataRepositoryOid(String theDataRepositoryOid) {
        this.dataRepositoryOid = theDataRepositoryOid;
    }

    public String getAreaOid() {
        return this.areaOid;
    }

    public void setAreaOid(String theAreaOid) {
        this.areaOid = theAreaOid;
    }

    public String getWorkAreaOid() {
        return this.workAreaOid;
    }

    public void setWorkAreaOid(String theWorkAreaOid) {
        this.workAreaOid = theWorkAreaOid;
    }
}

