/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.query;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj;
import java.io.Serializable;

public class R01MSearchedGeoCatalog
extends R01MBaseSearchedObj
implements Serializable {
    private static final long serialVersionUID = -5948116112295414471L;
    public String provinceId;
    public String municipalId;

    public R01MSearchedGeoCatalog() {
    }

    public R01MSearchedGeoCatalog(String newProvinceId, String newMunicipalityId) {
        this.provinceId = newProvinceId;
        this.municipalId = newMunicipalityId;
    }

    @Override
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedGeoCatalog) {
            R01MSearchedGeoCatalog otherCat = (R01MSearchedGeoCatalog)other;
            boolean eq = true;
            eq &= this.provinceId != null && otherCat.provinceId != null && this.provinceId.equals(otherCat.provinceId);
            return eq &= this.municipalId != null && otherCat.municipalId != null && this.municipalId.equals(otherCat.municipalId);
        }
        return false;
    }

    @Override
    public String composeDebugInfo() {
        return "provinceOid=" + this.getProvinceId() + " municipalityOid=" + this.getMunicipalId();
    }

    @Override
    public String getKey() {
        return this.getProvinceId() + "." + this.getMunicipalId();
    }

    @Override
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key de la catalogaci\u00f3n geogr\u00e1fica NO es valida: ha de tener el formato provinceOid.municipalityOid");
            return;
        }
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 2) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key de la catalogaci\u00f3n geogr\u00e1fica " + key + " NO es valida: ha de tener el formato provinceOid.municipalityOid");
        } else {
            this.provinceId = keySplitted[0];
            this.municipalId = keySplitted[1];
        }
    }

    public String getMunicipalId() {
        return this.municipalId;
    }

    public void setMunicipalId(String theMunicipalId) {
        this.municipalId = theMunicipalId;
    }

    public String getProvinceId() {
        return this.provinceId;
    }

    public void setProvinceId(String theProvinceId) {
        this.provinceId = theProvinceId;
    }
}

