/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.query;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj;
import java.io.Serializable;

public class R01MSearchedDataRepository
extends R01MBaseSearchedStorageObj
implements Serializable {
    private static final long serialVersionUID = -5701131633609126746L;
    public String serverOid;
    public String dataRepositoryOid;

    public R01MSearchedDataRepository() {
    }

    public R01MSearchedDataRepository(String newServerOid, String newDataRepositoryOid) {
        this();
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataRepositoryOid;
    }

    public R01MSearchedDataRepository(String newServerOid, String newDataRepositoryOid, String newName) {
        this(newServerOid, newDataRepositoryOid);
        this.name = newName;
    }

    @Override
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedDataRepository) {
            R01MSearchedDataRepository otherDR = (R01MSearchedDataRepository)other;
            boolean eq = true;
            eq &= this.serverOid != null && otherDR.serverOid != null && this.serverOid.equals(otherDR.serverOid);
            return eq &= this.dataRepositoryOid != null && otherDR.dataRepositoryOid != null && this.dataRepositoryOid.equals(otherDR.dataRepositoryOid);
        }
        return false;
    }

    @Override
    public String composeDebugInfo() {
        return "serverOid=" + this.serverOid + " dataStoreOid=" + this.dataRepositoryOid;
    }

    @Override
    public String getKey() {
        return this.serverOid + "." + this.dataRepositoryOid;
    }

    @Override
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key del objeto de almacenamiento dataRepository NO es valida: ha de tener el formato serverOid.dataRepositoryOid");
            return;
        }
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 2) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key del dataStore " + key + " NO es valida: ha de tener el formato serverOid.dataRepositoryOid");
        } else {
            this.serverOid = keySplitted[0];
            this.dataRepositoryOid = keySplitted[1];
        }
    }

    @Override
    public String getStorageObjOid() {
        return this.getDataRepositoryOid();
    }

    public String getServerOid() {
        return this.serverOid;
    }

    public void setServerOid(String theServerOid) {
        this.serverOid = theServerOid;
    }

    public String getDataRepositoryOid() {
        return this.dataRepositoryOid;
    }

    public void setDataRepositoryOid(String theDataRepositoryOid) {
        this.dataRepositoryOid = theDataRepositoryOid;
    }
}

