/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.query;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj;
import java.io.Serializable;

public class R01MSearchedArea
extends R01MBaseSearchedStorageObj
implements Serializable {
    private static final long serialVersionUID = -7274728889394973359L;
    public String serverOid;
    public String dataRepositoryOid;
    public String areaOid;

    public R01MSearchedArea() {
    }

    public R01MSearchedArea(String newServerOid, String newDataStoreOid, String newAreaOid) {
        this();
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataStoreOid;
        this.areaOid = newAreaOid;
    }

    public R01MSearchedArea(String newServerOid, String newDataRepositoryOid, String newAreaOid, String newName) {
        this(newServerOid, newDataRepositoryOid, newAreaOid);
        this.name = newName;
    }

    @Override
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedArea) {
            R01MSearchedArea otherArea = (R01MSearchedArea)other;
            boolean eq = true;
            eq &= this.serverOid != null && otherArea.serverOid != null && this.serverOid.equals(otherArea.serverOid);
            eq &= this.dataRepositoryOid != null && otherArea.dataRepositoryOid != null && this.dataRepositoryOid.equals(otherArea.dataRepositoryOid);
            return eq &= this.areaOid != null && otherArea.areaOid != null && this.areaOid.equals(otherArea.areaOid);
        }
        return false;
    }

    @Override
    public String composeDebugInfo() {
        return "serverOid=" + this.serverOid + " dataStoreOid=" + this.dataRepositoryOid + " areaOid=" + this.areaOid;
    }

    @Override
    public String getKey() {
        return this.serverOid + "." + this.dataRepositoryOid + "." + this.areaOid;
    }

    @Override
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key del objeto de almacenamiento area NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid");
            return;
        }
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 3) {
            R01FLog.to((String)"r01m.searchEngine").severe("La key del area " + key + " NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid");
        } else {
            this.serverOid = keySplitted[0];
            this.dataRepositoryOid = keySplitted[1];
            this.areaOid = keySplitted[2];
        }
    }

    @Override
    public String getStorageObjOid() {
        return this.getAreaOid();
    }

    public String getServerOid() {
        return this.serverOid;
    }

    public void setServerOid(String theServerOid) {
        this.serverOid = theServerOid;
    }

    public String getDataRepositoryOid() {
        return this.dataRepositoryOid;
    }

    public void setDataRepositoryOid(String theDataRepositoryOid) {
        this.dataRepositoryOid = theDataRepositoryOid;
    }

    public String getAreaOid() {
        return this.areaOid;
    }

    public void setAreaOid(String theAreaOid) {
        this.areaOid = theAreaOid;
    }
}

