/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.query;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedArea;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedDataRepository;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedGeoCatalog;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedPublishRepository;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedServer;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedStructureCatalog;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedWorkArea;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.query.R01MQueryObjectJsonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MQueryObject
implements Serializable {
    private static final long serialVersionUID = -4850345987691922295L;
    public static final String PRESENTATION_PAGE_SIZE = "r01PageSize";
    public static final String PRESENTATION_NAVBAR_BLOCK_SIZE = "r01NavBarBlockSize";
    public static final String PRESENTATION_SHOW_ATTACHMENTS = "r01ShowAttachments";
    public static final String METADATA_LANGUAGE = "documentLanguage";
    public static final String METADATA_FULLTEXT = "fullText";
    public String queryOid;
    public boolean modified;
    public String searchEngineId;
    public String context;
    public String queryName;
    public String queryDescription;
    public Map presentationProperties = null;
    public boolean saveQuery = false;
    public boolean isFullTextSearch = false;
    public boolean allResultsInAPage = false;
    public boolean returnDocuments = true;
    public boolean returnDataFiles = true;
    public boolean returnAttachments = true;
    public boolean returnLinkedDocuments = true;
    public String status;
    public List publishRepositories;
    public boolean publishedItemsOnly = true;
    public boolean onlyNotPublished = false;
    public int documentUIState;
    public List servers;
    public List dataRepositories;
    public List areas;
    public List workAreas;
    public List contentClusters;
    public List contentFamilies;
    public List contentTypes;
    public List contentExcludedTypes;
    public List searchedMetaData;
    public List orSearchedMetaData;
    public int fullTextWordCount = -1;
    public List catalogLabelsAnd;
    public List catalogLabelsOr;
    public List geoCatalogsAnd;
    public List geoCatalogsOr;
    public List orderBy;
    public boolean searchByDefaultLang = true;

    public R01MQueryObject() {
        try {
            this.queryOid = R01MUtils.generateNewOid(R01MConstants.API_APPCODE);
        }
        catch (GUIDDispenserException guidEx) {
            guidEx.printStackTrace(System.out);
            this.queryOid = "error";
        }
        this.queryName = null;
        this.queryDescription = null;
        this.saveQuery = false;
        this.publishRepositories = null;
        this.searchByDefaultLang = true;
        this.contentClusters = new ArrayList();
        this.contentFamilies = new ArrayList();
        this.contentTypes = new ArrayList();
        this.contentExcludedTypes = new ArrayList();
        this.searchedMetaData = new ArrayList();
        this.orSearchedMetaData = new ArrayList();
        this.catalogLabelsAnd = new ArrayList();
        this.catalogLabelsOr = new ArrayList();
        this.geoCatalogsAnd = new ArrayList();
        this.geoCatalogsOr = new ArrayList();
        this.orderBy = new ArrayList();
        this.servers = new ArrayList();
        this.dataRepositories = new ArrayList();
        this.areas = new ArrayList();
        this.workAreas = new ArrayList();
    }

    public void generateNewQueryOid() {
        try {
            this.queryOid = R01MUtils.generateNewOid(R01MConstants.API_APPCODE);
        }
        catch (GUIDDispenserException guidEx) {
            guidEx.printStackTrace(System.out);
            this.queryOid = "error";
        }
    }

    public void addServer(R01MSearchedServer searchedServer) throws IllegalArgumentException {
        if (searchedServer != null) {
            if (StringUtils.isEmptyString((String)searchedServer.serverOid)) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del servidor a buscar NO es valido!");
            }
            if (this.servers == null) {
                this.servers = new ArrayList();
            }
            if (!this._listContains(this.servers, searchedServer)) {
                this.servers.add(searchedServer);
            }
        }
    }

    public void addServer(String serverOid, String serverName) throws IllegalArgumentException {
        this.addServer(new R01MSearchedServer(serverOid, serverName));
    }

    public void addServer(String serverOid) throws IllegalArgumentException {
        this.addServer(serverOid, null);
    }

    public void addServerFromKey(String serverKey) throws IllegalArgumentException {
        R01MSearchedServer serverToAdd = new R01MSearchedServer();
        serverToAdd.fromKey(serverKey);
        this.addServer(serverToAdd);
    }

    public R01MSearchedServer getServer(String serverOid) {
        return (R01MSearchedServer)this._findSearchedStorageObj(this.servers, serverOid);
    }

    public void removeServer(String searchedServerOid) {
        this._removeSearchedStorageObj(this.servers, searchedServerOid);
    }

    public void addDataRepository(R01MSearchedDataRepository searchedDataRepository) throws IllegalArgumentException {
        if (searchedDataRepository != null) {
            if (searchedDataRepository.dataRepositoryOid == null || searchedDataRepository.dataRepositoryOid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del repositorio de datos a buscar NO es valido!");
            }
            if (this.dataRepositories == null) {
                this.dataRepositories = new ArrayList();
            }
            if (!this._listContains(this.dataRepositories, searchedDataRepository)) {
                this.dataRepositories.add(searchedDataRepository);
            }
        }
    }

    public void addDataRepository(String serverOid, String dataRepositoryOid, String dataRepositoryName) throws IllegalArgumentException {
        this.addDataRepository(new R01MSearchedDataRepository(serverOid, dataRepositoryOid, dataRepositoryName));
    }

    public void addDataRepository(String serverOid, String dataRepositoryOid) throws IllegalArgumentException {
        this.addDataRepository(serverOid, dataRepositoryOid, null);
    }

    public void addDataRepositoryFromKey(String drKey) throws IllegalArgumentException {
        R01MSearchedDataRepository drToAdd = new R01MSearchedDataRepository();
        drToAdd.fromKey(drKey);
        this.addDataRepository(drToAdd);
    }

    public R01MSearchedDataRepository getDataRepository(String dataRepositoryOid) {
        return (R01MSearchedDataRepository)this._findSearchedStorageObj(this.dataRepositories, dataRepositoryOid);
    }

    public void removeDataRepository(String searchedDataRepOid) {
        this._removeSearchedStorageObj(this.dataRepositories, searchedDataRepOid);
    }

    public void addArea(R01MSearchedArea searchedArea) throws IllegalArgumentException {
        if (searchedArea != null) {
            if (searchedArea.areaOid == null || searchedArea.areaOid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del area a buscar NO es valido!");
            }
            if (this.areas == null) {
                this.areas = new ArrayList();
            }
            if (!this._listContains(this.areas, searchedArea)) {
                this.areas.add(searchedArea);
            }
        }
    }

    public void addArea(String serverOid, String dataRepositoryOid, String areaOid, String areaName) throws IllegalArgumentException {
        this.addArea(new R01MSearchedArea(serverOid, dataRepositoryOid, areaOid, areaName));
    }

    public void addArea(String serverOid, String dataRepositoryOid, String areaOid) throws IllegalArgumentException {
        this.addArea(serverOid, dataRepositoryOid, areaOid, null);
    }

    public void addAreaFromKey(String areaKey) throws IllegalArgumentException {
        R01MSearchedArea areaToAdd = new R01MSearchedArea();
        areaToAdd.fromKey(areaKey);
        this.addArea(areaToAdd);
    }

    public R01MSearchedArea getArea(String areaOid) {
        return (R01MSearchedArea)this._findSearchedStorageObj(this.areas, areaOid);
    }

    public void removeArea(String searchedAreaOid) {
        this._removeSearchedStorageObj(this.areas, searchedAreaOid);
    }

    public void addWorkArea(R01MSearchedWorkArea searchedWorkArea) throws IllegalArgumentException {
        if (searchedWorkArea != null) {
            if (searchedWorkArea.workAreaOid == null || searchedWorkArea.workAreaOid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del WorkArea a buscar NO es valido!");
            }
            if (this.workAreas == null) {
                this.workAreas = new ArrayList();
            }
            if (!this._listContains(this.workAreas, searchedWorkArea)) {
                this.workAreas.add(searchedWorkArea);
            }
        }
    }

    public void addWorkArea(String serverOid, String dataRepositoryOid, String areaOid, String workAreaOid, String workAreaName) throws IllegalArgumentException {
        this.addWorkArea(new R01MSearchedWorkArea(serverOid, dataRepositoryOid, areaOid, workAreaOid, workAreaName));
    }

    public void addWorkArea(String serverOid, String dataRepositoryOid, String areaOid, String workAreaOid) throws IllegalArgumentException {
        this.addWorkArea(serverOid, dataRepositoryOid, areaOid, workAreaOid, null);
    }

    public void addWorkAreaFromKey(String waKey) throws IllegalArgumentException {
        R01MSearchedWorkArea waToAdd = new R01MSearchedWorkArea();
        waToAdd.fromKey(waKey);
        this.addWorkArea(waToAdd);
    }

    public R01MSearchedWorkArea getWorkArea(String workAreaOid) {
        return (R01MSearchedWorkArea)this._findSearchedStorageObj(this.workAreas, workAreaOid);
    }

    public void removeWorkdArea(String searchedWorkAreaOid) {
        this._removeSearchedStorageObj(this.workAreas, searchedWorkAreaOid);
    }

    private R01MBaseSearchedStorageObj _findSearchedStorageObj(List stgObjsList, String searchedStgObjKey) {
        if (searchedStgObjKey != null && stgObjsList != null) {
            R01MBaseSearchedStorageObj currStgObj2 = null;
            int index = -1;
            int i = 0;
            for (R01MBaseSearchedStorageObj currStgObj2 : stgObjsList) {
                if (currStgObj2.getKey().equals(searchedStgObjKey)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                return currStgObj2;
            }
        }
        return null;
    }

    private R01MBaseSearchedStorageObj _removeSearchedStorageObj(List storageObjsList, String searchedStorageObjKey) {
        if (searchedStorageObjKey != null && storageObjsList != null) {
            R01MBaseSearchedStorageObj currStorageObj2 = null;
            int index = -1;
            int i = 0;
            for (R01MBaseSearchedStorageObj currStorageObj2 : storageObjsList) {
                if (currStorageObj2.getKey().equals(searchedStorageObjKey)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index > 0) {
                storageObjsList.remove(index);
                return currStorageObj2;
            }
        }
        return null;
    }

    public void addContentCluster(R01MSearchedCluster searchedCluster) throws IllegalArgumentException {
        if (searchedCluster != null) {
            if (searchedCluster.oid == null || searchedCluster.oid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del Cluster a buscar NO es valido!");
            }
            if (this.contentClusters == null) {
                this.contentClusters = new ArrayList();
            }
            if (!this._listContains(this.contentClusters, searchedCluster)) {
                this.contentClusters.add(searchedCluster);
            }
        }
    }

    public void addContentCluster(String clusterOid) throws IllegalArgumentException {
        this.addContentCluster(clusterOid, null);
    }

    public void addContentCluster(String clusterOid, String clusterName) throws IllegalArgumentException {
        this.addContentCluster(new R01MSearchedCluster(clusterOid, clusterName));
    }

    public void addContentClusterFromKey(String clusterKey) throws IllegalArgumentException {
        R01MSearchedCluster clusterToAdd = new R01MSearchedCluster();
        clusterToAdd.fromKey(clusterKey);
        this.addContentCluster(clusterToAdd);
    }

    public void removeContentCluster(String searchedClusterOid) {
        this._removeSearchedTypoObj(this.contentClusters, searchedClusterOid);
    }

    public R01MSearchedCluster getContentCluster(String searchedClusterOid) {
        return (R01MSearchedCluster)this._findSearchedTypoObj(this.contentClusters, searchedClusterOid);
    }

    public void addContentFamily(R01MSearchedFamily searchedFamily) throws IllegalArgumentException {
        if (searchedFamily != null) {
            if (searchedFamily.oid == null || searchedFamily.oid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid de la familia a buscar NO es valido!");
            }
            if (this.contentFamilies == null) {
                this.contentFamilies = new ArrayList();
            }
            if (!this._listContains(this.contentFamilies, searchedFamily)) {
                this.contentFamilies.add(searchedFamily);
            }
        }
    }

    public void addContentFamily(String familyOid) throws IllegalArgumentException {
        this.addContentFamily(familyOid, null);
    }

    public void addContentFamily(String familyOid, String familyName) throws IllegalArgumentException {
        this.addContentFamily(new R01MSearchedFamily(familyOid, familyName));
    }

    public void addContentFamilyFromKey(String familyKey) throws IllegalArgumentException {
        R01MSearchedFamily famToAdd = new R01MSearchedFamily();
        famToAdd.fromKey(familyKey);
        this.addContentFamily(famToAdd);
    }

    public void removeContentFamily(String searchedFamilyOid) {
        this._removeSearchedTypoObj(this.contentFamilies, searchedFamilyOid);
    }

    public R01MSearchedFamily getContentFamily(String searchedFamilyOid) {
        return (R01MSearchedFamily)this._findSearchedTypoObj(this.contentFamilies, searchedFamilyOid);
    }

    public void addContentType(R01MSearchedContentType searchedType) throws IllegalArgumentException {
        if (searchedType != null) {
            if (searchedType.oid == null || searchedType.oid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del tipo a buscar NO es valido!");
            }
            if (this.contentTypes == null) {
                this.contentTypes = new ArrayList();
            }
            if (!this._listContains(this.contentTypes, searchedType)) {
                this.contentTypes.add(searchedType);
            }
        }
    }

    public void addContentType(String typeOid) throws IllegalArgumentException {
        this.addContentType(typeOid, null);
    }

    public void addContentType(String typeOid, String typeName) throws IllegalArgumentException {
        this.addContentType(new R01MSearchedContentType(typeOid, typeName));
    }

    public void addContentTypeFromKey(String typeKey) throws IllegalArgumentException {
        R01MSearchedContentType typeToAdd = new R01MSearchedContentType();
        typeToAdd.fromKey(typeKey);
        this.addContentType(typeToAdd);
    }

    public void removeContentType(String searchedTypeOid) {
        this._removeSearchedTypoObj(this.contentTypes, searchedTypeOid);
    }

    public R01MSearchedContentType getContentType(String searchedTypeOid) {
        return (R01MSearchedContentType)this._findSearchedTypoObj(this.contentTypes, searchedTypeOid);
    }

    public void addMetaData(R01MSearchedMetaData theSearchedMetaData) throws IllegalArgumentException {
        if (theSearchedMetaData != null) {
            if (theSearchedMetaData.oid == null || theSearchedMetaData.oid.length() == 0 || theSearchedMetaData.value == null || theSearchedMetaData.value.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el metaDato " + theSearchedMetaData.getOid() + " a buscar tiene un oid o un valor NO son valido (null)!");
            }
            if (this.searchedMetaData == null) {
                this.searchedMetaData = new ArrayList();
            }
            boolean metaDataExists = false;
            R01MSearchedMetaData currSearchedMetaData2 = null;
            for (R01MSearchedMetaData currSearchedMetaData2 : this.searchedMetaData) {
                if (!currSearchedMetaData2.getOid().equals(theSearchedMetaData.getOid())) continue;
                metaDataExists = true;
                break;
            }
            if (metaDataExists) {
                currSearchedMetaData2.setOperationSelected(theSearchedMetaData.getOperationSelected());
                currSearchedMetaData2.setValue(theSearchedMetaData.getValue());
            } else {
                this.searchedMetaData.add(theSearchedMetaData);
            }
        }
    }

    public void addMetaData(String metaDataOid, String operationSelected, String metaDataValue) throws IllegalArgumentException {
        this.addMetaData(metaDataOid, null, operationSelected, metaDataValue);
    }

    public void addMetaData(String metaDataOid, String metaDataName, String operationSelected, String value) throws IllegalArgumentException {
        this.addMetaData(new R01MSearchedMetaData(metaDataOid, metaDataName, operationSelected, value));
    }

    public void addMetaDataFromKey(String mdKey) throws IllegalArgumentException {
        R01MSearchedMetaData mdToAdd = new R01MSearchedMetaData();
        mdToAdd.fromKey(mdKey);
        this.addMetaData(mdToAdd);
    }

    public void removeMetaData(String searchedMetaDataOid) {
        this._removeSearchedTypoObj(this.searchedMetaData, searchedMetaDataOid);
    }

    public R01MSearchedMetaData getMetaData(String searchedMetaDataOid) {
        return (R01MSearchedMetaData)this._findSearchedTypoObj(this.searchedMetaData, searchedMetaDataOid);
    }

    public void addORMetaData(R01MSearchedMetaData theSearchedMetaData) throws IllegalArgumentException {
        if (theSearchedMetaData != null) {
            if (theSearchedMetaData.oid == null || theSearchedMetaData.oid.length() == 0 || theSearchedMetaData.value == null || theSearchedMetaData.value.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del metaDato a buscar o su valor NO son validos!");
            }
            if (this.orSearchedMetaData == null) {
                this.orSearchedMetaData = new ArrayList();
            }
            this.orSearchedMetaData.add(theSearchedMetaData);
        }
    }

    public void addORMetaData(String metaDataOid, String operationSelected, String metaDataValue) throws IllegalArgumentException {
        this.addORMetaData(metaDataOid, null, operationSelected, metaDataValue);
    }

    public void addORMetaData(String metaDataOid, String metaDataName, String operationSelected, String value) throws IllegalArgumentException {
        this.addORMetaData(new R01MSearchedMetaData(metaDataOid, metaDataName, operationSelected, value));
    }

    public void addORMetaDataFromKey(String mdKey) throws IllegalArgumentException {
        R01MSearchedMetaData mdToAdd = new R01MSearchedMetaData();
        mdToAdd.fromKey(mdKey);
        this.addORMetaData(mdToAdd);
    }

    public void removeORMetaData(String searchedMetaDataOid) {
        this._removeSearchedTypoObj(this.orSearchedMetaData, searchedMetaDataOid);
    }

    public R01MSearchedMetaData getORMetaData(String searchedMetaDataOid) {
        return (R01MSearchedMetaData)this._findSearchedTypoObj(this.orSearchedMetaData, searchedMetaDataOid);
    }

    public void setLanguage(String lang) {
        if (lang != null) {
            this.addMetaData(METADATA_LANGUAGE, "EQ", lang);
        }
    }

    public void setFullText(String fullText) {
        if (fullText != null) {
            this.addMetaData(METADATA_FULLTEXT, "LIKE", fullText);
            this.isFullTextSearch = true;
        } else {
            this.removeMetaData(METADATA_FULLTEXT);
            this.isFullTextSearch = false;
        }
    }

    public String getFullText() {
        R01MSearchedMetaData fullTextMD = this.getMetaData(METADATA_FULLTEXT);
        return fullTextMD != null ? fullTextMD.getValue() : null;
    }

    public int getFullTextWordCount() {
        return this.fullTextWordCount;
    }

    public void setFullTextWordCount(int thefullTextWordCount) {
        this.fullTextWordCount = thefullTextWordCount;
    }

    public boolean isFullTextSearch() {
        return this.isFullTextSearch;
    }

    public void setFullTextSearch(boolean newIsFullTextSearch) {
        this.isFullTextSearch = newIsFullTextSearch;
    }

    private R01MBaseSearchedTypoObj _findSearchedTypoObj(List typoObjsList, String searchedTypoObjOid) {
        if (searchedTypoObjOid != null && typoObjsList != null) {
            R01MBaseSearchedTypoObj currTypoObj2 = null;
            int index = -1;
            int i = 0;
            for (R01MBaseSearchedTypoObj currTypoObj2 : typoObjsList) {
                if (currTypoObj2.getOid().equals(searchedTypoObjOid)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                return currTypoObj2;
            }
        }
        return null;
    }

    private R01MBaseSearchedTypoObj _removeSearchedTypoObj(List typoObjsList, String searchedTypoObjOid) {
        if (searchedTypoObjOid != null && typoObjsList != null) {
            R01MBaseSearchedTypoObj currTypoObj2 = null;
            int index = -1;
            int i = 0;
            for (R01MBaseSearchedTypoObj currTypoObj2 : typoObjsList) {
                if (currTypoObj2.getOid().equals(searchedTypoObjOid)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                typoObjsList.remove(index);
                return currTypoObj2;
            }
        }
        return null;
    }

    public void addANDStructureCatalog(R01MSearchedStructureCatalog searchedCatalog) throws IllegalArgumentException {
        if (searchedCatalog != null) {
            if (searchedCatalog.labelOid == null || searchedCatalog.labelOid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid de la etiqueta and NO es v\u00e1lida");
            }
            if (this.catalogLabelsAnd == null) {
                this.catalogLabelsAnd = new ArrayList();
            }
            if (!this._listContains(this.catalogLabelsAnd, searchedCatalog)) {
                this.catalogLabelsAnd.add(searchedCatalog);
            }
        }
    }

    public void addANDStructureCatalog(String labelOid) throws IllegalArgumentException {
        this.addANDStructureCatalog(new R01MSearchedStructureCatalog(labelOid));
    }

    public void addANDStructureCatalogFromKey(String catKey) throws IllegalArgumentException {
        R01MSearchedStructureCatalog catToAdd = new R01MSearchedStructureCatalog();
        catToAdd.fromKey(catKey);
        this.addANDStructureCatalog(catToAdd);
    }

    public R01MSearchedStructureCatalog getANDStructureCatalog(String labelOid) {
        return this._findSearchedStructureObj(this.catalogLabelsAnd, labelOid);
    }

    public void removeANDStructrueCatalog(String structureOid) {
        this._removeSearchedStructureLabel(this.catalogLabelsAnd, structureOid);
    }

    public void addORStructureCatalog(R01MSearchedStructureCatalog searchedCatalog) throws IllegalArgumentException {
        if (searchedCatalog != null) {
            if (searchedCatalog.labelOid == null || searchedCatalog.labelOid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid de la etiqueta and NO es v\u00e1lida");
            }
            if (this.catalogLabelsOr == null) {
                this.catalogLabelsOr = new ArrayList();
            }
            if (!this._listContains(this.catalogLabelsOr, searchedCatalog)) {
                this.catalogLabelsOr.add(searchedCatalog);
            }
        }
    }

    public void addORStructureCatalog(String labelOid) throws IllegalArgumentException {
        this.addORStructureCatalog(new R01MSearchedStructureCatalog(labelOid));
    }

    public void addORStructureCatalogFromKey(String catKey) throws IllegalArgumentException {
        R01MSearchedStructureCatalog catToAdd = new R01MSearchedStructureCatalog();
        catToAdd.fromKey(catKey);
        this.addORStructureCatalog(catToAdd);
    }

    public R01MSearchedStructureCatalog getORStructureCatalog(String labelOid) {
        return this._findSearchedStructureObj(this.catalogLabelsOr, labelOid);
    }

    public void removeORStructrueCatalog(String structureOid) {
        this._removeSearchedStructureLabel(this.catalogLabelsOr, structureOid);
    }

    private R01MSearchedStructureCatalog _findSearchedStructureObj(List structureObjsList, String searchedStructureObjOid) {
        if (searchedStructureObjOid != null && structureObjsList != null) {
            R01MSearchedStructureCatalog currStructureObj2 = null;
            int index = -1;
            int i = 0;
            for (R01MSearchedStructureCatalog currStructureObj2 : structureObjsList) {
                if (currStructureObj2.getLabelOid().equals(searchedStructureObjOid)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                return currStructureObj2;
            }
        }
        return null;
    }

    private R01MSearchedStructureCatalog _removeSearchedStructureLabel(List labelList, String searchedLabelOid) {
        if (searchedLabelOid != null && labelList != null) {
            R01MSearchedStructureCatalog currLabelObj2 = null;
            int index = -1;
            int i = 0;
            for (R01MSearchedStructureCatalog currLabelObj2 : labelList) {
                if (currLabelObj2.getLabelOid().equals(searchedLabelOid)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                labelList.remove(index);
                return currLabelObj2;
            }
        }
        return null;
    }

    public void addOrderByMetaData(R01MSearchedOrderByMetaData orderByMetaData) throws IllegalArgumentException {
        if (orderByMetaData != null) {
            if (orderByMetaData.oid == null || orderByMetaData.oid.length() == 0 || orderByMetaData.order == null || orderByMetaData.order.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del metaDato por el que ordenar NO es valido!");
            }
            if (this.orderBy == null) {
                this.orderBy = new ArrayList();
            }
            if (!this._listContains(this.orderBy, orderByMetaData)) {
                this.orderBy.add(orderByMetaData);
            }
        }
    }

    public void addOrderByMetaData(String metaDataOid, String metaDataName, String order) throws IllegalArgumentException {
        this.addOrderByMetaData(new R01MSearchedOrderByMetaData(metaDataOid, metaDataName, order));
    }

    public void addOrderByMetaDataFromKey(String orderKey) throws IllegalArgumentException {
        R01MSearchedOrderByMetaData orderToAdd = new R01MSearchedOrderByMetaData();
        orderToAdd.fromKey(orderKey);
        this.addOrderByMetaData(orderToAdd);
    }

    public void addPublishRepository(R01MSearchedPublishRepository publishRepository) throws IllegalArgumentException {
        if (publishRepository != null) {
            if (publishRepository.oid == null || publishRepository.oid.length() == 0) {
                throw new IllegalArgumentException("Error al establecer la query de b\u00fasqueda: el oid del repositorio de b\u00fasqueda '" + publishRepository.oid + "' NO es v\u00e1lido!!!");
            }
            if (this.publishRepositories == null) {
                this.publishRepositories = new ArrayList();
            }
            if (!this._listContains(this.publishRepositories, publishRepository)) {
                this.publishRepositories.add(publishRepository);
            }
        }
        this.publishedItemsOnly = this.publishedItemsOnly || this.publishRepositories != null && !this.publishRepositories.isEmpty();
    }

    public void addPublishRepository(String repositoryOid) throws IllegalArgumentException {
        this.addPublishRepository(new R01MSearchedPublishRepository(repositoryOid));
    }

    public void addPublishRepository(String repositoryOid, String repositoryName) throws IllegalArgumentException {
        this.addPublishRepository(new R01MSearchedPublishRepository(repositoryOid, repositoryName));
    }

    public void addPublishRepositoryFromKey(String pubKey) throws IllegalArgumentException {
        R01MSearchedPublishRepository pubToAdd = new R01MSearchedPublishRepository();
        pubToAdd.fromKey(pubKey);
        this.addPublishRepository(pubToAdd);
    }

    public void removePublishRepository(String repOid) throws IllegalArgumentException {
        if (repOid != null && this.publishRepositories != null) {
            R01MSearchedPublishRepository currRep2 = null;
            int i = 0;
            for (R01MSearchedPublishRepository currRep2 : this.publishRepositories) {
                if (currRep2.getOid().equals(repOid)) {
                    this.publishRepositories.remove(i);
                    break;
                }
                ++i;
            }
        }
        this.publishedItemsOnly = this.publishedItemsOnly || this.publishRepositories != null && !this.publishRepositories.isEmpty();
    }

    public StringBuffer composeDebugInfo() {
        StringBuffer sb = new StringBuffer(601);
        sb.append("\r\n[Query] guid:");
        sb.append(this.queryOid);
        sb.append(" context: ");
        sb.append(this.context);
        sb.append(" searchEngineId: ");
        sb.append(this.searchEngineId);
        sb.append(" modified: ");
        sb.append(this.modified);
        sb.append("\r\n\t>> SISTEMA: \r\n\t\tName: ");
        sb.append(this.queryName);
        sb.append("\r\n\t\tDescription: ");
        sb.append(this.queryDescription);
        sb.append("\r\n\t\tSaveQuery: ");
        sb.append(this.saveQuery);
        sb.append("\r\n\t>> TIPOLOGIA:\r\n\t\tClusters\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.contentClusters));
        sb.append("\t\tFamilies\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.contentFamilies));
        sb.append("\t\tTypes\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.contentTypes));
        sb.append("\t\tExcludedTypes\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.contentExcludedTypes));
        sb.append("\t>> ALMACENAMIENTO:\r\n\t\tServers\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.servers));
        sb.append("\t\tDataStores\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.dataRepositories));
        sb.append("\t\tAreas\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.areas));
        sb.append("\t\tWorkAreas\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.workAreas));
        sb.append("\t>> CATALOGACION:\r\n\t\tAND\r\n");
        sb.append(this._composeCatalogDebugInfo(this.catalogLabelsAnd));
        sb.append("\t\tOR\r\n");
        sb.append(this._composeCatalogDebugInfo(this.catalogLabelsOr));
        sb.append("\t>> METADATOS:\r\n");
        sb.append(this._composeQueryElementDebugInfo(this.searchedMetaData));
        sb.append(this._composeQueryElementDebugInfo(this.orSearchedMetaData));
        sb.append("\t>> ORDENACION: \r\n");
        sb.append(this._composeQueryElementDebugInfo(this.orderBy));
        sb.append("\t>> REPOSITORIOS DE PUBLICACION: \r\n");
        sb.append(this._composeQueryElementDebugInfo(this.publishRepositories));
        sb.append("\t\tBuscar SOLO publicados: ");
        sb.append(this.publishedItemsOnly ? "true" : "false");
        sb.append("\r\n\t>> MODELO: \r\n\t\tDevolver ficheros de datos: ");
        sb.append(this.returnDataFiles);
        sb.append("\r\n\t\tDevolver documentos: ");
        sb.append(this.returnDocuments);
        sb.append("\r\n\t\tDevolver adjuntos: ");
        sb.append(this.returnDocuments);
        sb.append("\r\n\t\tstatus: ");
        sb.append(this.status);
        sb.append("\r\n\t>> PROPIEDADES DE PRESENTACION:\r\n");
        sb.append(this._composePresentationPropertiesDebugInfo(this.presentationProperties));
        sb.append("\r\n");
        return sb;
    }

    private StringBuffer _composeQueryElementDebugInfo(List searchedObjList) {
        StringBuffer sb = new StringBuffer("");
        if (searchedObjList != null) {
            R01MBaseSearchedObj so2 = null;
            for (R01MBaseSearchedObj so2 : searchedObjList) {
                sb.append("\t\t\t");
                sb.append(so2.composeDebugInfo());
                sb.append("\r\n");
            }
        }
        return sb;
    }

    private StringBuffer _composeCatalogDebugInfo(List catalogList) {
        StringBuffer sb = new StringBuffer("");
        if (catalogList != null) {
            R01MSearchedStructureCatalog cat2 = null;
            for (R01MSearchedStructureCatalog cat2 : catalogList) {
                sb.append("\t\t\t");
                sb.append(cat2.composeDebugInfo());
                sb.append("\r\n");
            }
        }
        return sb;
    }

    private StringBuffer _composePresentationPropertiesDebugInfo(Map props) {
        StringBuffer sb = new StringBuffer("");
        if (props != null && !props.isEmpty()) {
            Map.Entry me = null;
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                sb.append("\t\t");
                sb.append((String)me.getKey());
                sb.append('=');
                sb.append(String.valueOf(me.getValue()));
                if (!it.hasNext()) continue;
                sb.append("\r\n");
            }
        }
        return sb;
    }

    public String getQueryOid() {
        return this.queryOid;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean theModified) {
        this.modified = theModified;
    }

    public String getSearchEngineId() {
        return this.searchEngineId;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String theContext) {
        this.context = theContext;
    }

    public void setSearchEngineId(String theSearchEngineId) {
        this.searchEngineId = theSearchEngineId;
    }

    public void setQueryOid(String theQueryGuid) {
        this.queryOid = theQueryGuid;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String theQueryName) {
        this.queryName = theQueryName;
    }

    public String getQueryDescription() {
        return this.queryDescription;
    }

    public void setQueryDescription(String theQueryDescription) {
        String queryDescriptionTemp = "";
        queryDescriptionTemp = theQueryDescription != null && theQueryDescription.length() > 255 ? this.queryDescription.substring(0, 255) : theQueryDescription;
        this.queryDescription = queryDescriptionTemp;
    }

    public boolean isSaveQuery() {
        return this.saveQuery;
    }

    public void setSaveQuery(boolean theSaveQuery) {
        this.saveQuery = theSaveQuery;
    }

    public boolean isOnlyNotPublished() {
        return this.onlyNotPublished;
    }

    public void setOnlyNotPublished(boolean theOnlyNotPublished) {
        this.onlyNotPublished = theOnlyNotPublished;
    }

    public int getDocumentUIState() {
        return this.documentUIState;
    }

    public void setDocumentUIState(int theDocumentUIState) {
        this.documentUIState = theDocumentUIState;
        if (theDocumentUIState == 0) {
            this.setOnlyNotPublished(true);
        } else if (theDocumentUIState == 1) {
            this.setOnlyNotPublished(false);
        } else if (theDocumentUIState == 2) {
            this.setOnlyNotPublished(false);
        }
    }

    public void setPresentationProperties(Map thePresentationProperties) {
        this.presentationProperties = thePresentationProperties;
    }

    public Map getPresentationProperties() {
        return this.presentationProperties;
    }

    public void setPresentationProperty(String thePropertyName, String thePropertyValue) {
        if (this.presentationProperties == null) {
            this.presentationProperties = new HashMap();
        }
        if (thePropertyName != null && thePropertyValue != null) {
            this.presentationProperties.put(thePropertyName, thePropertyValue);
        }
    }

    public String getPresentationProperty(String thePropertyName) {
        if (this.presentationProperties == null || thePropertyName == null || this.presentationProperties.get(thePropertyName) == null) {
            return null;
        }
        return String.valueOf(this.presentationProperties.get(thePropertyName));
    }

    public void setAllResultsInAPage(boolean theAllResultsInAPage) {
        this.allResultsInAPage = theAllResultsInAPage;
    }

    public boolean getAllResultsInAPage() {
        return this.allResultsInAPage;
    }

    public boolean isReturnDocuments() {
        return this.returnDocuments;
    }

    public void setReturnDocuments(boolean theReturnDocuments) {
        this.returnDocuments = theReturnDocuments;
    }

    public boolean isReturnDataFiles() {
        return this.returnDataFiles;
    }

    public void setReturnAttachments(boolean theReturnAttachments) {
        this.returnAttachments = theReturnAttachments;
    }

    public void setReturnLinkedDocuments(boolean theReturnLinkedDocuments) {
        this.returnLinkedDocuments = theReturnLinkedDocuments;
    }

    public boolean isReturnAttachments() {
        return this.returnAttachments;
    }

    public boolean isReturnLinkedDocuments() {
        return this.returnLinkedDocuments;
    }

    public void setReturnDataFiles(boolean theReturnDataFiles) {
        this.returnDataFiles = theReturnDataFiles;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String theStatus) {
        this.status = theStatus;
    }

    public List getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List theOrderByMetaData) {
        this.orderBy = theOrderByMetaData;
    }

    public List getCatalogLabelsAnd() {
        return this.catalogLabelsAnd;
    }

    public List getGuideCatalogLabelsAnd() {
        return this._extractGuideConditions(this.catalogLabelsAnd);
    }

    public List getNotGuideCatalogLabelsAnd() {
        return this._extractNotGuideConditions(this.catalogLabelsAnd);
    }

    public void setCatalogLabelsAnd(List theCatalogLabelsAnd) {
        this.catalogLabelsAnd = theCatalogLabelsAnd;
    }

    public List getCatalogLabelsOr() {
        return this.catalogLabelsOr;
    }

    public void setCatalogLabelsOr(List theCatalogLabelsOr) {
        this.catalogLabelsOr = theCatalogLabelsOr;
    }

    public List getGeoCatalogsAnd() {
        return this.geoCatalogsAnd;
    }

    public List getGuideGeoCatalogsAnd() {
        return this._extractGuideConditions(this.geoCatalogsAnd);
    }

    public List getNotGuideGeoCatalogsAnd() {
        return this._extractNotGuideConditions(this.geoCatalogsAnd);
    }

    public void setGeoCatalogsAnd(List theGeoCatalogsAnd) {
        this.geoCatalogsAnd = theGeoCatalogsAnd;
    }

    public List getGeoCatalogsOr() {
        return this.geoCatalogsOr;
    }

    public void setGeoCatalogsOr(List theGeoCatalogsOr) {
        this.geoCatalogsOr = theGeoCatalogsOr;
    }

    public List getMetaData() {
        return this.searchedMetaData;
    }

    public void setMetaData(List theSearchedMetaData) {
        this.searchedMetaData = theSearchedMetaData;
    }

    public List getSearchedMetaData() {
        return this.getMetaData();
    }

    public void setSearchedMetaData(List theSearchedMetaData) {
        this.setMetaData(theSearchedMetaData);
    }

    public List getORMetaData() {
        return this.orSearchedMetaData;
    }

    public void setORMetaData(List theORSearchedMetaData) {
        this.orSearchedMetaData = theORSearchedMetaData;
    }

    public List getOrSearchedMetaData() {
        return this.getORMetaData();
    }

    public void setOrSearchedMetaData(List theORSearchedMetaData) {
        this.setORMetaData(theORSearchedMetaData);
    }

    public List getContentClusters() {
        return this.contentClusters;
    }

    public List getGuideContentClusters() {
        return this._extractGuideConditions(this.contentClusters);
    }

    public List getNotGuideContentClusters() {
        return this._extractNotGuideConditions(this.contentClusters);
    }

    public void setContentClusters(List theContentClusters) {
        this.contentClusters = theContentClusters;
    }

    public List getContentFamilies() {
        return this.contentFamilies;
    }

    public List getGuideContentFamilies() {
        return this._extractGuideConditions(this.contentFamilies);
    }

    public List getNotGuideContentFamilies() {
        return this._extractNotGuideConditions(this.contentFamilies);
    }

    public void setContentFamilies(List theContentFamilies) {
        this.contentFamilies = theContentFamilies;
    }

    public List getContentTypes() {
        return this.contentTypes;
    }

    public List getContentExcludedTypes() {
        return this.contentExcludedTypes;
    }

    public List getGuideContentTypes() {
        return this._extractGuideConditions(this.contentTypes);
    }

    public List getNotGuideContentTypes() {
        return this._extractNotGuideConditions(this.contentTypes);
    }

    public void setContentTypes(List theContentTypes) {
        this.contentTypes = theContentTypes;
    }

    public void setContentExcludedTypes(List theContentExcludedTypes) {
        this.contentExcludedTypes = theContentExcludedTypes;
    }

    public List getServers() {
        return this.servers;
    }

    public void setServers(List theServers) {
        this.servers = theServers;
    }

    public List getDataRepositories() {
        return this.dataRepositories;
    }

    public void setDataRepositories(List theDataRepository) {
        this.dataRepositories = theDataRepository;
    }

    public List getAreas() {
        return this.areas;
    }

    public void setAreas(List theAreas) {
        this.areas = theAreas;
    }

    public List getWorkAreas() {
        return this.workAreas;
    }

    public void setWorkAreas(List theWorkAreas) {
        this.workAreas = theWorkAreas;
    }

    public boolean isSearchByDefaultLang() {
        return this.searchByDefaultLang;
    }

    public void setSearchByDefaultLang(boolean theSearchByDefaultLang) {
        this.searchByDefaultLang = theSearchByDefaultLang;
    }

    public List getPublishRepositories() {
        return this.publishRepositories;
    }

    public void setPublishRepositories(List thePublishRepositories) {
        this.publishRepositories = thePublishRepositories;
        this.publishedItemsOnly = this.publishedItemsOnly || this.publishRepositories != null && !this.publishRepositories.isEmpty();
    }

    public boolean isPublishedItemsOnly() {
        return this.publishedItemsOnly;
    }

    public void setPublishedItemsOnly(boolean thePublishedItemsOnly) {
        this.publishedItemsOnly = thePublishedItemsOnly;
    }

    public boolean validate() {
        if (this.presentationProperties != null && this.presentationProperties.get(PRESENTATION_PAGE_SIZE) != null) {
            try {
                int pageSize = Integer.parseInt((String)this.presentationProperties.get(PRESENTATION_PAGE_SIZE));
                if (pageSize >= R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE) {
                    this.presentationProperties.put(PRESENTATION_PAGE_SIZE, new Integer(R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE));
                } else if (pageSize < 0) {
                    this.presentationProperties.remove(PRESENTATION_PAGE_SIZE);
                }
            }
            catch (NumberFormatException nfEx) {
                this.presentationProperties.remove(PRESENTATION_PAGE_SIZE);
            }
        }
        return true;
    }

    public void loadFromJson(JSONObject jObject) throws JSONException {
        if (jObject != null) {
            int i;
            JSONArray jArray;
            if (jObject.has("queryOid")) {
                this.queryOid = jObject.getString("queryOid");
            }
            if (jObject.has("modified")) {
                this.modified = jObject.getBoolean("modified");
            }
            if (jObject.has("searchEngineId")) {
                this.searchEngineId = jObject.getString("searchEngineId");
            }
            if (jObject.has("context")) {
                this.context = jObject.getString("context");
            }
            if (jObject.has("queryName")) {
                this.queryName = jObject.getString("queryName");
            }
            if (jObject.has("queryDescription")) {
                this.queryDescription = jObject.getString("queryDescription");
            }
            if (jObject.has("saveQuery")) {
                this.saveQuery = jObject.getBoolean("saveQuery");
            }
            if (jObject.has("isFullTextSearch")) {
                this.isFullTextSearch = jObject.getBoolean("isFullTextSearch");
            }
            if (jObject.has("allResultsInAPage")) {
                this.allResultsInAPage = jObject.getBoolean("allResultsInAPage");
            }
            if (jObject.has("returnDocuments")) {
                this.returnDocuments = jObject.getBoolean("returnDocuments");
            }
            if (jObject.has("returnDataFiles")) {
                this.returnDataFiles = jObject.getBoolean("returnDataFiles");
            }
            if (jObject.has("returnAttachments")) {
                this.returnAttachments = jObject.getBoolean("returnAttachments");
            }
            if (jObject.has("returnLinkedDocuments")) {
                this.returnLinkedDocuments = jObject.getBoolean("returnLinkedDocuments");
            }
            if (jObject.has("status")) {
                this.status = jObject.getString("status");
            }
            if (jObject.has("publishedItemsOnly")) {
                this.publishedItemsOnly = jObject.getBoolean("publishedItemsOnly");
            }
            if (jObject.has("onlyNotPublished")) {
                this.onlyNotPublished = jObject.getBoolean("onlyNotPublished");
            }
            if (jObject.has("documentUIState")) {
                this.documentUIState = jObject.getInt("documentUIState");
            }
            if (jObject.has("searchByDefaultLang")) {
                this.searchByDefaultLang = jObject.getBoolean("searchByDefaultLang");
            }
            if (jObject.has("presentationProperties")) {
                this._loadPresentationProperties(jObject.getJSONArray("presentationProperties"));
            }
            if (jObject.has("publishRepositories") && (jArray = (JSONArray)jObject.get("publishRepositories")) != null && jArray.length() > 0) {
                this.publishRepositories = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.publishRepositories.add(R01MQueryObjectJsonUtils.loadSearchedPublishRepositoryFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("servers") && (jArray = (JSONArray)jObject.get("servers")) != null && jArray.length() > 0) {
                this.servers = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.servers.add(R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("dataRepositories") && (jArray = (JSONArray)jObject.get("dataRepositories")) != null && jArray.length() > 0) {
                this.dataRepositories = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.dataRepositories.add(R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("areas") && (jArray = (JSONArray)jObject.get("areas")) != null && jArray.length() > 0) {
                this.areas = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.areas.add(R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("areas") && (jArray = (JSONArray)jObject.get("areas")) != null && jArray.length() > 0) {
                this.areas = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.areas.add(R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("workAreas") && (jArray = (JSONArray)jObject.get("workAreas")) != null && jArray.length() > 0) {
                this.workAreas = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.workAreas.add(R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("contentClusters") && (jArray = (JSONArray)jObject.get("contentClusters")) != null && jArray.length() > 0) {
                this.contentClusters = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.contentClusters.add(R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("contentFamilies") && (jArray = (JSONArray)jObject.get("contentFamilies")) != null && jArray.length() > 0) {
                this.contentFamilies = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.contentFamilies.add(R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("contentTypes") && (jArray = (JSONArray)jObject.get("contentTypes")) != null && jArray.length() > 0) {
                this.contentTypes = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.contentTypes.add(R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("contentExcludedTypes") && (jArray = (JSONArray)jObject.get("contentExcludedTypes")) != null && jArray.length() > 0) {
                this.contentExcludedTypes = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.contentExcludedTypes.add(R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("searchedMetaData") && (jArray = (JSONArray)jObject.get("searchedMetaData")) != null && jArray.length() > 0) {
                this.searchedMetaData = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.searchedMetaData.add(R01MQueryObjectJsonUtils.loadSearchedMetaDataFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("orSearchedMetaData") && (jArray = (JSONArray)jObject.get("orSearchedMetaData")) != null && jArray.length() > 0) {
                this.orSearchedMetaData = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.orSearchedMetaData.add(R01MQueryObjectJsonUtils.loadSearchedMetaDataFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("catalogLabelsAnd") && (jArray = (JSONArray)jObject.get("catalogLabelsAnd")) != null && jArray.length() > 0) {
                this.catalogLabelsAnd = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.catalogLabelsAnd.add(R01MQueryObjectJsonUtils.loadSearchedStructureCatalogFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("catalogLabelsOr") && (jArray = (JSONArray)jObject.get("catalogLabelsOr")) != null && jArray.length() > 0) {
                this.catalogLabelsOr = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.catalogLabelsOr.add(R01MQueryObjectJsonUtils.loadSearchedStructureCatalogFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("geoCatalogsAnd") && (jArray = (JSONArray)jObject.get("geoCatalogsAnd")) != null && jArray.length() > 0) {
                this.geoCatalogsAnd = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.geoCatalogsAnd.add(R01MQueryObjectJsonUtils.loadSearchedGeoCatalogFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("geoCatalogsOr") && (jArray = (JSONArray)jObject.get("geoCatalogsOr")) != null && jArray.length() > 0) {
                this.geoCatalogsOr = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.geoCatalogsOr.add(R01MQueryObjectJsonUtils.loadSearchedGeoCatalogFromJson((JSONObject)jArray.get(i)));
                }
            }
            if (jObject.has("orderBy") && (jArray = (JSONArray)jObject.get("orderBy")) != null && jArray.length() > 0) {
                this.orderBy = new ArrayList();
                for (i = 0; i < jArray.length(); ++i) {
                    this.orderBy.add(R01MQueryObjectJsonUtils.loadSearchedOrderByMetaDataFromJson((JSONObject)jArray.get(i)));
                }
            }
        }
    }

    public void loadFromJson(String jObject) throws JSONException {
        try {
            this.loadFromJson(new JSONObject(jObject));
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.loadFromJson(new JSONObject());
        }
    }

    public JSONObject loadToJson() throws JSONException {
        int i;
        JSONArray jArray;
        JSONObject jObject = new JSONObject();
        jObject.put("queryOid", (Object)this.queryOid);
        jObject.put("modified", this.modified);
        jObject.put("searchEngineId", (Object)this.searchEngineId);
        jObject.put("context", (Object)this.context);
        jObject.put("queryName", (Object)this.queryName);
        jObject.put("queryDescription", (Object)this.queryDescription);
        jObject.put("saveQuery", this.saveQuery);
        jObject.put("isFullTextSearch", this.isFullTextSearch);
        jObject.put("allResultsInAPage", this.allResultsInAPage);
        jObject.put("returnDocuments", this.returnDocuments);
        jObject.put("returnDataFiles", this.returnDataFiles);
        jObject.put("returnAttachments", this.returnAttachments);
        jObject.put("returnLinkedDocuments", this.returnLinkedDocuments);
        jObject.put("status", (Object)this.status);
        jObject.put("publishedItemsOnly", this.publishedItemsOnly);
        jObject.put("onlyNotPublished", this.onlyNotPublished);
        jObject.put("documentUIState", this.documentUIState);
        jObject.put("searchByDefaultLang", this.searchByDefaultLang);
        jObject.put("presentationProperties", (Object)this._loadPresentationPropertiesToJson());
        if (this.publishRepositories != null && !this.publishRepositories.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.publishRepositories.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedPublishRepositoryToJson((R01MSearchedPublishRepository)this.publishRepositories.get(i)));
            }
            jObject.put("publishRepositories", (Object)jArray);
        }
        if (this.servers != null && !this.servers.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.servers.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjToJson((R01MSearchedServer)this.servers.get(i)));
            }
            jObject.put("servers", (Object)jArray);
        }
        if (this.dataRepositories != null && !this.dataRepositories.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.dataRepositories.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjToJson((R01MSearchedDataRepository)this.dataRepositories.get(i)));
            }
            jObject.put("dataRepositories", (Object)jArray);
        }
        if (this.areas != null && !this.areas.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.areas.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjToJson((R01MSearchedDataRepository)this.areas.get(i)));
            }
            jObject.put("areas", (Object)jArray);
        }
        if (this.workAreas != null && !this.workAreas.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.workAreas.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedStorageObjToJson((R01MSearchedDataRepository)this.workAreas.get(i)));
            }
            jObject.put("workAreas", (Object)jArray);
        }
        if (this.contentClusters != null && !this.contentClusters.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.contentClusters.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjToJson((R01MSearchedCluster)this.contentClusters.get(i)));
            }
            jObject.put("contentClusters", (Object)jArray);
        }
        if (this.contentFamilies != null && !this.contentFamilies.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.contentFamilies.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjToJson((R01MSearchedFamily)this.contentFamilies.get(i)));
            }
            jObject.put("contentFamilies", (Object)jArray);
        }
        if (this.contentTypes != null && !this.contentTypes.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.contentTypes.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjToJson((R01MSearchedContentType)this.contentTypes.get(i)));
            }
            jObject.put("contentTypes", (Object)jArray);
        }
        if (this.contentExcludedTypes != null && !this.contentExcludedTypes.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.contentExcludedTypes.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadBaseSearchedTypoObjToJson((R01MSearchedContentType)this.contentExcludedTypes.get(i)));
            }
            jObject.put("contentTypes", (Object)jArray);
        }
        if (this.searchedMetaData != null && !this.searchedMetaData.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.searchedMetaData.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedMetaDataToJson((R01MSearchedMetaData)this.searchedMetaData.get(i)));
            }
            jObject.put("searchedMetaData", (Object)jArray);
        }
        if (this.orSearchedMetaData != null && !this.orSearchedMetaData.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.orSearchedMetaData.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedMetaDataToJson((R01MSearchedMetaData)this.orSearchedMetaData.get(i)));
            }
            jObject.put("orSearchedMetaData", (Object)jArray);
        }
        if (this.catalogLabelsAnd != null && !this.catalogLabelsAnd.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.catalogLabelsAnd.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedStructureCatalogToJson((R01MSearchedStructureCatalog)this.catalogLabelsAnd.get(i)));
            }
            jObject.put("catalogLabelsAnd", (Object)jArray);
        }
        if (this.catalogLabelsOr != null && !this.catalogLabelsOr.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.catalogLabelsOr.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedStructureCatalogToJson((R01MSearchedStructureCatalog)this.catalogLabelsOr.get(i)));
            }
            jObject.put("catalogLabelsOr", (Object)jArray);
        }
        if (this.geoCatalogsAnd != null && !this.geoCatalogsAnd.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.geoCatalogsAnd.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedGeoCatalogToJson((R01MSearchedGeoCatalog)this.geoCatalogsAnd.get(i)));
            }
            jObject.put("geoCatalogsAnd", (Object)jArray);
        }
        if (this.geoCatalogsOr != null && !this.geoCatalogsOr.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.geoCatalogsOr.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedGeoCatalogToJson((R01MSearchedGeoCatalog)this.geoCatalogsOr.get(i)));
            }
            jObject.put("geoCatalogsOr", (Object)jArray);
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            jArray = new JSONArray();
            for (i = 0; i < this.orderBy.size(); ++i) {
                jArray.put((Object)R01MQueryObjectJsonUtils.loadSearchedOrderByMetaDataToJson((R01MSearchedOrderByMetaData)this.orderBy.get(i)));
            }
            jObject.put("orderBy", (Object)jArray);
        }
        return jObject;
    }

    private JSONArray _loadPresentationPropertiesToJson() throws JSONException {
        JSONArray jArray = new JSONArray();
        if (this.presentationProperties != null && !this.presentationProperties.isEmpty()) {
            for (Map.Entry ent : this.presentationProperties.entrySet()) {
                JSONObject jObject = new JSONObject();
                jObject.put("key", ent.getKey());
                jObject.put("value", ent.getValue());
                jArray.put((Object)jObject);
            }
        }
        return jArray;
    }

    private void _loadPresentationProperties(JSONArray jArray) throws JSONException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (jArray != null && jArray.length() > 0) {
            for (int i = 0; i < jArray.length(); ++i) {
                JSONObject jObject = (JSONObject)jArray.get(i);
                try {
                    m.put(jObject.getString("key"), jObject.getString("value"));
                    continue;
                }
                catch (JSONException ex) {
                    m.put(jObject.getString("key"), "");
                }
            }
        }
        this.presentationProperties = m;
    }

    private List _extractGuideConditions(List conds) {
        ArrayList<R01MBaseSearchedObj> outConds = new ArrayList<R01MBaseSearchedObj>();
        if (conds != null) {
            R01MBaseSearchedObj searchedObj2 = null;
            for (R01MBaseSearchedObj searchedObj2 : conds) {
                if (searchedObj2.guideCondition == null) continue;
                outConds.add(searchedObj2);
            }
        }
        if (outConds.isEmpty()) {
            return null;
        }
        return outConds;
    }

    private List _extractNotGuideConditions(List conds) {
        ArrayList<R01MBaseSearchedObj> outConds = new ArrayList<R01MBaseSearchedObj>();
        if (conds != null) {
            R01MBaseSearchedObj searchedObj2 = null;
            for (R01MBaseSearchedObj searchedObj2 : conds) {
                if (searchedObj2.guideCondition != null) continue;
                outConds.add(searchedObj2);
            }
        }
        if (outConds.isEmpty()) {
            return null;
        }
        return outConds;
    }

    private boolean _listContains(List theList, R01MBaseSearchedObj theObj) {
        if (theList != null && !theList.isEmpty()) {
            R01MBaseSearchedObj currSearchedObj2 = null;
            for (R01MBaseSearchedObj currSearchedObj2 : theList) {
                if (!currSearchedObj2.equalsTo(theObj)) continue;
                return true;
            }
        }
        return false;
    }
}

