/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.metadataprocessors;

import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MFamilyStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MTypeStorageConfig;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.metadataprocessors.R01MMetaDataProcessor;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import java.util.HashMap;
import java.util.Map;

public class R01MMetaDataProcessorImpl
implements R01MMetaDataProcessor {
    private Map _metadataProcessorImplsCacheClassNameIndexed = null;

    @Override
    public void processIndexableContentMetaData(R01MSearchMetaDataStorageConfig searchMetadataStorage, R01MIndexableContent idxCont) {
        String typeOid;
        String familyOid;
        if (idxCont == null || idxCont.getTypo() == null) {
            return;
        }
        String clusterOid = idxCont.getTypo().getCluster() != null ? idxCont.getTypo().getCluster().getOid() : null;
        R01MMetaDataProcessor[] mdProcessors = this._obtainMetaDataProcessors(searchMetadataStorage, clusterOid, familyOid = idxCont.getTypo().getFamily() != null ? idxCont.getTypo().getFamily().getOid() : null, typeOid = idxCont.getTypo().getType() != null ? idxCont.getTypo().getType().getOid() : null);
        if (mdProcessors != null) {
            for (int i = 0; i < mdProcessors.length; ++i) {
                if (mdProcessors[i] == null) continue;
                mdProcessors[i].processIndexableContentMetaData(searchMetadataStorage, idxCont);
            }
        }
    }

    @Override
    public void processQueryObjectMetaData(R01MSearchMetaDataStorageConfig searchMetadataStorage, R01MQueryObject qry) {
        String typeOid;
        String familyOid;
        if (qry == null || qry.getContentFamilies() == null || qry.getMetaData() == null) {
            return;
        }
        String clusterOid = qry.getContentClusters() != null && !qry.getContentClusters().isEmpty() ? ((R01MSearchedCluster)qry.getContentClusters().get(0)).getOid() : null;
        R01MMetaDataProcessor[] mdProcessors = this._obtainMetaDataProcessors(searchMetadataStorage, clusterOid, familyOid = qry.getContentFamilies() != null && !qry.getContentFamilies().isEmpty() ? ((R01MSearchedFamily)qry.getContentFamilies().get(0)).getOid() : null, typeOid = qry.getContentTypes() != null && !qry.getContentTypes().isEmpty() ? ((R01MSearchedContentType)qry.getContentTypes().get(0)).getOid() : null);
        if (mdProcessors != null) {
            for (int i = 0; i < mdProcessors.length; ++i) {
                if (mdProcessors[i] == null) continue;
                mdProcessors[i].processQueryObjectMetaData(searchMetadataStorage, qry);
            }
        }
    }

    @Override
    public void processSearchResultItemMetaData(R01MSearchMetaDataStorageConfig searchMetadataStorage, R01MSearchResultItem item) {
        String typeOid;
        String familyOid;
        if (item == null || item.getContentTypology() == null) {
            return;
        }
        String clusterOid = item.getContentTypology().getClusterOid() != null ? item.getContentTypology().getClusterOid() : null;
        R01MMetaDataProcessor[] mdProcessors = this._obtainMetaDataProcessors(searchMetadataStorage, clusterOid, familyOid = item.getContentTypology().getFamilyOid() != null ? item.getContentTypology().getFamilyOid() : null, typeOid = item.getContentTypology().getTypeOid() != null ? item.getContentTypology().getTypeOid() : null);
        if (mdProcessors != null) {
            for (int i = 0; i < mdProcessors.length; ++i) {
                if (mdProcessors[i] == null) continue;
                mdProcessors[i].processSearchResultItemMetaData(searchMetadataStorage, item);
            }
        }
        boolean isMainDataFile = this._isSearchResultItemTheMainDataFile(item);
        item.setDocumentMainDataFile(isMainDataFile);
    }

    private R01MMetaDataProcessor[] _obtainMetaDataProcessors(R01MSearchMetaDataStorageConfig searchMetadataStorage, String clusterOid, String familyOid, String typeOid) {
        R01MClusterStorageConfig clusterStorageCfg = null;
        R01MFamilyStorageConfig familyStorageCfg = null;
        R01MTypeStorageConfig typeStorageCfg = null;
        if (clusterOid != null) {
            clusterStorageCfg = searchMetadataStorage.getClusterStorageCfg(clusterOid);
        }
        if (familyOid != null) {
            familyStorageCfg = searchMetadataStorage.getFamilyStorageConfig(clusterOid, familyOid);
        }
        if (typeOid != null) {
            typeStorageCfg = searchMetadataStorage.getTypeStorageConfig(clusterOid, familyOid, typeOid);
        }
        String clusterMetaDataProcessorClassName = clusterStorageCfg != null ? clusterStorageCfg.getMetaDataProcessorClassImpl() : null;
        String familyMetaDataProcessorClassName = familyStorageCfg != null ? familyStorageCfg.getMetaDataProcessorClassImpl() : null;
        String typeMetaDataProcessorClassName = typeStorageCfg != null ? typeStorageCfg.getMetaDataProcessorClassImpl() : null;
        R01MMetaDataProcessor clusterMetaDataProcessorImpl = clusterMetaDataProcessorClassName != null ? this._obtainMetaDataProcessorImpl(clusterMetaDataProcessorClassName) : null;
        R01MMetaDataProcessor familyMetaDataProcessorImpl = familyMetaDataProcessorClassName != null ? this._obtainMetaDataProcessorImpl(familyMetaDataProcessorClassName) : null;
        R01MMetaDataProcessor typeMetaDataProcessorImpl = typeMetaDataProcessorClassName != null ? this._obtainMetaDataProcessorImpl(typeMetaDataProcessorClassName) : null;
        return new R01MMetaDataProcessor[]{clusterMetaDataProcessorImpl, familyMetaDataProcessorImpl, typeMetaDataProcessorImpl};
    }

    private R01MMetaDataProcessor _obtainMetaDataProcessorImpl(String processorClassName) {
        R01MMetaDataProcessor mdProcessorImpl = this._metadataProcessorImplsCacheClassNameIndexed != null ? this._metadataProcessorImplsCacheClassNameIndexed.get(processorClassName) : null;
        try {
            if (mdProcessorImpl == null && (mdProcessorImpl = (R01MMetaDataProcessor)ReflectionUtils.getObjectInstance((String)processorClassName)) != null) {
                if (this._metadataProcessorImplsCacheClassNameIndexed == null) {
                    this._metadataProcessorImplsCacheClassNameIndexed = new HashMap();
                }
                this._metadataProcessorImplsCacheClassNameIndexed.put(processorClassName, mdProcessorImpl);
            }
        }
        catch (ReflectionException refEx) {
            refEx.printStackTrace(System.out);
        }
        return mdProcessorImpl;
    }

    private boolean _isSearchResultItemTheMainDataFile(R01MSearchResultItem item) {
        boolean isMainDataFileDefGenerated = false;
        if (item.documentWorkAreaRelativePath != null && item.documentMainDataFileDefaultGeneratedFileDocumentRelativePath != null && (item.realFileWorkAreaRelativePath != null || item.fileWorkAreaRelativePath != null)) {
            String itemFileWAPath;
            String mainDataFileGeneratedWAPath = item.documentWorkAreaRelativePath + "/" + item.documentMainDataFileDefaultGeneratedFileDocumentRelativePath;
            String string = itemFileWAPath = item.realFileWorkAreaRelativePath != null ? item.realFileWorkAreaRelativePath : item.fileWorkAreaRelativePath;
            if (mainDataFileGeneratedWAPath.charAt(0) == '/') {
                mainDataFileGeneratedWAPath = mainDataFileGeneratedWAPath.substring(1);
            }
            if (itemFileWAPath.charAt(0) == '/') {
                itemFileWAPath = itemFileWAPath.substring(1);
            }
            isMainDataFileDefGenerated = mainDataFileGeneratedWAPath.equals(itemFileWAPath);
        }
        return isMainDataFileDefGenerated;
    }
}

