/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.indexer.datafilemetadataextractors;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.utils.XMLParserHelper;
import com.ejie.r01f.xml.utils.XMLSerializerHelper;
import com.ejie.r01m.objects.searchengine.indexer.datafilemetadataextractors.R01MDataFileMetaDataExtractor;
import com.ejie.r01m.objects.searchengine.indexer.datafilemetadataextractors.R01MDataFileMetaDataToExtract;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class R01MDataFileMetaDataExtractorUtils {
    public static Document parseDCR(InputStream dcrIs) throws SAXException {
        return XMLParserHelper.parseXML((InputStream)dcrIs, (boolean)true);
    }

    public static String serializeDCR(Document dcrDoc, String outEncoding) throws TransformerException {
        return XMLSerializerHelper.getXML((Node)dcrDoc, (String)outEncoding);
    }

    public static Map<String, String> extractDataFileMetaData(Document dfDoc, Map<String, R01MDataFileMetaDataToExtract> metaDataToExtractInfo) {
        if (metaDataToExtractInfo == null || metaDataToExtractInfo.isEmpty()) {
            return null;
        }
        HashMap<String, String> outMetaDataValues = new HashMap<String, String>(metaDataToExtractInfo.size());
        R01MDataFileMetaDataToExtract currMDtoExtractData = null;
        for (Map.Entry<String, R01MDataFileMetaDataToExtract> xme : metaDataToExtractInfo.entrySet()) {
            currMDtoExtractData = xme.getValue();
            if (currMDtoExtractData == null) continue;
            try {
                R01MDataFileMetaDataExtractor extractor = (R01MDataFileMetaDataExtractor)ReflectionUtils.getObjectInstance((String)currMDtoExtractData.metaDataExtractorImplClassName);
                String currMDValue = extractor.extractMetaData(dfDoc, currMDtoExtractData);
                if (currMDValue == null) continue;
                outMetaDataValues.put(currMDtoExtractData.metaDataOid, currMDValue);
            }
            catch (ReflectionException ex) {
                ex.printStackTrace(System.out);
            }
        }
        return outMetaDataValues;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                String dcr = StringUtils.loadFromFile((String)"c:/dcr.xml");
                Document dcrDoc = R01MDataFileMetaDataExtractorUtils.parseDCR(new ByteArrayInputStream(dcr.getBytes()));
                R01FLog.to((String)"r01m.test").info(dcrDoc.getNodeName());
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to((String)"r01m.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

