/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MRispDocument
implements Serializable {
    private static final long serialVersionUID = -7562167727656252709L;
    public static final String TYPE_UNKNOWN = "unknown";
    public static final String TYPE_ZIP = "zip";
    public static final String TYPE_THINZIP = "zipThin";
    public static final String TYPE_XML = "xml";
    public static final String TYPE_CSV = "csv";
    public static final String TYPE_XLS = "xls";
    public static final String TYPE_WMS = "wms";
    private String type = "unknown";
    private String size = null;
    private String contentRelativePath = null;
    private String units = null;

    public R01MRispDocument() {
    }

    public R01MRispDocument(String newType, String newContentRelativePath, String newSize) {
        this(newType, newContentRelativePath, newSize, null);
    }

    public R01MRispDocument(String newType, String newContentRelativePath, String newSize, String newUnits) {
        this();
        this.type = newType;
        this.contentRelativePath = newContentRelativePath;
        this.size = newSize;
        this.units = newUnits;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String theType) {
        this.type = theType;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String theSize) {
        this.size = theSize;
    }

    public String getContentRelativePath() {
        return this.contentRelativePath;
    }

    public void setContentRelativePath(String theContentRelativePath) {
        this.contentRelativePath = theContentRelativePath;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String theUnits) {
        this.units = theUnits;
    }

    public String toString() {
        return this.type + ";" + this.contentRelativePath + "," + this.size;
    }

    public JSONObject composeJSONObject() {
        JSONObject jObject = new JSONObject();
        try {
            jObject.put("tipo", (Object)this.getType());
            jObject.put("path", (Object)this.getContentRelativePath());
            jObject.put("tamanio", (Object)this.getSize());
            if (this.getUnits() == null) {
                jObject.put("unidades", (Object)"");
            } else {
                jObject.put("unidades", (Object)this.getUnits());
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace(System.out);
        }
        return jObject;
    }

    public static String mapObjectsToJsonString(Map<String, R01MRispDocument> theMap) {
        JSONArray jArray = new JSONArray();
        if (theMap != null) {
            for (Map.Entry<String, R01MRispDocument> me : theMap.entrySet()) {
                jArray.put((Object)me.getValue().composeJSONObject());
            }
        }
        return jArray.toString();
    }

    public static Map<String, StringBuffer> jsonArrayToMap(String jString) {
        JSONArray jArray;
        HashMap<String, StringBuffer> theMap = new HashMap<String, StringBuffer>();
        if (!jString.substring(0, 1).equals("[") || !jString.substring(jString.length() - 1, jString.length()).equals("]")) {
            return null;
        }
        try {
            jArray = new JSONArray(jString);
        }
        catch (JSONException ex1) {
            Pattern p1 = Pattern.compile("\\{([^\\{\\}]*)\\}");
            Matcher m1 = p1.matcher(jString);
            jArray = new JSONArray();
            while (m1.find()) {
                String JObjectString = m1.group(0);
                Pattern p2 = Pattern.compile("([^:,\\{\\}]*):([^,\\{\\}]*)");
                Matcher m2 = p2.matcher(JObjectString);
                JSONObject jObjectAutonomy = new JSONObject();
                while (m2.find()) {
                    try {
                        jObjectAutonomy.put(m2.group(1).trim(), (Object)m2.group(2).trim());
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                jArray.put((Object)jObjectAutonomy);
            }
        }
        try {
            if (jArray != null && jArray.length() > 0) {
                for (int i = 0; i < jArray.length(); ++i) {
                    JSONObject jObject = (JSONObject)jArray.get(i);
                    StringBuffer rispValue = new StringBuffer();
                    if (jObject.has("path")) {
                        rispValue.append(jObject.getString("path"));
                        rispValue.append(',');
                    }
                    if (jObject.has("tamanio")) {
                        rispValue.append(jObject.getString("tamanio"));
                        rispValue.append(',');
                    }
                    if (jObject.has("unidades")) {
                        rispValue.append(jObject.getString("unidades"));
                    }
                    if (!jObject.has("tipo")) continue;
                    theMap.put(jObject.getString("tipo"), rispValue);
                }
            }
        }
        catch (JSONException ex) {
            theMap = null;
            ex.printStackTrace(System.out);
        }
        return theMap;
    }

    public void loadFromJson(JSONObject jObject) {
        try {
            if (jObject.has("tipo")) {
                this.type = jObject.getString("tipo");
            }
            if (jObject.has("path")) {
                this.contentRelativePath = jObject.getString("path");
            }
            if (jObject.has("tamanio")) {
                this.size = jObject.getString("tamanio");
            }
            if (jObject.has("unidades")) {
                this.units = jObject.getString("unidades");
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace(System.out);
        }
    }
}

