/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.indexer;

import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDataFile;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocumentLinkedData;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableMetaData;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePublicationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class R01MIndexableDocument
extends R01MBaseIndexableObject
implements Serializable {
    private static final long serialVersionUID = -6759943549116142479L;
    private float boosting = 1.0f;
    private Date scoreDate;
    private int approvalStatus;
    private List<R01MIndexablePublicationInfo> publicationInfo;
    private String language;
    private String depthLevel;
    private Map<String, R01MIndexableDataFile> dataFiles;
    private String contentRelativePath;
    private R01MIndexableDocumentLinkedData documentLinkedData = new R01MIndexableDocumentLinkedData();
    private String tags;
    private Date portalDataInitDate;
    private Date portalDataEndDate;
    private String portalDataDocumentSEOName = "";
    private String portalDataDocumentSEODescription = "";
    private String mainFriendlyURL;
    private Map<String, Map<String, String>> urlsByLanguage;
    private Map<String, Map<String, String>> friendlyUrlsByLanguage;

    public R01MIndexableDocument() {
        this.setObjectType(1);
    }

    public R01MIndexableDocument(String theOid) {
        this.setObjectType(1);
        this.setOid(theOid);
    }

    public float getBoosting() {
        return this.boosting;
    }

    public void setBoosting(float theBoosting) {
        this.boosting = theBoosting;
    }

    public Date getScoreDate() {
        return this.scoreDate;
    }

    public void setScoreDate(Date theScoreDate) {
        this.scoreDate = theScoreDate;
    }

    public int getApprovalStatus() {
        return this.approvalStatus;
    }

    public void setApprovalStatus(int theApprovalStatus) {
        this.approvalStatus = theApprovalStatus;
    }

    public List<R01MIndexablePublicationInfo> getPublicationInfo() {
        return this.publicationInfo;
    }

    public void setPublicationInfo(List<R01MIndexablePublicationInfo> thePublicationInfo) {
        this.publicationInfo = thePublicationInfo;
    }

    public boolean isPublishedInRepository(String repOid) {
        if (repOid == null) {
            return false;
        }
        boolean isPublished = false;
        List<R01MIndexablePublicationInfo> publications = this.getPublicationInfo();
        if (publications != null && !publications.isEmpty()) {
            ArrayList<R01MIndexablePublicationInfo> targetPublications = new ArrayList<R01MIndexablePublicationInfo>();
            for (R01MIndexablePublicationInfo publicacion : publications) {
                if (!publicacion.getRepositoryOid().equals(repOid)) continue;
                targetPublications.add(publicacion);
            }
            if (!targetPublications.isEmpty()) {
                for (R01MIndexablePublicationInfo pub1 : targetPublications) {
                    if (pub1.getState() != 1) continue;
                    boolean isUnpublished = false;
                    for (R01MIndexablePublicationInfo pub2 : targetPublications) {
                        if (!pub1.getRepositoryOid().equals(pub2.getRepositoryOid()) || pub2.getState() != 0) continue;
                        isUnpublished = true;
                        if (!pub1.getPublishDate().after(pub2.getPublishDate())) break;
                        isPublished = true;
                        break;
                    }
                    if (isUnpublished) continue;
                    isPublished = true;
                    break;
                }
            }
        }
        return isPublished;
    }

    public boolean isPublished() {
        List<R01MIndexablePublicationInfo> publications = this.getPublicationInfo();
        Date lastDate = null;
        int lastState = -1;
        if (publications != null && !publications.isEmpty()) {
            for (R01MIndexablePublicationInfo publication : publications) {
                if (lastDate != null && (!lastDate.before(publication.getPublishDate()) || publication.getState() == 4 || publication.getState() == 5)) continue;
                lastDate = publication.getPublishDate();
                lastState = publication.getState();
            }
        }
        return lastState == 1 || lastState == 3;
    }

    public String getDepthLevel() {
        return this.depthLevel;
    }

    public void setDepthLevel(String theDepthLevel) {
        this.depthLevel = theDepthLevel;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String theLanguage) {
        this.language = theLanguage;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String theTags) {
        this.tags = theTags;
    }

    public Date getPortalDataInitDate() {
        return this.portalDataInitDate;
    }

    public void setPortalDataInitDate(Date thePortalDataInitDate) {
        this.portalDataInitDate = thePortalDataInitDate;
    }

    public Date getPortalDataEndDate() {
        return this.portalDataEndDate;
    }

    public void setPortalDataEndDate(Date thePortalDataEndDate) {
        this.portalDataEndDate = thePortalDataEndDate;
    }

    public String getPortalDataDocumentSEOName() {
        return this.portalDataDocumentSEOName;
    }

    public void setPortalDataDocumentSEOName(String thePortalDataDocumentSEOName) {
        this.portalDataDocumentSEOName = thePortalDataDocumentSEOName;
    }

    public String getPortalDataDocumentSEODescription() {
        return this.portalDataDocumentSEODescription;
    }

    public void setPortalDataDocumentSEODescription(String thePortalDataDocumentSEODescription) {
        this.portalDataDocumentSEODescription = thePortalDataDocumentSEODescription;
    }

    public String getMainFriendlyURL() {
        return this.mainFriendlyURL;
    }

    public void setMainFriendlyURL(String theMainFriendlyURL) {
        this.mainFriendlyURL = theMainFriendlyURL;
    }

    public Map<String, Map<String, String>> getUrlsByLanguage() {
        return this.urlsByLanguage;
    }

    public void setUrlsByLanguage(Map<String, Map<String, String>> theUrlsByLanguage) {
        this.urlsByLanguage = theUrlsByLanguage;
    }

    public Map<String, Map<String, String>> getFriendlyUrlsByLanguage() {
        return this.friendlyUrlsByLanguage;
    }

    public void setFriendlyUrlsByLanguage(Map<String, Map<String, String>> theFriendlyUrlsByLanguage) {
        this.friendlyUrlsByLanguage = theFriendlyUrlsByLanguage;
    }

    public Map<String, R01MIndexableDataFile> getDataFiles() {
        return this.dataFiles;
    }

    public void setDataFiles(Map<String, R01MIndexableDataFile> theDataFiles) {
        this.dataFiles = theDataFiles;
    }

    public void addDataFile(R01MIndexableDataFile theDataFile) {
        if (this.dataFiles == null) {
            this.dataFiles = new HashMap<String, R01MIndexableDataFile>();
        }
        this.dataFiles.put(theDataFile.getOid(), theDataFile);
    }

    public R01MIndexableDataFile getDataFile(String dataFileOid) {
        return this.dataFiles == null ? null : this.dataFiles.get(dataFileOid);
    }

    public R01MIndexableDataFile getMainDataFile() {
        if (this.dataFiles == null) {
            return null;
        }
        R01MIndexableDataFile mainDataFile = null;
        for (R01MIndexableDataFile currDF : this.dataFiles.values()) {
            if (!currDF.isMainDataFile()) continue;
            mainDataFile = currDF;
            break;
        }
        return mainDataFile;
    }

    public R01MIndexableDataFile[] getMetaDataContainerDataFiles() {
        if (this.dataFiles == null) {
            return null;
        }
        ArrayList<R01MIndexableDataFile> metaDataContainerDataFiles = new ArrayList<R01MIndexableDataFile>();
        for (R01MIndexableDataFile currDF : this.dataFiles.values()) {
            if (!currDF.isMetaDataContainer()) continue;
            metaDataContainerDataFiles.add(currDF);
        }
        return metaDataContainerDataFiles.toArray(new R01MIndexableDataFile[metaDataContainerDataFiles.size()]);
    }

    public String getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() {
        R01MIndexableDataFile mainDf = this.getMainDataFile();
        if (mainDf == null) {
            return null;
        }
        return mainDf.getDefaultTemplateGeneratedFileDocumentRelativePath();
    }

    public Map<String, String> getDocumentMainDataFileGeneratedFilesDocumentRelativePaths() {
        R01MIndexableDataFile mainDf = this.getMainDataFile();
        if (mainDf == null) {
            return null;
        }
        return mainDf.getGeneratedFilesDocumentRelativePaths();
    }

    public Map<String, R01MIndexableMetaData> getMetaData() {
        HashMap<String, R01MIndexableMetaData> metaData = new HashMap<String, R01MIndexableMetaData>();
        Map<String, R01MIndexableDataFile> docDFs = this.getDataFiles();
        if (docDFs != null) {
            for (R01MIndexableDataFile idxDf : docDFs.values()) {
                if (!idxDf.isMetaDataContainer() || idxDf.getMetaData() == null || idxDf.getMetaData().size() <= 0) continue;
                for (Map.Entry<String, R01MIndexableMetaData> mdME : idxDf.getMetaData().entrySet()) {
                    metaData.put(mdME.getKey(), mdME.getValue());
                }
            }
        }
        return metaData;
    }

    public Map<String, Object> getDocumentCommonMetaData() {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("approvalStatus", Integer.toString(this.approvalStatus));
        metaData.put("publicationInfo", this.publicationInfo);
        metaData.put("language", this.language);
        metaData.put("depthLevel", this.depthLevel);
        metaData.put("contentRelativePath", this.contentRelativePath);
        metaData.put("tags", this.tags);
        metaData.put("portalDataInitDate", this.portalDataInitDate);
        metaData.put("portalDataEndDate", this.portalDataEndDate);
        metaData.put("portalDataDocumentSEOName", this.portalDataDocumentSEOName);
        metaData.put("portalDataDocumentSEODescription", this.portalDataDocumentSEODescription);
        metaData.put("mainFriendlyURL", this.mainFriendlyURL);
        metaData.put("documentLinkedData", this.documentLinkedData);
        metaData.put("urlsByLanguage", this.urlsByLanguage);
        metaData.put("friendlyUrlsByLanguage", this.friendlyUrlsByLanguage);
        return metaData;
    }

    public String getContentRelativePath() {
        return this.contentRelativePath;
    }

    public void setContentRelativePath(String theContentRelativePath) {
        this.contentRelativePath = theContentRelativePath;
    }

    public R01MIndexableDocumentLinkedData getDocumentLinkedData() {
        return this.documentLinkedData;
    }

    public void setDocumentLinkedData(R01MIndexableDocumentLinkedData theDocumentLinkedData) {
        this.documentLinkedData = theDocumentLinkedData;
    }
}

