/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.indexer;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MIndexerModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseObject;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.R01MValidateInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import weblogic.utils.ArrayUtils;

public class R01MIndexDefinition
extends R01MBaseObject
implements R01MPrintableInterface,
R01MValidateInterface,
Serializable {
    private static final long serialVersionUID = -1054083911820762499L;
    private int indexType;
    private String objectOid;
    private int objectType;
    private List<String> metadataFileNames;
    private boolean publishIndexData;
    private int publicationType;
    private Date publicationDate;
    private List<String> repositoryOids;
    private String indexFilesToPublish = "";
    private List<String> indexers;
    private int iteration;

    public R01MIndexDefinition() {
    }

    public R01MIndexDefinition(int theIndexType, String theObjectOid, int theObjectType, List<String> theMetadataFileNames, List<String> theIndexers, boolean thePublishIndexData, int thePublicationType, Date thePublicationDate, List<String> theRepositoryOids, String theIndexFilesToPublish) {
        this.indexType = theIndexType;
        this.objectOid = theObjectOid;
        this.objectType = theObjectType;
        this.metadataFileNames = theMetadataFileNames;
        this.indexers = theIndexers;
        this.publishIndexData = thePublishIndexData;
        this.publicationType = thePublicationType;
        this.publicationDate = thePublicationDate;
        this.repositoryOids = theRepositoryOids;
        this.indexFilesToPublish = theIndexFilesToPublish;
        this.iteration = 0;
    }

    public R01MIndexDefinition(int theIndexType, String theObjectOid, int theObjectType, List<String> theMetadataFileNames, List<String> theIndexers, boolean thePublishIndexData, int thePublicationType, Date thePublicationDate, List<String> theRepositoryOids, String theIndexFilesToPublish, int theIndexIteration) {
        this.indexType = theIndexType;
        this.objectOid = theObjectOid;
        this.objectType = theObjectType;
        this.metadataFileNames = theMetadataFileNames;
        this.indexers = theIndexers;
        this.publishIndexData = thePublishIndexData;
        this.publicationType = thePublicationType;
        this.publicationDate = thePublicationDate;
        this.repositoryOids = theRepositoryOids;
        this.indexFilesToPublish = theIndexFilesToPublish;
        this.iteration = theIndexIteration;
    }

    public int getIndexType() {
        return this.indexType;
    }

    public void setIndexType(int theIndexType) {
        this.indexType = theIndexType;
    }

    public String getObjectOid() {
        return this.objectOid;
    }

    public void setObjectOid(String theObjectOid) {
        this.objectOid = theObjectOid;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int theObjectType) {
        this.objectType = theObjectType;
    }

    public List<String> getMetadataFileNames() {
        return this.metadataFileNames;
    }

    public void setMetadataFileNames(List<String> theMetadataFileNames) {
        this.metadataFileNames = theMetadataFileNames;
    }

    public List<String> getIndexers() {
        return this.indexers;
    }

    public void setIndexers(List<String> theIndexers) {
        this.indexers = theIndexers;
    }

    public boolean isPublishIndexData() {
        return this.publishIndexData;
    }

    public void setPublishIndexData(boolean thePublishIndexData) {
        this.publishIndexData = thePublishIndexData;
    }

    public int getPublicationType() {
        return this.publicationType;
    }

    public void setPublicationType(int thePublicationType) {
        this.publicationType = thePublicationType;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(Date thePublicationDate) {
        this.publicationDate = thePublicationDate;
    }

    public List<String> getRepositoryOids() {
        return this.repositoryOids;
    }

    public void setRepositoryOids(List<String> theRepositoryOids) {
        this.repositoryOids = theRepositoryOids;
    }

    public String getIndexFilesToPublish() {
        return this.indexFilesToPublish;
    }

    public void setIndexFilesToPublish(String theIndexFilesToPublish) {
        this.indexFilesToPublish = theIndexFilesToPublish;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int theIteration) {
        this.iteration = theIteration;
    }

    public void resetIterations() {
        this.iteration = 0;
    }

    public void increaseIterations() {
        ++this.iteration;
    }

    @Override
    public final void validateObject() throws R01MIndexerModelObjectsValidatorException {
        if (this.indexType != 0 && this.indexType != 1) {
            throw new R01MIndexerModelObjectsValidatorException("El tipo de indexaci\u00f3n a realizar no se reconoce o no es v\u00e1lido: " + Integer.toString(this.objectType));
        }
        if (StringUtils.isEmptyString((String)this.objectOid)) {
            throw new R01MIndexerModelObjectsValidatorException("El OID del objeto a indexar es " + (this.objectOid == null ? "NULL" : "VAC\u00cdO"));
        }
        if (this.objectType != 4 && this.objectType != 0 && this.objectType != 1) {
            throw new R01MIndexerModelObjectsValidatorException("El tipo de objeto no se reconoce o no es v\u00e1lido: " + Integer.toString(this.objectType));
        }
        if (this.publishIndexData) {
            if (this.publicationType != 0 && this.publicationType != 1 && this.publicationType != 2 && this.publicationType != 3) {
                throw new R01MIndexerModelObjectsValidatorException("El tipo de publicaci\u00f3n no se reconoce o no es v\u00e1lido: " + Integer.toString(this.publicationType));
            }
            if ((this.publicationType == 1 || this.publicationType == 3) && this.publicationDate == null) {
                throw new R01MIndexerModelObjectsValidatorException("Para el tipo de publicaci\u00f3n " + (this.publicationType == 1 ? "PUBLICACI\u00d3N PROGRAMADA" : "DESPUBLICACI\u00d3N PROGRAMADA") + " la fecha de publicaci\u00f3n pasada es NULL");
            }
            if (this.repositoryOids == null || this.repositoryOids.isEmpty()) {
                throw new R01MIndexerModelObjectsValidatorException("El OID del repositorio de publicaci\u00f3n pasado es " + (this.repositoryOids == null ? "NULL" : "VAC\u00cdO"));
            }
        }
    }

    @Override
    public final StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(206);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== R01MIndexDefinition ========\r\n");
        sb.append(prefix);
        sb.append("\tIndexType:");
        sb.append(this.getIndexType());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tObjectOid:");
        sb.append(this.getObjectOid() == null ? "null" : this.getObjectOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tObjectType:");
        sb.append(this.getObjectType());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMetadataFileName:");
        sb.append(this.getMetadataFileNames() == null || this.getMetadataFileNames().isEmpty() ? "null" : ArrayUtils.toString((Object[])this.getMetadataFileNames().toArray()));
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPublishIndexData:");
        sb.append(this.isPublishIndexData());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRepositoryOids:");
        sb.append(this.getRepositoryOids() == null || this.getRepositoryOids().isEmpty() ? "null" : ArrayUtils.toString((Object[])this.getRepositoryOids().toArray()));
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPublicationType:");
        sb.append(this.getPublicationType());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPublicationDate:");
        sb.append(this.getPublicationDate() == null ? "null" : R01MDateUtils.dateToStr(this.getPublicationDate(), R01MConstants.DEFAULT_LANG));
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tIndexFilesToPublish:");
        sb.append(this.getIndexFilesToPublish() == null ? "null" : this.getIndexFilesToPublish());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tIteration:");
        sb.append(this.getIteration());
        sb.append("\r\n");
        return sb;
    }
}

