/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.indexer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.searchengine.R01MConditionType;
import com.ejie.r01m.config.objects.searchengine.R01MMetadataConditions;
import com.ejie.r01m.config.objects.searchengine.R01MMetadataGroupCondition;
import com.ejie.r01m.config.objects.searchengine.R01MMetadataParticularCondition;
import com.ejie.r01m.config.objects.searchengine.R01MNumericMetadataRange;
import com.ejie.r01m.config.objects.searchengine.R01MScoreIndexConditions;
import com.ejie.r01m.config.objects.searchengine.R01MSearchEngineByTypoConfig;
import com.ejie.r01m.config.objects.searchengine.R01MValueModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MBoostingFactorCalculator {
    private static final String CONDITION_TYPE_EQ = "EQ";
    private static final String CONDITION_TYPE_NEQ = "NEQ";
    private static final String CONDITION_TYPE_GT = "GT";
    private static final String CONDITION_TYPE_LT = "LT";
    private static final String CONDITION_TYPE_GE = "GE";
    private static final String CONDITION_TYPE_LE = "LE";
    private static final String CONDITION_TYPE_EX = "EX";
    private static final String CONDITION_TYPE_NEX = "NEX";
    private static final String CONDITION_TYPE_IN = "IN";
    private static final String CONDITION_TYPE_REGEX = "REGEX";
    private static final String METADATA_TYPE_TEXT = "TEXT";
    private static final String METADATA_TYPE_NUMERIC = "NUMERIC";
    private static final String METADATA_TYPE_LIST = "LIST";
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01m.indexerAPI").intValue() != Level.OFF.intValue();

    public static float obtainScoreValue(R01MSearchEngineByTypoConfig searchEngineByTypoConfig, Map<String, Object> metadatas) {
        if (searchEngineByTypoConfig == null) {
            return -1.0f;
        }
        StringBuffer sbError = new StringBuffer(85);
        float boostingFactor = searchEngineByTypoConfig.getBoostingFactor();
        R01MMetadataConditions metadataConditions = searchEngineByTypoConfig.getMetadataConditions();
        if (metadataConditions != null) {
            ArrayList<R01MMetadataGroupCondition> ANDgroups = new ArrayList<R01MMetadataGroupCondition>(metadataConditions.getMetadataAND());
            boolean atLeastOneGroupValid = false;
            for (int i = 0; i < ANDgroups.size(); ++i) {
                R01MMetadataGroupCondition metadataGroupCondition = ANDgroups.get(i);
                boolean append = metadataGroupCondition.isAppend();
                if (atLeastOneGroupValid && !append) continue;
                boolean validGroup = true;
                boolean denied = metadataGroupCondition.isDenied();
                R01MScoreIndexConditions scoreIndexConditions = metadataGroupCondition.getConditions();
                ArrayList<R01MMetadataParticularCondition> metadataParticularConditions = new ArrayList<R01MMetadataParticularCondition>(scoreIndexConditions.getMetadataRule());
                for (int j = 0; validGroup && j < metadataParticularConditions.size(); ++j) {
                    R01MMetadataParticularCondition metadataParticularCondition = metadataParticularConditions.get(j);
                    String metadataName = metadataParticularCondition.getMetadataName();
                    R01MConditionType conditionType = metadataParticularCondition.getConditionType();
                    if (metadataName == null || metadataName.length() == 0) {
                        sbError.append("Existe una regla particular en la que no se ha definido ning\u00fan metadato para aplicar la condici\u00f3n.\n");
                        continue;
                    }
                    if (conditionType == null) {
                        sbError.append("Existe una regla particular en la que no se ha definido ninguna condici\u00f3n.\n");
                        continue;
                    }
                    if (conditionType.getType() == null || conditionType.getType().length() == 0) {
                        sbError.append("Existe una condici\u00f3n en la que no se ha definido el tipo de cl\u00e1usula.\n");
                        continue;
                    }
                    if (metadatas.containsKey(metadataName)) {
                        if (conditionType.getType().equals(CONDITION_TYPE_NEX)) {
                            validGroup = false;
                        } else if (!conditionType.getType().equals(CONDITION_TYPE_EX)) {
                            String valueType = metadataParticularCondition.getType();
                            String metadataValue = (String)metadatas.get(metadataName);
                            String metadataConditionValue = conditionType.getValue();
                            if (conditionType.getType().equals(CONDITION_TYPE_EQ)) {
                                if ((valueType.equals(METADATA_TYPE_TEXT) || valueType.equals(METADATA_TYPE_NUMERIC)) && !metadataValue.trim().equals(metadataConditionValue.trim())) {
                                    validGroup = false;
                                } else if (valueType.equals(METADATA_TYPE_LIST)) {
                                    List<String> listValues = Arrays.asList(metadataValue.split(","));
                                    List<String> listConditionValues = Arrays.asList(metadataConditionValue.split(","));
                                    if (listConditionValues.size() != listValues.size() || listValues.retainAll(listConditionValues)) {
                                        validGroup = false;
                                    }
                                }
                            } else if (conditionType.getType().equals(CONDITION_TYPE_NEQ)) {
                                if (valueType.equals(METADATA_TYPE_TEXT) || valueType.equals(METADATA_TYPE_NUMERIC)) {
                                    if (metadataValue.trim().equals(metadataConditionValue.trim())) {
                                        validGroup = false;
                                    }
                                } else if (valueType.equals(METADATA_TYPE_LIST)) {
                                    List<String> listValues = Arrays.asList(metadataValue.split(","));
                                    List<String> listConditionValues = Arrays.asList(metadataConditionValue.split(","));
                                    if (listConditionValues.size() == listValues.size() && !listValues.retainAll(listConditionValues)) {
                                        validGroup = false;
                                    }
                                }
                            } else if (conditionType.getType().equals(CONDITION_TYPE_GE)) {
                                if (valueType.equals(METADATA_TYPE_NUMERIC)) {
                                    try {
                                        int value = Integer.parseInt(metadataValue.trim());
                                        int conditionValue = Integer.parseInt(metadataConditionValue);
                                        if (value < conditionValue) {
                                            validGroup = false;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        sbError.append("Error al convertir el metadato " + metadataName + " en un entero.\n");
                                        validGroup = false;
                                    }
                                } else {
                                    sbError.append("El metadato " + metadataName + " no es num\u00e9rico y se trata de aplicar en una condici\u00f3n num\u00e9rica (GE).\n");
                                    validGroup = false;
                                }
                            } else if (conditionType.getType().equals(CONDITION_TYPE_LE)) {
                                if (valueType.equals(METADATA_TYPE_NUMERIC)) {
                                    try {
                                        int value = Integer.parseInt(metadataValue.trim());
                                        int conditionValue = Integer.parseInt(metadataConditionValue);
                                        if (value > conditionValue) {
                                            validGroup = false;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        sbError.append("Error al convertir el metadato " + metadataName + " en un entero.\n");
                                        validGroup = false;
                                    }
                                } else {
                                    sbError.append("El metadato " + metadataName + " no es num\u00e9rico y se trata de aplicar en una condici\u00f3n num\u00e9rica (LE).\n");
                                    validGroup = false;
                                }
                            } else if (conditionType.getType().equals(CONDITION_TYPE_GT)) {
                                if (valueType.equals(METADATA_TYPE_NUMERIC)) {
                                    try {
                                        int value = Integer.parseInt(metadataValue.trim());
                                        int conditionValue = Integer.parseInt(metadataConditionValue);
                                        if (value <= conditionValue) {
                                            validGroup = false;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        sbError.append("Error al convertir el metadato " + metadataName + " en un entero.\n");
                                        validGroup = false;
                                    }
                                } else {
                                    sbError.append("El metadato " + metadataName + " no es num\u00e9rico y se trata de aplicar en una condici\u00f3n num\u00e9rica (GT).\n");
                                    validGroup = false;
                                }
                            } else if (conditionType.getType().equals(CONDITION_TYPE_LT)) {
                                if (valueType.equals(METADATA_TYPE_NUMERIC)) {
                                    try {
                                        int value = Integer.parseInt(metadataValue.trim());
                                        int conditionValue = Integer.parseInt(metadataConditionValue);
                                        if (value >= conditionValue) {
                                            validGroup = false;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        sbError.append("Error al convertir el metadato " + metadataName + " en un entero.\n");
                                        validGroup = false;
                                    }
                                } else {
                                    sbError.append("El metadato " + metadataName + " no es num\u00e9rico y se trata de aplicar en una condici\u00f3n num\u00e9rica (LT).\n");
                                    validGroup = false;
                                }
                            } else if (conditionType.getType().equals(CONDITION_TYPE_IN)) {
                                if (valueType.equals(METADATA_TYPE_LIST)) {
                                    List<String> listValues = Arrays.asList(metadataValue.split(","));
                                    List<String> listConditionValues = Arrays.asList(metadataConditionValue.split(","));
                                    int originalSize = listValues.size();
                                    if (!listValues.removeAll(listConditionValues) || listValues.size() + listConditionValues.size() != originalSize) {
                                        validGroup = false;
                                    }
                                } else {
                                    sbError.append("El metadato " + metadataName + " no es de tipo lista y se trata de aplicar en una condici\u00f3n IN.\n");
                                    validGroup = false;
                                }
                            } else if (conditionType.getType().equals(CONDITION_TYPE_REGEX)) {
                                if (valueType.equals(METADATA_TYPE_TEXT)) {
                                    Pattern pattern = Pattern.compile(metadataConditionValue);
                                    Matcher matcher = pattern.matcher(metadataValue);
                                    if (!matcher.find()) {
                                        validGroup = false;
                                    }
                                } else {
                                    sbError.append("El metadato " + metadataName + " no es de tipo texto y se trata de aplicar en una condici\u00f3n REGEX.\n");
                                    validGroup = false;
                                }
                            } else if (DEBUG) {
                                sbError.append("ERROR: No existe el tipo de condici\u00f3n indicado" + conditionType.getType() + "\n");
                            }
                        }
                        if (!DEBUG) continue;
                        R01FLog.to((String)"r01m.indexerAPI").warning("ERROR: Error al obtener las condiciones. " + sbError.toString());
                        continue;
                    }
                    if (conditionType.getType().equals(CONDITION_TYPE_NEX)) continue;
                    if (!conditionType.getType().equals(CONDITION_TYPE_EX)) {
                        sbError.append("No existe el metadato " + metadataName + ". No se aplicar\u00e1n las reglas correspondientes a ese metadato.\n");
                    }
                    validGroup = false;
                }
                if ((!validGroup || denied) && (validGroup || !denied)) continue;
                atLeastOneGroupValid = true;
                R01MValueModifier valueModifier = metadataGroupCondition.getValueModifier();
                String algorithm = null;
                String value = (String)metadatas.get(valueModifier.getMetadataRange());
                if (valueModifier.isRange()) {
                    boolean isNumeric;
                    int numericValue;
                    block74: {
                        if (value == null && DEBUG) {
                            R01FLog.to((String)"r01m.indexerAPI").warning("ERROR: El metadato que se usar\u00e1 en el algoritmo no existe para el objeto.");
                        }
                        numericValue = -1;
                        isNumeric = false;
                        try {
                            if (value != null) {
                                numericValue = Integer.parseInt(value.trim());
                                isNumeric = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            if (!DEBUG) break block74;
                            R01FLog.to((String)"r01m.indexerAPI").warning("ERROR: El metadato que se usar\u00e1 en el algoritmo no es un n\u00famero.");
                        }
                    }
                    if (isNumeric) {
                        ArrayList<R01MNumericMetadataRange> ranges = new ArrayList<R01MNumericMetadataRange>(valueModifier.getRangeDefined());
                        for (int j = 0; j < ranges.size(); ++j) {
                            R01MNumericMetadataRange range = ranges.get(i);
                            if (range.getInit() >= numericValue || numericValue > range.getEnd()) continue;
                            algorithm = range.getValue();
                            break;
                        }
                    }
                } else {
                    algorithm = valueModifier.getValue();
                }
                if (algorithm == null) {
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01m.indexerAPI").warning("ERROR: No se ha definido un algoritmo para modificar el peso.");
                    continue;
                }
                algorithm = algorithm.replaceAll(" ", "");
                algorithm = algorithm.replaceAll("\t", "");
                boostingFactor = R01MBoostingFactorCalculator.executeComposedAlgorithm(algorithm, boostingFactor, value);
            }
        }
        return boostingFactor;
    }

    private static float executeComposedAlgorithm(String algorithm, float boostingFactor, String value) {
        String newAlgorithm = String.valueOf(algorithm);
        String patternRegExp = "(\\([a-zA-Z_0-9\\.\\{\\}\\+\\-\\*\\/]*\\))";
        Pattern pattern = Pattern.compile(patternRegExp);
        Matcher matcher = pattern.matcher(newAlgorithm);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String subAlgorithm = matcher.group(i);
                String subResult = String.valueOf(R01MBoostingFactorCalculator.executeSimpleAlgorithm(subAlgorithm.substring(1, subAlgorithm.length() - 1), boostingFactor, value));
                if (DEBUG) {
                    R01FLog.to((String)"r01m.indexerAPI").info("Algorithm : " + newAlgorithm + "\nboost : " + boostingFactor + "\nmetadata : " + value + "\nsubAlgorithm : " + subAlgorithm + "\nsubResult : " + subResult);
                }
                newAlgorithm = StringUtils.replaceString((String)newAlgorithm, (String)subAlgorithm, (String)subResult);
            }
            pattern = Pattern.compile(patternRegExp);
            matcher = pattern.matcher(newAlgorithm);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.indexerAPI").info("Algorithm : " + newAlgorithm + "\nboost : " + boostingFactor + "\nmetadata : " + value + "\nResult : " + R01MBoostingFactorCalculator.executeSimpleAlgorithm(newAlgorithm, boostingFactor, value));
        }
        return R01MBoostingFactorCalculator.executeSimpleAlgorithm(newAlgorithm, boostingFactor, value);
    }

    private static float executeSimpleAlgorithm(String algorithm, float boostValue, String metadataValue) {
        float result = 0.0f;
        String newAlgorithm = String.valueOf(algorithm);
        newAlgorithm = newAlgorithm.replaceFirst("^[\\+\\*\\/\\%\\^]", "");
        if (DEBUG) {
            R01FLog.to((String)"r01m.indexerAPI").info("Algoritmo: " + newAlgorithm);
        }
        newAlgorithm = "+" + newAlgorithm;
        String patternRegExp = "[a-zA-Z_0-9\\{\\}\\.]+";
        Pattern pattern = Pattern.compile(patternRegExp);
        Matcher matcher = pattern.matcher(newAlgorithm);
        while (matcher.find()) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                float secondFactor;
                String factor;
                block27: {
                    factor = matcher.group(i);
                    secondFactor = 0.0f;
                    if (factor.equalsIgnoreCase("{boost}")) {
                        secondFactor = boostValue;
                    } else if (factor.equalsIgnoreCase("{metadata}")) {
                        if (metadataValue != null) {
                            try {
                                secondFactor = Float.parseFloat(metadataValue.trim());
                            }
                            catch (NumberFormatException e) {
                                if (DEBUG) {
                                    R01FLog.to((String)"r01m.indexerAPI").warning("ERROR (executeAlgorithm): El metadato que se usar\u00e1 en el algoritmo no es un n\u00famero.");
                                }
                            }
                        }
                    } else {
                        try {
                            secondFactor = Float.parseFloat(factor.trim());
                        }
                        catch (NumberFormatException e) {
                            if (!DEBUG) break block27;
                            R01FLog.to((String)"r01m.indexerAPI").warning("ERROR (executeAlgorithm): Algoritmo mal formado: " + factor + " no es un n\u00famero.");
                        }
                    }
                }
                if (newAlgorithm.charAt(1) == '-') {
                    factor = "-" + factor;
                    secondFactor *= -1.0f;
                }
                if (DEBUG) {
                    R01FLog.to((String)"r01m.indexerAPI").info("Se ejecuta " + result + " " + newAlgorithm.charAt(0) + " " + secondFactor);
                }
                if (newAlgorithm.charAt(0) == '+') {
                    result += secondFactor;
                } else if (newAlgorithm.charAt(0) == '-') {
                    result -= secondFactor;
                } else if (newAlgorithm.charAt(0) == '*') {
                    result *= secondFactor;
                } else if (newAlgorithm.charAt(0) == '/') {
                    result /= secondFactor;
                } else if (newAlgorithm.charAt(0) == '%') {
                    result %= secondFactor;
                } else if (DEBUG) {
                    R01FLog.to((String)"r01m.indexerAPI").warning("ERROR (executeAlgorithm): Operador no reconocido: " + newAlgorithm.charAt(0));
                }
                newAlgorithm = newAlgorithm.substring(factor.length() + 1);
                if (!DEBUG) continue;
                R01FLog.to((String)"r01m.indexerAPI").info("Se cambia el algoritmo a " + newAlgorithm);
            }
        }
        if (newAlgorithm.length() > 0 && DEBUG) {
            R01FLog.to((String)"r01m.indexerAPI").warning("WARNING (executeAlgorithm): Parte final del algoritmo (" + newAlgorithm + ") no reconocida. No se ejecutar\u00e1.");
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            R01MConditionType condition1 = new R01MConditionType();
            condition1.setType(CONDITION_TYPE_EQ);
            condition1.setValue("TextoMeta1");
            R01MConditionType condition2 = new R01MConditionType();
            condition2.setType(CONDITION_TYPE_EQ);
            condition2.setValue("2");
            R01MConditionType condition3 = new R01MConditionType();
            condition3.setType(CONDITION_TYPE_EQ);
            condition3.setValue("1,23,azk");
            R01MConditionType condition4 = new R01MConditionType();
            condition4.setType(CONDITION_TYPE_EQ);
            condition4.setValue("*Text*");
            R01MConditionType condition5 = new R01MConditionType();
            condition5.setType(CONDITION_TYPE_EQ);
            condition5.setValue("2");
            R01MConditionType condition6 = new R01MConditionType();
            condition6.setType(CONDITION_TYPE_EQ);
            condition6.setValue("9999999999");
            R01MConditionType condition7 = new R01MConditionType();
            condition7.setType(CONDITION_TYPE_EQ);
            condition7.setValue("1,23,azk,8a");
            R01MConditionType condition8 = new R01MConditionType();
            condition8.setType(CONDITION_TYPE_EQ);
            condition8.setValue("Prueba");
            R01MMetadataParticularCondition metadataParticularCondition1 = new R01MMetadataParticularCondition();
            R01MMetadataParticularCondition metadataParticularCondition2 = new R01MMetadataParticularCondition();
            R01MMetadataParticularCondition metadataParticularCondition3 = new R01MMetadataParticularCondition();
            R01MMetadataParticularCondition metadataParticularCondition4 = new R01MMetadataParticularCondition();
            R01MMetadataParticularCondition metadataParticularCondition5 = new R01MMetadataParticularCondition();
            R01MMetadataParticularCondition metadataParticularCondition6 = new R01MMetadataParticularCondition();
            R01MMetadataParticularCondition metadataParticularCondition7 = new R01MMetadataParticularCondition();
            R01MMetadataParticularCondition metadataParticularCondition8 = new R01MMetadataParticularCondition();
            metadataParticularCondition1.setConditionType(condition1);
            metadataParticularCondition1.setMetadataName("META1");
            metadataParticularCondition1.setType(METADATA_TYPE_TEXT);
            metadataParticularCondition2.setConditionType(condition2);
            metadataParticularCondition1.setMetadataName("META2");
            metadataParticularCondition1.setType(METADATA_TYPE_NUMERIC);
            metadataParticularCondition3.setConditionType(condition3);
            metadataParticularCondition1.setMetadataName("META3");
            metadataParticularCondition1.setType(METADATA_TYPE_LIST);
            metadataParticularCondition4.setConditionType(condition4);
            metadataParticularCondition1.setMetadataName("META4");
            metadataParticularCondition1.setType(METADATA_TYPE_TEXT);
            metadataParticularCondition5.setConditionType(condition5);
            metadataParticularCondition1.setMetadataName("META2");
            metadataParticularCondition1.setType(METADATA_TYPE_NUMERIC);
            metadataParticularCondition6.setConditionType(condition6);
            metadataParticularCondition1.setMetadataName("META2");
            metadataParticularCondition1.setType(METADATA_TYPE_NUMERIC);
            metadataParticularCondition7.setConditionType(condition7);
            metadataParticularCondition1.setMetadataName("META3");
            metadataParticularCondition1.setType(METADATA_TYPE_LIST);
            metadataParticularCondition8.setConditionType(condition8);
            metadataParticularCondition1.setMetadataName("META1");
            metadataParticularCondition1.setType(METADATA_TYPE_TEXT);
            R01MNumericMetadataRange range1 = new R01MNumericMetadataRange();
            R01MNumericMetadataRange range2 = new R01MNumericMetadataRange();
            range1.setInit(2);
            range1.setEnd(20000);
            range1.setValue("{boost}+(3*{metadata})*((5*6)/{metadata}-0.5)");
            range2.setInit(20001);
            range2.setEnd(40000);
            range2.setValue("{boost}+200");
            ArrayList<R01MNumericMetadataRange> rangeList = new ArrayList<R01MNumericMetadataRange>(2);
            rangeList.add(range1);
            rangeList.add(range2);
            R01MValueModifier valueModifier1 = new R01MValueModifier();
            R01MValueModifier valueModifier2 = new R01MValueModifier();
            R01MValueModifier valueModifier3 = new R01MValueModifier();
            valueModifier1.setRange(true);
            valueModifier1.setMetadataRange("META2");
            valueModifier1.setRangeDefined(rangeList);
            valueModifier2.setRange(false);
            valueModifier2.setValue("{boost}+5");
            valueModifier3.setRange(false);
            valueModifier3.setMetadataRange("META1");
            valueModifier3.setValue("4");
            ArrayList<R01MMetadataParticularCondition> metadataRules1 = new ArrayList<R01MMetadataParticularCondition>(4);
            ArrayList<R01MMetadataParticularCondition> metadataRules2 = new ArrayList<R01MMetadataParticularCondition>(2);
            ArrayList<R01MMetadataParticularCondition> metadataRules3 = new ArrayList<R01MMetadataParticularCondition>(2);
            metadataRules1.add(metadataParticularCondition1);
            metadataRules1.add(metadataParticularCondition2);
            metadataRules1.add(metadataParticularCondition3);
            metadataRules1.add(metadataParticularCondition4);
            metadataRules2.add(metadataParticularCondition5);
            metadataRules2.add(metadataParticularCondition6);
            metadataRules3.add(metadataParticularCondition7);
            metadataRules3.add(metadataParticularCondition8);
            R01MScoreIndexConditions conditions1 = new R01MScoreIndexConditions();
            conditions1.setMetadataRule(metadataRules1);
            R01MScoreIndexConditions conditions2 = new R01MScoreIndexConditions();
            conditions2.setMetadataRule(metadataRules1);
            R01MScoreIndexConditions conditions3 = new R01MScoreIndexConditions();
            conditions3.setMetadataRule(metadataRules1);
            R01MMetadataGroupCondition groupCondition1 = new R01MMetadataGroupCondition();
            R01MMetadataGroupCondition groupCondition2 = new R01MMetadataGroupCondition();
            R01MMetadataGroupCondition groupCondition3 = new R01MMetadataGroupCondition();
            groupCondition1.setConditions(conditions1);
            groupCondition1.setValueModifier(valueModifier1);
            groupCondition1.setDenied(false);
            groupCondition1.setAppend(false);
            groupCondition2.setConditions(conditions2);
            groupCondition2.setValueModifier(valueModifier2);
            groupCondition2.setAppend(true);
            groupCondition3.setConditions(conditions3);
            groupCondition3.setValueModifier(valueModifier3);
            groupCondition3.setDenied(true);
            ArrayList<R01MMetadataGroupCondition> metadataAND = new ArrayList<R01MMetadataGroupCondition>();
            metadataAND.add(groupCondition1);
            metadataAND.add(groupCondition2);
            metadataAND.add(groupCondition3);
            R01MMetadataConditions metadataConditions = new R01MMetadataConditions();
            metadataConditions.setMetadataAND(metadataAND);
            R01MSearchEngineByTypoConfig searchEngineByTypoConfig = new R01MSearchEngineByTypoConfig();
            searchEngineByTypoConfig.setBoostingFactor(2);
            searchEngineByTypoConfig.setMetadataConditions(metadataConditions);
            HashMap<String, Object> metadatas = new HashMap<String, Object>();
            metadatas.put("META1", "TextoMeta1");
            metadatas.put("META2", "200");
            metadatas.put("META3", "1,23,azk,8a");
            metadatas.put("META4", "TextoMeta4");
            if (DEBUG) {
                R01FLog.to((String)"r01m.indexerAPI").info("Valor: " + R01MBoostingFactorCalculator.obtainScoreValue(searchEngineByTypoConfig, metadatas));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

