/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.guide;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MSearchGuideNode
implements Serializable {
    private static final long serialVersionUID = -3000958207014210919L;
    private boolean clonedNode;
    private R01MSearchGuideNode parentNode;
    private List futureNodes;
    private R01MSearchGuideElement nodeElement;
    private String nodeType = null;

    public R01MSearchGuideNode() {
    }

    public R01MSearchGuideNode(R01MSearchGuideNode other) {
        this.parentNode = other.getParentNode();
        this.futureNodes = other.getFutureNodes();
        this.nodeElement = other.getNodeElement();
        this.nodeType = other.getNodeType();
    }

    public R01MSearchGuideNode(String newNodeType, String newBranchDefPath, String newNodeElementPathInBranch, Map newNodeElementDescs) {
        this.nodeType = newNodeType;
        this.nodeElement = new R01MSearchGuideElement(newBranchDefPath, newNodeElementPathInBranch, newNodeElementDescs);
    }

    public R01MSearchGuideNode(String newNodeType, R01MSearchGuideNode newParentNode) {
        this.nodeType = newNodeType;
        this.parentNode = newParentNode;
    }

    public R01MSearchGuideNode(String newNodeType, R01MSearchGuideElement newElement) {
        this.nodeElement = newElement;
        this.nodeType = newNodeType;
    }

    public R01MSearchGuideNode(String newNodeType, R01MSearchGuideNode newParentNode, R01MSearchGuideElement newElement) {
        this(newNodeType, newParentNode);
        this.nodeElement = newElement;
    }

    public void addFutureGuideNode(R01MSearchGuideNode futureNode) {
        if (futureNode == null) {
            return;
        }
        if (this.futureNodes == null) {
            this.futureNodes = new ArrayList();
        }
        this.futureNodes.add(futureNode);
    }

    public void removeFutureGuideNode(String nodePathInGuide) {
        if (this.futureNodes == null) {
            return;
        }
        int idx = 0;
        boolean nodeFound = false;
        for (R01MSearchGuideNode currFutureNode : this.futureNodes) {
            if (currFutureNode.getPathInGuide().equals(nodePathInGuide)) {
                nodeFound = true;
                break;
            }
            ++idx;
        }
        if (nodeFound) {
            this.futureNodes.remove(idx);
        }
    }

    public R01MSearchGuideElement[] getFutureElementsArray() {
        if (this.futureNodes == null) {
            return null;
        }
        ArrayList<R01MSearchGuideElement> futureGuideElements = new ArrayList<R01MSearchGuideElement>();
        for (R01MSearchGuideNode currFutureNode : this.futureNodes) {
            if (currFutureNode.getNodeElement() == null) continue;
            futureGuideElements.add(currFutureNode.getNodeElement());
        }
        return futureGuideElements.toArray(new R01MSearchGuideElement[futureGuideElements.size()]);
    }

    public R01MSearchGuideElement[] getPastElementsArray() {
        if (this.parentNode == null) {
            return null;
        }
        ArrayList<R01MSearchGuideElement> pastGuideElements = new ArrayList<R01MSearchGuideElement>();
        R01MSearchGuideNode currPastNod = this.parentNode;
        do {
            if (currPastNod.getNodeElement() == null) continue;
            pastGuideElements.add(0, currPastNod.getNodeElement());
        } while ((currPastNod = currPastNod.getParentNode()) != null);
        return pastGuideElements.toArray(new R01MSearchGuideElement[pastGuideElements.size()]);
    }

    public void setNodeElementState(int numberOfResults, boolean highLight) {
        if (this.nodeElement == null) {
            return;
        }
        this.nodeElement.setHighLight(highLight);
        this.nodeElement.setNumberOfResults(numberOfResults);
    }

    public void addNodeElementState(int numberOfResults, boolean highLight) {
        if (this.nodeElement == null) {
            return;
        }
        this.nodeElement.setHighLight(this.nodeElement.isHighLight() | highLight);
        this.nodeElement.setNumberOfResults(this.nodeElement.getNumberOfResults() + numberOfResults);
    }

    public void resetNodeElement() {
        if (this.nodeElement != null) {
            this.nodeElement.reset();
        }
    }

    public void resetFutureNodeElements() {
        if (this.futureNodes != null) {
            R01MSearchGuideNode theNod2 = null;
            for (R01MSearchGuideNode theNod2 : this.futureNodes) {
                theNod2.resetNodeElement();
            }
        }
    }

    public R01MSearchGuideNode cloneNode(R01MSearchGuideNode theParentNode) {
        if (this.isClonedNode()) {
            return this;
        }
        R01MSearchGuideElement clonedEl = this.nodeElement.cloneElement();
        R01MSearchGuideNode theClonedNode = new R01MSearchGuideNode(new String(this.nodeType), theParentNode, clonedEl);
        theClonedNode.setClonedNode(true);
        if (this.futureNodes != null) {
            theClonedNode.setFutureNodes(new ArrayList(this.futureNodes.size()));
            for (R01MSearchGuideNode futureNode : this.futureNodes) {
                R01MSearchGuideNode clonedFutureNode = futureNode.cloneNode(theClonedNode);
                if (!clonedFutureNode.getBranchDefPath().equals(theClonedNode.getBranchDefPath())) {
                    clonedFutureNode.setParentNode(null);
                }
                theClonedNode.addFutureGuideNode(clonedFutureNode);
            }
        }
        return theClonedNode;
    }

    public R01MSearchGuideNode cloneNode() {
        if (this.isClonedNode()) {
            return this;
        }
        R01MSearchGuideElement clonedEl = this.nodeElement.cloneElement();
        R01MSearchGuideNode theClonedNode = new R01MSearchGuideNode(this.nodeType, clonedEl);
        theClonedNode.setClonedNode(true);
        return theClonedNode;
    }

    String composeDebugInfo(int level) {
        StringBuffer dbg = new StringBuffer();
        String tab = new String(StringUtils.getCharArray((char)'\t', (int)level));
        if (this.nodeElement != null) {
            dbg.append(this.nodeElement.composeDebugInfo(level));
            dbg.append("\r\n");
        }
        if (this.futureNodes != null) {
            if (this.futureNodes != null) {
                dbg.append(tab);
                dbg.append("* Nodos Futuros...\r\n");
            }
            Iterator it = this.futureNodes.iterator();
            while (it.hasNext()) {
                dbg.append(((R01MSearchGuideNode)it.next()).composeDebugInfo(level + 1));
                if (!it.hasNext()) continue;
                dbg.append("\r\n");
            }
        }
        return dbg.toString();
    }

    public boolean isClonedNode() {
        return this.clonedNode;
    }

    public void setClonedNode(boolean bClonedNode) {
        this.clonedNode = bClonedNode;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String theNodeType) {
        this.nodeType = theNodeType;
    }

    public List getFutureNodes() {
        return this.futureNodes;
    }

    public R01MSearchGuideNode getFutureNode(String nodeElementPathInBranch) {
        if (this.futureNodes == null) {
            return null;
        }
        R01MSearchGuideNode outNode = null;
        for (R01MSearchGuideNode currNode : this.futureNodes) {
            if (!currNode.getPathInGuide().equals(nodeElementPathInBranch)) continue;
            outNode = currNode;
            break;
        }
        return outNode;
    }

    public R01MSearchGuideNode[] getFutureNodesArray() {
        return this.futureNodes == null ? null : this.futureNodes.toArray(new R01MSearchGuideNode[this.futureNodes.size()]);
    }

    public void setFutureNodes(List theChildNodes) {
        this.futureNodes = theChildNodes;
        if (theChildNodes == null) {
            return;
        }
        for (R01MSearchGuideNode currNode : theChildNodes) {
            currNode.setParentNode(this);
        }
    }

    public void setFutureNodesFromArray(R01MSearchGuideNode[] theChildNodes) {
        if (theChildNodes == null) {
            this.futureNodes = null;
            return;
        }
        if (this.futureNodes == null) {
            this.futureNodes = new ArrayList(theChildNodes.length);
        }
        for (int i = 0; i < theChildNodes.length; ++i) {
            theChildNodes[i].setParentNode(this);
            this.futureNodes.add(theChildNodes[i]);
        }
    }

    public R01MSearchGuideElement getNodeElement() {
        return this.nodeElement;
    }

    public Map getDescriptions() {
        return this.nodeElement == null ? null : this.nodeElement.getDescription();
    }

    public String getDescription(String lang) {
        return this.getDescriptions() == null ? null : (String)this.getDescriptions().get(lang);
    }

    public void setNodeElement(R01MSearchGuideElement theNodeElement) {
        this.nodeElement = theNodeElement;
    }

    public String getPathInBranch() {
        return this.nodeElement == null ? null : this.nodeElement.getElementPathInBranch();
    }

    public String getPathInGuide() {
        return this.nodeElement == null ? null : this.nodeElement.getPathInGuide();
    }

    public String getBranchDefPath() {
        return this.nodeElement == null ? null : this.nodeElement.getBranchDefPath();
    }

    public R01MSearchGuideNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(R01MSearchGuideNode theParentNode) {
        this.parentNode = theParentNode;
    }
}

