/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.guide;

import com.ejie.r01f.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class R01MSearchGuideElement
implements Serializable {
    private static final long serialVersionUID = -2296964948690384531L;
    public String branchDefPath;
    public String elementPathInBranch;
    public Map description;
    public int numberOfResults = -1;
    public boolean highLight = false;
    public long computeTime = -1L;

    public R01MSearchGuideElement() {
    }

    public R01MSearchGuideElement(R01MSearchGuideElement other) {
        this.branchDefPath = other.getBranchDefPath();
        this.elementPathInBranch = other.getElementPathInBranch();
        this.description = other.getDescription();
        this.highLight = other.isHighLight();
        this.numberOfResults = other.getNumberOfResults();
        this.computeTime = other.getComputeTime();
    }

    public R01MSearchGuideElement(String newBranchDefPath, String newElementPathInBranch, Map descs) {
        this.branchDefPath = newBranchDefPath;
        this.elementPathInBranch = newElementPathInBranch;
        this.description = descs;
    }

    public R01MSearchGuideElement(String newBranchDefPath, String newElementPathInBranch, Map descs, int newNumberOfResults, boolean newHighLight) {
        this(newBranchDefPath, newElementPathInBranch, descs);
        this.numberOfResults = newNumberOfResults;
        this.highLight = newHighLight;
    }

    public String getGuideOid() {
        String[] branchDefPathSplitted = this.branchDefPath.split("/");
        return branchDefPathSplitted[0];
    }

    public String getPathInGuide() {
        return this.branchDefPath + "/" + this.elementPathInBranch;
    }

    public void reset() {
        this.numberOfResults = 0;
        this.highLight = false;
    }

    public R01MSearchGuideElement cloneElement() {
        R01MSearchGuideElement clonedEl = new R01MSearchGuideElement(new String(this.branchDefPath), new String(this.elementPathInBranch), this._cloneStringMap(this.description));
        return clonedEl;
    }

    private Map _cloneStringMap(Map theMap) {
        HashMap<String, String> outMap = null;
        if (theMap != null) {
            outMap = new HashMap<String, String>(theMap.size());
            for (Map.Entry me : theMap.entrySet()) {
                outMap.put(new String((String)me.getKey()), new String((String)me.getValue()));
            }
        }
        return outMap;
    }

    String composeDebugInfo(int level) {
        StringBuffer dbg = new StringBuffer(80);
        String tab = new String(StringUtils.getCharArray((char)'\t', (int)level));
        dbg.append(tab);
        dbg.append("-path in guide   : ");
        dbg.append(this.getPathInGuide());
        dbg.append("\r\n");
        dbg.append(tab);
        dbg.append("-description (es): ");
        dbg.append(this.getDescription("es"));
        dbg.append("\r\n");
        dbg.append(tab);
        dbg.append("-numberOfResults : ");
        dbg.append(this.getNumberOfResults());
        dbg.append(" - highLight=");
        dbg.append(this.isHighLight());
        return dbg.toString();
    }

    public String getBranchDefPath() {
        return this.branchDefPath;
    }

    public void setBranchDefPath(String theBranchDefPath) {
        this.branchDefPath = theBranchDefPath;
    }

    public String getElementPathInBranch() {
        return this.elementPathInBranch;
    }

    public void setElementPathInBranch(String theElementPath) {
        this.elementPathInBranch = theElementPath;
    }

    public Map getDescription() {
        return this.description;
    }

    public String getDescription(String lang) {
        return this.description == null ? null : (String)this.description.get(lang);
    }

    public void setDescription(Map theDescription) {
        this.description = theDescription;
    }

    public boolean isHighLight() {
        return this.highLight;
    }

    public void setHighLight(boolean theHighLight) {
        this.highLight = theHighLight;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(int theNumberOfResults) {
        this.numberOfResults = theNumberOfResults;
    }

    public long getComputeTime() {
        return this.computeTime;
    }

    public void setComputeTime(long theComputeTime) {
        this.computeTime = theComputeTime;
    }
}

