/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.searchengine.guide;

import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class R01MSearchGuide
implements Serializable {
    private static final long serialVersionUID = 3623968304877854630L;
    private String guideDefOid;
    private Map name;
    private Map description;
    private R01MSearchGuideNode[] firstLevelNodes;
    private R01MSearchGuideNode currentGuideNode = null;
    private Map guideNodesIndex = new HashMap();

    public R01MSearchGuide() {
    }

    public R01MSearchGuide(String newGuideDefOid, Map newName, Map newDescription) {
        this();
        this.guideDefOid = newGuideDefOid;
        this.description = newDescription;
        this.name = newName;
    }

    public String getGuideDefOid() {
        return this.guideDefOid;
    }

    public void setGuideDefOid(String theGuideDefOid) {
        this.guideDefOid = theGuideDefOid;
    }

    public Map getName() {
        return this.name;
    }

    public String getName(String lang) {
        return this.name == null ? null : (String)this.name.get(lang);
    }

    public void setName(Map theName) {
        this.name = theName;
    }

    public Map getDescription() {
        return this.description;
    }

    public String getDescription(String lang) {
        return this.description == null ? null : (String)this.description.get(lang);
    }

    public void setDescription(Map theDescription) {
        this.description = theDescription;
    }

    public R01MSearchGuideNode[] getFirstLevelNodes() {
        return this.firstLevelNodes;
    }

    public void setFirstLevelNodes(R01MSearchGuideNode[] theFirstLevelNodes) {
        this.firstLevelNodes = theFirstLevelNodes;
    }

    public R01MSearchGuideNode getCurrentGuideNode() {
        return this.currentGuideNode;
    }

    public void setCurrentGuideNode(R01MSearchGuideNode theCurrentGuideNode) {
        this.currentGuideNode = theCurrentGuideNode;
    }

    public Map getGuideNodesIndex() {
        return this.guideNodesIndex;
    }

    public void setGuideNodesIndex(Map theNodeElementsIndex) {
        this.guideNodesIndex = theNodeElementsIndex;
    }

    public Map getBranchNodesIndex(String branchDefPath) {
        HashMap<String, R01MSearchGuideNode> outBranchNodesIndex = null;
        Map index = this.getGuideNodesIndex();
        if (index == null) {
            return null;
        }
        Map.Entry me2 = null;
        R01MSearchGuideNode currNode = null;
        String currNodeGuidePath = null;
        for (Map.Entry me2 : index.entrySet()) {
            currNodeGuidePath = (String)me2.getKey();
            currNode = (R01MSearchGuideNode)me2.getValue();
            if (!currNodeGuidePath.startsWith(branchDefPath)) continue;
            if (outBranchNodesIndex == null) {
                outBranchNodesIndex = new HashMap<String, R01MSearchGuideNode>();
            }
            outBranchNodesIndex.put(currNodeGuidePath, currNode);
        }
        return outBranchNodesIndex;
    }

    public R01MSearchGuideElement[] getFirstLevelNodesElements() {
        R01MSearchGuideElement[] outEls = null;
        if (this.firstLevelNodes != null) {
            outEls = new R01MSearchGuideElement[this.firstLevelNodes.length];
            for (int i = 0; i < this.firstLevelNodes.length; ++i) {
                outEls[i] = this.firstLevelNodes[i].getNodeElement();
            }
        }
        return outEls;
    }

    public R01MSearchGuideNode getNextLevelNode(String nodeElementPathInBranch) {
        R01MSearchGuideNode[] futureNodes;
        R01MSearchGuideNode[] r01MSearchGuideNodeArray = futureNodes = this.currentGuideNode != null ? this.currentGuideNode.getFutureNodesArray() : this.firstLevelNodes;
        if (futureNodes == null) {
            return null;
        }
        R01MSearchGuideNode outNode = null;
        for (int i = 0; i < futureNodes.length; ++i) {
            if (!futureNodes[i].getPathInGuide().equals(nodeElementPathInBranch)) continue;
            outNode = futureNodes[i];
            break;
        }
        return outNode;
    }

    public R01MSearchGuideElement[] getCurrentNodeFutureElementsArray() {
        if (this.currentGuideNode == null) {
            return this.getFirstLevelNodesElements();
        }
        return this.currentGuideNode.getFutureElementsArray();
    }

    public R01MSearchGuideElement[] getCurrentNodePastElementsArray() {
        if (this.currentGuideNode == null) {
            return null;
        }
        return this.currentGuideNode.getPastElementsArray();
    }

    public void resetFutureNodesState() {
        if (this.currentGuideNode != null) {
            this.currentGuideNode.resetFutureNodeElements();
        } else {
            R01MSearchGuideElement[] firstLevelEls = this.getFirstLevelNodesElements();
            if (firstLevelEls != null) {
                for (int i = 0; i < firstLevelEls.length; ++i) {
                    firstLevelEls[i].reset();
                }
            }
        }
    }

    public R01MSearchGuideNode findNode(String nodePathInGuide) {
        return this.guideNodesIndex == null ? null : (R01MSearchGuideNode)this.guideNodesIndex.get(nodePathInGuide);
    }

    public void removeNode(String nodePathInGuide) {
        if (nodePathInGuide == null) {
            return;
        }
        this.guideNodesIndex.remove(nodePathInGuide);
        HashSet<Integer> nodesToRemove = new HashSet<Integer>();
        for (int i = 0; i < this.firstLevelNodes.length; ++i) {
            this._removeGuideNode(nodePathInGuide, this.firstLevelNodes[i]);
            if (!this.firstLevelNodes[i].getPathInGuide().equals(nodePathInGuide)) continue;
            nodesToRemove.add(new Integer(i));
        }
        if (!nodesToRemove.isEmpty()) {
            ArrayList<R01MSearchGuideNode> newFirstLevelNodes = new ArrayList<R01MSearchGuideNode>();
            for (int i = 0; i < this.firstLevelNodes.length; ++i) {
                if (nodesToRemove.contains(new Integer(i))) continue;
                newFirstLevelNodes.add(this.firstLevelNodes[i]);
            }
            this.firstLevelNodes = newFirstLevelNodes.toArray(new R01MSearchGuideNode[newFirstLevelNodes.size()]);
        }
    }

    private void _removeGuideNode(String nodeToRemoveGuidePath, R01MSearchGuideNode node) {
        if (node.getFutureNodes() != null && node.getFutureNodes().size() > 0) {
            ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
            R01MSearchGuideNode currNode2 = null;
            int i = 0;
            for (R01MSearchGuideNode currNode2 : node.getFutureNodes()) {
                this._removeGuideNode(nodeToRemoveGuidePath, currNode2);
                if (currNode2.getPathInGuide().equals(nodeToRemoveGuidePath)) {
                    nodesToRemove.add(new Integer(i));
                }
                ++i;
            }
            Iterator it = nodesToRemove.iterator();
            while (it.hasNext()) {
                int index = (Integer)it.next();
                node.getFutureNodes().remove(index);
            }
        }
    }

    public boolean followGuide(String futureNodePathInGuide) {
        return this.gotoNode(futureNodePathInGuide);
    }

    public boolean rewindGuide(String pastNodePathInGuide) {
        return this.gotoNode(pastNodePathInGuide);
    }

    public boolean gotoNode(String nodePathInGuide) {
        R01MSearchGuideNode node = this.findNode(nodePathInGuide);
        if (node == null) {
            return false;
        }
        if (node.getNodeElement() != null) {
            this.setCurrentGuideNode(node);
        }
        return true;
    }

    public R01MSearchGuide cloneGuide() {
        R01MSearchGuide clonedGuide = new R01MSearchGuide(new String(this.guideDefOid), this._cloneStringMap(this.name), this._cloneStringMap(this.description));
        Map clonedGuideIndex = clonedGuide.getGuideNodesIndex();
        R01MSearchGuideNode clonedNode = null;
        Iterator it = this.guideNodesIndex.values().iterator();
        while (it.hasNext()) {
            clonedNode = ((R01MSearchGuideNode)it.next()).cloneNode();
            clonedGuideIndex.put(clonedNode.getPathInGuide(), clonedNode);
        }
        R01MSearchGuideNode masterNode2 = null;
        for (R01MSearchGuideNode masterNode2 : this.guideNodesIndex.values()) {
            clonedNode = clonedGuide.findNode(masterNode2.getPathInGuide());
            if (masterNode2.getParentNode() != null) {
                clonedNode.setParentNode(clonedGuide.findNode(masterNode2.getParentNode().getPathInGuide()));
            }
            if (masterNode2.getFutureNodes() == null) continue;
            Iterator fit = masterNode2.getFutureNodes().iterator();
            while (fit.hasNext()) {
                clonedNode.addFutureGuideNode(clonedGuide.findNode(((R01MSearchGuideNode)fit.next()).getPathInGuide()));
            }
        }
        if (this.firstLevelNodes != null) {
            R01MSearchGuideNode[] clonedGuideFirstLevelNodes = new R01MSearchGuideNode[this.firstLevelNodes.length];
            for (int i = 0; i < this.firstLevelNodes.length; ++i) {
                clonedGuideFirstLevelNodes[i] = clonedGuide.findNode(this.firstLevelNodes[i].getPathInGuide());
            }
            clonedGuide.setFirstLevelNodes(clonedGuideFirstLevelNodes);
        }
        return clonedGuide;
    }

    private Map _cloneStringMap(Map theMap) {
        HashMap<String, String> outMap = null;
        if (theMap != null) {
            outMap = new HashMap<String, String>(theMap.size());
            for (Map.Entry me : theMap.entrySet()) {
                outMap.put(new String((String)me.getKey()), new String((String)me.getValue()));
            }
        }
        return outMap;
    }

    public String composeDebugInfo() {
        StringBuffer dbg = new StringBuffer(28);
        dbg.append("GUIA: ");
        dbg.append(this.name.get("es"));
        dbg.append(" guideDefOid=");
        dbg.append(this.guideDefOid);
        dbg.append("\r\n");
        if (this.firstLevelNodes != null) {
            for (int i = 0; i < this.firstLevelNodes.length; ++i) {
                dbg.append(this.firstLevelNodes[i].composeDebugInfo(1));
                dbg.append("\r\n");
            }
        }
        return dbg.toString();
    }
}

