/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.resources;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.R01MValidateInterface;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MLinkedResourcesGroup
implements R01MValidateInterface,
R01MPrintableInterface,
Serializable {
    private static final long serialVersionUID = 5077132047244529808L;
    public static final int ACTION_DELETE = 0;
    public static final int ACTION_NEW = 1;
    public static final int ACTION_UPDATE = 2;
    public static final int ACTION_HTML_GENERATION = 3;
    private String titleGroupLabel;
    private Map<String, R01MLinkedResource> resources = new HashMap<String, R01MLinkedResource>();

    public Map<String, R01MLinkedResource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, R01MLinkedResource> theResources) {
        this.resources = theResources;
    }

    public String getTitleGroupLabel() {
        return this.titleGroupLabel;
    }

    public void setTitleGroupLabel(String theTitleGroupLabel) {
        this.titleGroupLabel = theTitleGroupLabel;
    }

    public String addLinkToContent(String contentOid, String documentOid) {
        return this.addLinkToContent(contentOid, documentOid, null);
    }

    public String addLinkToContent(String contentOid, String documentOid, R01MLinkedResource currRes) {
        R01MLinkedResource res = new R01MLinkedResource();
        res.linkToContent(contentOid, documentOid, currRes);
        Map<String, R01MLinkedResource> linkedResources = this.getResources() == null ? new HashMap<String, R01MLinkedResource>() : this.getResources();
        linkedResources.put(res.getOid(), res);
        this.setResources(linkedResources);
        return res.getOid();
    }

    public String addLinkToUrl(String url, String text, String textAlt) {
        R01MLinkedResource res = new R01MLinkedResource();
        res.linkToUrl(url, text, textAlt);
        Map<String, R01MLinkedResource> linkedResources = this.getResources() == null ? new HashMap<String, R01MLinkedResource>() : this.getResources();
        linkedResources.put(res.getOid(), res);
        this.setResources(linkedResources);
        return res.getOid();
    }

    public List<R01MLinkedResource> getContainerLinkedResources(String containerId) {
        ArrayList<R01MLinkedResource> cotainerLinkedResources = new ArrayList<R01MLinkedResource>();
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            for (R01MLinkedResource currResource : this.getResources().values()) {
                if (!currResource.getContainerId().equals(containerId)) continue;
                cotainerLinkedResources.add(currResource);
            }
        }
        return cotainerLinkedResources;
    }

    public Map<String, List<R01MLinkedResource>> getResourcesGroupByContainer() {
        HashMap<String, List<R01MLinkedResource>> containerLinkedResources = new HashMap<String, List<R01MLinkedResource>>();
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            for (R01MLinkedResource currResource : this.getResources().values()) {
                if (containerLinkedResources.containsKey(currResource.getContainerId())) {
                    ((List)containerLinkedResources.get(currResource.getContainerId())).add(currResource);
                    continue;
                }
                ArrayList<R01MLinkedResource> linkedResources = new ArrayList<R01MLinkedResource>();
                linkedResources.add(currResource);
                containerLinkedResources.put(currResource.getContainerId(), linkedResources);
            }
        }
        return containerLinkedResources;
    }

    public String getJSONObjectAsString() {
        JSONObject allLinkedDocumentInfo = new JSONObject();
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            for (Map.Entry<String, R01MLinkedResource> me : this.getResources().entrySet()) {
                R01MLinkedResource currResource = me.getValue();
                JSONObject resourceInfo = new JSONObject();
                try {
                    resourceInfo.put("containerId", (Object)currResource.getContainerId());
                    resourceInfo.put("presentationTags", (Collection)currResource.getPresentationTags());
                    resourceInfo.put("relationId", (Object)currResource.getRelationId());
                    resourceInfo.put("presentationOrder", currResource.getPresentationOrder());
                    resourceInfo.put("linkName", (Object)currResource.getLinkName());
                    resourceInfo.put("linkDescription", (Object)currResource.getLinkDescription());
                    resourceInfo.put("linkUrl", (Object)currResource.getLinkUrl());
                    resourceInfo.put("relationDocumentOid", (Object)currResource.getRelatedDocumentDocumentOid());
                    resourceInfo.put("relationLabelSelection", (Object)currResource.getUserInterfaceRelationTextSelector());
                    allLinkedDocumentInfo.put(currResource.getOid(), (Object)resourceInfo);
                }
                catch (JSONException jsonExc) {
                    return "error";
                }
            }
            return allLinkedDocumentInfo.toString();
        }
        return "";
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            for (R01MLinkedResource res : this.getResources().values()) {
                if (res != null) {
                    res.validateObject();
                    continue;
                }
                throw new R01MContentModelObjectsValidatorException("[Object R01MLinkedResourcesGroup][Attribute resources] Contiene valores NULL.");
            }
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(500);
        sb.append(prefix);
        sb.append("\tTitleGroupLabel:");
        sb.append(StringUtils.isEmptyString((String)this.titleGroupLabel) ? "" : this.titleGroupLabel);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tResources:");
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            Iterator<R01MLinkedResource> itResources = this.getResources().values().iterator();
            while (itResources.hasNext()) {
                sb.append(itResources.next().debugInfo(tabPrefix));
            }
        }
        sb.append("\r\n");
        return sb;
    }
}

