/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.resources;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.R01MValidateInterface;
import com.ejie.r01m.objects.contentmodel.R01MLinkedRelationsGroup;
import com.ejie.r01m.objects.link.R01MLink;
import com.ejie.r01m.objects.resources.R01MBaseResource;
import com.ejie.r01m.objects.resources.R01MResourceInterface;
import com.ejie.r01m.services.R01MClientFactory;
import java.util.Comparator;
import java.util.List;

public class R01MLinkedResource
extends R01MBaseResource
implements R01MResourceInterface,
R01MValidateInterface,
R01MPrintableInterface {
    private static final long serialVersionUID = 3723313359503584195L;
    public static final String RELATION_LABEL_SRC = "src";
    public static final String RELATION_LABEL_DST = "dst";
    public static final String RELATION_ID_DEFAULT = "default";
    private String relationId = "default";
    private String relatedDocumentLinkedResourceOid;
    private boolean relationOwner = true;
    private String userInterfaceRelationTextSelector = "";
    private String containerId = "euskadinet";
    public static Comparator COMPARE_BY_PRESENTATION_ORDER = new Comparator(){

        public int compare(Object objectOne, Object objectOther) {
            R01MLinkedResource linkedOne = (R01MLinkedResource)objectOne;
            R01MLinkedResource linkedOther = (R01MLinkedResource)objectOther;
            Integer intOne = new Integer(String.valueOf(linkedOne.getPresentationOrder()));
            Integer intOther = new Integer(String.valueOf(linkedOther.getPresentationOrder()));
            return intOne.compareTo(intOther);
        }
    };

    public void linkToUrl(String url, String text, String textAlt) {
        R01MLink linkComp = new R01MLink();
        linkComp.addLinkItemFromURL(url);
        if (!StringUtils.isEmptyString((String)text)) {
            linkComp.getFirstLinkItem().setText(text);
        }
        if (!StringUtils.isEmptyString((String)textAlt)) {
            linkComp.getFirstLinkItem().setTitle(textAlt);
        }
        this.setLink(linkComp);
    }

    public void linkToUrl(String url) {
        this.linkToUrl(url, null, null);
    }

    public void linkToContent(String contentOid, String documentOid) {
        R01MLink linkComp = new R01MLink();
        linkComp.setType(2);
        linkComp.addLinkItemDocument(contentOid, documentOid);
        this.setLink(linkComp);
    }

    public void linkToContent(String contentOid, String documentOid, R01MLinkedResource currRes) {
        int currPresentationOrder = currRes.getPresentationOrder();
        boolean currShowByDefaultRendering = currRes.isShowByDefaultRendering();
        String currUserInterfaceRelationTextSelector = currRes.getUserInterfaceRelationTextSelector();
        String currRelationId = currRes.getRelationId();
        List presentationTags = currRes.getPresentationTags();
        R01MLink linkComp = new R01MLink();
        linkComp.setType(2);
        linkComp.addLinkItemDocument(contentOid, documentOid);
        this.setLink(linkComp);
        if (!StringUtils.isEmptyString((String)currRelationId)) {
            this.setRelationId(currRelationId);
        }
        this.setPresentationOrder(currPresentationOrder);
        this.setShowByDefaultRendering(currShowByDefaultRendering);
        if (!StringUtils.isEmptyString((String)currUserInterfaceRelationTextSelector)) {
            this.setUserInterfaceRelationTextSelector(currUserInterfaceRelationTextSelector);
        }
        if (!StringUtils.isEmptyString((String)currRelationId)) {
            this.setRelationId(currRelationId);
        }
        if (presentationTags != null && !presentationTags.isEmpty()) {
            this.setPresentationTags(presentationTags);
        }
    }

    public String getRelationOid() {
        return this.getRelatedDocumentLinkedResourceOid();
    }

    public void setRelationOid(String theRelationOid) {
        this.setRelatedDocumentLinkedResourceOid(theRelationOid);
    }

    public String getRelatedDocumentLinkedResourceOid() {
        return this.relatedDocumentLinkedResourceOid;
    }

    public void setRelatedDocumentLinkedResourceOid(String theRelationOid) {
        this.relatedDocumentLinkedResourceOid = theRelationOid;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public void setRelationId(String theRelationId) {
        this.relationId = theRelationId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String theContainerId) {
        this.containerId = theContainerId;
    }

    public boolean isBaseRelationContent() {
        return this.isRelationOwner();
    }

    public boolean isRelationOwner() {
        return this.relationOwner;
    }

    public void setBaseRelationContent(boolean bBaseRelationContent) {
        this.relationOwner = bBaseRelationContent;
    }

    public void setRelationOwner(boolean bOwnerOfRelation) {
        this.relationOwner = bOwnerOfRelation;
    }

    public String getRelationLabelSelection() {
        return this.getUserInterfaceRelationTextSelector();
    }

    public void setRelationLabelSelection(String theRelationLabelSelection) {
        this.setUserInterfaceRelationTextSelector(theRelationLabelSelection);
    }

    public String getUserInterfaceRelationTextSelector() {
        return this.userInterfaceRelationTextSelector;
    }

    public void setUserInterfaceRelationTextSelector(String theUserInterfaceRelationTextSelector) {
        this.userInterfaceRelationTextSelector = theUserInterfaceRelationTextSelector;
    }

    public String getRelatedRelationContentOid() {
        return this.getRelatedDocumentContentOid();
    }

    public String getRelationDocumentOid() {
        return this.getRelatedDocumentOid();
    }

    public String getDocumentRepositoryOid() {
        return this.getRelatedDocumentContentRepositoryOid();
    }

    public String getRelationContentOid() {
        return this.getRelatedDocumentContentOid();
    }

    public String getRelatedDocumentContentOid() {
        if (this.getLink() != null) {
            return this.getLink().getFirstLinkItem().getContentOid();
        }
        return "";
    }

    public String getRelatedDocumentOid() {
        return this.getRelatedDocumentDocumentOid();
    }

    public String getRelatedDocumentDocumentOid() {
        if (this.getLink() != null) {
            return this.getLink().getFirstLinkItem().getDocumentOid();
        }
        return "";
    }

    public String getRelatedDocumentContentRepositoryOid() {
        if (this.getLink() != null) {
            return this.getLink().getFirstLinkItem().getDocumentRepositoryOid();
        }
        return "";
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        super.validateObject();
        R01MLinkedRelationsGroup relations = null;
        try {
            relations = R01MClientFactory.getLinkedRelationsConfigAPI().getLinkedRelationsConfig();
        }
        catch (Exception ex) {
            throw new R01MContentModelObjectsValidatorException("Error al cargar la configuracion de las relaciones: " + ex.getMessage());
        }
        if (!(relations == null || relations.getRelations().isEmpty() || StringUtils.isEmptyString((String)this.relationId) || relations.getRelations().containsKey(this.relationId))) {
            throw new R01MContentModelObjectsValidatorException("La relacion especificada '" + this.relationId + "' no existe.");
        }
        if (StringUtils.isEmptyString((String)this.containerId)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MBaseResource] El identificador del contenedor es nulo o vac\u00edo.");
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(500);
        sb.append(super.debugInfo(prefix));
        sb.append(prefix);
        sb.append("\tRelationId: ");
        sb.append(this.relationId == null ? "null" : this.relationId);
        sb.append("\r\n");
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRelationOid: ");
        sb.append(this.relatedDocumentLinkedResourceOid == null ? "null" : this.relatedDocumentLinkedResourceOid);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tBaseRelationContent: ");
        sb.append(this.relationOwner);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRelationLabelSelection: ");
        sb.append(this.userInterfaceRelationTextSelector);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append(prefix);
        sb.append("\tContainerId:");
        sb.append(this.containerId != null ? this.containerId : "null");
        sb.append("\r\n");
        sb.append("\r\n");
        return sb;
    }

    @Override
    public int getDocumentResourceType() {
        return 0;
    }
}

