/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.resources;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.R01MValidateInterface;
import com.ejie.r01m.objects.resources.R01MGalleryResource;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class R01MGallery
implements R01MValidateInterface,
R01MPrintableInterface,
Serializable {
    private static final long serialVersionUID = -84965107673862586L;
    public static final int GALLERY_TYPE_MIX = 0;
    public static final int GALLERY_TYPE_IMAGE = 1;
    public static final int GALLERY_TYPE_VIDEO = 2;
    public static final int GALLERY_TYPE_DOCS = 3;
    private String id;
    private int type = 0;
    private String name;
    private String description;
    private Map resources = new HashMap();
    private String containerId = "euskadinet";
    private int resourcesPerPage = 4;

    public R01MGallery() {
    }

    public R01MGallery(String theGalleryId) {
        this.id = theGalleryId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String theGalleryId) {
        this.id = theGalleryId;
    }

    public Map getResources() {
        return this.resources;
    }

    public void setResources(Map theResources) {
        TreeMap sortedResources = new TreeMap(new SortedByPresentationOrder(theResources));
        sortedResources.putAll(theResources);
        this.resources = sortedResources;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String theContainerId) {
        this.containerId = theContainerId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int theGalleryType) {
        this.type = theGalleryType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theGalleryName) {
        this.name = theGalleryName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String theGalleryDescription) {
        this.description = theGalleryDescription;
    }

    public int getResourcesPerPage() {
        return this.resourcesPerPage;
    }

    public void setResourcesPerPage(int theResourcesPerPage) {
        this.resourcesPerPage = theResourcesPerPage;
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.id)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MGallery] El id de la galer\u00eda es obligatorio.");
        }
        if (StringUtils.isEmptyString((String)this.containerId)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MGallery] El nombre del contenedor es obligatorio.");
        }
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            for (R01MGalleryResource res : this.getResources().values()) {
                if (res != null) {
                    res.validateObject();
                    continue;
                }
                throw new R01MContentModelObjectsValidatorException("[Object R01MGallery(" + this.id + ")][Attribute resources] Contiene valores NULL.");
            }
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(500);
        sb.append(prefix);
        sb.append("\tGalleryId:");
        sb.append(this.id != null ? this.id : "null");
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tType:");
        sb.append(this.type);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tName:");
        sb.append(this.name);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescription:");
        sb.append(this.description);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tContainerName:");
        sb.append(this.containerId != null ? this.containerId : "null");
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tResources:");
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            Iterator itResources = this.getResources().values().iterator();
            while (itResources.hasNext()) {
                sb.append(((R01MGalleryResource)itResources.next()).debugInfo(tabPrefix));
            }
        }
        sb.append("\r\n");
        return sb;
    }

    private static class SortedByPresentationOrder
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -7366129526678004066L;
        private Map _data = null;

        public SortedByPresentationOrder(Map data) {
            this._data = data;
        }

        public int compare(Object o1, Object o2) {
            R01MGalleryResource resource1 = (R01MGalleryResource)this._data.get(o1);
            R01MGalleryResource resource2 = (R01MGalleryResource)this._data.get(o2);
            if (resource1 != null && resource2 != null) {
                return new Integer(resource1.getPresentationOrder()).compareTo(new Integer(resource2.getPresentationOrder()));
            }
            return -1;
        }
    }
}

