/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.resources;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.objects.link.R01MLink;
import com.ejie.r01m.objects.link.R01MLinkItem;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MBaseResource
extends R01MBaseContentModelObject
implements R01MPrintableInterface,
Comparable {
    private static final long serialVersionUID = 7414966167736746787L;
    public static final int RESOURCE_TYPE_LINK = 0;
    public static final int RESOURCE_TYPE_GALLERY = 1;
    private String oid;
    private List presentationTags = new ArrayList();
    private boolean showByDefaultRendering = true;
    private int presentationOrder = 0;
    private R01MLink link;

    R01MBaseResource() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE, "content");
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public int getPresentationOrder() {
        return this.presentationOrder;
    }

    public void setPresentationOrder(int thePresentationOrder) {
        this.presentationOrder = thePresentationOrder;
    }

    public List getPresentationTags() {
        return this.presentationTags;
    }

    public void setPresentationTags(List thePresentationTags) {
        this.presentationTags = thePresentationTags;
    }

    public boolean isShowByDefaultRendering() {
        return this.showByDefaultRendering;
    }

    public void setShowByDefaultRendering(boolean bShowByDefaultRendering) {
        this.showByDefaultRendering = bShowByDefaultRendering;
    }

    public R01MLink getLink() {
        return this.link;
    }

    public void setLink(R01MLink theLink) {
        this.link = theLink;
    }

    public void setLinkDetails(Map theData) {
        this._prepareObjectLink();
        this.getLink().getLink(0).setData(theData);
    }

    public String getLinkName() {
        if (this.getLink() != null && this.getLink().getLinkItems() != null && !this.getLink().getLinkItems().isEmpty()) {
            return this.getLink().getFirstLinkItem().getText();
        }
        return "";
    }

    public String getLinkText() {
        if (this.getLink() != null && this.getLink().getLinkItems() != null && !this.getLink().getLinkItems().isEmpty()) {
            return this.getLink().getFirstLinkItem().getText();
        }
        return "";
    }

    public String getLinkDescription() {
        if (this.getLink() != null && this.getLink().getLinkItems() != null && !this.getLink().getLinkItems().isEmpty()) {
            return this.getLink().getFirstLinkItem().getTitle();
        }
        return "";
    }

    public String getLinkTextAlt() {
        if (this.getLink() != null && this.getLink().getLinkItems() != null && !this.getLink().getLinkItems().isEmpty()) {
            return this.getLink().getFirstLinkItem().getTitle();
        }
        return "";
    }

    public int getLinkType() {
        if (this.getLink() != null) {
            return this.getLink().getType();
        }
        return 8;
    }

    public String getLinkUrl() {
        if (this.getLink() != null && this.getLink().getLinkItems() != null && !this.getLink().getLinkItems().isEmpty()) {
            return this.getLink().getFirstLinkItem().getUrl();
        }
        return "";
    }

    public void setLinkUrl(String theLinkUrl) {
        this._prepareObjectLink();
        this.getLink().getFirstLinkItem().setUrl(theLinkUrl);
    }

    public void setLinkText(String theLinkText) {
        this._prepareObjectLink();
        this.getLink().getFirstLinkItem().setText(theLinkText);
    }

    public void setLinkType(int theLinkType) {
        this._prepareObjectLink();
        this.getLink().setType(theLinkType);
    }

    public void setLinkTextAlt(String theLinkTextAlt) {
        this._prepareObjectLink();
        this.getLink().getFirstLinkItem().setTitle(theLinkTextAlt);
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (this.link == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MBaseResource] El enlace del v\u00ednculo es nulo.");
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== R01MBaseResource  ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.oid == null ? "null" : this.oid);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPresentationTags: ");
        if (this.getPresentationTags() != null && !this.getPresentationTags().isEmpty()) {
            Iterator itPresentationTags = this.getPresentationTags().iterator();
            while (itPresentationTags.hasNext()) {
                sb.append("\t>> tag: ");
                sb.append(itPresentationTags.next());
                sb.append("\r\n");
            }
        }
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tShowByDefaultRendering: ");
        sb.append(this.showByDefaultRendering);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPresentationOrder: ");
        sb.append(this.presentationOrder);
        sb.append("\r\n");
        sb.append("\tLink:");
        sb.append(this.link != null ? "el enlace" : "null");
        return sb;
    }

    public int compareTo(Object otherResource) {
        if (this.getPresentationOrder() < ((R01MBaseResource)otherResource).getPresentationOrder()) {
            return -1;
        }
        if (this.getPresentationOrder() == ((R01MBaseResource)otherResource).getPresentationOrder()) {
            return 0;
        }
        return 1;
    }

    private void _prepareObjectLink() {
        if (this.getLink() == null) {
            this.link = new R01MLink();
        }
        if (this.getLink().getLinkItems() == null || this.getLink().getLinkItems().isEmpty()) {
            ArrayList<R01MLinkItem> lstResult = new ArrayList<R01MLinkItem>();
            lstResult.add(new R01MLinkItem());
            this.link.setLinks(lstResult);
        }
    }
}

